/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeRelations {
    public static final int INFINITE_SUBSTITUTION_LIMIT = 50;
    private static final Key<ParameterizedCachedValue<JSType, Supplier<JSType>>> EXPAND_TYPE_KEY = Key.create((String)"expand.type.recursive");
    private static final Key<ParameterizedCachedValue<JSType, Supplier<JSType>>> ENUM_VALUES_UNION_TYPE_KEY = Key.create((String)"enum.values.union.type");

    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (source == null || target == null) {
            return false;
        }
        assert (processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null);
        return TypeScriptTypeRelations.isTypeRelatedTo(target, source, processingContext);
    }

    public static boolean isTypeInstanceOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext subtypingContext) {
        if (subtypingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        return TypeScriptTypeRelations.isTypeSubtypeOf(source, target, subtypingContext);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        block3: {
            block2: {
                if (!(source instanceof JSUnionType)) break block2;
                for (JSType sourceSubType : ((JSUnionType)source).getTypes()) {
                    if (!TypeScriptTypeRelations.isTypeComparableTo(sourceSubType, target, context)) continue;
                    return true;
                }
                break block3;
            }
            if (!(target instanceof JSUnionType)) break block3;
            for (JSType targetSubType : ((JSUnionType)target).getTypes()) {
                if (!TypeScriptTypeRelations.isTypeRelatedTo(source, targetSubType, context)) continue;
                return true;
            }
        }
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context);
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeRelatedTo(target, source, context);
    }

    public static boolean isTypeSubsetOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source == null || target == null) {
            return source == target;
        }
        if (source.isEquivalentTo(target, context)) {
            return true;
        }
        return target instanceof JSCompositeTypeImpl && TypeScriptTypeRelations.isTypeSubsetOfUnionType(source, (JSCompositeTypeImpl)target, context);
    }

    public static boolean isTypeRelatedTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return source != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(source).isDirectlyAssignableType(TypeScriptTypeRelations.getRegularTypeOfLiteralType(target), context);
    }

    public static boolean typeMaybeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source instanceof JSCompositeTypeImpl) {
            return ((JSCompositeTypeImpl)source).getTypes().stream().anyMatch(el -> TypeScriptTypeRelations.typeMaybeAssignableTo(el, target, context));
        }
        return TypeScriptTypeRelations.isTypeAssignableTo(source, target, context);
    }

    public static boolean isTypeSubsetOfUnionType(@NotNull JSType source, @NotNull JSCompositeTypeImpl target, @Nullable ProcessingContext context) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        if (target == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        List<JSType> types = target.getTypes();
        if (source instanceof JSCompositeTypeImpl) {
            List<JSType> subTypes = ((JSCompositeTypeImpl)source).getTypes();
            for (JSType type : subTypes) {
                if (TypeScriptTypeRelations.containsType(types, type, context)) continue;
                return false;
            }
            return true;
        }
        return TypeScriptTypeRelations.containsType(types, source, context);
    }

    public static boolean containsType(@NotNull List<JSType> types, @NotNull JSType sourceType, @Nullable ProcessingContext context) {
        if (types == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(4);
        }
        if (sourceType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(5);
        }
        return types.stream().anyMatch(el -> {
            if (sourceType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(31);
            }
            return el.isEquivalentTo(sourceType, context);
        });
    }

    @Contract(value="!null -> !null; null -> null")
    public static JSType expandAndOptimizeTypeRecursive(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        return type.getLocalCachedType(() -> JSCompositeTypeImpl.optimizeTypeIfComposite(TypeScriptTypeRelations.expandTypeRecursive(type, true)), EXPAND_TYPE_KEY);
    }

    @Contract(value="!null, _ -> !null; null, _ -> null")
    @Nullable
    public static JSType expandTypeRecursive(@Nullable JSType type, boolean keepAliasForRecordTypes) {
        if (type == null) {
            return null;
        }
        return TypeScriptTypeRelations.expandAliasesRecursive(type, keepAliasForRecordTypes);
    }

    @NotNull
    public static JSType expandAliasesRecursive(@NotNull JSType originalType, boolean keepAliasForComplexTypes) {
        JSType type;
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(6);
        }
        JSType jSType = (type = TypeScriptTypeRelations.expandAliasesRecursive(originalType, null, keepAliasForComplexTypes, (Set<JSResolvedTypeId>)ContainerUtil.newTroveSet())) == null ? JSAnyType.get(originalType.getSource()) : type;
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Nullable
    private static JSType expandAliasesRecursive(@NotNull JSType originalType, @Nullable JSGenericTypeImpl genericOwner, boolean keepAliasForComplexTypes, @NotNull Set<JSResolvedTypeId> visited) {
        PsiElement sourceElement;
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(8);
        }
        if (visited == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        if (visited.size() > 50) {
            Logger.getInstance(JSTypeImpl.class).error("Infinite type substitution " + originalType.getTypeText());
            return null;
        }
        JSType valuableType = JSTypeUtils.getValuableType(originalType);
        if (valuableType != originalType) {
            if (!visited.add(originalType.getResolvedTypeId())) {
                return null;
            }
            return TypeScriptTypeRelations.expandAliasesRecursive(valuableType, genericOwner, keepAliasForComplexTypes, visited);
        }
        if (originalType instanceof JSGenericTypeImpl && !((sourceElement = originalType.getSource().getSourceElement()) instanceof JSDocComment)) {
            JSType nestedType = ((JSGenericTypeImpl)originalType).getType();
            JSType expanded = TypeScriptTypeRelations.expandAliasesRecursive(nestedType, (JSGenericTypeImpl)originalType, keepAliasForComplexTypes, visited);
            return expanded == nestedType ? originalType : expanded;
        }
        if (originalType instanceof JSTypeImpl) {
            return TypeScriptTypeRelations.expandForSingleType((JSTypeImpl)originalType, genericOwner, visited, keepAliasForComplexTypes);
        }
        if (originalType instanceof JSUnionOrIntersectionType) {
            List<JSType> types = ((JSUnionOrIntersectionType)originalType).getTypes();
            if (!visited.add(originalType.getResolvedTypeId())) {
                return null;
            }
            List<JSType> expandedTypes = types.stream().map(el -> {
                if (visited == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(30);
                }
                return TypeScriptTypeRelations.expandAliasesRecursive(el, genericOwner, keepAliasForComplexTypes, (Set<JSResolvedTypeId>)ContainerUtil.newTroveSet((Collection)visited));
            }).collect(Collectors.toList());
            for (JSType jsType : expandedTypes) {
                if (jsType != null) continue;
                return null;
            }
            if (ContainerUtil.equalsIdentity(types, expandedTypes)) {
                return originalType;
            }
            if (originalType instanceof JSCompositeTypeImpl) {
                return new JSCompositeTypeImpl(originalType.getSource(), expandedTypes);
            }
            if (originalType instanceof JSIntersectionTypeImpl) {
                return new JSIntersectionTypeImpl(originalType.getSource(), expandedTypes);
            }
        }
        return originalType;
    }

    @Nullable
    private static JSType expandForSingleType(@NotNull JSTypeImpl toApply, @Nullable JSGenericTypeImpl genericType, @NotNull Set<JSResolvedTypeId> expanded, boolean keepAliasForComplexTypes) {
        JSResolvedTypeInfo info;
        TypeScriptTypeAlias alias;
        if (toApply == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(10);
        }
        if (expanded == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(11);
        }
        if ((alias = (info = toApply.resolveType()).getDeclarationOfType(TypeScriptTypeAlias.class)) == null) {
            return toApply;
        }
        if (!TypeScriptTypeRelations.validateAliases(info, alias)) {
            return toApply;
        }
        JSType declaration = info.getTypedef();
        if (declaration == null) {
            return toApply;
        }
        if (genericType != null) {
            JSTypeSubstitutor generics = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)alias, genericType);
            declaration = JSTypeUtils.applyGenericArguments(declaration, generics);
        }
        if (keepAliasForComplexTypes && !TypeScriptTypeRelations.isPossibleSimpleType(declaration)) {
            return toApply;
        }
        if (!expanded.add(toApply.getResolvedTypeId())) {
            return null;
        }
        return TypeScriptTypeRelations.expandAliasesRecursive(declaration, null, keepAliasForComplexTypes, expanded);
    }

    private static boolean validateAliases(@NotNull JSResolvedTypeInfo info, @NotNull TypeScriptTypeAlias alias) {
        if (info == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(12);
        }
        if (alias == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(13);
        }
        Collection<? extends PsiElement> declarations = info.getDeclarations();
        String name = alias.getName();
        return name != null && !declarations.stream().anyMatch(e -> !(e instanceof TypeScriptTypeAlias) || !name.equals(((TypeScriptTypeAlias)e).getName()));
    }

    private static boolean isPossibleSimpleType(@Nullable JSType declaration) {
        return !(declaration instanceof JSRecordType);
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type, @NotNull Predicate<JSType> filter, @NotNull PsiElement context) {
        if (filter == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(14);
        }
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(15);
        }
        if (type == null) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(JSTypeSourceFactory.createTypeSource(context, true));
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(16);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (type instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            List<JSType> resultTypes = types.stream().filter(el -> {
                if (filter == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(29);
                }
                return filter.apply(el);
            }).collect(Collectors.toList());
            if (types.size() == resultTypes.size()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(17);
                }
                return jSType;
            }
            JSType jSType = TypeScriptTypeRelations.getUnionType(resultTypes, type.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        Object object = filter.apply((Object)type) ? type : new TypeScriptNeverJSTypeImpl(type.getSource());
        if (object == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(19);
        }
        return object;
    }

    @Contract(value="!null -> !null")
    public static JSType getAsUnionTypeIfEnumWithLiterals(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType) || !type.isTypeScript()) {
            return type;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        if (info.isEnumWithLiteralValues()) {
            return type.getLocalCachedType(() -> {
                JSType result2 = TypeScriptTypeRelations.createEnumValuesUnionType(type, info);
                return result2 == null ? type : result2;
            }, ENUM_VALUES_UNION_TYPE_KEY);
        }
        return type;
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<JSType> resultTypes, @NotNull JSTypeSource source) {
        if (resultTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(20);
        }
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(21);
        }
        if (resultTypes.isEmpty()) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(source);
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(22);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (resultTypes.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem(resultTypes, null);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(23);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(resultTypes, source, true);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    protected static JSType getRegularTypeOfLiteralType(@Nullable JSType valueType) {
        if (valueType instanceof JSLiteralType && ((JSLiteralType)valueType).canBeWidened()) {
            return ((JSLiteralType)valueType).copyWithCanBeWidened(false);
        }
        return valueType;
    }

    @Nullable
    public static JSType createEnumValuesUnionType(@NotNull JSType elementType, @NotNull JSResolvedTypeInfo resolvedType) {
        TypeScriptEnum enumDeclaration;
        if (elementType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(25);
        }
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(26);
        }
        if ((enumDeclaration = resolvedType.getDeclarationOfType(TypeScriptEnum.class)) == null) {
            return null;
        }
        JSField[] members = enumDeclaration.getFields();
        if (members.length == 0) {
            return null;
        }
        ArrayList combinedTypeMembers = ContainerUtil.newArrayListWithCapacity((int)members.length);
        for (JSField member : members) {
            combinedTypeMembers.add(JSNamedType.createType(elementType.getTypeText() + "." + member.getName(), JSTypeSourceFactory.createTypeSource((PsiElement)member, true), JSTypeContext.INSTANCE, false));
        }
        return new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)enumDeclaration, true), combinedTypeMembers);
    }

    @Nullable
    public static JSType getBestChoiceType(@Nullable JSType lType, @Nullable JSType rType, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(27);
        }
        if (lType == null) {
            return rType;
        }
        if (rType == null) {
            return lType;
        }
        if (lType instanceof JSAnyType) {
            return TypeScriptTypeRelations.replaceTypeSourceByNotStrict(rType);
        }
        if (rType instanceof JSAnyType) {
            return TypeScriptTypeRelations.replaceTypeSourceByNotStrict(lType);
        }
        if (!DialectDetector.isTypeScript(context)) {
            return JSTypeUtils.getCommonType(lType, rType, DialectDetector.dialectOfElement(context), true);
        }
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(context);
        boolean firstAssignableToSecond = TypeScriptTypeRelations.isTypeAssignableTo(lType, rType, processingContext);
        boolean secondAssignableToFirst = TypeScriptTypeRelations.isTypeAssignableTo(rType, lType, processingContext);
        if (secondAssignableToFirst && !firstAssignableToSecond) {
            return lType;
        }
        if (firstAssignableToSecond && !secondAssignableToFirst) {
            return rType;
        }
        processingContext.put(JSTypeComparingCache.SUBTYPING_CONTEXT, (Object)true);
        if (lType.isDirectlyAssignableType(rType, processingContext)) {
            return lType;
        }
        if (rType.isDirectlyAssignableType(lType, processingContext)) {
            return rType;
        }
        return JSTypeUtils.getCommonType(lType, rType, DialectDetector.dialectOfElement(context), true);
    }

    @NotNull
    private static JSType replaceTypeSourceByNotStrict(JSType partType) {
        JSType jSType = JSTypeUtils.copyWithStrictRecursive(partType, false);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtypingContext";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 9: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toApply";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expanded";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTypes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAliasesRecursive";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTypeSourceByNotStrict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubtypeOf";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeInstanceOf";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubsetOfUnionType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandAliasesRecursive";
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandForSingleType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateAliases";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEnumValuesUnionType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBestChoiceType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterType$5";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expandAliasesRecursive$3";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsType$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

