/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSFindFirstResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSMergeResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubBasedPsiTreeUtil {
    static final TokenSet DECLARATIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TypeScriptElementTypes.TYPE_MEMBERS, JSElementTypes.FUNCTION_DECLARATIONS, JSExtendedLanguagesTokenSetProvider.CLASSES, JSExtendedLanguagesTokenSetProvider.VARIABLES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptElementTypes.IMPLICIT_MODULE, JSStubElementTypes.DEFINITION_EXPRESSION, ES6ElementTypes.IMPORT_SPECIFIER, ES6ElementTypes.IMPORT_SPECIFIER_ALIAS, ES6ElementTypes.IMPORTED_BINDING, ES6ElementTypes.EXPORT_SPECIFIER, ES6ElementTypes.EXPORT_SPECIFIER_ALIAS, ES6ElementTypes.EXPORTED_DEFAULT_BINDING, TypeScriptElementTypes.IMPORT_STATEMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
    private static final TokenSet FUNCTIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS});
    private static final TokenSet RETURN_STATEMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.RETURN_STATEMENT});
    private static final Predicate<PsiElement> IS_TARGET = element -> {
        boolean isImport = false;
        if (element instanceof JSVariable) {
            JSExpression initializer = JSDestructuringUtil.getNearestInitializerStubSafely((JSVariable)element);
            isImport = initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
        } else if (element instanceof JSDefinitionExpression) {
            JSQualifiedName name = ((JSDefinitionExpression)element).getJSNamespace().getQualifiedName();
            isImport = name != null && "exports".equals(name.getName()) && (name.getParent() == null || "module".equals(name.getParent().getName()) && name.getParent().getParent() == null);
        } else if (element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedExportedDefaultBinding || element instanceof JSExportAssignment) {
            isImport = true;
        }
        return !isImport;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_AT = element -> {
        if (!IS_TARGET.test((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSVariable && element.getParent() instanceof JSDestructuringProperty) {
            return false;
        }
        return !(element instanceof JSProperty) || ((JSProperty)element).getInitializerReference() == null;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_BEFORE = element -> element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element);

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(1);
        }
        return JSStubBasedPsiTreeUtil.resolveLocally(name, context, true);
    }

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context, boolean includeDefinitions) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (name.contains(".")) {
            return null;
        }
        JSFindFirstResolveProcessor processor = new JSFindFirstResolveProcessor(name, includeDefinitions);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, processor, true);
        return processor.getResult();
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(5);
        }
        if (name.contains(".")) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        JSMergeResolveProcessor processor = new JSMergeResolveProcessor(name);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, processor, true);
        List<PsiElement> list = processor.getResults();
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static boolean processDeclarationsInScope(@NotNull PsiElement context, @NotNull PsiScopeProcessor processor, boolean includeParentScopes) {
        String name;
        PsiElement scope;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(9);
        }
        if ((scope = JSStubBasedPsiTreeUtil.getScope(context = (PsiElement)ObjectUtils.coalesce((Object)CompletionUtilCoreImpl.getOriginalElement((PsiElement)context), (Object)context))) == null) {
            return true;
        }
        String string = name = processor instanceof JSResolveProcessor ? ((JSResolveProcessor)processor).getName() : null;
        if (!JSStubBasedPsiTreeUtil.hasStub(scope)) {
            return JSStubBasedPsiTreeUtil.processDeclarationsInScopeAstBased(context, scope, processor, name, includeParentScopes);
        }
        return JSStubBasedPsiTreeUtil.processDeclarationsInScopeStubBased(context, scope, processor, name, includeParentScopes);
    }

    @Nullable
    private static PsiElement getScope(@NotNull PsiElement context) {
        PsiElement scope;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(10);
        }
        return (scope = JSStubBasedPsiTreeUtil.getContextOfType(context, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, false)) instanceof TypeScriptInterface ? ((TypeScriptInterface)scope).getBody() : scope;
    }

    private static boolean hasStub(@NotNull PsiElement scope) {
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(11);
        }
        return scope instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)scope).getStub() != null || scope instanceof PsiFileImpl && ((PsiFileImpl)scope).getStubTree() != null;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(14);
        }
        while (scope != null) {
            if (!JSStubBasedPsiTreeUtil.processDeclarationsInScopeStubBased(context, scope, processor, name)) {
                return false;
            }
            if (!includeParentScopes || scope instanceof PsiFile || scope instanceof JSEmbeddedContent) {
                return true;
            }
            context = scope;
            scope = JSStubBasedPsiTreeUtil.getContextOfType(scope, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true);
        }
        return true;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(17);
        }
        List<JSElement> elements = scope == context && name != null ? JSScopeNamesCache.findNamedElementsInStubScope(name, scope) : JSStubBasedPsiTreeUtil.findElementsInStubScopeWithContext(context, scope, name);
        for (PsiElement psiElement : elements) {
            if (processor.execute(psiElement, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static TIntObjectHashMap<Object> buildStubBasedNamesMap(@NotNull PsiElement scope) {
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(18);
        }
        TIntObjectHashMap defs = new TIntObjectHashMap();
        ArrayList declarations = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, scope, null, declarations);
        for (PsiElement declaration : declarations) {
            String name = JSStubBasedPsiTreeUtil.extractName(declaration);
            if (name == null || !JSStubBasedPsiTreeUtil.isAcceptableDeclaration(declaration)) continue;
            JSScopeNamesCache.addElementCompact((TIntObjectHashMap<Object>)defs, (JSElement)declaration, name.hashCode());
        }
        TIntObjectHashMap tIntObjectHashMap = defs;
        if (tIntObjectHashMap == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(19);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static List<JSElement> findElementsInStubScopeWithContext(@NotNull PsiElement context, @NotNull PsiElement scope, @Nullable String name) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(21);
        }
        List result2 = ContainerUtil.newSmartList();
        ArrayList declarations = new ArrayList();
        Ref declarationsBeforeContextRef = Ref.create((Object)0);
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, context, (Ref<Integer>)declarationsBeforeContextRef, declarations);
        int declarationsBeforeContext = (Integer)declarationsBeforeContextRef.get();
        for (int i = 0; i < declarations.size(); ++i) {
            PsiElement declaration = (PsiElement)declarations.get(i < declarationsBeforeContext ? declarationsBeforeContext - i - 1 : i);
            String extractedName = JSStubBasedPsiTreeUtil.extractName(declaration);
            if (name != null && !name.equals(extractedName) || !JSStubBasedPsiTreeUtil.isAcceptableDeclaration(declaration)) continue;
            result2.add((JSElement)declaration);
        }
        List list = result2;
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static boolean isAcceptableDeclaration(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(23);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getNamespace() == null;
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getAlias() == null;
        }
        return declaration instanceof JSNamedElement;
    }

    @Nullable
    private static String extractName(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(24);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getName();
        }
        if (declaration instanceof JSNamedElement) {
            return ((JSNamedElement)declaration).getName();
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getDeclaredName();
        }
        return null;
    }

    private static boolean processDeclarationsInScopeAstBased(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        JSTreeUtil.JSScopeDeclarationsAndAssignments definitions;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(27);
        }
        JSTreeUtil.JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = definitions = includeParentScopes ? JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, scope.getNode()) : JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)scope.getNode());
        if (context.getNode() == null) {
            if (!(context instanceof JSImplicitElement)) {
                Logger.getInstance(JSStubBasedPsiTreeUtil.class).error("Element without node " + context + ", isValid " + context.isValid());
                return true;
            }
            context = context.getParent();
        }
        ASTNode node = context.getNode();
        return definitions == null || node == null || definitions.processFromNearest(node, processor, context != scope);
    }

    @Nullable
    public static PsiElement getContextOfType(@NotNull PsiElement element, @NotNull TokenSet types, boolean strict) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(28);
        }
        if (types == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(29);
        }
        if (strict && element instanceof PsiFile) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        if (element == null) {
            return null;
        }
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            while (stub != null) {
                PsiElement psi = stub.getPsi();
                if (stub instanceof PsiFileStub) {
                    return types.contains((IElementType)((PsiFileStub)stub).getType()) ? psi : null;
                }
                if (types.contains((IElementType)stub.getStubType())) {
                    return psi;
                }
                stub = stub.getParentStub();
            }
        } else {
            ASTNode node = element.getNode();
            while (node != null) {
                if (types.contains(node.getElementType())) {
                    return node.getPsi();
                }
                if (node instanceof FileASTNode) {
                    return null;
                }
                node = TreeUtil.findParent((ASTNode)node, (TokenSet)types);
            }
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull IStubElementType<?, T> elementType) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(30);
        }
        if (elementType == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(31);
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, TokenSet.create((IElementType[])new IElementType[]{elementType}));
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(33);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(34);
        }
        List<T> list = JSStubBasedPsiTreeUtil.findDescendants(element, elements, TokenSet.EMPTY);
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static <T extends PsiElement> List<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements, @NotNull TokenSet stopAt) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(36);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(37);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(38);
        }
        ArrayList result2 = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(element, elements, stopAt, null, null, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull PsiElement container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable PsiElement context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        StubElement stub;
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(40);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(41);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(42);
        }
        if (!(container instanceof PsiFileImpl || container instanceof StubBasedPsiElementBase || container instanceof LazyParseablePsiElement)) {
            return;
        }
        Object object = container instanceof PsiFileImpl ? ((PsiFileImpl)container).getStub() : (stub = container instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)container).getStub() : null);
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement child : stubs) {
                IStubElementType type;
                PsiElement psi = child.getPsi();
                if (psi == context && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set((Object)out.size());
                }
                if (targetElements.contains((IElementType)(type = child.getStubType()))) {
                    out.add(psi);
                }
                if (stopAt.contains((IElementType)type)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(psi, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
            }
        } else {
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(container.getNode(), targetElements, stopAt, context != null ? context.getNode() : null, outTargetElementsBeforeContext, out);
        }
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull ASTNode container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable ASTNode context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(43);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(44);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(45);
        }
        for (ASTNode child = container.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type;
            if (child == context && outTargetElementsBeforeContext != null) {
                outTargetElementsBeforeContext.set((Object)out.size());
            }
            if (targetElements.contains(type = child.getElementType())) {
                out.add(child.getPsi());
            }
            if (stopAt.contains(type)) continue;
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(child, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
        }
    }

    @Nullable
    public static JSDocComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(46);
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element);
            if (docComment instanceof JSDocComment) {
                candidate = (JSDocComment)docComment;
            }
        } else if (element instanceof JSDefinitionExpression) {
            PsiElement prevSibling;
            if ((element = element.getContext()) != null && (prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(element)) instanceof JSDocComment) {
                candidate = (JSDocComment)prevSibling;
            }
        } else {
            candidate = (JSDocComment)((StubBasedPsiElementBase)element).getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(47);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getNextSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getNextSibling();
    }

    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(48);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getPrevSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getPrevSibling();
    }

    @NotNull
    public static <T extends JSExpression> Collection<T> findReturnedExpressions(@NotNull JSFunction function, Class<? extends T> ... classes) {
        if (function == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(49);
        }
        SmartList candidates = new SmartList();
        if (function.getStub() != null) {
            List<Object> candidateParents = function instanceof JSFunctionExpression && ((JSFunctionExpression)function).isShorthandArrowFunction() ? Collections.singletonList(function) : JSStubBasedPsiTreeUtil.findDescendants((PsiElement)function, RETURN_STATEMENT_TOKEN_SET, FUNCTIONS_TOKEN_SET);
            for (StubBasedPsiElement statement : candidateParents) {
                StubElement returnStub = statement.getStub();
                if (returnStub == null) continue;
                List childrenStubs = returnStub.getChildrenStubs();
                for (StubElement childrenStub : childrenStubs) {
                    PsiElement psi = childrenStub.getPsi();
                    if (!(psi instanceof JSExpression)) continue;
                    candidates.add((JSExpression)psi);
                }
            }
        } else {
            JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
            if ((expression = JSUtils.unparenthesize(expression)) != null) {
                candidates.add(expression);
            } else {
                function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor((List)candidates){
                    final /* synthetic */ List val$candidates;
                    {
                        this.val$candidates = list;
                    }

                    public void visitJSFunctionExpression(JSFunctionExpression node) {
                    }

                    public void visitJSFunctionDeclaration(JSFunction node) {
                    }

                    public void visitJSReturnStatement(JSReturnStatement node) {
                        JSExpression expression = node.getExpression();
                        this.val$candidates.add(expression);
                    }
                });
            }
        }
        Collection collection = candidates.stream().filter(c -> PsiTreeUtil.instanceOf((Object)c, (Class[])classes)).map(c -> c).collect(Collectors.toList());
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(50);
        }
        return collection;
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase element, @NotNull TokenSet filter) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(51);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(52);
        }
        return JSStubBasedPsiTreeUtil.getStubOrPsiChild(element, filter, TokenSet.EMPTY);
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase<?> element, @NotNull TokenSet filter, @NotNull TokenSet stopAt) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(53);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(54);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(55);
        }
        if ((stub = element.getStub()) != null) {
            List childrenStubs = stub.getChildrenStubs();
            for (StubElement childStub : childrenStubs) {
                IStubElementType stubType = childStub.getStubType();
                if (filter.contains((IElementType)stubType)) {
                    return childStub.getPsi();
                }
                if (!stopAt.contains((IElementType)stubType)) continue;
                return null;
            }
        } else {
            for (ASTNode child = element.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType elementType = child.getElementType();
                if (filter.contains(elementType)) {
                    return child.getPsi();
                }
                if (!stopAt.contains(elementType)) continue;
                return null;
            }
        }
        return null;
    }

    public static PsiElement[] getChildrenByType(JSElement element, TokenSet type) {
        if (element instanceof JSFileImpl || element instanceof JSStubElementImpl) {
            StubElement stub;
            StubElement stubElement = stub = element instanceof JSFileImpl ? ((JSFileImpl)element).getStub() : ((JSStubElementImpl)element).getStub();
            if (stub != null) {
                return stub.getChildrenByType(type, JSElement.ARRAY_FACTORY);
            }
        }
        ASTNode[] children = element.getNode().getChildren(type);
        PsiElement[] result2 = new PsiElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result2[i] = children[i].getPsi();
        }
        return result2;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(56);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(57);
        }
        return psiElement;
    }

    @NotNull
    public static Collection<PsiElement> calculateMeaningfulElements(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(58);
        }
        Collection<PsiElement> collection = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolveResult, null, x -> false, x -> false);
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(59);
        }
        return collection;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(60);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, x -> false);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(61);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited, @NotNull Predicate<PsiElement> stopAt) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(62);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(63);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, stopAt, x -> false);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(64);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited, @NotNull Predicate<PsiElement> stopAt, @NotNull Predicate<PsiElement> stopBefore) {
        Collection<PsiElement> elements;
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(65);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(66);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(67);
        }
        if ((elements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolveResult, visited, stopAt, stopBefore)).size() > 1) {
            PsiElement psiElement = resolveResult;
            if (psiElement == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(68);
            }
            return psiElement;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        PsiElement psiElement = item == null ? resolveResult : item;
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(69);
        }
        return psiElement;
    }

    @NotNull
    public static Collection<PsiElement> calculateMeaningfulElements(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited, @NotNull Predicate<PsiElement> stopAt, @NotNull Predicate<PsiElement> stopBefore) {
        PsiElement localResolved;
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(70);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(71);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(72);
        }
        if (stopAt.test(resolveResult)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(73);
            }
            return list;
        }
        if (visited != null && !visited.add((PsiElement)resolveResult)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(74);
            }
            return list;
        }
        String initializerReference = null;
        List referencedElements = ContainerUtil.newSmartList();
        boolean referencedViaExportAssignment = false;
        if (resolveResult instanceof JSVariable) {
            PsiReference reference;
            PsiElement parent;
            JSExpression methodExpression;
            JSExpression initializer = ((JSVariable)resolveResult).getInitializerOrStub();
            if (initializer instanceof JSReferenceExpression) {
                Collection<PsiElement> elements = JSResolveResult.resolveReference((PsiPolyVariantReference)((JSReferenceExpression)initializer));
                if (!elements.isEmpty()) {
                    referencedElements.addAll(elements);
                }
            } else if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                referencedElements.addAll(JSStubBasedPsiTreeUtil.getRequireCallReferencedElement((JSCallExpression)initializer));
            } else if (initializer instanceof JSCallExpression && (methodExpression = ((JSCallExpression)initializer).getStubSafeMethodExpression()) instanceof JSFunctionExpression) {
                Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)methodExpression), JSFunctionExpression.class);
                referencedElements.addAll(returnedExpressions);
            }
            String initializerText = ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText();
            if (initializerText != null && JSSymbolUtil.isValidPropertyName(initializerText)) {
                initializerReference = initializerText;
            }
            if ((parent = resolveResult.getParent()) instanceof JSDestructuringProperty && referencedElements.isEmpty() && (reference = parent.getReference()) instanceof JSDestructuringPropertyReference) {
                referencedElements.addAll(JSResolveResult.resolveReference((PsiPolyVariantReference)((JSDestructuringPropertyReference)reference)));
            }
        } else if (resolveResult instanceof JSProperty) {
            if (((JSProperty)resolveResult).isGetProperty() && resolveResult instanceof JSFunction) {
                JSType type = ((JSFunction)resolveResult).getReturnType();
                if (type instanceof JSRequireCallExpressionType) {
                    referencedElements.addAll(JSStubBasedPsiTreeUtil.resolveRequireCallReference(resolveResult, ((JSRequireCallExpressionType)type).getReferencedModule()));
                }
            } else {
                initializerReference = ((JSProperty)resolveResult).getInitializerReference();
            }
        } else if (resolveResult instanceof JSDefinitionExpression) {
            initializerReference = ((JSDefinitionExpression)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            Collection importElements = ((TypeScriptImportStatement)resolveResult).findReferencedElements();
            referencedElements.addAll(importElements);
        } else if (resolveResult instanceof ES6ImportExportSpecifierAlias) {
            PsiElement element = ((ES6ImportExportSpecifierAlias)resolveResult).findAliasedElement();
            ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)element);
        } else if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            Collection elements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            referencedElements.addAll(elements);
        } else if (resolveResult instanceof JSExportAssignment) {
            initializerReference = ((JSExportAssignment)resolveResult).getInitializerReference();
            if (initializerReference == null) {
                ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)((JSExportAssignment)resolveResult).getStubSafeElement());
            }
            referencedViaExportAssignment = true;
        }
        if (!(initializerReference == null || !referencedElements.isEmpty() || (localResolved = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult)) == null || referencedViaExportAssignment && localResolved instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)localResolved).size() != 1)) {
            ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)localResolved);
        }
        if (referencedElements.isEmpty()) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(75);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement element : referencedElements) {
            if (visited == null) {
                visited = new THashSet();
            }
            if (stopBefore.test(element)) {
                List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
                if (list == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(76);
                }
                return list;
            }
            result2.addAll(JSStubBasedPsiTreeUtil.calculateMeaningfulElements(element, (Set<PsiElement>)visited, stopAt, stopBefore));
        }
        List list = result2;
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(77);
        }
        return list;
    }

    @NotNull
    public static PsiElement calculateTargetElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(78);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, IS_TARGET);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(79);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateTargetElementForHighlighting(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(80);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, SEMANTIC_HIGHLIGHTING_STOP_AT, SEMANTIC_HIGHLIGHTING_STOP_BEFORE);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(81);
        }
        return psiElement;
    }

    @NotNull
    private static Collection<PsiElement> getRequireCallReferencedElement(JSCallExpression initializer) {
        String referencePath;
        JSLiteralExpression argument = JSStubBasedPsiTreeUtil.findRequireCallArgument(initializer);
        String string = referencePath = argument != null ? argument.getSignificantValue() : null;
        if (referencePath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(82);
            }
            return list;
        }
        Collection<PsiElement> collection = JSStubBasedPsiTreeUtil.resolveRequireCallReference((PsiElement)initializer, StringUtil.unquoteString((String)referencePath));
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(83);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiElement> resolveRequireCallReference(@NotNull PsiElement context, @Nullable String unquotedModuleName) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(84);
        }
        if (unquotedModuleName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(85);
            }
            return list;
        }
        Collection<JSFile> files = CommonJSUtil.resolveReferencedElements(context, unquotedModuleName);
        if (files.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(86);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JSFile file2 : files) {
            List candidates = ContainerUtil.newSmartList();
            if (JSAmdPsiUtil.isWithinAmdModule(context)) {
                JSFunctionExpression defaultAmdModule = JSAmdModulesIndex.findDefaultAmdModule(file2);
                if (defaultAmdModule != null) {
                    JSType returnType = defaultAmdModule.getReturnType();
                    if (returnType instanceof JSReferenceType) {
                        ContainerUtil.addIfNotNull((Collection)candidates, (Object)JSStubBasedPsiTreeUtil.resolveLocally(((JSReferenceType)returnType).getReferencedName(), (PsiElement)defaultAmdModule));
                    } else {
                        candidates.addAll(JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)defaultAmdModule, JSExpression.class));
                    }
                }
            } else {
                candidates.addAll(JSResolveUtil.getExportedElements(file2));
            }
            if (candidates.isEmpty()) {
                result2.add(file2);
                continue;
            }
            result2.addAll(candidates);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    @Nullable
    public static JSLiteralExpression findRequireCallArgument(@NotNull JSCallExpression callExpression) {
        Collection<JSLiteralExpression> expressions;
        if (callExpression == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(88);
        }
        return (expressions = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)callExpression, JSStubElementTypes.LITERAL_EXPRESSION)).size() == 1 ? expressions.iterator().next() : null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull JSDocComment psiComment) {
        if (psiComment == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(89);
        }
        PsiElement parent = psiComment.getContext();
        PsiElement next = null;
        if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getStubSafeVariables();
            if (variables.length > 0) {
                next = variables[0];
            }
        } else {
            JSDocComment nextDoc;
            next = JSStubBasedPsiTreeUtil.getNextSibling((PsiElement)psiComment);
            while (next instanceof PsiWhiteSpace) {
                next = JSStubBasedPsiTreeUtil.getNextSibling(next);
            }
            if (next != null && (nextDoc = JSStubBasedPsiTreeUtil.findDocComment(next)) != null && nextDoc != psiComment) {
                next = null;
            }
        }
        return next;
    }

    @Nullable
    public static JSExpression findStubSafeChildExpression(StubBasedPsiElementBase<?> element) {
        StubElement stub = element.getStub();
        if (stub != null) {
            StubElement expressionStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
            return expressionStub != null ? (JSExpression)expressionStub.getPsi() : null;
        }
        ASTNode exprNode = element.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return exprNode != null ? (JSExpression)exprNode.getPsi() : null;
    }

    public static Stream<? extends PsiElement> getFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(90);
        }
        return JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(fileOrModule, null, null);
    }

    @NotNull
    public static Stream<? extends PsiElement> getFilteredFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule, @Nullable JSStubElementType stubSearchFilter, @Nullable Class<? extends PsiElement> psiSearchFilter) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(91);
        }
        StubElement stub = null;
        if (fileOrModule instanceof PsiFileImpl) {
            stub = ((PsiFileImpl)fileOrModule).getGreenStub();
        } else if (fileOrModule instanceof JSStubElementImpl) {
            stub = ((JSStubElementImpl)fileOrModule).getGreenStub();
        }
        if (stub != null) {
            Stream<PsiElement> stream = stub.getChildrenStubs().stream().filter(el -> stubSearchFilter == null || el.getStubType() == stubSearchFilter).map(childStub -> childStub.getPsi());
            if (stream == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(92);
            }
            return stream;
        }
        JBIterable iterable = SyntaxTraverser.psiTraverser().children((Object)fileOrModule);
        if (psiSearchFilter != null) {
            iterable = iterable.filter(psiSearchFilter);
        }
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterable.iterator(), 16);
        Stream stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(93);
        }
        return stream;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, boolean includeRawSignatures) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(94);
        }
        Collection<JSFunctionWithSubstitutor> collection = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(element, methodExpression, null, includeRawSignatures);
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(95);
        }
        return collection;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        Collection implicitElements;
        JSElementIndexingData data;
        JSExpression initializer;
        boolean isTypeScript;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(96);
        }
        if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
        }
        if ((element = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element, visited, !(isTypeScript = DialectDetector.isTypeScript(element)) ? x -> false : el -> {
            if (DialectDetector.isTypeScript(el) && el instanceof JSTypeDeclarationOwner) {
                return ((JSTypeDeclarationOwner)el).getTypeElement() != null;
            }
            return false;
        })) instanceof JSFunctionItem) {
            if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadImplementation()) {
                List overloads = ((TypeScriptFunction)element).getOverloadDeclarations();
                Collection collection = overloads.stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(97);
                }
                return collection;
            }
            JSFunctionItem function = ((JSFunctionItem)element).isGetProperty() ? null : (JSFunctionItem)element;
            Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(function);
            if (collection == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(98);
            }
            return collection;
        }
        if (element instanceof JSInitializerOwner && !isTypeScript) {
            initializer = ((JSInitializerOwner)element).getInitializerOrStub();
            if (initializer instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(99);
                }
                return collection;
            }
            if (initializer instanceof ES6Class) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((ES6Class)initializer).getConstructor());
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(100);
                }
                return collection;
            }
        }
        if (element instanceof JSVariable) {
            if ((!isTypeScript || ((JSVariable)element).getTypeElement() == null) && (initializer = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)((JSVariable)element))) instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(101);
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(element);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(102);
                }
                return collection;
            }
            if (isTypeScript) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForVariable((JSFieldVariable)((JSVariable)element), methodExpression, visited, includeRawSignatures);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(103);
                }
                return collection;
            }
        } else if (element instanceof JSField) {
            if (isTypeScript) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForVariable((JSFieldVariable)((JSField)element), methodExpression, visited, includeRawSignatures);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(104);
                }
                return collection;
            }
        } else if (element instanceof JSProperty) {
            JSFunction value = ((JSProperty)element).tryGetFunctionInitializer();
            if (value != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)value);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(105);
                }
                return collection;
            }
        } else if (element instanceof JSDefinitionExpression) {
            initializer = ((JSDefinitionExpression)element).getInitializerOrStub();
            if (initializer instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)initializer);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(106);
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(element);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(107);
                }
                return collection;
            }
        } else if (element instanceof JSImplicitElement) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSLiteralExpressionImpl) {
                JSFunction function;
                JSProperty property;
                JSObjectLiteralExpression nextArgument = null;
                JSLiteralExpressionStub stub = (JSLiteralExpressionStub)((JSLiteralExpressionImpl)parent).getStub();
                if (stub != null) {
                    StubElement nextSibling = StubTreeUtil.getNextSibling(stub);
                    if (nextSibling instanceof JSObjectLiteralExpressionStub) {
                        nextArgument = (JSObjectLiteralExpression)((JSObjectLiteralExpressionStub)nextSibling).getPsi();
                    }
                } else {
                    JSExpression[] arguments;
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof JSArgumentList && (arguments = ((JSArgumentList)grandParent).getArguments()).length == 2 && arguments[0] == parent && arguments[1] instanceof JSObjectLiteralExpression) {
                        nextArgument = (JSObjectLiteralExpression)arguments[1];
                    }
                }
                if (nextArgument != null && (property = nextArgument.findProperty("construct")) != null && (function = property.tryGetFunctionInitializer()) != null) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)function);
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(108);
                    }
                    return collection;
                }
            } else if (parent instanceof JSDocComment) {
                JSFunctionExpression constructsFunction;
                PsiElement associatedElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)parent);
                JSFunctionExpression jSFunctionExpression = constructsFunction = associatedElement != null ? JSPsiImplUtils.findConstructsFunction(associatedElement) : null;
                if (constructsFunction != null) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)constructsFunction);
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(109);
                    }
                    return collection;
                }
            }
        } else if (element instanceof TypeScriptClass) {
            if (methodExpression != null) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptUtil.resolveConstructorFunctions((TypeScriptClass)element, methodExpression);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(110);
                }
                return collection;
            }
        } else {
            if (element instanceof ES6Class) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((ES6Class)element).getConstructor());
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(111);
                }
                return collection;
            }
            if (element instanceof TypeScriptImportStatement) {
                Collection elements = ((TypeScriptImportStatement)element).findReferencedElements();
                if (visited == null) {
                    visited = new THashSet();
                }
                if (!visited.add((PsiElement)element)) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(112);
                    }
                    return list;
                }
                ArrayList result2 = ContainerUtil.newArrayList();
                for (PsiElement psiElement : elements) {
                    result2.addAll(JSStubBasedPsiTreeUtil.calculatePossibleFunctions(psiElement, methodExpression, (Set<PsiElement>)visited, includeRawSignatures));
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(113);
                }
                return arrayList;
            }
        }
        if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!(implicitElement instanceof JSImplicitFunctionImpl)) continue;
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSImplicitFunctionImpl)implicitElement);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(114);
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(115);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 68: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 68: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 25: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 68: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 53: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 38: 
            case 42: 
            case 45: 
            case 55: 
            case 63: 
            case 66: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElements";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 65: 
            case 70: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopBefore";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocallyWithMergedResults";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubBasedNamesMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInStubScopeWithContext";
                break;
            }
            case 32: 
            case 35: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findDescendants";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnedExpressions";
                break;
            }
            case 57: 
            case 61: 
            case 64: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElement";
                break;
            }
            case 59: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElements";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTargetElement";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTargetElementForHighlighting";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequireCallReferencedElement";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRequireCallReference";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyWithMergedResults";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 68: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasStub";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeStubBased";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildStubBasedNamesMap";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInStubScopeWithContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeAstBased";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDescendants";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addDescendantsRecursively";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findReturnedExpressions";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 56: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElement";
                break;
            }
            case 58: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElements";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElement";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElementForHighlighting";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "resolveRequireCallReference";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findRequireCallArgument";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedElement";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrModuleChildrenStream";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
            case 94: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 68: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 92: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

