/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLiteralBasedPropertyElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSRenameExtension;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultRenameProcessor
extends RenamePsiElementProcessor {
    public static final String SEARCH_IN_COMMENTS = "js.rename.search.in.comments";
    public static final String SEARCH_FOR_TEXT_OCCURRENCES = "js.rename.search.for.text.occurrences";
    public static final String SEARCH_FOR_JAVASCRIPT_OCCURRENCES = "ts.rename.search.for.js.occurrences";

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof JSNamedElement || element instanceof TypeScriptLiteralBasedPropertyElement;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        String newFileName;
        PsiFile containingFile;
        VirtualFile virtualFile;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(4);
        }
        super.prepareRenaming(element, newName, allRenames, scope);
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> overloads = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element);
            overloads.forEach(el -> {
                if (allRenames == null) {
                    JSDefaultRenameProcessor.$$$reportNull$$$0(59);
                }
                if (newName == null) {
                    JSDefaultRenameProcessor.$$$reportNull$$$0(60);
                }
                allRenames.put((PsiElement)el, newName);
            });
        }
        VirtualFile virtualFile2 = virtualFile = (containingFile = element.getContainingFile()) != null ? containingFile.getVirtualFile() : null;
        if (!StringUtil.isEmpty((String)newName) && element instanceof JSNamedElement && !DialectDetector.isActionScript(element) && virtualFile != null && JSDefaultRenameProcessor.isTopLevelElementInMatchingFile((JSNamedElement)element) && (newFileName = JSNameSuggestionsUtil.fileNameFromElementName((JSNamedElement)element, newName)) != null && !StringUtil.equals((CharSequence)newFileName, (CharSequence)virtualFile.getNameWithoutExtension())) {
            boolean renameContainingFile;
            String newFileNameWithExtension = newFileName + "." + virtualFile.getExtension();
            String message = JSBundle.message((String)"javascript.rename.containing.file.message", (Object[])new Object[]{newFileNameWithExtension});
            boolean bl = renameContainingFile = Messages.showYesNoDialog((Project)element.getProject(), (String)message, (String)JSBundle.message((String)"javascript.rename.file.with.related.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            if (renameContainingFile) {
                allRenames.put((PsiElement)containingFile, newFileNameWithExtension);
                for (JSRenameExtension extension : (JSRenameExtension[])JSRenameExtension.EP_NAME.getExtensions()) {
                    allRenames.putAll(extension.getAdditionalFilesToRename(element, containingFile, newFileName));
                }
            }
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(8);
        }
        for (Map.Entry<PsiElement, String> entry : allRenames.entrySet()) {
            this.findExistingNameConflicts(entry.getKey(), entry.getValue(), conflicts);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(10);
        }
        if (conflicts == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(11);
        }
        boolean processStatics = element instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.STATIC);
        JSElement scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class});
        PsiElement existing = (PsiElement)ContainerUtil.getFirstItem(JSRefactoringUtil.findExistingInScope(newName, (PsiElement)scope, processStatics));
        if (!(existing == null || existing == element || existing instanceof JSInitializerOwner && ((JSInitializerOwner)existing).getInitializer() == element)) {
            conflicts.putValue((Object)existing, (Object)JSRefactoringUtil.getMemberAlreadyExistsMessage(existing));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        boolean isTypeScript;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(12);
        }
        ReferencesType refType = (isTypeScript = DialectDetector.isTypeScript(element)) && !JSDefaultRenameProcessor.getSearchJavaScriptReferences(element) ? ReferencesType.TS : ReferencesType.ALL;
        Collection<PsiReference> collection = JSDefaultRenameProcessor.getReferences(element, searchInCommentsAndStrings, refType);
        if (collection == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiReference> getReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings, @NotNull ReferencesType type) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(14);
        }
        if (type == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<PsiReference> collection = JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, JSDefaultRenameProcessor.getScope(element, type));
        if (collection == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static SearchScope getScope(@NotNull PsiElement element, @NotNull ReferencesType type) {
        SearchScope defaultScope;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(17);
        }
        if (type == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(18);
        }
        if (!((defaultScope = element.getUseScope()) instanceof GlobalSearchScope) || type == ReferencesType.ALL) {
            SearchScope searchScope = defaultScope;
            if (searchScope == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(19);
            }
            return searchScope;
        }
        final boolean useJS = type == ReferencesType.JS;
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope((GlobalSearchScope)defaultScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                return useJS == DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file2.getFileType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(20);
        }
        return delegatingGlobalSearchScope;
    }

    public static Collection<PsiReference> findReferencesForScope(PsiElement element, boolean searchInCommentsAndStrings, SearchScope useScope) {
        return JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, useScope, -1L);
    }

    public static Collection<PsiReference> findReferencesForScope(final PsiElement element, final boolean searchInCommentsAndStrings, SearchScope useScope, final long timeoutMs) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        final boolean hasES6Imports = holder != null && (holder.isTypeScript || holder.isECMA6);
        List<PsiReference> result2 = Collections.synchronizedList(new ArrayList());
        final long start = timeoutMs <= 0L ? 0L : System.currentTimeMillis();
        try {
            ReferencesSearch.search((PsiElement)element, (SearchScope)useScope).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(result2){

                protected boolean accept(PsiReference psiReference) {
                    if (timeoutMs > 0L && System.currentTimeMillis() - start > timeoutMs) {
                        throw new ProcessCanceledException();
                    }
                    return JSDefaultRenameProcessor.acceptReference(psiReference, searchInCommentsAndStrings, hasES6Imports, element);
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return result2;
    }

    public static boolean acceptReference(PsiReference psiReference, boolean searchInCommentsAndStrings, boolean hasES6Imports, PsiElement renameTarget) {
        PsiElement resolve;
        String elementName;
        boolean accept;
        boolean bl = accept = searchInCommentsAndStrings || JSDefaultRenameProcessor.isStrictlyRenameableReference(psiReference);
        if (!accept) {
            return false;
        }
        if (!hasES6Imports) {
            return true;
        }
        if (renameTarget instanceof ES6ImportExportSpecifierAlias) {
            return true;
        }
        PsiElement referenceElement = psiReference.getElement();
        String string = elementName = renameTarget instanceof JSNamedElement ? ((JSNamedElement)renameTarget).getName() : null;
        if (referenceElement instanceof ES6ImportExportSpecifier && "default".equals(((ES6ImportExportSpecifier)referenceElement).getReferenceName())) {
            return false;
        }
        if (referenceElement instanceof JSReferenceExpression && ((JSReferenceExpression)referenceElement).getQualifier() == null || referenceElement instanceof ES6ImportExportSpecifier) {
            PsiElement item;
            ResolveResult[] results = ((PsiPolyVariantReference)referenceElement).multiResolve(false);
            if (results.length == 1 && (renameTarget.isEquivalentTo(item = results[0].getElement()) || item instanceof TypeScriptProxyImplicitElement && renameTarget.isEquivalentTo(((TypeScriptProxyImplicitElement)item).getExplicitElement()))) {
                return true;
            }
            for (ResolveResult result2 : results) {
                if (!JSDefaultRenameProcessor.importDefinesLocalName(result2.getElement(), elementName)) continue;
                return false;
            }
        }
        if (JSDefaultRenameProcessor.importDefinesLocalName(referenceElement, elementName)) {
            return false;
        }
        if (referenceElement instanceof JSXmlLiteralExpression && DialectDetector.isJSX(renameTarget) && (resolve = psiReference.resolve()) != null) {
            if (renameTarget.isEquivalentTo(resolve)) {
                return true;
            }
            if (JSDefaultRenameProcessor.importDefinesLocalName(resolve, elementName)) {
                return false;
            }
        }
        return true;
    }

    private static boolean importDefinesLocalName(@Nullable PsiElement importElement, String elementName) {
        if (importElement instanceof ES6ImportedBinding) {
            return !StringUtil.equals((CharSequence)((ES6ImportedBinding)importElement).getName(), (CharSequence)elementName);
        }
        return importElement instanceof ES6ImportExportSpecifierAlias || importElement instanceof TypeScriptImportStatement || importElement instanceof TypeScriptImplicitOverloadedAliasElement;
    }

    public static boolean isStrictlyRenameableReference(PsiReference psiReference) {
        boolean reallyWeak;
        if (psiReference instanceof JSXNamespaceReference) {
            return true;
        }
        PsiElement element = psiReference.getElement();
        boolean bl = reallyWeak = psiReference.isSoft() && element instanceof JSLiteralExpression && !(element.getParent() instanceof JSIndexedPropertyAccessExpression);
        if (!reallyWeak) {
            return true;
        }
        return JSResolveUtil.getExpressionJSType((JSExpression)((JSLiteralExpression)element)) instanceof JSLiteralKeyType;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(21);
        }
        return PropertiesComponent.getInstance().getBoolean(SEARCH_IN_COMMENTS, true);
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(22);
        }
        PropertiesComponent.getInstance().setValue(SEARCH_IN_COMMENTS, String.valueOf(enabled));
        super.setToSearchInComments(element, enabled);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(23);
        }
        return PropertiesComponent.getInstance().getBoolean(SEARCH_FOR_TEXT_OCCURRENCES);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(24);
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return null;
        }
        element = JSDefaultRenameProcessor.substituteOverload(element);
        if ((element = this.substituteDestructuringShorthanding(element, editor, null)) == null) {
            return null;
        }
        return this.substituteShorthandedProperty(element, editor, null);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(26);
        }
        if (renameCallback == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(27);
        }
        element = JSDefaultRenameProcessor.substituteOverload(element);
        if ((element = this.substituteDestructuringShorthanding(element, editor, renameCallback)) == null) {
            return;
        }
        if ((element = this.substituteShorthandedProperty(element, editor, renameCallback)) == null) {
            return;
        }
        renameCallback.pass((Object)element);
    }

    @Nullable
    private PsiElement substituteShorthandedProperty(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Pass<PsiElement> callback) {
        PsiElement valueResolveResult;
        ES6Property propertyResolveResult;
        ES6Property property;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(28);
        }
        ES6Property eS6Property = property = element instanceof ES6Property ? (ES6Property)element : null;
        if (property == null || !property.isShorthanded() || property.getValue() == null) {
            return element;
        }
        PsiReference reference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        ES6Property atCaret = reference != null ? (ES6Property)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), ES6Property.class, (boolean)false) : null;
        JSReferenceExpression referenceExpression = property.getValue() instanceof JSReferenceExpression ? (JSReferenceExpression)property.getValue() : null;
        Object object = propertyResolveResult = property.getPropertyNameReference() != null ? (PsiElement)ObjectUtils.coalesce((Object)property.getPropertyNameReference().resolve(), (Object)property) : property;
        if (atCaret == property && referenceExpression != null && (valueResolveResult = referenceExpression.resolve()) != null) {
            String valueDescription = ElementDescriptionUtil.getElementDescription((PsiElement)valueResolveResult, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String title = JSBundle.message((String)"javascript.rename.shorthand.target.dialog.title", (Object[])new Object[]{valueDescription});
            String message = JSBundle.message((String)"javascript.rename.choose.target.message", (Object[])new Object[0]);
            String propertyDescription = JSBundle.message((String)"javascript.rename.shorthand.property.description", (Object[])new Object[0]);
            return this.substituteWithPopup(editor, callback, title, message, valueResolveResult, StringUtil.capitalize((String)valueDescription), (PsiElement)propertyResolveResult, propertyDescription);
        }
        return propertyResolveResult;
    }

    @NotNull
    private static PsiElement substituteOverload(PsiElement element) {
        TypeScriptFunction impl;
        TypeScriptFunction func;
        if (element instanceof TypeScriptFunction && (func = (TypeScriptFunction)element).isOverloadDeclaration() && (impl = TypeScriptPsiUtil.getOverloadImplementation(func)) != null) {
            TypeScriptFunction typeScriptFunction = impl;
            if (typeScriptFunction == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(29);
            }
            return typeScriptFunction;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(30);
        }
        return psiElement;
    }

    @Nullable
    private PsiElement substituteDestructuringShorthanding(@NotNull PsiElement element, @Nullable Editor editor, @Nullable Pass<PsiElement> renameCallback) {
        PsiElement shorthandedPropertyResolve;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(31);
        }
        if (!(element instanceof JSVariable)) {
            return element;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSDestructuringShorthandedProperty)) {
            return element;
        }
        PsiReference propertyRef = parent.getReference();
        PsiElement psiElement = shorthandedPropertyResolve = propertyRef instanceof JSDestructuringPropertyReference ? propertyRef.resolve() : null;
        if (shorthandedPropertyResolve != null) {
            String description = ElementDescriptionUtil.getElementDescription((PsiElement)shorthandedPropertyResolve, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String title = JSBundle.message((String)"javascript.rename.destructuring.target.dialog.title", (Object[])new Object[]{description});
            String message = JSBundle.message((String)"javascript.rename.choose.target.message", (Object[])new Object[0]);
            String initializer = JSBundle.message((String)"javascript.destructuring.initializer", (Object[])new Object[]{description});
            String variable = JSBundle.message((String)"javascript.destructuring.variable.only", (Object[])new Object[0]);
            return this.substituteWithPopup(editor, renameCallback, title, message, shorthandedPropertyResolve, initializer, element, variable);
        }
        return element;
    }

    @Nullable
    @Contract(value="null,null,_,_,_,_,_,_ -> fail")
    protected PsiElement substituteWithPopup(@Nullable Editor editor, @Nullable Pass<PsiElement> renameCallback, @NotNull String title, @Nullable String message, @NotNull PsiElement defaultElement, @NotNull String defaultElementLabel, @NotNull PsiElement otherElement, @NotNull String otherElementLabel) {
        if (title == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(32);
        }
        if (defaultElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(33);
        }
        if (defaultElementLabel == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(34);
        }
        if (otherElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(35);
        }
        if (otherElementLabel == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(36);
        }
        if (defaultElement == otherElement) {
            return this.processSubstituted(defaultElement, editor, renameCallback);
        }
        if (renameCallback == null || ApplicationManager.getApplication().isUnitTestMode()) {
            int exitCode = Messages.showOkCancelDialog((Project)defaultElement.getProject(), (String)message, (String)title, (String)defaultElementLabel, (String)otherElementLabel, (Icon)Messages.getQuestionIcon());
            return this.processSubstituted(exitCode == 0 ? defaultElement : otherElement, editor, renameCallback);
        }
        assert (editor != null) : "editor must be provided for inplace rename";
        JBList list = new JBList((Object[])new String[]{defaultElementLabel, otherElementLabel});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            String value;
            if (defaultElementLabel == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(56);
            }
            if (defaultElement == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(57);
            }
            if (otherElement == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(58);
            }
            if ((value = (String)list.getSelectedValue()) != null) {
                PsiElement method = value.equals(defaultElementLabel) ? defaultElement : otherElement;
                this.processSubstituted(method, editor, renameCallback);
            }
        }).createPopup().showInBestPositionFor(editor);
        return null;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, final @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(37);
        }
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(38);
        }
        boolean isContextTypeScript = nameSuggestionContext != null && DialectDetector.isTypeScript(nameSuggestionContext);
        boolean isElementToRenameTypeScript = DialectDetector.isTypeScript(element);
        if (!isContextTypeScript) {
            if (isElementToRenameTypeScript) {
                JSDefaultRenameProcessor.setSearchJavaScriptReferences(element, true);
            }
            RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
            if (renameDialog == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(39);
            }
            return renameDialog;
        }
        RenameDialog renameDialog = new RenameDialog(project, element, nameSuggestionContext, editor){
            private JCheckBox myCbSearchForReferences;

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                gbConstraints.insets = JBUI.insetsBottom((int)4);
                gbConstraints.gridwidth = 1;
                gbConstraints.gridx = 0;
                gbConstraints.weighty = 0.0;
                gbConstraints.weightx = 1.0;
                gbConstraints.fill = 1;
                this.myCbSearchForReferences = new NonFocusableCheckBox(JSBundle.message((String)"typescript.rename.javascript.references", (Object[])new Object[0]));
                this.myCbSearchForReferences.setSelected(JSDefaultRenameProcessor.getSearchJavaScriptReferences(element));
                panel.add((Component)this.myCbSearchForReferences, gbConstraints);
                super.createCheckboxes(panel, gbConstraints);
            }

            protected void doAction() {
                JSDefaultRenameProcessor.setSearchJavaScriptReferences(element, this.myCbSearchForReferences.isSelected());
                super.doAction();
            }
        };
        if (renameDialog == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(40);
        }
        return renameDialog;
    }

    @Nullable
    protected PsiElement processSubstituted(@NotNull PsiElement psiElement, Editor editor, @Nullable Pass<PsiElement> renameCallback) {
        if (psiElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(41);
        }
        if (!PsiElementRenameHandler.canRename((Project)psiElement.getProject(), (Editor)editor, (PsiElement)psiElement)) {
            return null;
        }
        if (renameCallback != null) {
            renameCallback.pass((Object)super.substituteElementToRename(psiElement, editor));
            return null;
        }
        return psiElement;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        JSDestructuringProperty destructuringProperty;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(42);
        }
        if (newName == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(43);
        }
        if (usages == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(44);
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return;
        }
        PsiElement parent = element.getParent();
        JSDestructuringProperty jSDestructuringProperty = destructuringProperty = element instanceof JSVariable && parent instanceof JSDestructuringProperty ? (JSDestructuringProperty)parent : null;
        if (destructuringProperty != null) {
            destructuringProperty = destructuringProperty.setDestructuringElementName(newName);
            element = destructuringProperty.getDestructuringElement();
        }
        JSDefaultRenameProcessor.processShorthandProperties(element, newName, usages);
        super.renameElement(element, newName, usages, listener2);
    }

    private static boolean isTopLevelElementInMatchingFile(@NotNull JSNamedElement element) {
        JSExecutionScope scope;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(45);
        }
        return (scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)element, JSExecutionScope.class)) instanceof JSFile && JSNameSuggestionsUtil.matchesFileNameRelaxed(element);
    }

    private static void processShorthandProperties(@NotNull PsiElement element, String newName, @NotNull UsageInfo[] usages) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(46);
        }
        if (usages == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(47);
        }
        if (element instanceof ES6Property && ((ES6Property)element).isShorthanded()) {
            ES6ChangeUtil.expandShorthandPropertyWithName((ES6Property)element, newName);
        }
        boolean renameTargetRequiresQualifiedAccess = element instanceof ES6Property || JSUtils.isMember(element);
        List<ES6Property> shorthandUsages = JSDefaultRenameProcessor.collectShorthandPropertyUsages(ContainerUtil.mapNotNull((Object[])usages, UsageInfo::getReference));
        if (renameTargetRequiresQualifiedAccess) {
            for (ES6Property usage : shorthandUsages) {
                ES6ChangeUtil.expandShorthandPropertyWithName(usage, newName);
            }
        } else {
            for (ES6Property usage : shorthandUsages) {
                ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)usage, newName);
            }
        }
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        ResolveResult[] resolveResults;
        PsiElement psiElement;
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(48);
        }
        if (ref == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(49);
        }
        if (referenceElement == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(50);
        }
        if (DialectDetector.isTypeScript(element) && ref instanceof PsiPolyVariantReference && ((psiElement = ref.resolve()) == null || psiElement instanceof TypeScriptProxyImplicitElement) && (resolveResults = ((PsiPolyVariantReference)ref).multiResolve(true)).length > 0 && Arrays.stream(resolveResults).allMatch(r -> r.getElement() instanceof TypeScriptProxyImplicitElement)) {
            MoveRenameUsageInfo moveRenameUsageInfo = new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, false){
                {
                    this.myDynamicUsage = false;
                }
            };
            if (moveRenameUsageInfo == null) {
                JSDefaultRenameProcessor.$$$reportNull$$$0(51);
            }
            return moveRenameUsageInfo;
        }
        UsageInfo usageInfo = super.createUsageInfo(element, ref, referenceElement);
        if (usageInfo == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(52);
        }
        return usageInfo;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(53);
        }
        PropertiesComponent.getInstance().setValue(SEARCH_FOR_TEXT_OCCURRENCES, String.valueOf(enabled));
        super.setToSearchForTextOccurrences(element, enabled);
    }

    public static boolean getSearchJavaScriptReferences(PsiElement element) {
        return JSDefaultRenameProcessor.getSearchJavaScriptReferences(element.getProject());
    }

    public static boolean getSearchJavaScriptReferences(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(SEARCH_FOR_JAVASCRIPT_OCCURRENCES, true);
    }

    public static void setSearchJavaScriptReferences(PsiElement element, boolean enabled) {
        JSDefaultRenameProcessor.setSearchJavaScriptReferences(element.getProject(), enabled);
    }

    public static void setSearchJavaScriptReferences(Project project, boolean enabled) {
        PropertiesComponent.getInstance((Project)project).setValue(SEARCH_FOR_JAVASCRIPT_OCCURRENCES, enabled, true);
    }

    @NotNull
    public static List<ES6Property> collectShorthandPropertyUsages(@NotNull Collection<PsiReference> refs) {
        if (refs == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(54);
        }
        ArrayList results = ContainerUtil.newArrayList();
        for (PsiReference ref : refs) {
            PsiElement element = ref instanceof JSPropertyNameReference ? ref.getElement() : ref.getElement().getParent();
            ES6Property property = element instanceof ES6Property ? (ES6Property)element : null;
            if (property == null || !property.isShorthanded()) continue;
            results.add(property);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            JSDefaultRenameProcessor.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 51: 
            case 52: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 51: 
            case 52: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 43: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 8: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 51: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultElement";
                break;
            }
            case 34: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultElementLabel";
                break;
            }
            case 35: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherElement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherElementLabel";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteOverload";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShorthandPropertyUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 51: 
            case 52: 
            case 55: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "substituteShorthandedProperty";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "substituteDestructuringShorthanding";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithPopup";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processSubstituted";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelElementInMatchingFile";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processShorthandProperties";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "collectShorthandPropertyUsages";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$substituteWithPopup$1";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRenaming$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 39: 
            case 40: 
            case 51: 
            case 52: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReferencesType {
        ALL,
        TS,
        JS;

    }
}

