/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.inline.InjectionQuoteHandler;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FunctionInliner
implements JSInlineHandler.Inliner {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final JSFunction myFunction;
    private final ES6ReferenceExpressionsInfo myNonCallReferenceExpressionsInfo;
    private final ES6ReferenceExpressionsInfo myReferenceExpressionsInfoForCall;

    public FunctionInliner(@NotNull PsiElement element, @NotNull JSFunction function) {
        if (element == null) {
            FunctionInliner.$$$reportNull$$$0(0);
        }
        if (function == null) {
            FunctionInliner.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myFunction = function;
        PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)function);
        this.myNonCallReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo((PsiElement)function, module);
        JSElement body = (JSElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function), (Object)FunctionInliner.getFunctionBlockBody(function));
        this.myReferenceExpressionsInfoForCall = body != null ? ES6ReferenceExpressionsInfo.getInfo((PsiElement)body, module) : ES6ReferenceExpressionsInfo.EMPTY;
    }

    @Override
    public void checkConflicts(@NotNull PsiReference reference, @NotNull MultiMap<PsiElement, String> conflicts) {
        JSReferenceExpression referenceExpression;
        if (reference == null) {
            FunctionInliner.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            FunctionInliner.$$$reportNull$$$0(3);
        }
        if ((referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), JSReferenceExpression.class)) == null) {
            return;
        }
        if (this.myElement instanceof JSAttributeListOwner) {
            JSRefactoringConflictsUtil.checkClassMemberAccessibilityConflicts((PsiReference)referenceExpression, (JSAttributeListOwner)this.myElement, JSVisibilityUtil.DEFAULT_OPTIONS, conflicts);
        }
        if (this.myElement instanceof JSQualifiedNamedElement) {
            JSInlineHandler.checkES6ModuleConflicts(this.getReferenceExpressionsInfo(referenceExpression), (JSQualifiedNamedElement)this.myElement, ES6PsiUtil.findExternalModule((PsiElement)referenceExpression), conflicts);
        }
    }

    @Override
    @Nullable
    public PsiElement inlineUsage(@NotNull UsageInfo usage) {
        PsiElement usageElement;
        if (usage == null) {
            FunctionInliner.$$$reportNull$$$0(4);
        }
        if (FunctionInliner.isImportExportUsage(usageElement = usage.getElement()) || JSResolveUtil.isSelfReference(usageElement) || !(usageElement instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)usageElement;
        PsiElement usageModule = ES6PsiUtil.findExternalModule((PsiElement)referenceExpression);
        JSExpression usageReplacement = null;
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)referenceExpression.getParent(), JSCallExpression.class);
        if (callExpression != null) {
            JSElement[] replacement = FunctionInliner.calculateReplacementForCall(this.myFunction, callExpression);
            PsiElement usageParent = callExpression.getParent();
            if (replacement.length == 1 && replacement[0] instanceof JSExpression && !(usageParent instanceof JSExpressionStatement)) {
                JSExpression expression = (JSExpression)replacement[0];
                expression = FunctionInliner.removeRedundantAwaitExpressions(expression, (PsiElement)callExpression);
                usageReplacement = JSChangeUtil.replaceExpression((JSExpression)callExpression, expression);
            } else if (usageParent instanceof JSExpressionStatement) {
                if (replacement.length > 0) {
                    PsiElement first = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)replacement[0], PsiComment.class), (Object)replacement[0]);
                    PsiElement last = (PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)replacement[replacement.length - 1], PsiComment.class), (Object)replacement[replacement.length - 1]);
                    usageReplacement = usageParent.getParent().addRangeAfter(first, last, usageParent);
                    usageParent.delete();
                } else {
                    JSInlineHandler.deleteElementWithReformat(usageParent);
                }
            }
        } else {
            JSExpression thisExpression = JSPsiImplUtils.isArrowFunction(this.myFunction) ? referenceExpression.getQualifier() : null;
            JSFunction replacement = FunctionInliner.buildReplacementFunction(this.myFunction, (JSExpression)referenceExpression, Collections.emptyMap(), thisExpression);
            if (replacement == null) {
                return null;
            }
            JSFunctionExpression replacementFunctionExpression = replacement instanceof JSFunctionExpression ? (JSFunctionExpression)replacement.copy() : JSFunctionsRefactoringUtil.createAnonymousFunction(replacement);
            usageReplacement = JSChangeUtil.replaceExpression((JSExpression)referenceExpression, (JSExpression)replacementFunctionExpression);
        }
        if (usageModule != null) {
            ES6CreateImportUtil.addRequiredImports(this.getReferenceExpressionsInfo(referenceExpression), usageModule);
        }
        return usageReplacement;
    }

    @Override
    public void removeDefinition(@NotNull PsiElement element) {
        ASTNode prev;
        PsiElement whitespace;
        if (element == null) {
            FunctionInliner.$$$reportNull$$$0(5);
        }
        if (element instanceof JSFunction && element.getParent() instanceof JSClass && (whitespace = (prev = element.getNode().getTreePrev()).getPsi()) instanceof PsiWhiteSpace) {
            whitespace.delete();
        }
        JSInlineHandler.deleteElementWithReformat(element);
    }

    @NotNull
    private static JSElement[] calculateReplacementForCall(@NotNull JSFunction referenced, @NotNull JSCallExpression callExpr) {
        JSStatement[] statements;
        if (referenced == null) {
            FunctionInliner.$$$reportNull$$$0(6);
        }
        if (callExpr == null) {
            FunctionInliner.$$$reportNull$$$0(7);
        }
        THashMap parametersToActualMap = new THashMap();
        JSExpression thisExpression = ((JSReferenceExpression)callExpr.getMethodExpression()).getQualifier();
        JSExpression[] expressions = callExpr.getArguments();
        int currentActualIndex = 0;
        for (JSParameter p : referenced.getParameterVariables()) {
            if (expressions.length <= currentActualIndex) continue;
            parametersToActualMap.put(p, expressions[currentActualIndex++]);
        }
        JSFunction replacementFun = FunctionInliner.buildReplacementFunction(referenced, (JSExpression)callExpr, (Map<JSParameter, JSExpression>)parametersToActualMap, thisExpression);
        if (replacementFun == null) {
            if (JSElement.EMPTY_ARRAY == null) {
                FunctionInliner.$$$reportNull$$$0(8);
            }
            return JSElement.EMPTY_ARRAY;
        }
        PsiElement usageParent = callExpr.getParent();
        JSBlockStatement body = FunctionInliner.getFunctionBlockBody(replacementFun);
        JSStatement[] jSStatementArray = statements = body != null ? body.getStatements() : JSStatement.EMPTY;
        if (usageParent instanceof JSExpressionStatement && body != null) {
            if (statements == null) {
                FunctionInliner.$$$reportNull$$$0(9);
            }
            return statements;
        }
        JSExpression arrowReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(replacementFun);
        if (arrowReturnExpression != null) {
            JSElement[] jSElementArray = new JSElement[]{arrowReturnExpression};
            if (jSElementArray == null) {
                FunctionInliner.$$$reportNull$$$0(10);
            }
            return jSElementArray;
        }
        if (statements.length == 1) {
            JSStatement statement = statements[0];
            if (statement instanceof JSReturnStatement) {
                JSElement[] jSElementArray = new JSElement[]{((JSReturnStatement)statement).getExpression()};
                if (jSElementArray == null) {
                    FunctionInliner.$$$reportNull$$$0(11);
                }
                return jSElementArray;
            }
            if (statement instanceof JSExpressionStatement) {
                JSElement[] jSElementArray = new JSElement[]{((JSExpressionStatement)statement).getExpression()};
                if (jSElementArray == null) {
                    FunctionInliner.$$$reportNull$$$0(12);
                }
                return jSElementArray;
            }
        }
        if (JSElement.EMPTY_ARRAY == null) {
            FunctionInliner.$$$reportNull$$$0(13);
        }
        return JSElement.EMPTY_ARRAY;
    }

    @Nullable
    private static JSFunction buildReplacementFunction(@NotNull JSFunction referenced, @NotNull JSExpression context, @NotNull Map<JSParameter, JSExpression> parametersToActualMap, @Nullable JSExpression thisExpression) {
        if (referenced == null) {
            FunctionInliner.$$$reportNull$$$0(14);
        }
        if (context == null) {
            FunctionInliner.$$$reportNull$$$0(15);
        }
        if (parametersToActualMap == null) {
            FunctionInliner.$$$reportNull$$$0(16);
        }
        String replacementText = FunctionInliner.buildReplacement((PsiElement)referenced, context, parametersToActualMap, thisExpression);
        if (JSUtils.getMemberContainingClass((PsiElement)referenced) != null) {
            return JSChangeUtil.createClassMemberPsiFromTextWithContext(replacementText, (PsiElement)referenced, JSFunction.class);
        }
        ASTNode functionNode = JSChangeUtil.createJSTreeFromTextWithContext(replacementText, (PsiElement)referenced);
        if (functionNode != null && functionNode.getPsi() instanceof JSExpressionStatement) {
            return (JSFunctionExpression)((JSExpressionStatement)functionNode.getPsi()).getExpression();
        }
        return (JSFunction)functionNode.getPsi();
    }

    /*
     * WARNING - void declaration
     */
    static String buildReplacement(@NotNull PsiElement referenced, JSExpression callExpr, @NotNull Map<JSParameter, JSExpression> parametersToActualMap, @Nullable JSExpression thisExpression) {
        PsiElement referencedParent;
        if (referenced == null) {
            FunctionInliner.$$$reportNull$$$0(17);
        }
        if (parametersToActualMap == null) {
            FunctionInliner.$$$reportNull$$$0(18);
        }
        final int funOffset = -referenced.getTextRange().getStartOffset();
        DocumentImpl document = new DocumentImpl(referenced.getText());
        THashMap parameterRefs = new THashMap();
        THashMap markersToParametersMap = new THashMap();
        THashSet thisRefs = new THashSet();
        THashSet staticRefs = new THashSet();
        THashSet returnExprsToDrop = new THashSet();
        THashMap nonfinalParameters = new THashMap();
        InjectionQuoteHandler injectionQuoteHandler = new InjectionQuoteHandler((PsiElement)callExpr);
        Ref firstStatementMarker = Ref.create(null);
        referenced.accept((PsiElementVisitor)new JSRecursiveElementVisitor((Set)thisRefs, (Document)document, firstStatementMarker, referenced, (Map)nonfinalParameters, (Map)markersToParametersMap, (Map)parameterRefs, (Set)staticRefs, callExpr, (Set)returnExprsToDrop){
            final /* synthetic */ Set val$thisRefs;
            final /* synthetic */ Document val$document;
            final /* synthetic */ Ref val$firstStatementMarker;
            final /* synthetic */ PsiElement val$referenced;
            final /* synthetic */ Map val$nonfinalParameters;
            final /* synthetic */ Map val$markersToParametersMap;
            final /* synthetic */ Map val$parameterRefs;
            final /* synthetic */ Set val$staticRefs;
            final /* synthetic */ JSExpression val$callExpr;
            final /* synthetic */ Set val$returnExprsToDrop;
            {
                this.val$thisRefs = set;
                this.val$document = document;
                this.val$firstStatementMarker = ref;
                this.val$referenced = psiElement;
                this.val$nonfinalParameters = map;
                this.val$markersToParametersMap = map2;
                this.val$parameterRefs = map3;
                this.val$staticRefs = set2;
                this.val$callExpr = jSExpression;
                this.val$returnExprsToDrop = set3;
            }

            public void visitJSThisExpression(JSThisExpression node) {
                super.visitJSThisExpression(node);
                JSInlineHandler.doAddThisReference((PsiElement)node, (PsiElement)node, funOffset, this.val$thisRefs, this.val$document);
            }

            public void visitJSStatement(JSStatement node) {
                if (this.val$firstStatementMarker.isNull() && !(node instanceof JSBlockStatement)) {
                    this.val$firstStatementMarker.set((Object)node.getTextRange().getStartOffset());
                }
                super.visitJSStatement(node);
            }

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                PsiElement nodeTarget;
                JSReferenceExpression refExpr;
                JSExpression qualifier;
                super.visitJSDefinitionExpression(node);
                JSExpression expression = node.getExpression();
                if (expression instanceof JSReferenceExpression && (qualifier = (refExpr = (JSReferenceExpression)expression).getQualifier()) == null && (nodeTarget = refExpr.resolve()) instanceof JSParameter && nodeTarget.getParent().getParent() == this.val$referenced) {
                    this.val$nonfinalParameters.put((JSParameter)nodeTarget, null);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSExpression qualifier = node.getQualifier();
                if (qualifier == null) {
                    PsiElement nodeTarget = node.resolve();
                    if (nodeTarget instanceof JSParameter) {
                        if (nodeTarget.getParent().getParent() == this.val$referenced) {
                            RangeMarker rangeMarker = InjectionQuoteHandler.rangeMarker((PsiElement)node, this.val$document, funOffset);
                            this.val$markersToParametersMap.put(rangeMarker, (JSParameter)nodeTarget);
                            this.val$parameterRefs.put(node, rangeMarker);
                        }
                    } else if (node.getParent() != nodeTarget && nodeTarget != null) {
                        JSAttributeList attrList = nodeTarget instanceof JSAttributeListOwner ? ((JSAttributeListOwner)nodeTarget).getAttributeList() : null;
                        JSInlineHandler.addThisReference((PsiElement)node, (PsiElement)node.getQualifier(), nodeTarget, funOffset, attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.STATIC) ? this.val$staticRefs : this.val$thisRefs, this.val$document);
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                if (this.val$callExpr.getParent() instanceof JSExpressionStatement) {
                    JSInlineHandler.doAddThisReference(null, (PsiElement)node, funOffset, this.val$returnExprsToDrop, this.val$document);
                }
                super.visitJSReturnStatement(node);
            }
        });
        injectionQuoteHandler.fixQuotes(referenced, funOffset, (Document)document);
        if (!nonfinalParameters.isEmpty()) {
            SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(new CompletionResultSink(null));
            JSResolveUtil.treeWalkUp(processor, (PsiElement)callExpr, null, (PsiElement)callExpr);
            List<PsiElement> list = processor.getResults();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (PsiElement psiElement : list) {
                if (!(psiElement instanceof JSNamedElement)) continue;
                arrayList.add(((JSNamedElement)psiElement).getName());
            }
            TreeSet<String> evaluatedName = new TreeSet<String>();
            for (Map.Entry entry : nonfinalParameters.entrySet()) {
                JSParameter nonfinalParameter = (JSParameter)entry.getKey();
                evaluatedName.clear();
                evaluatedName.add(JSNameSuggestionsUtil.ensureUniqueVariableName(nonfinalParameter.getName(), null, arrayList, true));
                String name = (String)evaluatedName.first();
                entry.setValue(name);
            }
        }
        for (Map.Entry entry : parameterRefs.entrySet()) {
            void var19_46;
            JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)entry.getKey();
            RangeMarker rangeMarker = (RangeMarker)entry.getValue();
            JSParameter jSParameter = (JSParameter)markersToParametersMap.get(rangeMarker);
            JSExpression jSExpression = parametersToActualMap.get(jSParameter);
            if (jSExpression == null && jSParameter != null && jSParameter.isOptional()) {
                JSExpression jSExpression2 = jSParameter.getInitializer();
            }
            String parameterValueText = null;
            if (var19_46 != null) {
                parameterValueText = var19_46.getText();
                if (JSUtils.isNeedParenthesis((JSExpression)jSReferenceExpression, (JSExpression)var19_46)) {
                    parameterValueText = "(" + parameterValueText + ")";
                }
            }
            String introducedString = (String)ObjectUtils.coalesce(nonfinalParameters.get(jSParameter), (Object)parameterValueText, (Object)jSParameter.getName());
            ES6Property property = (ES6Property)ObjectUtils.tryCast((Object)jSReferenceExpression.getParent(), ES6Property.class);
            introducedString = property != null && property.isShorthanded() && !StringUtil.equals((CharSequence)property.getName(), (CharSequence)introducedString) ? String.format("%s: %s", property.getName(), introducedString) : introducedString;
            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)introducedString);
        }
        if (thisExpression != null) {
            String thisValue = thisExpression.getText();
            for (RangeMarker rangeMarker : thisRefs) {
                document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)(thisValue + (rangeMarker.getStartOffset() == rangeMarker.getEndOffset() ? "." : "")));
            }
        }
        if ((referencedParent = PsiTreeUtil.getParentOfType((PsiElement)referenced, JSClass.class)) != null) {
            String string = ((JSClass)referencedParent).getQualifiedName();
            for (RangeMarker marker : staticRefs) {
                document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)(string + "."));
            }
        }
        for (RangeMarker rangeMarker : returnExprsToDrop) {
            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)"");
        }
        for (Map.Entry entry : nonfinalParameters.entrySet()) {
            JSParameter parameter = (JSParameter)entry.getKey();
            JSExpression jSExpression = parametersToActualMap.get(parameter);
            String string = jSExpression != null ? jSExpression.getText() : null;
            StringBuilder builder = new StringBuilder(JSChangeUtil.getVariablePrefix(referenced));
            builder.append(" ");
            builder.append((String)entry.getValue());
            if (string != null) {
                builder.append(" = ");
                builder.append(jSExpression.getText());
            }
            builder.append(";\n");
            document.insertString((Integer)firstStatementMarker.get() + funOffset, (CharSequence)builder.toString());
        }
        return document.getText();
    }

    @Nullable
    public static JSInlineHandler.Settings handleFunction(@NotNull PsiElement toSearchForUsages, final @NotNull JSFunction fun, @Nullable Editor editor, boolean invokedOnReference, final NotNullLazyValue<Collection<PsiReference>> deferredUsages) {
        if (toSearchForUsages == null) {
            FunctionInliner.$$$reportNull$$$0(19);
        }
        if (fun == null) {
            FunctionInliner.$$$reportNull$$$0(20);
        }
        Project project = fun.getProject();
        if (JSProjectUtil.isInLibrary(fun.getContainingFile())) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.function.defined.in.library", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (fun.isReferencesArguments()) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.function.referencing.arguments", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (fun.getParent() instanceof JSClass && ((JSClass)fun.getParent()).isInterface()) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.interface.method", (Object[])new Object[0]), editor, project);
            return null;
        }
        for (JSParameter p : fun.getParameterVariables()) {
            if (!p.isRest()) continue;
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.function.referencing.rest.parameter", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (JSInheritanceUtil.participatesInHierarchy(fun)) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.overrided.or.overridden.method", (Object[])new Object[0]), editor, project);
            return null;
        }
        final Ref problem = new Ref();
        fun.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
            boolean nonLastStatement;
            boolean nonLastStatementCalculated;

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getParent() != fun && node.resolve() == fun) {
                    problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.recursive.function", (Object[])new Object[0]));
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                block4: {
                    JSSourceElement bodyBlock;
                    block3: {
                        JSFunction parentFunction;
                        bodyBlock = fun.getBody()[0];
                        if (node.getParent() == bodyBlock) break block3;
                        if (!this.nonLastStatementCalculated) {
                            this.calcNonLastStatement();
                            this.nonLastStatementCalculated = true;
                        }
                        if (!this.nonLastStatement || (parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != fun) break block4;
                        problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.function.with.multiple.returns", (Object[])new Object[0]));
                        break block4;
                    }
                    if (((JSBlockStatement)bodyBlock).getStatements().length > 1 && node.getExpression() != null) {
                        for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                            PsiElement elt = ref.getElement();
                            PsiElement eltParent = elt.getParent();
                            if (eltParent instanceof JSCallExpression && eltParent.getParent() instanceof JSExpressionStatement) continue;
                            problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.complex.expression.evaluation", (Object[])new Object[0]));
                            break;
                        }
                    }
                }
                super.visitJSReturnStatement(node);
            }

            private void calcNonLastStatement() {
                for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                    PsiElement elt = ref.getElement();
                    PsiElement parent = elt.getParent();
                    if (!(parent instanceof JSCallExpression)) continue;
                    PsiElement grandParent = parent.getParent();
                    if (!(grandParent instanceof JSStatement)) {
                        this.nonLastStatement = true;
                        break;
                    }
                    PsiElement grandGrandParent = grandParent.getParent();
                    if (!(grandGrandParent instanceof JSStatement)) {
                        this.nonLastStatement = true;
                        break;
                    }
                    boolean b = ControlFlowUtils.statementCompletesWithStatement((JSStatement)grandGrandParent, (JSStatement)grandParent);
                    if (b) continue;
                    this.nonLastStatement = true;
                    break;
                }
            }
        });
        if (problem.isNull()) {
            for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                PsiElement elt = ref.getElement();
                PsiElement parent = elt.getParent();
                if (!(parent instanceof JSNewExpression)) continue;
                problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.constructor", (Object[])new Object[0]));
                break;
            }
        }
        if (!problem.isNull()) {
            FunctionInliner.inlineFunctionProblem((String)problem.get(), editor, project);
            return null;
        }
        return new JSInlineHandler.Settings(toSearchForUsages, deferredUsages, invokedOnReference, editor);
    }

    private static boolean isImportExportUsage(@Nullable PsiElement element) {
        return element instanceof ES6ImportExportDeclarationPart;
    }

    private ES6ReferenceExpressionsInfo getReferenceExpressionsInfo(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            FunctionInliner.$$$reportNull$$$0(21);
        }
        return reference.getParent() instanceof JSCallExpression ? this.myReferenceExpressionsInfoForCall : this.myNonCallReferenceExpressionsInfo;
    }

    @Nullable
    private static JSBlockStatement getFunctionBlockBody(@NotNull JSFunction function) {
        JSSourceElement[] body;
        if (function == null) {
            FunctionInliner.$$$reportNull$$$0(22);
        }
        if ((body = function.getBody()).length == 0) {
            return null;
        }
        return (JSBlockStatement)ObjectUtils.tryCast((Object)body[0], JSBlockStatement.class);
    }

    static void inlineFunctionProblem(String key, @Nullable Editor editor, Project project) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)key, (String)JSBundle.message((String)"javascript.refactoring.inline.function.title", (Object[])new Object[0]), null);
    }

    @Nullable
    static JSExpression removeRedundantAwaitExpressions(@Nullable JSExpression toInsert, @Nullable PsiElement insertionPoint) {
        if (insertionPoint == null) {
            return toInsert;
        }
        PsiElement insertionParent = insertionPoint.getParent();
        if (ES6PsiUtil.isAwaitExpression(insertionParent)) {
            while (ES6PsiUtil.isAwaitExpression((PsiElement)toInsert)) {
                toInsert = ((JSPrefixExpression)toInsert).getExpression();
            }
            return toInsert;
        }
        return toInsert;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 6: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/FunctionInliner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToActualMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSearchForUsages";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/FunctionInliner";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReplacementForCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inlineUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementForCall";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacementFunction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "handleFunction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionsInfo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionBlockBody";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

