/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptTypeInliner
implements JSInlineHandler.Inliner {
    @NotNull
    private final JSClass myToInline;
    private final ES6ReferenceExpressionsInfo myReferenceExpressionsInfo;

    public TypescriptTypeInliner(@NotNull JSClass toInline) {
        if (toInline == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(0);
        }
        this.myToInline = toInline;
        this.myReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo((PsiElement)toInline);
    }

    @Nullable
    public static JSInlineHandler.Settings tryCreateSettings(@NotNull JSClass element, @Nullable Editor editor, boolean invokedOnReference, @NotNull NotNullLazyValue<Collection<PsiReference>> elementUsages) {
        if (element == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(1);
        }
        if (elementUsages == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(2);
        }
        if (element.getExtendsList() != null && element.getExtendsList().getExpressions().length > 0 || element.getImplementsList() != null && element.getImplementsList().getExpressions().length > 0) {
            JSInlineHandler.showErrorHint((PsiElement)element, editor, JSBundle.message((String)"inline.cannot.inline.has.supers", (Object[])new Object[]{new JSNamedElementPresenter((PsiElement)element).describeElementKind()}));
            return null;
        }
        if (element.isInterface() && !PsiTreeUtil.processElements((PsiElement)element, t -> !(t instanceof TypeScriptThisType))) {
            JSInlineHandler.showErrorHint((PsiElement)element, editor, JSBundle.message((String)"inline.cannot.inline.references.this.type", (Object[])new Object[0]));
            return null;
        }
        return new JSInlineHandler.Settings((PsiElement)element, elementUsages, invokedOnReference, editor);
    }

    @Override
    public void checkConflicts(@NotNull PsiReference reference, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(4);
        }
        PsiElement referenceElement = reference.getElement();
        JSInlineHandler.checkES6ModuleConflicts(this.myReferenceExpressionsInfo, (JSQualifiedNamedElement)this.myToInline, ES6PsiUtil.findExternalModule(referenceElement), conflicts);
        if (referenceElement.getParent() instanceof JSReferenceListMember) {
            boolean isImplements = referenceElement.getParent().getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST;
            conflicts.putValue((Object)referenceElement, (Object)JSBundle.message((String)"inline.type.used.in.reference.list", (Object[])new Object[]{isImplements ? "implements" : "extends"}));
        }
    }

    @Override
    @Nullable
    public PsiElement inlineUsage(@NotNull UsageInfo usage) {
        if (usage == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(5);
        }
        TypeScriptSingleType typeUsageElement = TypescriptTypeInliner.getTypeFromUsage(usage);
        JSClass namedType = this.myToInline;
        TypeScriptType typeDeclaration = TypescriptTypeInliner.getTypeDeclarationFromReferenced(namedType);
        if (typeUsageElement == null || typeDeclaration == null) {
            return null;
        }
        PsiElement usageModule = ES6PsiUtil.findExternalModule((PsiElement)typeUsageElement);
        String replacementText = TypescriptTypeInliner.getTypeTextWithAppliedGenerics(typeUsageElement, (TypeScriptTypeParameterListOwner)namedType, (JSTypeDeclaration)typeDeclaration);
        TypeScriptType usageParent = (TypeScriptType)ObjectUtils.tryCast((Object)typeUsageElement.getParent(), TypeScriptType.class);
        boolean needParens = usageParent != null && !(usageParent instanceof TypeScriptParenthesizedType) && !(typeDeclaration instanceof TypeScriptSingleType) && TypeScriptUtil.getTypePrecedence((JSTypeDeclaration)usageParent) < TypeScriptUtil.getTypePrecedence((JSTypeDeclaration)typeDeclaration);
        String text = needParens ? "(" + replacementText + ")" : replacementText;
        PsiElement replacement = typeUsageElement.replace((PsiElement)JSChangeUtil.createTypeScriptType(text, (PsiElement)typeUsageElement));
        if (usageModule != null) {
            ES6CreateImportUtil.addRequiredImports(this.myReferenceExpressionsInfo, usageModule);
        }
        return replacement;
    }

    private static String getTypeTextWithAppliedGenerics(@NotNull TypeScriptSingleType typeUsageElement, @NotNull TypeScriptTypeParameterListOwner namedType, @NotNull JSTypeDeclaration replacementTypeDeclaration) {
        JSType usageJSType;
        JSTypeSubstitutor substitutor;
        if (typeUsageElement == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(6);
        }
        if (namedType == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(7);
        }
        if (replacementTypeDeclaration == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(8);
        }
        if ((substitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(namedType, usageJSType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeUsageElement))) == null || substitutor.isEmpty()) {
            return replacementTypeDeclaration.getText();
        }
        final StringBuilder result2 = new StringBuilder();
        replacementTypeDeclaration.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                PsiElement resolve = node.resolve();
                if (resolve instanceof TypeScriptTypeParameter) {
                    TypeScriptTypeParser.TypeParameterGenericId id = TypeScriptTypeParser.getTypeParameterId((TypeScriptTypeParameter)resolve);
                    result2.append(substitutor.get((JSTypeSubstitutor.JSTypeGenericId)id));
                } else {
                    super.visitJSReferenceExpression(node);
                }
            }

            public void visitElement(PsiElement element) {
                if (element instanceof LeafPsiElement) {
                    result2.append(element.getText());
                } else {
                    super.visitElement(element);
                }
            }
        });
        return result2.toString();
    }

    @Nullable
    private static TypeScriptSingleType getTypeFromUsage(UsageInfo usage) {
        PsiElement element = usage.getElement();
        return element != null ? (TypeScriptSingleType)ObjectUtils.tryCast((Object)element.getParent(), TypeScriptSingleType.class) : null;
    }

    @Nullable
    private static TypeScriptType getTypeDeclarationFromReferenced(@Nullable JSClass referenced) {
        if (referenced instanceof TypeScriptTypeAlias) {
            return ((TypeScriptTypeAlias)referenced).getTypeDeclaration();
        }
        if (referenced instanceof TypeScriptInterface) {
            return ((TypeScriptInterface)referenced).getBody();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInline";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeUsageElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementTypeDeclaration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/TypescriptTypeInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCreateSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConflicts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineUsage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeTextWithAppliedGenerics";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

