/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpParameters;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPullUpHelper {
    private static final Logger LOG = Logger.getInstance((String)JSPullUpHelper.class.getName());
    private final JSClass mySourceClass;
    private final JSClass myTargetClass;
    private final JSMemberInfo[] myMembersToMove;
    private final int myDocCommentPolicy;

    public JSPullUpHelper(JSPullUpParameters parameters) {
        this(parameters.subClass, parameters.superClass, parameters.members, parameters.docCommentPolicy);
    }

    public JSPullUpHelper(JSClass sourceClass, JSClass targetSuperClass, JSMemberInfo[] membersToMove, int docCommentPolicy) {
        this.mySourceClass = sourceClass;
        this.myTargetClass = targetSuperClass;
        this.myMembersToMove = membersToMove;
        this.myDocCommentPolicy = docCommentPolicy;
    }

    public void moveMembersToBase() throws IncorrectOperationException {
        ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
        this.moveMembersToBase(postponedFormatters);
        JSRefactoringUtil.format(postponedFormatters);
    }

    public Collection<JSElement> moveMembersToBase(List<FormatFixer> postponedFormatters) throws IncorrectOperationException {
        boolean withMethodsJSDoc;
        List filesWithUsages = DialectDetector.isActionScript((PsiElement)this.myTargetClass) ? ActionScriptRefactoringUtil.qualifyIncomingReferences(JSRefactoringUtil.getUsages(JSMemberInfo.getStatics(this.myMembersToMove), this.myTargetClass)) : ContainerUtil.emptyList();
        List movedMembers = ContainerUtil.map((Object[])this.myMembersToMove, m -> (JSAttributeListOwner)m.getMember());
        boolean bl = withMethodsJSDoc = !this.myTargetClass.isInterface() || this.mySourceClass.isInterface() || this.myDocCommentPolicy == 1;
        if (!this.myTargetClass.isInterface() || this.mySourceClass.isInterface()) {
            JSRefactoringUtil.addRemovalFormatters(this.mySourceClass, movedMembers, (Condition<JSFunction>)(withMethodsJSDoc ? Conditions.alwaysTrue() : Conditions.alwaysFalse()), (Condition<JSVariable>)Conditions.alwaysTrue(), postponedFormatters);
        }
        ImportHandler importHandler = DialectDetector.isActionScript((PsiElement)this.mySourceClass) ? new ActionScriptImportHandler(filesWithUsages) : new ES6ImportHandler();
        for (JSMemberInfo info : this.myMembersToMove) {
            JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
            if (!this.myTargetClass.isInterface() && !(member instanceof JSClass)) {
                JSAttributeList.AccessType newVisibility = this.getClassMemberVisibility(movedMembers, info);
                if (newVisibility != null) {
                    JSChangeVisibilityUtil.setVisibility(member, newVisibility);
                }
                if (JSClassUtils.isES6ClassImplementation((PsiElement)this.myTargetClass) && JSPsiImplUtils.hasModifier(member, JSAttributeList.ModifierType.STATIC)) {
                    JSPullUpHelper.updateThisQualifiersForStaticAccess(member, this.myMembersToMove, this.mySourceClass);
                }
            }
            importHandler.processMovedMember(member);
        }
        if (!this.myTargetClass.isInterface() && ContainerUtil.or((Object[])this.myMembersToMove, m -> m.isToAbstract()) && !JSPsiImplUtils.hasModifier((JSAttributeListOwner)this.myTargetClass, JSAttributeList.ModifierType.ABSTRACT)) {
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper(this.myTargetClass.getAttributeList(), this.myTargetClass.getProject());
            wrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, true);
            wrapper.removeAccessModifier();
            wrapper.applyTo((JSAttributeListOwner)this.myTargetClass);
        }
        Collection<JSElement> membersAfterMove = new HashSet<JSElement>();
        for (JSMemberInfo info : this.myMembersToMove) {
            Pair<JSElement, List<PsiElement>> result2 = this.moveMember(info, postponedFormatters);
            if (result2.second != null) {
                for (PsiElement toDelete : (List)result2.second) {
                    JSRefactoringUtil.deleteWithNoPostponedFormatting(toDelete);
                }
            }
            if (result2.first == null) continue;
            membersAfterMove.add((JSElement)result2.first);
        }
        ExplicitSuperReplacer explicitSuperReplacer = new ExplicitSuperReplacer();
        for (JSElement member : membersAfterMove) {
            member.accept((PsiElementVisitor)explicitSuperReplacer);
        }
        explicitSuperReplacer.fixSupers();
        List<SmartPsiElementPointer<JSElement>> pointers = JSPullUpHelper.convertToPointers(membersAfterMove);
        postponedFormatters.addAll(importHandler.commitChanges());
        membersAfterMove = JSPullUpHelper.convertToPsi(pointers);
        return membersAfterMove;
    }

    private static void updateThisQualifiersForStaticAccess(@NotNull JSAttributeListOwner member, @NotNull JSMemberInfo[] membersToMove, @NotNull JSClass originalClass) {
        if (member == null) {
            JSPullUpHelper.$$$reportNull$$$0(0);
        }
        if (membersToMove == null) {
            JSPullUpHelper.$$$reportNull$$$0(1);
        }
        if (originalClass == null) {
            JSPullUpHelper.$$$reportNull$$$0(2);
        }
        PsiTreeUtil.processElements((PsiElement)member, el -> {
            JSReferenceExpression replacement;
            PsiElement resolved;
            JSReferenceExpression referenceExpression;
            if (membersToMove == null) {
                JSPullUpHelper.$$$reportNull$$$0(47);
            }
            if (originalClass == null) {
                JSPullUpHelper.$$$reportNull$$$0(48);
            }
            JSReferenceExpression jSReferenceExpression = referenceExpression = el instanceof JSReferenceExpression ? (JSReferenceExpression)el : null;
            if (referenceExpression != null && referenceExpression.getQualifier() instanceof JSThisExpression && !JSPullUpHelper.isMoved(membersToMove, resolved = referenceExpression.resolve()) && resolved instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)resolved, JSAttributeList.ModifierType.STATIC) && JSUtils.getMemberContainingClass(resolved) == originalClass && (replacement = JSChangeUtil.createExpressionPsiWithContext(originalClass.getName(), (PsiElement)referenceExpression, JSReferenceExpression.class)) != null) {
                referenceExpression.getQualifier().replace((JSExpression)replacement);
            }
            return true;
        });
    }

    private static boolean isMoved(@NotNull JSMemberInfo[] membersToMove, @Nullable PsiElement resolved) {
        if (membersToMove == null) {
            JSPullUpHelper.$$$reportNull$$$0(3);
        }
        return ContainerUtil.find((Object[])membersToMove, t -> t.getMember() == resolved) != null;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveMember(@NotNull JSMemberInfo info, @NotNull List<FormatFixer> postponedFormatters) {
        if (info == null) {
            JSPullUpHelper.$$$reportNull$$$0(4);
        }
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(5);
        }
        if (JSRefactoringConflictsUtil.getConflictingMember((JSAttributeListOwner)info.getMember(), this.myTargetClass) != null) {
            Pair pair = Pair.create(null, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(6);
            }
            return pair;
        }
        JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
        if (member instanceof TypeScriptTypeMember) {
            Pair<JSElement, List<PsiElement>> pair = this.moveInterfaceMember(postponedFormatters, member);
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (this.myTargetClass.isInterface() && !this.mySourceClass.isInterface()) {
            if (member instanceof JSFunction) {
                Pair<JSElement, List<PsiElement>> pair = this.moveMethodToInterface(postponedFormatters, (JSFunction)member);
                if (pair == null) {
                    JSPullUpHelper.$$$reportNull$$$0(8);
                }
                return pair;
            }
            if (member instanceof JSVariable) {
                Pair<JSElement, List<PsiElement>> pair = this.moveFieldToInterface(postponedFormatters, (JSVariable)member);
                if (pair == null) {
                    JSPullUpHelper.$$$reportNull$$$0(9);
                }
                return pair;
            }
        }
        if (member instanceof JSFunction) {
            Pair<JSElement, List<PsiElement>> pair = this.moveToSuperClass(postponedFormatters, (JSFunction)member, info.isToAbstract());
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(10);
            }
            return pair;
        }
        if (member instanceof JSVariable) {
            Pair<JSElement, List<PsiElement>> pair = this.moveClassField(postponedFormatters, (JSVariable)member);
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(11);
            }
            return pair;
        }
        if (member instanceof JSClass) {
            Pair<JSElement, List<PsiElement>> pair = this.moveReferenceListItem(info, postponedFormatters, (JSClass)member);
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(12);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)ContainerUtil.emptyList());
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveInterfaceMember(@NotNull List<FormatFixer> postponedFormatters, JSAttributeListOwner member) {
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(14);
        }
        JSElement newMember = (JSElement)JSRefactoringUtil.addMemberToTargetClass(this.myTargetClass, (PsiElement)member);
        JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)newMember, postponedFormatters);
        ArrayList toDelete = ContainerUtil.newArrayList((Object[])new PsiElement[]{member});
        PsiElement originalSeparator = JSPullUpHelper.getTypeMemberSeparator((JSElement)member);
        if (originalSeparator != null) {
            newMember.getParent().addAfter(originalSeparator, (PsiElement)newMember);
            toDelete.add(originalSeparator);
        }
        Pair pair = Pair.create((Object)newMember, (Object)toDelete);
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(15);
        }
        return pair;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveReferenceListItem(@NotNull JSMemberInfo info, @NotNull List<FormatFixer> postponedFormatters, @NotNull JSClass member) {
        JSReferenceList refList;
        if (info == null) {
            JSPullUpHelper.$$$reportNull$$$0(16);
        }
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(17);
        }
        if (member == null) {
            JSPullUpHelper.$$$reportNull$$$0(18);
        }
        JSReferenceList jSReferenceList = refList = info.isExtendsNotImplements() ? this.mySourceClass.getExtendsList() : this.mySourceClass.getImplementsList();
        if (refList == null || member.getQualifiedName() == null) {
            Pair pair = Pair.create(null, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(19);
            }
            return pair;
        }
        String refText = JSRefactoringUtil.removeFromReferenceList(refList, member, postponedFormatters);
        if (refText != null) {
            JSRefactoringUtil.addToSupersList(this.myTargetClass, member.getQualifiedName(), true);
        }
        Pair pair = Pair.create(null, (Object)ContainerUtil.emptyList());
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(20);
        }
        return pair;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveClassField(@NotNull List<FormatFixer> postponedFormatters, @NotNull JSVariable member) {
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(21);
        }
        if (member == null) {
            JSPullUpHelper.$$$reportNull$$$0(22);
        }
        PsiElement varStatementCopy = JSRefactoringUtil.addMemberToTargetClass(this.myTargetClass, (PsiElement)JSRefactoringUtil.getVarStatementCopy(member));
        JSElement newMember = (JSElement)PsiTreeUtil.getChildOfType((PsiElement)varStatementCopy, JSVariable.class);
        JSRefactoringUtil.handleDocCommentAndFormat(varStatementCopy, postponedFormatters);
        Pair pair = Pair.create((Object)newMember, (Object)ContainerUtil.list((Object[])new PsiElement[]{member}));
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveToSuperClass(@NotNull List<FormatFixer> postponedFormatters, @NotNull JSFunction member, boolean makeAbstract) {
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(24);
        }
        if (member == null) {
            JSPullUpHelper.$$$reportNull$$$0(25);
        }
        Collection<JSPsiElementBase> overriddenMembers = JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)member, false);
        JSFunction newMember = makeAbstract ? JSRefactoringUtil.buildAbstractMethodSignature(member) : (JSElement)member.copy();
        newMember = (JSElement)JSRefactoringUtil.addMemberToTargetClass(this.myTargetClass, (PsiElement)newMember);
        if (makeAbstract) {
            JSPullUpHelper.applyDocCommentPolicy((JSElement)member, (JSElement)newMember, this.myDocCommentPolicy);
        }
        JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)newMember, postponedFormatters);
        if (makeAbstract) {
            Pair pair = Pair.create((Object)newMember, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(26);
            }
            return pair;
        }
        ArrayList toDelete = ContainerUtil.newArrayList();
        toDelete.add(member);
        JSElement superMember = (JSElement)ContainerUtil.getFirstItem(overriddenMembers);
        if (overriddenMembers.size() == 1 && superMember instanceof JSAttributeListOwner && TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)superMember)) {
            toDelete.add(superMember);
        }
        Pair pair = Pair.create((Object)newMember, (Object)toDelete);
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(27);
        }
        return pair;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveFieldToInterface(@NotNull List<FormatFixer> postponedFormatters, @NotNull JSVariable field) {
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(28);
        }
        if (field == null) {
            JSPullUpHelper.$$$reportNull$$$0(29);
        }
        TypeScriptPropertySignature toAdd = JSRefactoringUtil.buildInterfaceProperty(field);
        Pair pair = Pair.create((Object)this.moveClassMemberToInterface(postponedFormatters, (JSPsiElementBase)field, (JSPsiElementBase)toAdd), (Object)ContainerUtil.emptyList());
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(30);
        }
        return pair;
    }

    @NotNull
    private Pair<JSElement, List<PsiElement>> moveMethodToInterface(@NotNull List<FormatFixer> postponedFormatters, @NotNull JSFunction member) {
        JSFunction toAdd;
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(31);
        }
        if (member == null) {
            JSPullUpHelper.$$$reportNull$$$0(32);
        }
        if (this.myTargetClass instanceof TypeScriptInterface && member.isSetProperty()) {
            Pair pair = Pair.create(null, (Object)ContainerUtil.emptyList());
            if (pair == null) {
                JSPullUpHelper.$$$reportNull$$$0(33);
            }
            return pair;
        }
        if (this.myTargetClass instanceof TypeScriptInterface && member.isGetProperty()) {
            boolean shouldGenerateReadonly = this.mySourceClass.findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER) == null;
            JSType type = (JSType)ObjectUtils.coalesce((Object)member.getReturnType(), (Object)TypeFromUsageDetector.detectTypeFromUsage((PsiElement)member), (Object)((Object)JSAnyType.get((PsiElement)member, true)));
            String text = (shouldGenerateReadonly ? "readonly " : "") + member.getName() + ": " + TypeScriptUtil.getShortestTypeNameInContext(type, (PsiElement)member);
            toAdd = JSRefactoringUtil.buildInterfacePropertyFromText((JSElement)member, text);
        } else {
            toAdd = JSRefactoringUtil.buildInterfaceSignature(member);
        }
        Pair pair = Pair.create((Object)this.moveClassMemberToInterface(postponedFormatters, (JSPsiElementBase)member, (JSPsiElementBase)toAdd), (Object)ContainerUtil.emptyList());
        if (pair == null) {
            JSPullUpHelper.$$$reportNull$$$0(34);
        }
        return pair;
    }

    @NotNull
    private JSElement moveClassMemberToInterface(@NotNull List<FormatFixer> postponedFormatters, @NotNull JSPsiElementBase member, @NotNull JSPsiElementBase toAdd) {
        if (postponedFormatters == null) {
            JSPullUpHelper.$$$reportNull$$$0(35);
        }
        if (member == null) {
            JSPullUpHelper.$$$reportNull$$$0(36);
        }
        if (toAdd == null) {
            JSPullUpHelper.$$$reportNull$$$0(37);
        }
        PsiElement separator = JSPullUpHelper.getTypeMemberSeparator((JSElement)toAdd);
        JSPsiElementBase newMember = (JSPsiElementBase)JSRefactoringUtil.addMemberToTargetClass(this.myTargetClass, (PsiElement)toAdd);
        if (separator != null) {
            newMember.getParent().addAfter(separator, (PsiElement)newMember);
        }
        JSPullUpHelper.applyDocCommentPolicy((JSElement)member, (JSElement)newMember, this.myDocCommentPolicy);
        postponedFormatters.add(FormatFixer.create((PsiElement)newMember, FormatFixer.Mode.Reformat));
        ArrayList<JSAttributeListOwner> makePublic = new ArrayList<JSAttributeListOwner>();
        if (member instanceof JSAttributeListOwner) {
            makePublic.add((JSAttributeListOwner)member);
        }
        Processor p = el -> {
            if (el != newMember && el instanceof JSAttributeListOwner && (!DialectDetector.isActionScript((PsiElement)el) || ModuleUtilCore.findModuleForPsiElement((PsiElement)el) != null)) {
                makePublic.add((JSAttributeListOwner)el);
            }
            return true;
        };
        JSInheritanceUtil.iterateOverriddenMemberUp(member, (Processor<JSPsiElementBase>)p);
        JSMembersSearch.searchOverridingMembers(member, true).forEach(p);
        for (JSAttributeListOwner f : makePublic) {
            JSChangeVisibilityUtil.setVisibility(f, JSAttributeList.AccessType.PUBLIC);
            postponedFormatters.add(FormatFixer.create((PsiElement)f, FormatFixer.Mode.Reformat));
        }
        JSPsiElementBase jSPsiElementBase = newMember;
        if (jSPsiElementBase == null) {
            JSPullUpHelper.$$$reportNull$$$0(38);
        }
        return jSPsiElementBase;
    }

    private static void applyDocCommentPolicy(@NotNull JSElement oldMember, @NotNull JSElement newMember, int policy) {
        PsiElement docComment;
        if (oldMember == null) {
            JSPullUpHelper.$$$reportNull$$$0(39);
        }
        if (newMember == null) {
            JSPullUpHelper.$$$reportNull$$$0(40);
        }
        if ((docComment = JSRefactoringUtil.findDocComment((PsiElement)oldMember)) != null) {
            if (policy == 1) {
                JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
            } else if (policy == 0) {
                docComment = JSRefactoringUtil.findDocComment((PsiElement)newMember);
                JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
            }
        }
    }

    private static List<SmartPsiElementPointer<JSElement>> convertToPointers(Collection<JSElement> elements) {
        return ContainerUtil.map(elements, element -> SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer((PsiElement)element));
    }

    private static List<JSElement> convertToPsi(Collection<SmartPsiElementPointer<JSElement>> pointers) {
        return ContainerUtil.map(pointers, pointer -> (JSElement)pointer.getElement());
    }

    @Nullable
    private static PsiElement getTypeMemberSeparator(@NotNull JSElement element) {
        PsiElement sibling;
        if (element == null) {
            JSPullUpHelper.$$$reportNull$$$0(41);
        }
        if ((sibling = JSPsiImplUtils.getNextSiblingIgnoreWhitespace((PsiElement)element)) != null && (sibling.getNode().getElementType() == JSTokenTypes.COMMA || sibling.getNode().getElementType() == JSTokenTypes.SEMICOLON)) {
            return sibling.getNode().getPsi();
        }
        return null;
    }

    @Nullable
    private JSAttributeList.AccessType getClassMemberVisibility(@NotNull Collection<JSAttributeListOwner> movedMembers, @NotNull JSMemberInfo info) {
        JSAttributeListOwner member;
        if (movedMembers == null) {
            JSPullUpHelper.$$$reportNull$$$0(42);
        }
        if (info == null) {
            JSPullUpHelper.$$$reportNull$$$0(43);
        }
        if ((member = (JSAttributeListOwner)info.getMember()).getAttributeList() == null || member.getAttributeList().getNamespace() != null) {
            return null;
        }
        JSAttributeList.AccessType accessType = member.getAttributeList().getAccessType();
        if (accessType == JSAttributeList.AccessType.PRIVATE) {
            if (JSPullUpHelper.willBeUsedInSubclass((PsiElement)member, movedMembers, this.myTargetClass, this.mySourceClass) || info.isToAbstract()) {
                return JSAttributeList.AccessType.PROTECTED;
            }
        } else if (DialectDetector.isActionScript((PsiElement)member) && accessType == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            AtomicBoolean usedInPackage = new AtomicBoolean(false);
            AtomicBoolean usedInSubClass = new AtomicBoolean(false);
            ReferencesSearch.search((PsiElement)member, (SearchScope)GlobalSearchScope.moduleScope((Module)ModuleUtil.findModuleForPsiElement((PsiElement)member))).forEach(psiReference -> {
                if (movedMembers == null) {
                    JSPullUpHelper.$$$reportNull$$$0(46);
                }
                if (!(psiReference.getElement() instanceof JSReferenceExpression)) {
                    return true;
                }
                if (JSRefactoringUtil.isOrWillBeInTargetClass(psiReference.getElement(), movedMembers, this.myTargetClass, false)) {
                    return true;
                }
                JSClass clazz = JSResolveUtil.getClassOfContext(psiReference.getElement());
                if (clazz == this.myTargetClass) {
                    return true;
                }
                if (clazz != null && JSInheritanceUtil.isParentClass(this.mySourceClass, clazz, false)) {
                    usedInSubClass.set(true);
                } else {
                    usedInPackage.set(true);
                }
                return !usedInPackage.get() || !usedInSubClass.get();
            });
            if (usedInPackage.get() && usedInSubClass.get()) {
                return JSAttributeList.AccessType.PUBLIC;
            }
            if (usedInPackage.get()) {
                return JSAttributeList.AccessType.PACKAGE_LOCAL;
            }
            if (usedInSubClass.get()) {
                return JSAttributeList.AccessType.PROTECTED;
            }
        }
        return null;
    }

    private static boolean willBeUsedInSubclass(PsiElement member, Collection<JSAttributeListOwner> movedMembers, JSClass superclass, JSClass subclass) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)subclass), (boolean)false)) {
            PsiElement element = ref.getElement();
            if (JSRefactoringUtil.isOrWillBeInTargetClass(element, movedMembers, superclass, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkedInterfacesContain(@NotNull Collection<JSMemberInfo> memberInfos, @NotNull JSFunction psiMethod) {
        if (memberInfos == null) {
            JSPullUpHelper.$$$reportNull$$$0(44);
        }
        if (psiMethod == null) {
            JSPullUpHelper.$$$reportNull$$$0(45);
        }
        for (MemberInfoBase memberInfoBase : memberInfos) {
            if (!memberInfoBase.isChecked() || !(memberInfoBase.getMember() instanceof JSClass)) continue;
            assert (Boolean.FALSE.equals(memberInfoBase.getOverrides()));
            if (((JSClass)memberInfoBase.getMember()).findFunctionByName(psiMethod.getName()) == null) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ JSMemberInfo[] access$300(JSPullUpHelper x0) {
        return x0.myMembersToMove;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 3: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 2: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 4: 
            case 16: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postponedFormatters";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHelper";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMember";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMember";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedMembers";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHelper";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "moveMember";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "moveInterfaceMember";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "moveReferenceListItem";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "moveClassField";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "moveToSuperClass";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "moveFieldToInterface";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "moveMethodToInterface";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "moveClassMemberToInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateThisQualifiersForStaticAccess";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMoved";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveMember";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 38: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveInterfaceMember";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "moveReferenceListItem";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moveClassField";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveToSuperClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "moveFieldToInterface";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "moveMethodToInterface";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "moveClassMemberToInterface";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "applyDocCommentPolicy";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMemberSeparator";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getClassMemberVisibility";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkedInterfacesContain";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassMemberVisibility$7";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateThisQualifiersForStaticAccess$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ES6ImportHandler
    implements ImportHandler {
        private final List<ES6ReferenceExpressionsInfo> myUsageInfos = ContainerUtil.newArrayList();

        private ES6ImportHandler() {
        }

        @Override
        public void processMovedMember(@NotNull JSAttributeListOwner memberInfo) {
            if (memberInfo == null) {
                ES6ImportHandler.$$$reportNull$$$0(0);
            }
            if (memberInfo instanceof JSPsiElementBase) {
                this.myUsageInfos.add(ES6ReferenceExpressionsInfo.getInfo((PsiElement)((JSPsiElementBase)memberInfo)));
            }
        }

        @Override
        @NotNull
        public List<FormatFixer> commitChanges() {
            PsiElement sourceModule = ES6PsiUtil.findExternalModule((PsiElement)JSPullUpHelper.this.mySourceClass);
            PsiElement destinationModule = ES6PsiUtil.findExternalModule((PsiElement)JSPullUpHelper.this.myTargetClass);
            if (destinationModule != null && sourceModule != null && destinationModule != sourceModule) {
                ES6CreateImportUtil.addRequiredImports(this.myUsageInfos, (Condition<PsiElement>)Conditions.alwaysFalse(), destinationModule);
                ES6CreateImportUtil.optimizeImports(destinationModule);
                ES6CreateImportUtil.optimizeImports(sourceModule);
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ImportHandler.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHelper$ES6ImportHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHelper$ES6ImportHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "commitChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processMovedMember";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ActionScriptImportHandler
    implements ImportHandler {
        private final Collection<String> myNamespacesInTargetFile = ContainerUtil.newHashSet();
        private final Collection<String> myImportsInTargetFile = ContainerUtil.newHashSet();
        private final Collection<JSAttributeListOwner> myMovedMembers = ContainerUtil.mapNotNull((Object[])JSPullUpHelper.access$300(JSPullUpHelper.this), m -> (JSAttributeListOwner)m.getMember());
        private final Collection<PsiFile> myFilesWithUsages;

        public ActionScriptImportHandler(Collection<PsiFile> usages) {
            this.myFilesWithUsages = usages;
        }

        @Override
        public void processMovedMember(@NotNull JSAttributeListOwner memberInfo) {
            if (memberInfo == null) {
                ActionScriptImportHandler.$$$reportNull$$$0(0);
            }
            if (memberInfo instanceof JSClass) {
                String qName = ((JSClass)memberInfo).getQualifiedName();
                if (!(JSPullUpHelper.this.myTargetClass instanceof XmlBackedJSClass) && qName != null && qName.indexOf(46) != -1 && JSPsiImplUtils.differentPackageName(qName, JSPullUpHelper.this.myTargetClass.getQualifiedName())) {
                    this.myImportsInTargetFile.add(qName);
                }
            } else {
                ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)memberInfo, this.myImportsInTargetFile, this.myNamespacesInTargetFile, this.myMovedMembers, JSPullUpHelper.this.myTargetClass, JSPullUpHelper.this.myTargetClass.isInterface() && !JSPullUpHelper.this.mySourceClass.isInterface(), false);
            }
        }

        @Override
        @NotNull
        public List<FormatFixer> commitChanges() {
            ArrayList postponedFormatters = ContainerUtil.newArrayList();
            JSRefactoringUtil.postProcess((PsiElement)JSPullUpHelper.this.mySourceClass, (JSQualifiedNamedElement)JSPullUpHelper.this.myTargetClass, this.myFilesWithUsages, this.myImportsInTargetFile, this.myNamespacesInTargetFile, postponedFormatters, false, false);
            ArrayList arrayList = postponedFormatters;
            if (arrayList == null) {
                ActionScriptImportHandler.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHelper$ActionScriptImportHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHelper$ActionScriptImportHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "commitChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processMovedMember";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ImportHandler {
        public void processMovedMember(@NotNull JSAttributeListOwner var1);

        @NotNull
        public List<FormatFixer> commitChanges();
    }

    private static class ExplicitSuperReplacer
    extends JSRecursiveElementVisitor {
        private final ArrayList<JSExpression> mySupersToReplace = new ArrayList();
        private boolean myInsideObjectStatus;
        private boolean myInsideObjectStatusCalculated;

        private ExplicitSuperReplacer() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            PsiElement resolved;
            if (expression.getQualifier() instanceof JSSuperExpression && ((resolved = expression.resolve()) == null || DialectDetector.isActionScript((PsiElement)expression) && this.myInsideObjectStatus)) {
                this.mySupersToReplace.add(expression.getQualifier());
            }
        }

        public void visitJSElement(JSElement node) {
            PsiElement parentNode;
            if (!this.myInsideObjectStatusCalculated && node instanceof JSNamedElement && (parentNode = JSResolveUtil.findParent((PsiElement)node)) instanceof JSClass) {
                JSClass[] superClasses = ((JSClass)parentNode).getSuperClasses();
                if (superClasses.length > 0 && "Object".equals(superClasses[0].getQualifiedName())) {
                    this.myInsideObjectStatus = true;
                }
                this.myInsideObjectStatusCalculated = true;
            }
            super.visitJSElement(node);
        }

        public void fixSupers() {
            for (JSExpression expression : this.mySupersToReplace) {
                if (DialectDetector.isActionScript((PsiElement)expression)) {
                    PsiElement nextSibling = JSPsiImplUtils.findNextCodeElement((PsiElement)expression);
                    LOG.assertTrue(nextSibling != null && nextSibling.getNode().getElementType() == JSTokenTypes.DOT);
                    expression.getParent().deleteChildRange((PsiElement)expression, nextSibling);
                    continue;
                }
                expression.replace(JSChangeUtil.createExpressionPsiWithContext("this", (PsiElement)expression, JSExpression.class));
            }
        }
    }
}

