/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.react.ReactFunctionalToClassComponentHandler;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactClassToFunctionalComponentHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_TITLE = JSBundle.message((String)"refactoring.react.class.to.functional.refactoring.title", (Object[])new Object[0]);
    private static final String[] CONVERTIBLE_NAMES = new String[]{"propTypes", "defaultProps", "render"};

    public boolean isAvailable(@NotNull JSClass<?> clazz) {
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(0);
        }
        if (ReactXmlExtension.isAcceptableClassComponent(clazz) == ThreeState.NO) {
            return false;
        }
        for (JSElement member : clazz.getMembers()) {
            if (member instanceof JSNamedElement && ArrayUtil.indexOf((Object[])CONVERTIBLE_NAMES, (Object)member.getName()) < 0) {
                return false;
            }
            if (!ReactClassToFunctionalComponentHandler.referencesState(member)) continue;
            return false;
        }
        if (JSPsiImplUtils.hasModifier(clazz, JSAttributeList.ModifierType.ABSTRACT)) {
            return false;
        }
        return JSClassSearch.searchClassInheritors(clazz, false).findFirst() == null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(2);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, editor, file2);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        JSClass clazz;
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(6);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), JSClass.class, (boolean)false)) == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"react.class.to.function.caret.at.class", (Object[])new Object[0]));
            ReactClassToFunctionalComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz, editor, REFACTORING_TITLE)) {
            return;
        }
        String propTypesInitializer = ReactClassToFunctionalComponentHandler.getFieldInitializer(clazz, "propTypes");
        String defaultPropsInitializer = ReactClassToFunctionalComponentHandler.getFieldInitializer(clazz, "defaultProps");
        String introducedName = clazz.getName();
        if (!(DialectDetector.isTypeScript((PsiElement)clazz) || StringUtil.isEmpty((String)propTypesInitializer) && StringUtil.isEmpty((String)defaultPropsInitializer) || !StringUtil.isEmpty((String)introducedName) || !StringUtil.isEmpty((String)(introducedName = ReactClassToFunctionalComponentHandler.showNameDialog(project, (JSNamedElement)clazz))))) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_TITLE, null, () -> {
            if (editor == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(35);
            }
            ReactClassToFunctionalComponentHandler.doRefactoringInWriteAction(finalIntroducedName, clazz, editor, propTypesInitializer, defaultPropsInitializer);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void doRefactoringInWriteAction(@Nullable String introducedName, @NotNull JSClass clazz, @NotNull Editor editor, @Nullable String propTypesInitializer, @Nullable String defaultPropsInitializer) {
        JSElement replacementPsi;
        String replacementText;
        JSParameterList createdFunctionParameterList;
        JSLanguageDialect languageDialect;
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(8);
        }
        DialectOptionHolder dialectOptionHolder = (languageDialect = DialectDetector.languageDialectOfElement((PsiElement)clazz)) != null ? languageDialect.getOptionHolder() : null;
        boolean generateDefaultPropsAssignment = dialectOptionHolder == null || !dialectOptionHolder.isTypeScript;
        boolean generatePropTypesAssignment = dialectOptionHolder == null || !dialectOptionHolder.hasFeature(JSLanguageFeature.TYPES);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)clazz.getProject());
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)introducedName)) {
            properties.setProperty("NAME", introducedName);
        }
        if (generatePropTypesAssignment && !StringUtil.isEmpty((String)propTypesInitializer)) {
            properties.setProperty("PROP_TYPES", propTypesInitializer);
        }
        if (generateDefaultPropsAssignment && !StringUtil.isEmpty((String)defaultPropsInitializer)) {
            properties.setProperty("DEFAULT_PROPS", defaultPropsInitializer);
        }
        String codeTemplateName = ReactExtractComponentHandler.getCodeTemplateName(ReactExtractComponentHandler.ComponentType.Function, !generateDefaultPropsAssignment);
        JSNamedElement createdNamedElement = ReactExtractComponentHandler.expandTemplate((PsiElement)clazz, properties, codeTemplateName, JSNamedElement.class);
        PsiFile createdFile = createdNamedElement != null ? createdNamedElement.getContainingFile() : null;
        JSFunction createdFunction = JSPsiImplUtils.getPossibleFunction((PsiElement)createdNamedElement);
        JSElement createdFunctionBody = (JSElement)ObjectUtils.coalesce((Object)ReactFunctionalToClassComponentHandler.findFunctionBlockBody(createdFunction), (Object)JSPsiImplUtils.tryGetArrowFunctionReturnExpression(createdFunction));
        JSParameterList jSParameterList = createdFunctionParameterList = createdFunction != null ? createdFunction.getParameterList() : null;
        if (createdFunctionBody == null || createdFunctionParameterList == null) {
            String message = JSBundle.message((String)"refactoring.react.could.not.find.in.template", (Object[])new Object[]{introducedName, codeTemplateName});
            ReactClassToFunctionalComponentHandler.showErrorHint(clazz.getProject(), editor, message);
            return;
        }
        JSFunction renderMethod = clazz.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE);
        JSBlockStatement renderMethodBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(renderMethod);
        JSExpression renderReturnExpression = renderMethod != null ? JSPsiImplUtils.getReturnedExpressionIfSingle(renderMethod) : null;
        String typedDialectPropsType = ReactClassToFunctionalComponentHandler.getTypeFromGenerics(clazz);
        Ref hasProps = new Ref((Object)Boolean.FALSE);
        Ref hasContext = new Ref((Object)Boolean.FALSE);
        ReactFunctionalToClassComponentHandler.copyExportStatus((JSNamedElement)clazz, (JSAttributeListOwner)createdFunction);
        ReactFunctionalToClassComponentHandler.copyReturnType((JSNamedElement)renderMethod, (JSNamedElement)createdFunction);
        if (createdFunctionBody instanceof JSExpression && renderReturnExpression != null) {
            replacementText = ReactClassToFunctionalComponentHandler.processRenderMethod((JSElement)renderReturnExpression, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = (JSElement)JSChangeUtil.createExpressionPsiWithContext((String)ObjectUtils.coalesce((Object)replacementText, (Object)"null"), (PsiElement)clazz, JSExpression.class);
        } else {
            replacementText = ReactClassToFunctionalComponentHandler.processRenderMethod((JSElement)renderMethodBody, (Ref<Boolean>)hasProps, (Ref<Boolean>)hasContext);
            replacementPsi = (JSElement)JSChangeUtil.createStatementPsiFromTextWithContext((String)ObjectUtils.coalesce((Object)replacementText, (Object)"{}"), (PsiElement)clazz, JSBlockStatement.class);
        }
        createdFunctionBody.replace((PsiElement)replacementPsi);
        String propsParameterName = hasProps.get() == Boolean.TRUE ? "props" : null;
        String contextParameterName = hasContext.get() == Boolean.TRUE ? "context" : null;
        createdFunctionParameterList.replace((PsiElement)ReactClassToFunctionalComponentHandler.createParameterList(propsParameterName, typedDialectPropsType, contextParameterName, (PsiElement)createdFunction));
        PsiElement resultElement = ReactClassToFunctionalComponentHandler.expressionAwareReplace((JSNamedElement)clazz, createdFile, (JSNamedElement)createdFunction);
        ES6CreateImportUtil.optimizeImports(resultElement);
    }

    @NotNull
    public static PsiElement expressionAwareReplace(@NotNull JSNamedElement toReplace, @NotNull PsiFile createdFile, @NotNull JSNamedElement createdDeclaration) {
        if (toReplace == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(9);
        }
        if (createdFile == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(10);
        }
        if (createdDeclaration == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(11);
        }
        if (toReplace instanceof JSExpression) {
            JSExpression functionExpression = JSChangeUtil.createExpressionPsiWithContext(createdDeclaration.getText(), (PsiElement)toReplace, JSExpression.class);
            assert (functionExpression != null);
            createdDeclaration.replace((PsiElement)functionExpression);
            if (!(toReplace.getParent() instanceof ES6ExportDefaultAssignment) && ContainerUtil.filter((Object[])createdFile.getChildren(), t -> t instanceof JSSourceElement).size() > 1) {
                JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class);
                String name = createdDeclaration.getName();
                assert (name != null);
                assert (sourceElement != null);
                JSChangeUtil.doAddRangeBefore(sourceElement.getParent(), createdFile.getFirstChild(), createdFile.getLastChild(), (PsiElement)sourceElement);
                JSReferenceExpression reference = JSChangeUtil.createExpressionPsiWithContext(name, (PsiElement)createdDeclaration, JSReferenceExpression.class);
                assert (reference != null);
                PsiElement psiElement = toReplace.replace((PsiElement)reference);
                if (psiElement == null) {
                    ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(12);
                }
                return psiElement;
            }
        }
        PsiElement psiElement = ReactClassToFunctionalComponentHandler.replaceSourceElement((PsiElement)toReplace, createdFile.getFirstChild(), createdFile.getLastChild());
        if (psiElement == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    @Nullable
    private static String getFieldInitializer(@NotNull JSClass clazz, @NotNull String name) {
        JSField field;
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(15);
        }
        if ((field = clazz.findFieldByName(name)) != null && field.getInitializer() != null) {
            return field.getInitializer().getText();
        }
        return null;
    }

    @Nullable
    private static String getTypeFromGenerics(@NotNull JSClass clazz) {
        JSReferenceList extendsList;
        if (clazz == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(16);
        }
        if ((extendsList = clazz.getExtendsList()) == null) {
            return null;
        }
        JSReferenceListMember[] extendsListMembers = extendsList.getMembers();
        if (extendsListMembers.length == 0) {
            return null;
        }
        JSTypeDeclaration[] typeArguments = extendsListMembers[0].getTypeArguments();
        if (typeArguments.length == 0) {
            return null;
        }
        return typeArguments[0].getText();
    }

    @NotNull
    private static JSParameterList createParameterList(@Nullable String propsParameterName, @Nullable String propsTypeText, @Nullable String contextParameterName, @NotNull PsiElement context) {
        if (context == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(17);
        }
        StringBuilder text = new StringBuilder("(");
        if (!StringUtil.isEmpty((String)propsParameterName)) {
            text.append(propsParameterName);
            if (!StringUtil.isEmpty((String)propsTypeText)) {
                text.append(": ").append(propsTypeText);
            }
        }
        if (!StringUtil.isEmpty((String)contextParameterName)) {
            text.append(", ").append(contextParameterName);
        }
        text.append(")");
        JSFunction function = JSChangeUtil.createStatementPsiFromTextWithContext("function dummy" + text + "{}", context, JSFunction.class);
        assert (function != null && function.getParameterList() != null);
        JSParameterList jSParameterList = function.getParameterList();
        if (jSParameterList == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(18);
        }
        return jSParameterList;
    }

    @Nullable
    private static String processRenderMethod(@Nullable JSElement toProcess, @NotNull Ref<Boolean> hasProps, @NotNull Ref<Boolean> hasContext) {
        if (hasProps == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(19);
        }
        if (hasContext == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(20);
        }
        if (toProcess == null) {
            return null;
        }
        ArrayList referencesToReplace = new ArrayList();
        ReactClassToFunctionalComponentHandler.processThisReferences(toProcess, (Processor<JSReferenceExpression>)((Processor)element -> {
            if (hasProps == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(33);
            }
            if (hasContext == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(34);
            }
            if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"props")) {
                referencesToReplace.add(element);
                hasProps.set((Object)Boolean.TRUE);
            } else if (StringUtil.equals((CharSequence)element.getReferenceName(), (CharSequence)"context")) {
                referencesToReplace.add(element);
                hasContext.set((Object)Boolean.TRUE);
            }
            return true;
        }));
        return ReactExtractComponentHandler.replaceOccurrences(toProcess, toProcess.getTextRange(), referencesToReplace, expression -> StringUtil.notNullize((String)expression.getReferenceName()));
    }

    private static boolean referencesState(@NotNull JSElement member) {
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(21);
        }
        return !ReactClassToFunctionalComponentHandler.processThisReferences(member, (Processor<JSReferenceExpression>)((Processor)referenceExpression -> !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"state") && !StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)"setState")));
    }

    private static boolean processThisReferences(@NotNull JSElement member, @NotNull Processor<JSReferenceExpression> processor) {
        if (member == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(23);
        }
        return PsiTreeUtil.processElements((PsiElement)member, element -> {
            JSReferenceExpression referenceExpression;
            if (processor == null) {
                ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(32);
            }
            return !(element instanceof JSReferenceExpression) || !((referenceExpression = (JSReferenceExpression)element).getQualifier() instanceof JSThisExpression) || processor.process((Object)referenceExpression);
        });
    }

    @NotNull
    private static PsiElement replaceSourceElement(@NotNull PsiElement toReplace, @NotNull PsiElement first, @NotNull PsiElement last) {
        if (toReplace == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(24);
        }
        if (first == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(25);
        }
        if (last == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(26);
        }
        JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)toReplace, JSSourceElement.class, (boolean)false);
        assert (sourceElement != null);
        PsiElement resultElement = (PsiElement)JSChangeUtil.doAddRangeBefore((PsiElement)sourceElement.getParent(), (PsiElement)first, (PsiElement)last, (PsiElement)sourceElement).first;
        toReplace.delete();
        PsiElement psiElement = resultElement;
        if (psiElement == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(27);
        }
        return psiElement;
    }

    @Nullable
    public static String showNameDialog(@NotNull Project project, @NotNull JSNamedElement elementForName) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(28);
        }
        if (elementForName == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(29);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return "Component";
        }
        PsiElement scope = (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.getNameScope(elementForName), (Object)elementForName.getContainingFile());
        InputValidatorEx nameValidator = ReactExtractComponentHandler.createNameValidator(scope);
        return Messages.showInputDialog((Project)project, (String)"Component Name:", (String)REFACTORING_TITLE, (Icon)Messages.getQuestionIcon(), null, (InputValidator)nameValidator);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, String message) {
        if (project == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(30);
        }
        if (editor == null) {
            ReactClassToFunctionalComponentHandler.$$$reportNull$$$0(31);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_TITLE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 8: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeclaration";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/ReactClassToFunctionalComponentHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasProps";
                break;
            }
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasContext";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementForName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/ReactClassToFunctionalComponentHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionAwareReplace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expressionAwareReplace";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 27: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFieldInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromGenerics";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processRenderMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "referencesState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processThisReferences";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showNameDialog";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processThisReferences$5";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRenderMethod$2";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

