/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.react.ReactClassToFunctionalComponentHandler;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFunctionalToClassComponentHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_TITLE = JSBundle.message((String)"refactoring.react.function.to.class.refactoring.title", (Object[])new Object[0]);

    public boolean isAvailable(@NotNull JSNamedElement element, boolean allowAnonymous) {
        JSFunction function;
        if (element == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(0);
        }
        return (function = JSPsiImplUtils.getPossibleFunction((PsiElement)element)) != null && (ReactXmlExtension.isComponentName(function.getName()) || allowAnonymous && function.getName() == null) && ReactXmlExtension.isFunctionComponentBySignature(function) && !ReactFunctionalToClassComponentHandler.hasInstanceProperties(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(2);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, editor, file2);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        JSLanguageDialect languageDialect;
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(6);
        }
        JSNamedElement namedElement = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), JSNamedElement.class, (boolean)false);
        JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)namedElement);
        if (namedElement == null || function == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"react.function.to.class.caret.at.function", (Object[])new Object[0]));
            ReactFunctionalToClassComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)namedElement, editor, REFACTORING_TITLE)) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)namedElement, (boolean)false));
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            SearchScope useScope = (SearchScope)ReadAction.compute(() -> namedElement.getUseScope());
            ReferencesSearch.search((PsiElement)namedElement, (SearchScope)useScope).forEach(psiReference -> {
                PsiElement refElement = psiReference.getElement();
                PsiElement parentElement = refElement.getParent();
                if (refElement instanceof JSReferenceExpression && parentElement instanceof JSCallExpression) {
                    String message = parentElement instanceof JSNewExpression ? JSBundle.message((String)"refactoring.react.function.to.class.used.in.new.conflict", (Object[])new Object[]{elementDescription}) : JSBundle.message((String)"refactoring.react.function.to.class.used.in.call.conflict", (Object[])new Object[]{elementDescription});
                    conflicts.putValue((Object)refElement, (Object)message);
                }
                return true;
            });
        }, JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
            if (!conflictsDialog.showAndGet()) {
                return;
            }
        }
        boolean isTypedDialect = (languageDialect = DialectDetector.languageDialectOfElement((PsiElement)function)) != null && languageDialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES);
        List<ReactExtractComponentHandler.Prop> inferredProps = ReactFunctionalToClassComponentHandler.inferPropsFromDestructuring((JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters()));
        String introducedName = namedElement.getName();
        if (!isTypedDialect && !inferredProps.isEmpty() && StringUtil.isEmpty((String)introducedName) && StringUtil.isEmpty((String)(introducedName = ReactClassToFunctionalComponentHandler.showNameDialog(function.getProject(), (JSNamedElement)function)))) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_TITLE, null, () -> {
            if (editor == null) {
                ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(32);
            }
            ReactFunctionalToClassComponentHandler.doRefactoringInWriteAction(finalIntroducedName, namedElement, function, editor, inferredProps);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void doRefactoringInWriteAction(@Nullable String introducedName, @NotNull JSNamedElement namedElement, @NotNull JSFunction function, @NotNull Editor editor, @NotNull List<ReactExtractComponentHandler.Prop> inferredProps) {
        JSSourceElement defaultPropsAssignmentStatement;
        Object[] templateStatements;
        JSClass createdClass;
        String defaultValuesText;
        JSLanguageDialect languageDialect;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(7);
        }
        if (function == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(9);
        }
        if (inferredProps == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(10);
        }
        boolean isTypedDialect = (languageDialect = DialectDetector.languageDialectOfElement((PsiElement)function)) != null && languageDialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES);
        JSParameterListElement propsParameter = (JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters());
        List<JSStatement> replacement = ReactFunctionalToClassComponentHandler.getRenderFunctionBody(function);
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)function.getProject());
        String codeTemplateName = ReactExtractComponentHandler.getCodeTemplateName(ReactExtractComponentHandler.ComponentType.Class, isTypedDialect);
        JSPsiElementBase defaultPropsProperty = ReactFunctionalToClassComponentHandler.findDefinedProperty(namedElement, "defaultProps");
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)introducedName)) {
            properties.setProperty("NAME", introducedName);
        }
        properties.setProperty("HAS_PROPS", Boolean.valueOf(propsParameter != null).toString());
        String propTypesText = ReactFunctionalToClassComponentHandler.getPropsText(namedElement, propsParameter, inferredProps, isTypedDialect);
        if (!StringUtil.isEmpty((String)propTypesText)) {
            properties.setProperty("PROP_TYPES", propTypesText);
        }
        if (!StringUtil.isEmpty((String)(defaultValuesText = ReactFunctionalToClassComponentHandler.getDefaultPropsText(isTypedDialect, defaultPropsProperty, inferredProps)))) {
            properties.setProperty("DEFAULT_PROPS", defaultValuesText);
        }
        PsiFile createdFile = (createdClass = ReactExtractComponentHandler.expandTemplate((PsiElement)namedElement, properties, codeTemplateName, JSClass.class)) != null ? createdClass.getContainingFile() : null;
        JSFunction renderMethod = createdClass != null ? createdClass.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE) : null;
        JSBlockStatement templateBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(renderMethod);
        Object[] objectArray = templateStatements = templateBody != null ? templateBody.getStatements() : JSStatement.EMPTY;
        if (createdClass == null || templateBody == null || templateStatements.length == 0) {
            String message = JSBundle.message((String)"refactoring.react.could.not.find.in.template", (Object[])new Object[]{introducedName, codeTemplateName});
            ReactFunctionalToClassComponentHandler.showErrorHint(namedElement.getProject(), editor, message);
            return;
        }
        ReactFunctionalToClassComponentHandler.copyExportStatus(namedElement, (JSAttributeListOwner)createdClass);
        ReactExtractComponentHandler.addRequiredImportsForClassComponent(createdClass, (PsiElement)namedElement);
        ReactFunctionalToClassComponentHandler.copyReturnType((JSNamedElement)function, (JSNamedElement)renderMethod);
        templateBody.deleteChildRange((PsiElement)templateStatements[0], (PsiElement)ArrayUtil.getLastElement((Object[])templateStatements));
        PsiElement anchor = templateBody.getFirstChild();
        for (JSStatement statement : replacement) {
            anchor = JSChangeUtil.doAddAfter((PsiElement)templateBody, (PsiElement)statement, anchor);
        }
        ReactClassToFunctionalComponentHandler.expressionAwareReplace(namedElement, createdFile, (JSNamedElement)createdClass);
        if (isTypedDialect && defaultPropsProperty != null && (defaultPropsAssignmentStatement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)defaultPropsProperty, JSStatement.class, (boolean)false)) != null) {
            defaultPropsAssignmentStatement.delete();
        }
    }

    @NotNull
    private static List<ReactExtractComponentHandler.Prop> inferPropsFromDestructuring(@Nullable JSParameterListElement propsParameter) {
        JSDestructuringContainer target;
        JSDestructuringContainer jSDestructuringContainer = target = propsParameter instanceof JSDestructuringParameter ? ((JSDestructuringParameter)propsParameter).getTarget() : null;
        if (!(target instanceof JSDestructuringObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Object[])((JSDestructuringObject)target).getProperties(), property -> {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name) || property.isRest()) {
                return null;
            }
            JSInitializerOwner initializerOwner = property.getDestructuringElement();
            JSExpression initializer = initializerOwner != null ? initializerOwner.getInitializer() : null;
            return new ReactExtractComponentHandler.Prop(name, ReactExtractComponentHandler.getUsableExpressionType(initializer, (PsiElement)property), initializer != null ? initializer.getText() : null);
        });
        if (list == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static String getPropsText(@NotNull JSNamedElement namedElement, @Nullable JSParameterListElement propsParameter, @NotNull List<ReactExtractComponentHandler.Prop> inferredProps, boolean isTypedDialect) {
        PsiElement propsTypeElement;
        JSReferenceExpression typeReferenceExpression;
        TypeScriptSingleType functionTypeElement;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(13);
        }
        if (inferredProps == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(14);
        }
        TypeScriptSingleType typeScriptSingleType = functionTypeElement = namedElement instanceof JSTypeDeclarationOwner ? (TypeScriptSingleType)ObjectUtils.tryCast((Object)((JSTypeDeclarationOwner)namedElement).getTypeElement(), TypeScriptSingleType.class) : null;
        if (functionTypeElement != null && (typeReferenceExpression = functionTypeElement.getReferenceExpression()) != null && TypeScriptReactComponentUtil.REACT_SFC_TYPE_NAMES.contains(typeReferenceExpression.getReferenceName())) {
            JSTypeDeclaration typeArg = (JSTypeDeclaration)ArrayUtil.getFirstElement((Object[])functionTypeElement.getTypeArguments());
            return typeArg != null ? typeArg.getText() : null;
        }
        PsiElement psiElement = propsTypeElement = propsParameter != null ? propsParameter.getTypeElement() : null;
        if (propsTypeElement != null) {
            return propsTypeElement.getText();
        }
        boolean isPropsTypeParameterRequired = DialectDetector.isFlow((PsiElement)namedElement);
        if (!inferredProps.isEmpty()) {
            if (isTypedDialect) {
                return ReactExtractComponentHandler.buildTypedPropTypesText(inferredProps, !isPropsTypeParameterRequired);
            }
            if (!ReactFunctionalToClassComponentHandler.hasDefinedProperty(namedElement, "propTypes")) {
                return ReactExtractComponentHandler.buildJSPropTypesText(inferredProps, (PsiElement)namedElement);
            }
        }
        return isPropsTypeParameterRequired ? "{}" : null;
    }

    @Nullable
    private static String getDefaultPropsText(boolean dialectSupportsFieldInitializers, @Nullable JSPsiElementBase defaultPropsElement, @NotNull List<ReactExtractComponentHandler.Prop> propsToDefine) {
        if (propsToDefine == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(15);
        }
        if (defaultPropsElement != null) {
            if (dialectSupportsFieldInitializers) {
                JSExpression initializer = defaultPropsElement instanceof JSInitializerOwner ? ((JSInitializerOwner)defaultPropsElement).getInitializer() : null;
                return initializer != null ? initializer.getText() : null;
            }
            return null;
        }
        if ((propsToDefine = ContainerUtil.filter(propsToDefine, t -> t.value != null)).isEmpty()) {
            return null;
        }
        return "{" + StringUtil.join((Collection)propsToDefine, t -> t.name + ": " + t.value, (String)", ") + "}";
    }

    private static boolean hasDefinedProperty(@NotNull JSNamedElement namedElement, @NotNull String propName) {
        JSPsiElementBase elements;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(16);
        }
        if (propName == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(17);
        }
        return (elements = ReactFunctionalToClassComponentHandler.findDefinedProperty(namedElement, propName)) != null;
    }

    @Nullable
    private static JSPsiElementBase findDefinedProperty(@NotNull JSNamedElement namedElement, @NotNull String propName) {
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(18);
        }
        if (propName == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(19);
        }
        if (namedElement.getName() == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)namedElement.getContainingFile());
        return (JSPsiElementBase)ContainerUtil.getFirstItem(JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(namedElement.getName() + "." + propName, scope));
    }

    private static boolean hasInstanceProperties(@NotNull JSNamedElement namedElement) {
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(20);
        }
        if (namedElement.getName() == null) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)namedElement.getContainingFile());
        return !JSClassResolver.getInstance().processNamespaceMembers(namedElement.getName(), scope, (Processor<JSPsiElementBase>)((Processor)element -> element.getJSContext() != JSContext.INSTANCE));
    }

    @NotNull
    private static List<JSStatement> getRenderFunctionBody(@NotNull JSFunction function) {
        Object[] objectArray;
        JSStatement replacementStatement;
        JSParameterListElement[] parameters;
        if (function == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(21);
        }
        JSParameterListElement propsParameter = (parameters = function.getParameters()).length > 0 ? parameters[0] : null;
        JSParameterListElement contextParameter = parameters.length > 1 ? parameters[1] : null;
        JSBlockStatement functionBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(function);
        JSExpression arrowFunctionReturned = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        JSElement toProcess = (JSElement)ObjectUtils.coalesce((Object)functionBody, (Object)arrowFunctionReturned);
        if (toProcess == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(22);
            }
            return list;
        }
        String replacementText = ReactFunctionalToClassComponentHandler.replaceParameterReferences(toProcess, propsParameter, contextParameter);
        if (arrowFunctionReturned != null) {
            replacementText = String.format("return %s%s", replacementText, semicolon);
        }
        if ((replacementStatement = JSChangeUtil.createStatementPsiFromTextWithContext(replacementText, (PsiElement)function, JSStatement.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (replacementStatement instanceof JSBlockStatement) {
            objectArray = ((JSBlockStatement)replacementStatement).getStatements();
        } else {
            JSStatement[] jSStatementArray = new JSStatement[1];
            objectArray = jSStatementArray;
            jSStatementArray[0] = replacementStatement;
        }
        ArrayList result2 = ContainerUtil.newArrayList((Object[])objectArray);
        if (contextParameter instanceof JSDestructuringParameter) {
            result2.add(0, JSChangeUtil.createStatementPsiFromTextWithContext(String.format("let %s = this.context%s", contextParameter.getText(), semicolon), (PsiElement)propsParameter, JSStatement.class));
        }
        if (propsParameter instanceof JSDestructuringParameter) {
            JSDestructuringParameter parameterCopy = (JSDestructuringParameter)propsParameter.copy();
            JSDestructuringObject destructuringObject = (JSDestructuringObject)ObjectUtils.tryCast((Object)parameterCopy.getTarget(), JSDestructuringObject.class);
            if (destructuringObject != null) {
                for (JSDestructuringProperty property : destructuringObject.getProperties()) {
                    JSInitializerOwner element = property.getDestructuringElement();
                    if (element == null) continue;
                    JSRefactoringUtil.removeInitializer(element);
                }
            }
            JSRefactoringUtil.setType((JSElement)parameterCopy, null);
            result2.add(0, JSChangeUtil.createStatementPsiFromTextWithContext(String.format("let %s = this.props%s", parameterCopy.getText(), semicolon), (PsiElement)propsParameter, JSStatement.class));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static String replaceParameterReferences(@NotNull JSElement toProcess, @Nullable JSParameterListElement propsParameter, @Nullable JSParameterListElement contextParameter) {
        if (toProcess == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(25);
        }
        ArrayList paramReferencesToReplace = new ArrayList();
        PsiTreeUtil.processElements((PsiElement)toProcess, element -> {
            if (element instanceof JSReferenceExpression) {
                PsiElement resolved = ((JSReferenceExpression)element).resolve();
                if (propsParameter instanceof JSParameter && propsParameter.isEquivalentTo(resolved) || contextParameter instanceof JSParameter && contextParameter.isEquivalentTo(resolved)) {
                    paramReferencesToReplace.add((JSReferenceExpression)element);
                }
            }
            return true;
        });
        String string = ReactExtractComponentHandler.replaceOccurrences(toProcess, toProcess.getTextRange(), paramReferencesToReplace, expression -> "this." + expression.getText());
        if (string == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public static JSBlockStatement findFunctionBlockBody(@Nullable JSFunction function) {
        return function != null ? (JSBlockStatement)ContainerUtil.findInstance((Object[])function.getBody(), JSBlockStatement.class) : null;
    }

    public static void copyReturnType(@Nullable JSNamedElement owner, @Nullable JSNamedElement target) {
        PsiElement typeElement;
        if (owner instanceof JSFunction && target instanceof JSFunction && (typeElement = ((JSFunction)owner).getReturnTypeElement()) != null) {
            JSRefactoringUtil.setFunctionReturnType((JSFunction)target, typeElement.getText());
        }
    }

    public static void copyExportStatus(@NotNull JSNamedElement source, @NotNull JSAttributeListOwner target) {
        if (source == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(27);
        }
        if (target == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(28);
        }
        boolean isExported = source instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)source, JSAttributeList.ModifierType.EXPORT);
        JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(target.getAttributeList(), target.getProject());
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.EXPORT, isExported);
        attributeListWrapper.applyTo(target);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(29);
        }
        if (editor == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(30);
        }
        if (message == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(31);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_TITLE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 9: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredProps";
                break;
            }
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/ReactFunctionalToClassComponentHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsToDefine";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/ReactFunctionalToClassComponentHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "inferPropsFromDestructuring";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderFunctionBody";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceParameterReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPropsText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropsText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasDefinedProperty";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findDefinedProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasInstanceProperties";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRenderFunctionBody";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "replaceParameterReferences";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "copyExportStatus";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

