/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSImplementedInterfacesIndex;
import com.intellij.lang.javascript.psi.stubs.JSSuperClassIndex;
import com.intellij.lang.javascript.search.JSClassInheritorsProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSClassSearch
implements QueryExecutor<JSClass, SearchParameters> {
    private static final QueryFactory<JSClass, SearchParameters> INTERFACE_IMPLEMENTATIONS_QUERY_FACTORY = new QueryFactory();
    private static final QueryFactory<JSClass, SearchParameters> CLASS_INHERITORS_QUERY_FACTORY = new QueryFactory();
    private static final JSClassSearch OUR_CLASS_SEARCH_EXECUTOR;

    public static Query<JSClass> searchClassInheritors(JSClass superClass, boolean checkDeepInheritance, GlobalSearchScope scope) {
        return CLASS_INHERITORS_QUERY_FACTORY.createUniqueResultsQuery((Object)new SearchParameters(superClass, checkDeepInheritance, scope));
    }

    public static Query<JSClass> searchClassInheritors(JSClass superClass, boolean checkDeepInheritance) {
        return JSClassSearch.searchClassInheritors(superClass, checkDeepInheritance, JSClassSearch.getUseScope(superClass));
    }

    private static GlobalSearchScope getUseScope(JSClass superClass) {
        return (GlobalSearchScope)ReadAction.compute(() -> {
            SearchScope searchScope = superClass.getUseScope();
            return searchScope instanceof GlobalSearchScope ? (GlobalSearchScope)searchScope : GlobalSearchScope.fileScope((PsiFile)superClass.getContainingFile());
        });
    }

    public static Query<JSClass> searchInterfaceImplementations(JSClass superClass, boolean checkDeepInheritance, GlobalSearchScope scope) {
        return INTERFACE_IMPLEMENTATIONS_QUERY_FACTORY.createUniqueResultsQuery((Object)new SearchParameters(superClass, checkDeepInheritance, scope));
    }

    public static Query<JSClass> searchInterfaceImplementations(JSClass superClass, boolean checkDeepInheritance) {
        return JSClassSearch.searchInterfaceImplementations(superClass, checkDeepInheritance, JSClassSearch.getUseScope(superClass));
    }

    public boolean execute(@NotNull SearchParameters queryParameters, @NotNull Processor<? super JSClass> consumer) {
        if (queryParameters == null) {
            JSClassSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JSClassSearch.$$$reportNull$$$0(1);
        }
        return this.processDirectInheritors(queryParameters.getTargetClass(), consumer, queryParameters.isCheckDeepInheritance(), null, queryParameters.getScope());
    }

    protected boolean processDirectInheritors(JSClass superClass, Processor<? super JSClass> consumer, boolean checkDeep, Set<String> processed, GlobalSearchScope scope) {
        String qualifiedName = JSClassSearch.getUniqueQName(superClass);
        if (processed != null) {
            if (processed.contains(qualifiedName)) {
                return true;
            }
        } else {
            processed = new THashSet();
        }
        processed.add(qualifiedName);
        Project project = superClass.getProject();
        String name = superClass.getName();
        if (name == null) {
            return true;
        }
        Collection candidates = StubIndex.getElements(this.getIndexKey(), (Object)name, (Project)project, (GlobalSearchScope)scope, JSClass.class);
        for (JSClassInheritorsProvider provider2 : (JSClassInheritorsProvider[])Extensions.getExtensions(JSClassInheritorsProvider.EP_NAME)) {
            candidates.addAll(this.getInheritors(provider2, name, project, scope));
        }
        for (JSClass candidate : candidates) {
            JSClass[] classes = this.getSupers(candidate);
            if (classes == null) continue;
            for (JSClass superClassCandidate : classes) {
                String uniqueQName = JSClassSearch.getUniqueQName(superClassCandidate);
                if (uniqueQName == null || !uniqueQName.equals(qualifiedName)) continue;
                if (!consumer.process((Object)candidate)) {
                    return false;
                }
                if (!checkDeep || this.processDirectInheritors(candidate, consumer, checkDeep, (Set<String>)processed, scope)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static String getUniqueQName(@NotNull JSClass superClass) {
        String qualifiedName;
        if (superClass == null) {
            JSClassSearch.$$$reportNull$$$0(2);
        }
        if ((qualifiedName = superClass.getQualifiedName()) != null) {
            PsiElement possibleFileParent;
            boolean isLocalClass = superClass instanceof JSClassExpression && ES6PsiUtil.isLocalClass((JSClass)((JSClassExpression)superClass));
            PsiElement psiElement = possibleFileParent = isLocalClass ? null : TypeScriptPsiUtil.getParentOverDefaultAssignable((PsiElement)superClass);
            if (possibleFileParent instanceof JSFile && qualifiedName.indexOf(46) == -1) {
                JSFile classFile = (JSFile)possibleFileParent;
                JSAttributeList attributeList = superClass.getAttributeList();
                if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL || classFile.isCommonJSModule()) {
                    qualifiedName = qualifiedName + "@" + JSItemPresentation.getNameOfPhysicalFile(superClass.getContainingFile().getVirtualFile());
                }
            }
        }
        return qualifiedName;
    }

    protected abstract Collection<JSClass> getInheritors(JSClassInheritorsProvider var1, String var2, Project var3, GlobalSearchScope var4);

    protected abstract StubIndexKey<String, JSClass> getIndexKey();

    protected abstract JSClass[] getSupers(JSClass var1);

    static {
        INTERFACE_IMPLEMENTATIONS_QUERY_FACTORY.registerExecutor((QueryExecutor)new JSClassSearch(){

            @Override
            protected StubIndexKey<String, JSClass> getIndexKey() {
                return JSImplementedInterfacesIndex.KEY;
            }

            @Override
            protected JSClass[] getSupers(JSClass candidate) {
                return candidate.getImplementedInterfaces();
            }

            @Override
            public boolean execute(final @NotNull SearchParameters queryParameters, @NotNull Processor<? super JSClass> consumer) {
                if (queryParameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (consumer == null) {
                    1.$$$reportNull$$$0(1);
                }
                final THashSet visited = new THashSet();
                if (queryParameters.isCheckDeepInheritance()) {
                    final Processor<JSClass> consumerCopy = consumer;
                    consumer = new Processor<JSClass>(){

                        public boolean process(JSClass jsClass) {
                            return consumerCopy.process((Object)jsClass) && OUR_CLASS_SEARCH_EXECUTOR.processDirectInheritors(jsClass, this, false, (Set<String>)visited, queryParameters.getScope());
                        }
                    };
                }
                Processor<JSClass> consumerToUse = consumer;
                boolean b = this.processDirectInheritors(queryParameters.getTargetClass(), (Processor<? super JSClass>)consumerToUse, queryParameters.isCheckDeepInheritance(), (Set<String>)visited, queryParameters.getScope());
                if (b) {
                    return 1.searchClassInheritors(queryParameters.getTargetClass(), queryParameters.isCheckDeepInheritance()).forEach(arg_0 -> this.lambda$execute$0((Processor)consumerToUse, queryParameters, visited, arg_0));
                }
                return b;
            }

            @Override
            protected Collection<JSClass> getInheritors(JSClassInheritorsProvider provider2, String parentName, Project project, GlobalSearchScope scope) {
                return provider2.getImplementingClasses(parentName, project, scope);
            }

            private /* synthetic */ boolean lambda$execute$0(Processor consumerToUse, @NotNull SearchParameters queryParameters, THashSet visited, JSClass jsClass) {
                if (queryParameters == null) {
                    1.$$$reportNull$$$0(2);
                }
                return this.processDirectInheritors(jsClass, (Processor<? super JSClass>)consumerToUse, queryParameters.isCheckDeepInheritance(), (Set<String>)visited, queryParameters.getScope());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "queryParameters";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/search/JSClassSearch$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$execute$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        OUR_CLASS_SEARCH_EXECUTOR = new JSClassSearch(){

            @Override
            protected StubIndexKey<String, JSClass> getIndexKey() {
                return JSSuperClassIndex.KEY;
            }

            @Override
            protected JSClass[] getSupers(JSClass candidate) {
                return candidate.getSuperClasses();
            }

            @Override
            protected Collection<JSClass> getInheritors(JSClassInheritorsProvider provider2, String parentName, Project project, GlobalSearchScope scope) {
                return provider2.getExtendingClasses(parentName, project, scope);
            }
        };
        CLASS_INHERITORS_QUERY_FACTORY.registerExecutor((QueryExecutor)OUR_CLASS_SEARCH_EXECUTOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/search/JSClassSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUniqueQName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchParameters {
        private final JSClass myClass;
        private final boolean myCheckDeepInheritance;
        private final GlobalSearchScope myScope;

        public SearchParameters(JSClass anClass, boolean checkDeepInheritance, GlobalSearchScope scope) {
            this.myClass = anClass;
            this.myCheckDeepInheritance = checkDeepInheritance;
            this.myScope = scope;
        }

        public JSClass getTargetClass() {
            return this.myClass;
        }

        public boolean isCheckDeepInheritance() {
            return this.myCheckDeepInheritance;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }
    }
}

