/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class JSConstructorReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public JSConstructorReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element;
        if (p == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(1);
        }
        if (!JSResolveUtil.isConstructorFunction(element = p.getElementToSearch())) {
            return;
        }
        JSFunction constructorFunction = (JSFunction)element;
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)constructorFunction);
        if (containingClass == null) {
            return;
        }
        SearchScope searchScope = p.getEffectiveSearchScope();
        JSClassSearch.searchClassInheritors(containingClass, false).forEach(jsClass -> {
            if (consumer == null) {
                JSConstructorReferencesSearcher.$$$reportNull$$$0(3);
            }
            return JSInheritanceUtil.processSuperCallsIn(jsClass, (Processor<JSCallExpression>)((Processor)jsCallExpression -> {
                if (consumer == null) {
                    JSConstructorReferencesSearcher.$$$reportNull$$$0(4);
                }
                if (PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)jsCallExpression)) {
                    return consumer.process((Object)jsCallExpression.getMethodExpression().getReference());
                }
                return false;
            }));
        });
        if ("constructor".equals(constructorFunction.getName())) {
            SearchRequestCollector optimizer = p.getOptimizer();
            ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)searchScope, (boolean)p.isIgnoreAccessScope(), (SearchRequestCollector)optimizer, (boolean)true, (ref, collector) -> {
                PsiElement refElement;
                if (consumer == null) {
                    JSConstructorReferencesSearcher.$$$reportNull$$$0(2);
                }
                if ((refElement = ref.getElement()) instanceof JSReferenceExpression && refElement.getParent() instanceof JSNewExpression) {
                    return consumer.process(ref);
                }
                return true;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processQuery$2";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processQuery$1";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

