/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.util.AnalysisUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceChecker {
    @NotNull
    protected final JSReferenceInspectionProblemReporter myReporter;

    public JSReferenceChecker(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            JSReferenceChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    protected void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(1);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "arguments") && PsiTreeUtil.getParentOfType((PsiElement)node, XmlAttributeValue.class) != null) {
            return;
        }
        if (!node.shouldCheckReferences() || node.getParent() instanceof JSCallExpression || node.getParent() instanceof ES6TaggedTemplateExpression) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            hasValidResult = true;
            if (this.processExpressionResolveResult((JSExpression)node, r.getElement())) break;
        }
        if (!hasValidResult) {
            this.registerQuickFixesForUnresolvedRef(node, resolveResults);
        } else if (!JSResolveUtil.isSelfReference((PsiElement)node) && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.ReadWrite) {
            boolean seenRead = false;
            boolean seenWrite = false;
            for (ResolveResult r : resolveResults) {
                PsiElement element = r.getElement();
                if (element instanceof JSFunction && ((JSFunction)element).isGetProperty() || element instanceof JSProperty && ((JSProperty)element).isGetProperty()) {
                    seenRead = true;
                    continue;
                }
                if (element instanceof JSFunction && ((JSFunction)element).isSetProperty() || element instanceof JSProperty && ((JSProperty)element).isSetProperty()) {
                    seenWrite = true;
                    continue;
                }
                if (!(element instanceof JSProperty) && !(element instanceof JSVariable) && !(element instanceof JSDefinitionExpression)) continue;
                seenWrite = true;
                seenRead = true;
                break;
            }
            if (seenRead || seenWrite) {
                if (!seenRead) {
                    this.myReporter.reportUnresolvedFunctionError(node.getReferenceNameElement(), null, JSBundle.message((String)"javascript.missing.read.property", (Object[])new Object[0]), null);
                }
                if (!seenWrite) {
                    this.myReporter.reportUnresolvedFunctionError(node.getReferenceNameElement(), null, JSBundle.message((String)"javascript.missing.write.property", (Object[])new Object[0]), null);
                }
            }
        }
        this.checkReadWriteAccess(node);
    }

    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        return true;
    }

    protected void registerQuickFixesForUnresolvedRef(JSReferenceExpression node, ResolveResult[] resolveResults) {
        boolean canHaveCreateFromUsage;
        PsiElement nameIdentifier = node.getReferenceNameElement();
        if (nameIdentifier == null) {
            return;
        }
        LinkedList<LocalQuickFix> fixes = new LinkedList<LocalQuickFix>();
        boolean inTypeContext = JSResolveUtil.isExprInTypeContext(node);
        JSExpression qualifier = node.getQualifier();
        boolean bl = canHaveCreateFromUsage = JSReferenceChecker.findInsufficientVisibilityResult(resolveResults) == null && JSReferenceChecker.canHaveCreateFromUsage(qualifier);
        if (canHaveCreateFromUsage) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.getPreferredQuickFixForUnresolvedRef(nameIdentifier));
            if (fixes.isEmpty()) {
                boolean reportProblem;
                PsiFile containingFile = node.getContainingFile();
                boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                ProblemHighlightType highlightType = this.getUnresolvedReferenceHighlightType(node);
                boolean bl2 = reportProblem = (!ecma || highlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) && highlightType != null;
                if (!reportProblem) {
                    return;
                }
                inTypeContext = this.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
            }
        }
        JSReferenceChecker.addEscalateVisibilityFix(resolveResults, node, fixes);
        fixes.add(JSReferenceChecker.renameReferenceFix());
        Ref message = Ref.create((Object)JSBundle.message((String)(node.getQualifier() == null ? (inTypeContext ? "javascript.unresolved.type.name.message" : "javascript.unresolved.variable.or.type.name.message") : "javascript.unresolved.variable.name.message"), (Object[])new Object[]{node.getReferenceName()}));
        this.modifyUnresolvedErrorMessage((Ref<String>)message, resolveResults, qualifier, node, inTypeContext);
        this.reportUnresolvedReference(resolveResults, node, fixes, (Ref<String>)message, false);
    }

    protected void modifyUnresolvedErrorMessage(@NotNull Ref<String> message, @NotNull ResolveResult[] results, @Nullable JSExpression qualifier, @NotNull JSReferenceExpression node, boolean inTypeContext) {
        if (message == null) {
            JSReferenceChecker.$$$reportNull$$$0(2);
        }
        if (results == null) {
            JSReferenceChecker.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(4);
        }
    }

    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        return true;
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(PsiElement nameIdentifier) {
        return null;
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSType type;
        JSExpression qualifier;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(5);
        }
        if ((qualifier = node.getQualifier()) == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        if (qualifier != null && (type = JSResolveUtil.getExpressionJSType(qualifier)) != null && JSTypeUtils.isMapType(type)) {
            return null;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        boolean isField;
        JSClass contextClass;
        JSExpression qualifier = node.getQualifier();
        String referencedName = node.getReferenceName();
        PsiElement parent = node.getParent();
        PsiFile containingFile = node.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(containingFile);
        boolean supportsClasses = JSClassUtils.canHaveClasses(parent);
        JSClass jSClass = contextClass = supportsClasses ? JSResolveUtil.getClassOfContext((PsiElement)node) : null;
        if (parent instanceof JSReferenceListMember) {
            if (supportsClasses && contextClass != null && qualifier == null) {
                boolean isInterface = contextClass.isInterface() || parent.getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST;
                fixes.add(JSReferenceChecker.createClassOrInterfaceFix(node, isInterface));
            }
            return inTypeContext;
        }
        if (inTypeContext && supportsClasses && resolveResults.length == 0) {
            PsiElement element;
            fixes.add(JSReferenceChecker.createClassOrInterfaceFix(node, true));
            fixes.add(JSReferenceChecker.createClassOrInterfaceFix(node, false));
            if (qualifier instanceof JSReferenceExpression && (element = ((JSReferenceExpression)qualifier).resolve()) instanceof TypeScriptEnum) {
                fixes.add(this.createJSVariableIntentionAction(referencedName, true, false, false));
            }
            return true;
        }
        boolean bl = isField = qualifier != null || (ecma || supportsClasses) && contextClass != null;
        if (!inTypeContext) {
            if (parent instanceof JSArgumentList && (dialect == null || !dialect.isTypeScript) || JSReferenceChecker.isFunctionExpectedType(node) || parent instanceof ES6Decorator) {
                if (parent instanceof JSArgumentList && ecma) {
                    fixes.add(JSFixFactory.getInstance().createJSFunctionFromArgumentIntentionAction(referencedName, qualifier, true));
                } else {
                    this.addFunctionFixes(node, fixes, referencedName, dialect, qualifier);
                }
            }
            if (!(parent instanceof ES6Decorator) && this.suggestCreateVarFromUsage(node)) {
                boolean isTypeScriptModule = JSReferenceChecker.isTypeScriptModule(qualifier);
                fixes.add(this.createJSVariableIntentionAction(referencedName, isField, false, isTypeScriptModule));
                if (qualifier != null && referencedName != null) {
                    this.addSurroundWithTypeGuardFix(qualifier, fixes, referencedName);
                }
                if (isField && qualifier == null) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, false, false, false));
                }
                if (qualifier == null) {
                    JSReferenceChecker.addCreateParameterFix(parent, fixes, referencedName);
                }
                if (ecma && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, isField, true, isTypeScriptModule));
                }
            }
        }
        if (qualifier != null && dialect != null && dialect.isJavaScript() && contextClass == null) {
            fixes.add(JSFixFactory.getInstance().createJSNamespaceIntentionAction(referencedName));
        }
        return inTypeContext;
    }

    private static boolean isTypeScriptModule(JSExpression qualifier) {
        return qualifier instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)qualifier) && ((JSReferenceExpression)qualifier).resolve() instanceof TypeScriptModule;
    }

    protected void addSurroundWithTypeGuardFix(@NotNull JSExpression qualifier, @NotNull List<LocalQuickFix> fixes, @NotNull String name) {
        if (qualifier == null) {
            JSReferenceChecker.$$$reportNull$$$0(6);
        }
        if (fixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JSReferenceChecker.$$$reportNull$$$0(8);
        }
    }

    protected void addCreateFromUsageFixesForCall(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression, @NotNull ResolveResult[] resolveResults, @NotNull List<LocalQuickFix> quickFixes) {
        if (methodExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(9);
        }
        if (resolveResults == null) {
            JSReferenceChecker.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(11);
        }
        String refName = methodExpression.getReferenceName();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)methodExpression);
        JSExpression qualifier = methodExpression.getQualifier();
        if (isNewExpression) {
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return;
            }
            if (dialect != null && !dialect.hasFeature(JSLanguageFeature.CLASSES)) {
                boolean isModuleScope = JSReferenceChecker.isTypeScriptModule(qualifier);
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, isModuleScope));
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false, isModuleScope));
            } else {
                JSNewExpression newExpression = (JSNewExpression)ObjectUtils.tryCast((Object)methodExpression.getParent(), JSNewExpression.class);
                if (newExpression != null) {
                    quickFixes.add(JSReferenceChecker.createClassFromNewFix(methodExpression, newExpression.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)newExpression)));
                }
            }
        } else {
            this.addFunctionFixes(methodExpression, quickFixes, refName, dialect, qualifier);
        }
        if (JSClassUtils.isES6ClassImplementation((PsiElement)methodExpression) && !isNewExpression && JSReferenceChecker.isPossibleMethodCallWithoutThis(methodExpression)) {
            quickFixes.add(new JSInsertThisFix((JSExpression)methodExpression));
        }
        quickFixes.add(JSReferenceChecker.renameReferenceFix());
    }

    protected void addFunctionFixes(@NotNull JSReferenceExpression node, @NotNull List<LocalQuickFix> quickFixes, @Nullable String refName, DialectOptionHolder dialect, JSExpression qualifier) {
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(12);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(13);
        }
        if (qualifier != null) {
            quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, JSReferenceChecker.isTypeScriptModule(qualifier)));
            if (refName != null) {
                this.addSurroundWithTypeGuardFix(qualifier, quickFixes, refName);
            }
        } else {
            if (JSResolveUtil.getClassOfContext((PsiElement)node) != null && PsiTreeUtil.getParentOfType((PsiElement)node, ES6Decorator.class, (boolean)true, (Class[])new Class[]{JSClass.class}) == null) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, false));
            }
            if (dialect == null || dialect.isJavaScript() && !dialect.isECMA6) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, false));
            }
            if (dialect == null || !dialect.isECMA4) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false, false));
            }
        }
    }

    protected LocalQuickFix createJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant, boolean isModuleScope) {
        return JSFixFactory.getInstance().createJSVariableIntentionAction(referencedName, isField, isConstant, isModuleScope);
    }

    private void reportUnresolvedReference(@NotNull ResolveResult[] resolveResults, @NotNull JSReferenceExpression referenceExpression, @NotNull List<LocalQuickFix> quickFixes, @NotNull Ref<String> message, boolean isFunction) {
        PsiElement place;
        if (resolveResults == null) {
            JSReferenceChecker.$$$reportNull$$$0(14);
        }
        if (referenceExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(15);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(16);
        }
        if (message == null) {
            JSReferenceChecker.$$$reportNull$$$0(17);
        }
        if ((place = referenceExpression.getReferenceNameElement()) == null) {
            return;
        }
        boolean jsSymbolNotAccessible = false;
        boolean jsSymbolToImport = false;
        if (resolveResults.length > 0 && resolveResults[0] instanceof JSResolveResult) {
            String resolveProblemKey;
            if (isFunction) {
                JSReferenceChecker.addEscalateVisibilityFix(resolveResults, referenceExpression, quickFixes);
            }
            jsSymbolNotAccessible = (resolveProblemKey = ((JSResolveResult)resolveResults[0]).getResolveProblemKey()) == "javascript.jsdoc.private.member.is.not.accessible.message" || resolveProblemKey == "javascript.jsdoc.protected.member.is.not.accessible.message";
            boolean bl = jsSymbolToImport = resolveProblemKey == "javascript.element.need.to.be.imported";
            if (resolveProblemKey != null) {
                message.set((Object)JSBundle.message((String)resolveProblemKey, (Object[])new Object[0]));
            }
            PsiElement element = resolveResults[0].getElement();
            if (jsSymbolNotAccessible && element instanceof JSQualifiedNamedElement) {
                JSAttributeList.AccessType newVisibility = JSVisibilityUtil.getEscalatedJSDocVisibility((JSQualifiedNamedElement)element, (PsiElement)referenceExpression);
                quickFixes.add((LocalQuickFix)new JSAccessibilityCheckInspection.SetJSDocElementVisibilityFix(element, newVisibility));
            }
            this.addFixesForDistinctResolveProblem(referenceExpression, quickFixes, resolveProblemKey, element);
        }
        if (jsSymbolNotAccessible) {
            this.myReporter.reportAccessibilityError(place, null, (String)message.get(), quickFixes);
        } else {
            ProblemHighlightType type;
            ProblemHighlightType problemHighlightType = type = jsSymbolToImport ? ProblemHighlightType.INFORMATION : this.getUnresolvedReferenceHighlightType(referenceExpression);
            if (isFunction) {
                this.myReporter.reportUnresolvedFunctionError(place, type, (String)message.get(), quickFixes);
            } else {
                this.myReporter.reportUnresolvedVariableError(place, type, (String)message.get(), quickFixes);
            }
        }
    }

    protected boolean isErrorReported(@NotNull JSReferenceExpression ref) {
        ResolveResult[] results;
        boolean hasValidResult;
        if (ref == null) {
            JSReferenceChecker.$$$reportNull$$$0(18);
        }
        if (!(hasValidResult = Arrays.stream(results = ref.multiResolve(false)).anyMatch(ResolveResult::isValidResult)) && this.getUnresolvedReferenceHighlightType(ref) == ProblemHighlightType.ERROR) {
            return true;
        }
        JSExpression qualifier = ref.getQualifier();
        return qualifier instanceof JSReferenceExpression && this.isErrorReported((JSReferenceExpression)qualifier);
    }

    protected void addFixesForDistinctResolveProblem(JSReferenceExpression node, List<LocalQuickFix> fixes, String resolveProblemKey, PsiElement element) {
    }

    protected void checkCallReferences(JSReferenceExpression methodExpression, boolean isNewExpression) {
        JSElement expression;
        ResolveResult[] resolveResults = methodExpression.multiResolve(false);
        boolean noCompleteResolve = true;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            noCompleteResolve = false;
            if (this.processExpressionResolveResult((JSExpression)methodExpression, r.getElement())) break;
        }
        if (resolveResults.length == 0 || noCompleteResolve) {
            boolean canCreateFromUsage;
            JSExpression qualifier = methodExpression.getQualifier();
            LinkedList<LocalQuickFix> quickFixes = new LinkedList<LocalQuickFix>();
            String refName = methodExpression.getReferencedName();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)methodExpression);
            boolean simpleJs = dialect != null && dialect.isJavaScript();
            ProblemHighlightType unresolvedRefHighlightType = this.getUnresolvedReferenceHighlightType(methodExpression);
            boolean reportProblem = unresolvedRefHighlightType != null && (dialect == null || !dialect.isECMA4 || unresolvedRefHighlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            boolean bl = canCreateFromUsage = JSReferenceChecker.canHaveCreateFromUsage(qualifier) && (simpleJs || JSReferenceChecker.findInsufficientVisibilityResult(resolveResults) == null);
            if (reportProblem && canCreateFromUsage) {
                this.addCreateFromUsageFixesForCall(methodExpression, isNewExpression, resolveResults, quickFixes);
            }
            if (reportProblem) {
                Ref message = Ref.create((Object)JSBundle.message((String)(isNewExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.function.name.message"), (Object[])new Object[]{refName}));
                this.reportUnresolvedReference(resolveResults, methodExpression, quickFixes, (Ref<String>)message, true);
            }
        } else if (resolveResults.length == 1 && resolveResults[0].getElement() instanceof JSVariable && methodExpression.getQualifier() == null && ((expression = JSSymbolUtil.calcRefExprValue(methodExpression)) instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression)) {
            this.myReporter.reportUnresolvedFunctionError(methodExpression.getReferenceNameElement(), ProblemHighlightType.ERROR, JSBundle.message((String)"javascript.invalid.invokation.target", (Object[])new Object[0]), null);
        }
    }

    protected void checkNewExpressionInsideCallReferences(JSExpression methodExpression) {
        PsiElement elt;
        ResolveResult[] results;
        JSExpression methodExpr = ((JSNewExpression)methodExpression).getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression && (results = ((JSReferenceExpression)methodExpr).multiResolve(false)).length > 0 && ((elt = results[0].getElement()) instanceof JSFunction && ((JSFunction)elt).isConstructor() || elt instanceof JSClass)) {
            this.myReporter.reportUnresolvedFunctionError((PsiElement)methodExpression, this.getUnresolvedReferenceHighlightType((JSReferenceExpression)methodExpr), JSBundle.message((String)"javascript.term.does.not.evaluate.to.function", (Object[])new Object[0]), null);
        }
    }

    protected void checkReadWriteAccess(@NotNull JSReferenceExpression node) {
        ReadWriteAccessDetector.Access expressionAccess;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(19);
        }
        if (!JSResolveUtil.isSelfReference((PsiElement)node) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node)) != ReadWriteAccessDetector.Access.Read) {
            this.checkAssignmentToConst(node);
        }
    }

    protected void checkAssignmentToConst(@NotNull JSReferenceExpression lExpr) {
        ResolveResult[] results;
        ResolveResult[] resolveResultArray;
        int n;
        int n2;
        PsiElement resolved;
        if (lExpr == null) {
            JSReferenceChecker.$$$reportNull$$$0(20);
        }
        if ((resolved = lExpr.resolve()) == null && DialectDetector.isTypeScript((PsiElement)lExpr) && (n2 = 0) < (n = (resolveResultArray = (results = lExpr.multiResolve(false))).length)) {
            ResolveResult result2 = resolveResultArray[n2];
            if (!result2.isValidResult()) {
                return;
            }
            PsiElement element = result2.getElement();
            if (!(element instanceof TypeScriptMergedTypeImplicitElement)) {
                return;
            }
            resolved = element;
        }
        if (this.isConst(lExpr, resolved)) {
            if (this.isConstAssignable(lExpr, resolved)) {
                return;
            }
            PsiElement place = lExpr.getReferenceNameElement();
            if (place == null) {
                place = lExpr;
            }
            this.reportAssignToConst(place);
        }
    }

    protected void reportAssignToConst(PsiElement place) {
        this.myReporter.reportUnresolvedVariableError(place, ProblemHighlightType.GENERIC_ERROR, JSBundle.message((String)"javascript.validation.message.assignment.to.const", (Object[])new Object[0]), null);
    }

    protected boolean isConst(@NotNull JSReferenceExpression lExpr, PsiElement resolved) {
        if (lExpr == null) {
            JSReferenceChecker.$$$reportNull$$$0(21);
        }
        if (resolved instanceof JSVariable) {
            return ((JSVariable)resolved).isConst();
        }
        if (resolved instanceof JSImplicitElement) {
            return ((JSImplicitElement)resolved).isConst();
        }
        if (resolved instanceof JSFunction) {
            return !(resolved instanceof JSFunctionExpression) && !JSPsiImplUtils.isGetterOrSetter((JSFunction)resolved) && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)lExpr) == ReadWriteAccessDetector.Access.ReadWrite;
        }
        if ((resolved instanceof JSDefinitionExpression || resolved instanceof JSProperty) && DialectDetector.isJavaScript(resolved)) {
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment(resolved);
            return comment != null && comment.hasConstTag();
        }
        return false;
    }

    protected boolean isConstAssignable(@NotNull JSReferenceExpression lExpr, PsiElement resolved) {
        JSExecutionScope contextParent;
        JSAttributeList attributeList;
        if (lExpr == null) {
            JSReferenceChecker.$$$reportNull$$$0(22);
        }
        if (resolved instanceof JSParameter && (attributeList = ((JSParameter)resolved).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.READONLY)) {
            JSFunction ctor = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)resolved, (Class[])new Class[]{JSFunction.class});
            while (ctor != null && !ctor.isConstructor()) {
                ctor = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)ctor, JSFunction.class, (boolean)true, (Class[])new Class[]{JSClass.class});
            }
            if (ctor != null && PsiTreeUtil.isContextAncestor((PsiElement)ctor, (PsiElement)lExpr, (boolean)true)) {
                return true;
            }
        }
        if (JSResolveUtil.isSameReference(lExpr, resolved)) {
            return true;
        }
        return lExpr.getQualifier() instanceof JSThisExpression && JSResolveUtil.isConstructorFunction((PsiElement)(contextParent = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)lExpr, JSExecutionScope.class)));
    }

    private static JSResolveResult findInsufficientVisibilityResult(ResolveResult[] results) {
        for (ResolveResult r : results) {
            String problemKey;
            if (r.isValidResult() || !(r instanceof JSResolveResult) || !ArrayUtil.contains((String)(problemKey = ((JSResolveResult)r).getResolveProblemKey()), (String[])JSResolveResult.INSUFFICIENT_VISIBILITY_PROBLEM_KEYS)) continue;
            return (JSResolveResult)r;
        }
        return null;
    }

    private static void addEscalateVisibilityFix(ResolveResult[] resolveResults, JSReferenceExpression refExpr, List<LocalQuickFix> fixes) {
        JSResolveResult result2 = JSReferenceChecker.findInsufficientVisibilityResult(resolveResults);
        if (result2 == null || !(result2.getElement() instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner element = (JSAttributeListOwner)result2.getElement();
        JSAttributeList attributeList = element.getAttributeList();
        if (attributeList == null) {
            return;
        }
        if (JSProjectUtil.isInLibrary((PsiElement)element)) {
            return;
        }
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        String key = result2.getResolveProblemKey();
        if (key == "javascript.private.member.is.not.accessible.without.sharp.message") {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PUBLIC, null));
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createAddRemoveSharpFix(refExpr, false));
            return;
        }
        if (key == "javascript.public.member.is.not.accessible.via.sharp.message") {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PRIVATE, null));
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createAddRemoveSharpFix(refExpr, true));
            return;
        }
        options.ignoreClassInheritance = key == "javascript.protected.member.is.not.accessible.message";
        JSAttributeList.AccessType visibility = JSVisibilityUtil.getEscalatedVisibility(element, (PsiElement)refExpr, attributeList.getAccessType(), options);
        fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, visibility, null));
        if (DialectDetector.isJavaScriptFamily((PsiElement)element) && visibility == JSAttributeList.AccessType.PROTECTED) {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PUBLIC, null));
        }
    }

    protected static void addCreateParameterFix(PsiElement parentElement, List<LocalQuickFix> fixes, String referencedName) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parentElement, JSFunction.class) != null) {
            fixes.add(JSFixFactory.getInstance().createJSParameterIntentionAction(referencedName));
        }
    }

    private static boolean isFunctionExpectedType(@NotNull JSReferenceExpression node) {
        JSType type;
        JSType valuableType;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(23);
        }
        return (valuableType = JSTypeUtils.getValuableType(type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node, JSExpectedTypeKind.EXPECTED))) != null && !JSTypeCastUtil.isAlwaysAssignableType(valuableType, (PsiElement)node) && JSTypeUtils.hasFunctionType(valuableType, false, (PsiElement)node);
    }

    protected static LocalQuickFix createClassOrInterfaceFix(JSReferenceExpression referenceExpression, boolean isInterface) {
        return JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)referenceExpression, isInterface, null, null);
    }

    private static boolean isPossibleMethodCallWithoutThis(@NotNull JSReferenceExpression methodExpression) {
        if (methodExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(24);
        }
        if (methodExpression.getQualifier() != null) {
            return false;
        }
        JSClass context = JSResolveUtil.getClassOfContext((PsiElement)methodExpression);
        if (context == null) {
            return false;
        }
        return context.findFunctionByName(methodExpression.getReferenceName()) != null;
    }

    private static LocalQuickFix createClassFromNewFix(JSReferenceExpression referenceExpression, JSArgumentList argumentList, JSType expectedType) {
        return JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)referenceExpression, false, argumentList, expectedType);
    }

    private static LocalQuickFix renameReferenceFix() {
        return JSFixFactory.getInstance().renameReferenceFix();
    }

    private static boolean canHaveCreateFromUsage(JSExpression qualifier) {
        JSExpression innerExpression;
        if (qualifier instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)qualifier).getInnerExpression()) instanceof JSBinaryExpression && JSTokenTypes.AS_KEYWORD == ((JSBinaryExpression)innerExpression).getOperationSign()) {
            return true;
        }
        return qualifier == null || qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier instanceof JSNewExpression || qualifier instanceof JSCallExpression && (DialectDetector.isActionScript((PsiElement)qualifier) || DialectDetector.isTypeScript((PsiElement)qualifier)) || AnalysisUtils.isLHSExpression(qualifier);
    }

    public static LocalQuickFix[] collectCreateFromUsageFixesForImportExport(ES6ImportExportDeclarationPart importExportPart) {
        PsiElement file2 = ES6PsiUtil.computeFromFileForImportExport((PsiElement)importExportPart);
        if (JSReferenceChecker.isInapplicableFile(file2)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix createClassFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)importExportPart, false, null, null);
        LocalQuickFix createInterfaceFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)importExportPart, true, null, null);
        FixAndIntentionAction createVariableFix = (FixAndIntentionAction)JSFixFactory.getInstance().createJSVariableIntentionAction(JSReferenceChecker.getNameToCreate(importExportPart), true, false, true);
        createVariableFix.registerElementRefForFix((PsiElement)importExportPart, null);
        FixAndIntentionAction createFunctionFix = (FixAndIntentionAction)JSFixFactory.getInstance().createJSFunctionIntentionAction(JSReferenceChecker.getNameToCreate(importExportPart), true, true);
        createFunctionFix.registerElementRefForFix((PsiElement)importExportPart, null);
        return new LocalQuickFix[]{createClassFix, createInterfaceFix, createVariableFix, createFunctionFix};
    }

    private static boolean isInapplicableFile(@Nullable PsiElement file2) {
        if (file2 == null) {
            return true;
        }
        PsiFile file1 = file2.getContainingFile();
        if (file1 == null) {
            return true;
        }
        VirtualFile virtualFile = file1.getVirtualFile();
        return virtualFile == null || JSLibraryUtil.isProbableLibraryFile(virtualFile);
    }

    public static String getNameToCreate(ES6ImportExportDeclarationPart importExportPart) {
        if (importExportPart instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)importExportPart).getReferenceName();
        }
        return importExportPart.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lExpr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRefExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyUnresolvedErrorMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addSurroundWithTypeGuardFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addCreateFromUsageFixesForCall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addFunctionFixes";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnresolvedReference";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isErrorReported";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReadWriteAccess";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentToConst";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isConst";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstAssignable";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionExpectedType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isPossibleMethodCallWithoutThis";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

