/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JSReferenceInspectionVisitor
extends JSElementVisitor {
    @NotNull
    protected final JSReferenceInspectionProblemReporter myReporter;

    public JSReferenceInspectionVisitor(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    protected boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceInspectionVisitor.$$$reportNull$$$0(1);
        }
        return !DialectDetector.isTypeScript(element);
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkRefExpression(node);
    }

    public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ES6ExportDeclaration declaration = node.getDeclaration();
        if (declaration != null && declaration.getFromClause() == null) {
            ResolveResult result2;
            ResolveResult[] results = node.multiResolve(false);
            if (results.length == 0) {
                this.myReporter.reportUnresolvedVariableError((PsiElement)node, null, XmlHighlightVisitor.getErrorDescription((PsiReference)node), ContainerUtil.newArrayList((Object[])JSReferenceChecker.collectCreateFromUsageFixesForImportExport((ES6ImportExportDeclarationPart)node)));
            } else if (results.length == 1 && !(result2 = results[0]).isValidResult()) {
                String key;
                String message = null;
                if (result2 instanceof JSResolveResult && (key = ((JSResolveResult)result2).getResolveProblemKey()) != null) {
                    message = JSBundle.message((String)key, (Object[])new Object[0]);
                }
                String s = message != null ? message : XmlHighlightVisitor.getErrorDescription((PsiReference)node);
                this.myReporter.reportUnresolvedVariableError((PsiElement)node, null, s, null);
            }
        }
    }

    public void visitES6TaggedTemplateExpression(ES6TaggedTemplateExpression expression) {
        if (!this.isAcceptable((PsiElement)expression)) {
            return;
        }
        JSExpression tag = expression.getTag();
        if (tag instanceof JSReferenceExpression) {
            JSAnalysisHandlersFactory.forElement((PsiElement)expression).getReferenceChecker(this.myReporter).checkCallReferences((JSReferenceExpression)tag, false);
        }
    }

    public void visitJSCallExpression(JSCallExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSExpression methodExpression = node.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkCallReferences((JSReferenceExpression)methodExpression, node instanceof JSNewExpression);
        } else if (methodExpression instanceof JSNewExpression) {
            JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter).checkNewExpressionInsideCallReferences(methodExpression);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

