/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSTypeChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;

    public JSTypeChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSTypeChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public final void registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.myReporter.registerProblem(place, message, highlightType, fixes);
    }

    public final void checkExpressionIsAssignableToType(@Nullable JSExpression expr, @Nullable String type, @NotNull String problemKey, @Nullable PsiElement elementToChangeTypeOf, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(1);
        }
        if ("*".equals(type) || type == null || expr == null) {
            return;
        }
        this.checkExpressionIsAssignableToType(expr, JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)expr)), problemKey, elementToChangeTypeOf, widenLiteralTypes);
    }

    public final void checkExpressionIsAssignableToType(@Nullable JSExpression expr, @Nullable JSType jsType, @NotNull String problemKey, @Nullable PsiElement elementToChangeTypeOf, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(2);
        }
        ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)expr);
        this.checkExpressionIsAssignableToType(expr, jsType, null, problemKey, elementToChangeTypeOf, context, widenLiteralTypes);
    }

    public boolean checkExpressionIsAssignableToType(@Nullable JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable PsiElement elementToChangeTypeOf, @Nullable ProcessingContext context, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(3);
        }
        if (this.canSkipTypeChecking(expr, jsType)) {
            return true;
        }
        JSType expressionJSType = this.getExpressionTypeForChecking(expr, widenLiteralTypes);
        return this.checkExpressionIsAssignableToType(expr, jsType, typeOwner, problemKey, elementToChangeTypeOf, context, expressionJSType);
    }

    public boolean checkExpressionIsAssignableToType(JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable PsiElement elementToChangeTypeOf, @Nullable ProcessingContext context, @Nullable JSType expressionJSType) {
        PsiElement typeOfTarget;
        String typeOfImmediateTarget;
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(4);
        }
        if (expressionJSType == null) {
            return true;
        }
        if (this.skipByExpressionType(expr, expressionJSType)) {
            return true;
        }
        PsiFile containingFile = expr.getContainingFile();
        boolean typeScript = DialectDetector.isTypeScript((PsiElement)containingFile);
        if (!typeScript && expressionJSType instanceof JSNamedType && ((JSNamedType)expressionJSType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        if (!expressionJSType.getSource().isStrict() && !DialectDetector.isActionScript((PsiElement)containingFile)) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile(containingFile);
        if (JSResolveUtil.isAssignableJSType(jsType, expressionJSType, context)) {
            boolean ecma;
            boolean bl = ecma = holder != null && holder.isECMA4;
            if (ecma && jsType != null) {
                String expressionType = expressionJSType.getResolvedTypeText();
                if (ValidateTypesUtil.checkIfNullIsAssignedToNumeric(expr, jsType.getTypeText(), expressionType)) {
                    this.registerExpressionNotAssignableToType(expr, typeOwner, JSBundle.message((String)"javascript.expression.type.implicitly.coerced.to.unrelated.type", (Object[])new Object[]{jsType.getResolvedTypeText(), expressionType}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return false;
                }
            }
            return true;
        }
        PsiElement expressionTypeSource = expressionJSType.getSource().getSourceElement();
        if (expressionTypeSource instanceof JSObjectLiteralExpression && !(expr.getParent() instanceof JSArgumentList) && !(expr.getParent() instanceof JSReturnStatement) && !(expr.getParent() instanceof JSFunctionExpression) && ((JSObjectLiteralExpression)expressionTypeSource).getProperties().length == 0 && JSTypeUtils.getValuableType(jsType) instanceof JSRecordType) {
            return true;
        }
        JSExpression exprToCheckForProxy = expr;
        if (exprToCheckForProxy instanceof JSCallExpression) {
            exprToCheckForProxy = ((JSCallExpression)exprToCheckForProxy).getMethodExpression();
            if (expr instanceof JSNewExpression && exprToCheckForProxy instanceof JSArrayLiteralExpression) {
                exprToCheckForProxy = null;
            }
        }
        if (exprToCheckForProxy instanceof JSReferenceExpression) {
            exprToCheckForProxy = ((JSReferenceExpression)exprToCheckForProxy).getQualifier();
        }
        if (exprToCheckForProxy != null && !(exprToCheckForProxy instanceof JSLiteralExpression) && (typeOfImmediateTarget = JSResolveUtil.getQualifiedExpressionType(exprToCheckForProxy, containingFile)) != null && (typeOfTarget = JSResolveUtil.findType(typeOfImmediateTarget, (PsiElement)exprToCheckForProxy, true)) instanceof JSClass) {
            if ("XML".equals(typeOfImmediateTarget) || "XMLList".equals(typeOfImmediateTarget) || DialectDetector.isJavaScript((PsiElement)containingFile) && typeOfTarget instanceof XmlBackedJSClass && expr instanceof JSThisExpression) {
                return true;
            }
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            PsiElement parentClass = resolver.findClassByQName("flash.utils.Proxy", typeOfTarget.getResolveScope());
            if (parentClass instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)typeOfTarget, (JSClass)parentClass, false)) {
                return true;
            }
        }
        String message = JSTypeChecker.buildAssignableErrorMessage(expr.getProject(), jsType, expressionJSType, holder, problemKey, context);
        Collection<LocalQuickFix> fixes = JSTypeChecker.getFixes(expr, jsType, elementToChangeTypeOf, containingFile, expressionJSType, context, holder);
        this.registerExpressionNotAssignableToType(expr, typeOwner, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)expr), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        return false;
    }

    protected boolean skipByExpressionType(@NotNull JSExpression expr, @Nullable JSType expressionJSType) {
        if (expr == null) {
            JSTypeChecker.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected void registerExpressionNotAssignableToType(JSExpression expr, @Nullable PsiElement typeOwner, String message, ProblemHighlightType problemHighlightType, LocalQuickFix ... fixes) {
        this.registerProblem((PsiElement)expr, message, problemHighlightType, fixes);
    }

    @Nullable
    private JSType getExpressionTypeForChecking(@Nullable JSExpression expr, boolean widenLiteralTypes) {
        JSType expressionJSType = this.getExpressionType(expr);
        if (expr != null && widenLiteralTypes) {
            JSType contextual = JSDialectSpecificHandlersFactory.findExpectedType(expr, JSExpectedTypeKind.CONTEXTUAL);
            return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(expressionJSType, contextual);
        }
        return expressionJSType;
    }

    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(expr);
        return JSCompositeTypeImpl.optimizeTypeIfComposite(evaluatedType);
    }

    protected boolean canSkipTypeChecking(JSExpression expr, @Nullable JSType jsType) {
        if (jsType == null || expr == null || jsType instanceof JSAnyType) {
            return true;
        }
        if (jsType instanceof JSNamedType && ((JSNamedType)jsType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        return !jsType.getSource().isEcma() && !jsType.getSource().isStrict() && !JSTypeUtils.hasFunctionType(jsType, false, (PsiElement)expr);
    }

    public void checkIfProperTypeReference(JSExpression rOperand) {
    }

    @NotNull
    private static Collection<LocalQuickFix> getFixes(JSExpression expr, @NotNull JSType declaredJSType, @Nullable PsiElement elementToChangeTypeOf, PsiFile containingFile, @NotNull JSType expressionJSType, ProcessingContext context, @Nullable DialectOptionHolder holder) {
        boolean hasTypes;
        if (declaredJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(6);
        }
        if (expressionJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(7);
        }
        if (expr instanceof JSSpreadExpression) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeChecker.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String expressionType = JSTypeChecker.formatTypeForFix(expressionJSType, holder);
        String declaredTypeText = JSTypeChecker.formatTypeForFix(declaredJSType, holder);
        if (holder != null && (holder.isTypeScript && declaredJSType instanceof JSNamedType || holder.isECMA4)) {
            LocalQuickFix insertCastFix = ValidateTypesUtil.jsInsertCastFix(declaredTypeText, holder);
            if (holder.isTypeScript) {
                if (declaredJSType.isDirectlyAssignableType(expressionJSType, context) || expressionJSType.isDirectlyAssignableType(declaredJSType, context)) {
                    fixes.add(insertCastFix);
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, TypeGuardSurroundKind.IfStatement, null, false, true));
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, TypeGuardSurroundKind.Ternary, null, false, true));
                } else if (declaredJSType instanceof JSPrimitiveType && !(declaredJSType instanceof JSLiteralType) && expressionJSType instanceof JSPrimitiveType) {
                    fixes.add(JSFixFactory.getInstance().jsInsertPrimitiveWrapperFix(declaredTypeText));
                }
                if (expressionJSType instanceof JSCompositeTypeImpl) {
                    List<JSType> types = ((JSCompositeTypeImpl)expressionJSType).getTypes();
                    boolean hasNullOrUndefined = false;
                    boolean hasOurType = false;
                    boolean hasOtherTypes = false;
                    for (JSType part : types) {
                        if (part.isEquivalentTo(declaredJSType, null, true)) {
                            hasOurType = true;
                            continue;
                        }
                        if (part instanceof JSNullType || part instanceof JSUndefinedType) {
                            hasNullOrUndefined = true;
                            continue;
                        }
                        hasOtherTypes = true;
                    }
                    if (hasNullOrUndefined && hasOurType && !hasOtherTypes) {
                        fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, new JSNullType(expressionJSType.getSource()), TypeGuardSurroundKind.IfStatement, null, true, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(Collections.singletonList(declaredJSType))));
                    }
                }
            } else {
                fixes.add(insertCastFix);
            }
        }
        if (holder != null && holder.isTypeScript && expr instanceof JSObjectLiteralExpression && !(declaredJSType instanceof JSPrimitiveType)) {
            fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, declaredJSType));
        }
        ContainerUtil.addIfNotNull(fixes, (Object)ValidateTypesUtil.tryCreateInheritanceFix(declaredTypeText, expressionType, (PsiElement)expr));
        boolean bl = hasTypes = holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
        if (elementToChangeTypeOf instanceof JSVariable) {
            PsiComment docComment = null;
            if (elementToChangeTypeOf instanceof JSParameter) {
                JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)elementToChangeTypeOf, JSFunction.class);
                if (function != null) {
                    if (hasTypes) {
                        Map parameterTypes = ContainerUtil.newHashMap((Pair)Pair.create((Object)((JSParameter)elementToChangeTypeOf).getName(), (Object)expressionType), (Pair[])new Pair[0]);
                        fixes.add(JSFixFactory.getInstance().changeSignatureFix(function, parameterTypes, null));
                    } else if (elementToChangeTypeOf.getContainingFile() == containingFile && (docComment = JSDocumentationUtils.findDocComment(elementToChangeTypeOf)) == null) {
                        docComment = JSDocumentationUtils.findFunctionComment(function);
                    }
                }
            } else if (hasTypes) {
                JSVariable var = (JSVariable)elementToChangeTypeOf;
                if (!(expressionJSType instanceof JSVoidType)) {
                    fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)var, expressionType, "javascript.fix.change.type"));
                }
            } else if (elementToChangeTypeOf.getContainingFile() == containingFile) {
                docComment = JSDocumentationUtils.findDocComment(elementToChangeTypeOf);
            }
            if (!hasTypes && declaredJSType.getSource().isStrict() && docComment != null) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)((JSVariable)elementToChangeTypeOf), (PsiElement)docComment, expressionJSType));
            }
        } else if (elementToChangeTypeOf instanceof JSFunction) {
            JSFunction function = (JSFunction)elementToChangeTypeOf;
            JSType typeToUse = TypeFromUsageDetector.getReturnTypeInContext(expressionJSType, function);
            if (hasTypes) {
                if (JSInheritanceUtil.participatesInHierarchy(function)) {
                    fixes.add(JSFixFactory.getInstance().changeSignatureFix(function, Collections.emptyMap(), expressionType));
                } else {
                    fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)function, JSTypeChecker.formatTypeForFix(typeToUse, holder), "javascript.fix.set.method.return.type"));
                }
            } else {
                PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)function);
                if (comment != null) {
                    fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)function, (PsiElement)comment, typeToUse));
                }
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            JSTypeChecker.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public void checkExpressionIsAssignableToVariable(JSVariable p, JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        this.checkExpressionIsAssignableToType(expr, p.getType(), problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null), true);
    }

    public void checkTypesInReturnStatement(@NotNull JSElement returnStatementOrShorthandArrowFunctionExpression) {
        JSType actualType;
        JSExpression expression;
        JSType iterableComponentType;
        JSFunction fun;
        if (returnStatementOrShorthandArrowFunctionExpression == null) {
            JSTypeChecker.$$$reportNull$$$0(10);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSFunction.class)) == null) {
            return;
        }
        JSType returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)fun);
        if (returnType == null) {
            return;
        }
        if (ES6PsiUtil.isGeneratorContext(fun) && (iterableComponentType = JSTypeUtils.getIterableComponentType(returnType)) != null) {
            returnType = iterableComponentType;
        }
        if (ES6PsiUtil.isAsyncContext(fun)) {
            returnType = this.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        if (returnStatementOrShorthandArrowFunctionExpression instanceof JSReturnStatement) {
            expression = ((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression).getExpression();
            if (expression == null) {
                this.checkEmptyReturnStatement((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression, fun, returnType);
                return;
            }
        } else {
            expression = (JSExpression)returnStatementOrShorthandArrowFunctionExpression;
        }
        if (returnType instanceof JSVoidType && (actualType = JSResolveUtil.getExpressionJSType(expression)) != null && !(actualType instanceof JSVoidType)) {
            this.registerProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSBundle.message((String)"javascript.cannot.return.expression.from.function.with.void.result.type", (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression), ValidateTypesUtil.removeASTNodeFix((PsiElement)expression, "javascript.cannot.return.expression.from.function.with.void.result.type.fix"), ValidateTypesUtil.changeTypeFix((JSNamedElement)fun, actualType.getTypeText(JSType.TypeTextFormat.CODE), "javascript.fix.set.method.return.type"));
            return;
        }
        this.checkExpressionIsAssignableToType(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    private void checkEmptyReturnStatement(@NotNull JSReturnStatement node, @NotNull JSFunction function, @NotNull JSType returnType) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(11);
        }
        if (function == null) {
            JSTypeChecker.$$$reportNull$$$0(12);
        }
        if (returnType == null) {
            JSTypeChecker.$$$reportNull$$$0(13);
        }
        if (!ValidateTypesUtil.emptyReturnIsAcceptable(function, returnType)) {
            String message = JSBundle.message((String)"javascript.validation.message.return.value.of.type.is.required", (Object[])new Object[]{returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
            ProblemHighlightType highlightType = ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node);
            this.registerProblem((PsiElement)node, message, highlightType, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected JSType getAsyncFunctionReturnTypeForValidation(@NotNull JSFunction function, @NotNull JSType declaredType) {
        if (function == null) {
            JSTypeChecker.$$$reportNull$$$0(14);
        }
        if (declaredType == null) {
            JSTypeChecker.$$$reportNull$$$0(15);
        }
        declaredType = JSTypeUtils.getValuableType(declaredType);
        JSType componentType = JSTypeUtils.getPromiseComponentTypeOrNull(declaredType);
        JSTypeSource typeSource = declaredType.getSource();
        if (componentType != null) {
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(typeSource, declaredType, componentType);
            if (jSCompositeTypeImpl == null) {
                JSTypeChecker.$$$reportNull$$$0(16);
            }
            return jSCompositeTypeImpl;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(typeSource, declaredType, JSAnyType.get((PsiElement)function, typeSource.isStrict()));
        if (jSCompositeTypeImpl == null) {
            JSTypeChecker.$$$reportNull$$$0(17);
        }
        return jSCompositeTypeImpl;
    }

    @NotNull
    private static String formatTypeForFix(@NotNull JSType jsType, @Nullable DialectOptionHolder holder) {
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(18);
        }
        String string = holder != null && holder.isECMA4 ? jsType.getResolvedTypeText() : jsType.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            JSTypeChecker.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void checkTypesInForIn(@NotNull JSForInStatement node) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(20);
        }
    }

    @NotNull
    public static String buildAssignableErrorMessage(@NotNull Project project, @NotNull JSType jsType, @NotNull JSType expressionType, @Nullable DialectOptionHolder holder, @NotNull String problemKey, @Nullable ProcessingContext context) {
        if (project == null) {
            JSTypeChecker.$$$reportNull$$$0(21);
        }
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(22);
        }
        if (expressionType == null) {
            JSTypeChecker.$$$reportNull$$$0(23);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(24);
        }
        String message = JSBundle.message((String)problemKey, (Object[])new Object[]{jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
        if (holder == null || holder.isECMA4 || holder.isTypeScript && TypeScriptCompilerSettings.getSettings(project).useService() || jsType.isJavaScript() && expressionType.isJavaScript()) {
            String string = message;
            if (string == null) {
                JSTypeChecker.$$$reportNull$$$0(25);
            }
            return string;
        }
        ProcessingContext newContext = context == null ? new ProcessingContext() : JSTypeBaseImpl.copyProcessingContextWithoutComparingCache(context);
        JSTypeAssignableErrorMessage.startTracking((ProcessingContext)newContext);
        newContext.put(JSTypeComparingContextService.TYPE_COMPARATOR, (Object)new JSTypeComparingCache());
        assert (!JSResolveUtil.isAssignableJSType(jsType, expressionType, newContext));
        List texts = (List)newContext.get(JSTypeAssignableErrorMessage.NOT_ASSIGNABLE_CHAIN_KEY);
        if (texts == null || texts.size() <= 1) {
            String string = message;
            if (string == null) {
                JSTypeChecker.$$$reportNull$$$0(26);
            }
            return string;
        }
        int limit = 3;
        Stream<String> distinct = ContainerUtil.reverse((List)texts).stream().skip(1L).limit(limit).map(el -> el.getText()).distinct();
        StringBuilder result2 = new StringBuilder();
        result2.append("<html>");
        result2.append(message);
        StringBuilder separator = new StringBuilder("<br>");
        if (texts.size() > limit + 1) {
            result2.append((CharSequence)separator);
            result2.append("...");
        }
        String spaces = "&nbsp;&nbsp;";
        distinct.forEach(el -> {
            separator.append(spaces);
            result2.append((CharSequence)separator);
            result2.append(XmlUtil.escape((String)el));
        });
        result2.append("</html>");
        String string = result2.toString();
        if (string == null) {
            JSTypeChecker.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredJSType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionJSType";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatementOrShorthandArrowFunctionExpression";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeForFix";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAssignableErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionIsAssignableToType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "skipByExpressionType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInReturnStatement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkEmptyReturnStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeForFix";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInForIn";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildAssignableErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

