/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class TypeScriptReferenceInspectionVisitor
extends JSReferenceInspectionVisitor {
    public TypeScriptReferenceInspectionVisitor(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            TypeScriptReferenceInspectionVisitor.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Override
    protected boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptReferenceInspectionVisitor.$$$reportNull$$$0(1);
        }
        return DialectDetector.isTypeScript(element);
    }

    public void visitTypeScriptEntityName(TypeScriptEntityName entityName) {
        JSAnalysisHandlersFactory.forElement((PsiElement)entityName).getReferenceChecker(this.myReporter).checkRefExpression((JSReferenceExpression)entityName);
        super.visitTypeScriptEntityName(entityName);
    }

    public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
        if (node == null) {
            TypeScriptReferenceInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        if (node instanceof JSXmlLiteralExpression) {
            this.processXmlLiteralExpression((JSXmlLiteralExpression)node);
        }
        super.visitJSLiteralExpression(node);
    }

    private void processXmlLiteralExpression(JSXmlLiteralExpression expression) {
        ASTNode nameNode;
        if (!StringUtil.isCapitalized((String)expression.getName())) {
            return;
        }
        boolean isResolved = JSXHarmonyLanguageDialect.areReferencesResolvedOrEmpty(expression);
        if (!isResolved && (nameNode = expression.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME)) != null) {
            PsiElement psi = nameNode.getPsi();
            this.myReporter.reportUnresolvedVariableError(psi, ProblemHighlightType.WEAK_WARNING, JSBundle.message((String)"typescript.validation.message.unresolved.component", (Object[])new Object[0]), JSFixFactory.getInstance().typeScriptAddImportStatementFix(expression.getName(), psi));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptReferenceInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSLiteralExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

