/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.MarkerPsiElementPointer;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateMembersFix<T extends JSElement> {
    private final Set<T> elementsToProcess = new LinkedHashSet<T>();
    @Nullable
    protected final PsiElement myJsClass;
    protected PsiElement anchor;

    public BaseCreateMembersFix(@Nullable PsiElement jsClass) {
        this.myJsClass = jsClass;
    }

    public void beforeInvoke(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(0);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(1);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        this.evalAnchor(editor, file2);
        MultiMap types = MultiMap.createSet();
        Set<T> elementsToProcess = this.getElementsToProcess();
        for (JSElement element : elementsToProcess) {
            this.fixName(element);
        }
        for (JSElement e : elementsToProcess) {
            for (String type : this.getTypes(e)) {
                String resolved = JSImportHandlingUtil.resolveTypeName(type, (PsiElement)e);
                if (type.indexOf(46) == -1 && resolved.equals(type)) continue;
                types.putValue((Object)JSResolveUtil.getShortTypeName(type, false), (Object)resolved);
            }
        }
        this.processElements(project, (MultiMap<String, String>)types, elementsToProcess);
    }

    protected void processElements(Project project, MultiMap<String, String> types, Set<T> elementsToProcess) {
        ArrayList<MarkerPsiElementPointer> elementPointers = new ArrayList<MarkerPsiElementPointer>();
        for (JSElement element : elementsToProcess) {
            elementPointers.add(new MarkerPsiElementPointer((PsiElement)element));
        }
        elementsToProcess.clear();
        for (MarkerPsiElementPointer e : elementPointers) {
            JSElement element = (JSElement)e.getElement();
            this.anchor = this.doAddOneMethod(project, this.buildFunctionText(element, types), this.anchor);
            elementsToProcess.add(element);
        }
    }

    protected void fixName(T t) {
    }

    protected void evalAnchor(@Nullable Editor editor, PsiFile file2) {
        PsiElement parent;
        PsiElement at;
        this.anchor = null;
        if (editor == null) {
            return;
        }
        if (file2 instanceof XmlFile && this.myJsClass instanceof XmlBackedJSClassImpl) {
            PsiElement element;
            file2 = ((XmlBackedJSClassImpl)this.myJsClass).createOrGetFirstScriptTag();
            editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file2);
            PsiElement lastChild = file2.getLastChild();
            PsiElement psiElement = element = lastChild == null ? null : lastChild.getPrevSibling();
            if (element != null) {
                this.anchor = element;
                return;
            }
        }
        if ((at = file2.findElementAt(editor.getCaretModel().getOffset())) != null && ((parent = at.getParent()) == this.myJsClass || parent instanceof JSFile && this.myJsClass != null && this.myJsClass.getParent() != null && parent.getContext() != null && this.myJsClass.getParent().getContainingFile() == parent.getContext().getContainingFile())) {
            ASTNode atNode = at.getNode();
            if (atNode.getElementType() == JSTokenTypes.RBRACE) {
                return;
            }
            for (ASTNode node = atNode; node != null; node = node.getTreeNext()) {
                if (node.getElementType() != JSTokenTypes.LBRACE) continue;
                return;
            }
            this.anchor = at;
        }
        if (this.myJsClass instanceof JSClass && at != null && at.getParent() == ((JSClass)this.myJsClass).getNameIdentifier()) {
            PsiElement[] classMembers = ((StubBasedPsiElementBase)this.myJsClass).getStubOrPsiChildren(TypeScriptClassImpl.MEMBERS, JSElement.ARRAY_FACTORY);
            if (classMembers.length > 0) {
                this.anchor = classMembers[classMembers.length - 1];
            }
            if (this.anchor == null) {
                this.anchor = this.myJsClass.getNode().findChildByType(JSTokenTypes.LBRACE).getPsi();
            }
        }
    }

    public PsiElement doAddOneMethod(Project project, String functionText, PsiElement anchor) throws IncorrectOperationException {
        assert (this.myJsClass != null);
        return BaseCreateMembersFix.addOneMethodToClass(this.myJsClass, project, functionText, anchor);
    }

    @Nullable
    public static PsiElement addOneMethodToClass(@NotNull PsiElement clazz, Project project, @Nullable String functionText, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (clazz == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(2);
        }
        if (functionText != null && functionText.length() > 0) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(clazz);
            PsiElement element = JSChangeUtil.createClassMemberFromText(project, functionText, dialect).getPsi();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            if (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (anchor != null && anchor.isValid() && (!(anchor instanceof PsiWhiteSpace) || !JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(dialect) || BaseCreateMembersFix.isNotSurroundedCDATA(anchor))) {
                PsiElement newAnchor = anchor.getParent().addAfter(element, anchor);
                codeStyleManager.reformatNewlyAddedElement(newAnchor.getParent().getNode(), newAnchor.getNode());
                return newAnchor;
            }
            anchor = BaseCreateMembersFix.addMethodToClassWithoutAnchor(clazz, dialect, element, codeStyleManager);
        }
        return anchor;
    }

    public static PsiElement addMethodToClassWithoutAnchor(@NotNull PsiElement jsClass, @Nullable JSLanguageDialect dialect, @NotNull PsiElement element, @Nullable CodeStyleManager codeStyleManager) {
        PsiElement anchor;
        if (jsClass == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(4);
        }
        if (!JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(dialect)) {
            ASTNode possibleAnchor = jsClass.getNode().findChildByType(JSTokenTypes.LBRACE);
            assert (possibleAnchor != null);
            anchor = jsClass.addAfter(element, possibleAnchor.getPsi());
            if (codeStyleManager != null) {
                PsiElement parent = anchor.getParent();
                codeStyleManager.reformatNewlyAddedElement(parent.getNode(), anchor.getNode());
            }
        } else {
            anchor = jsClass.add(element);
        }
        return anchor;
    }

    private static boolean isNotSurroundedCDATA(PsiElement anchor) {
        String anchorText = anchor.getText();
        return !anchorText.contains("<![CDATA[") && !anchorText.contains("]]>");
    }

    private Collection<String> getTypes(T fun) {
        if (fun instanceof JSFunction) {
            return BaseCreateMembersFix.getFunctionTypes((JSFunction)fun);
        }
        if (fun instanceof JSVariable) {
            ArrayList<String> result2 = new ArrayList<String>();
            JSType type = ((JSVariable)fun).getType();
            if (type != null) {
                result2.add(type.getTypeText(JSType.TypeTextFormat.CODE));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    public static Collection<String> getFunctionTypes(JSFunction function) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (function.getReturnType() != null) {
            result2.add(function.getReturnType().getTypeText(JSType.TypeTextFormat.CODE));
        }
        for (JSParameterListElement param : function.getParameterList().getParameters()) {
            JSType type = param.getType();
            if (type == null) continue;
            result2.add(type.getTypeText(JSType.TypeTextFormat.CODE));
        }
        return result2;
    }

    public String buildFunctionText(T fun, @Nullable MultiMap<String, String> types) {
        assert (this.myJsClass != null);
        String attrText = this.getAttributeListText(fun, types);
        String typeString = null;
        JSParameterList parameterList = null;
        JSType type = null;
        if (fun instanceof JSVariable || fun instanceof JSFunction) {
            JSFunction function = fun instanceof JSFunction ? (JSFunction)fun : null;
            JSVariable var = fun instanceof JSVariable ? (JSVariable)fun : null;
            parameterList = function != null ? function.getParameterList() : null;
            JSType jSType = type = function != null ? function.getReturnType() : var.getType();
        }
        if (type != null) {
            typeString = this.getTypeString(type, fun, types);
        } else if (this.shouldHandleNoTypeAsAnyType()) {
            typeString = JSClassUtils.getAnyTypeString(this.myJsClass, false);
        }
        String functionText = attrText;
        if (functionText.length() > 0) {
            functionText = functionText + " ";
        }
        functionText = functionText + JSClassUtils.createClassFunctionName(this.buildFunctionKind(fun) + this.buildName(fun), this.myJsClass);
        functionText = functionText + this.buildParameterList(parameterList, fun, types);
        String string = typeString = typeString != null ? this.buildReturnType(typeString) : null;
        if (typeString != null) {
            functionText = functionText + ":" + typeString;
        }
        functionText = functionText + this.buildFunctionBodyText(typeString, parameterList, fun);
        return functionText;
    }

    protected String getAttributeListText(T fun, @Nullable MultiMap<String, String> types) {
        assert (this.myJsClass != null);
        String attrText = "";
        if (fun instanceof JSAttributeListOwner) {
            String namespace;
            JSAttributeList attributeList = ((JSAttributeListOwner)fun).getAttributeList();
            JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(attributeList, fun.getProject());
            String string = namespace = attributeList != null ? JSResolveUtil.getNamespaceValue(attributeList) : null;
            if (namespace != null) {
                String namespaceId = BaseCreateMembersFix.calcNamespaceId(attributeList, namespace, this.anchor != null ? this.anchor : this.myJsClass);
                namespaceId = this.importType(namespaceId, fun, types);
                attributeListWrapper.overrideNamespace(namespaceId);
            }
            this.adjustAttributeList(attributeListWrapper, fun);
            attrText = attributeListWrapper.computeText((JSAttributeListOwner)fun, DialectDetector.dialectOfElement(this.myJsClass));
        }
        return attrText;
    }

    @Nullable
    protected static String calcNamespaceId(@NotNull JSAttributeList attributeList, final String namespace, @NotNull PsiElement anchor) {
        if (attributeList == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(5);
        }
        if (anchor == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(6);
        }
        if (namespace == null) {
            return null;
        }
        Map<String, String> ns2Id = JSResolveUtil.calculateOpenNses(anchor);
        String namespaceId = ns2Id.get(namespace);
        if (namespaceId != null) {
            return namespaceId;
        }
        final GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)attributeList.getProject());
        final Ref namespaceVar = new Ref();
        JSPackageIndex.processElementsInScopeRecursive("", new JSPackageIndex.PackageQualifiedElementsProcessor(){

            @Override
            public boolean process(String qualifiedName, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                String initializerText;
                if (kind != JSPackageIndexInfo.Kind.VARIABLE) {
                    return true;
                }
                PsiElement classByQName = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(qualifiedName, searchScope);
                if (classByQName instanceof JSVariable && (initializerText = ((JSVariable)classByQName).getLiteralOrReferenceInitializerText()) != null && namespace.equals(StringUtil.stripQuotesAroundValue((String)initializerText))) {
                    namespaceVar.set((Object)((JSVariable)classByQName).getName());
                    return false;
                }
                return true;
            }
        }, searchScope, attributeList.getProject());
        namespaceId = (String)namespaceVar.get();
        if (namespaceId == null) {
            namespaceId = attributeList.getNamespace();
        }
        return namespaceId;
    }

    protected boolean shouldHandleNoTypeAsAnyType() {
        return false;
    }

    @NonNls
    protected String buildReturnType(String typeString) {
        return this.myJsClass != null && BaseCreateMembersFix.dialectSupportsTypes(this.myJsClass) ? typeString : null;
    }

    @Nullable
    protected String getTypeString(JSType type, T fun, @Nullable MultiMap<String, String> types) {
        if (type == null) {
            return null;
        }
        if (this.myJsClass == null || !BaseCreateMembersFix.dialectSupportsTypes(this.myJsClass)) {
            return null;
        }
        String typeString = null;
        if (DialectDetector.isActionScript(this.myJsClass)) {
            String resolvedTypeText = this.importType(type.getTypeText(JSType.TypeTextFormat.CODE), fun, types);
            if (!StringUtil.isEmpty((String)resolvedTypeText)) {
                typeString = resolvedTypeText;
            }
        } else {
            typeString = BaseCreateMembersFix.getProcessedType(type, this.myJsClass, fun);
        }
        return typeString;
    }

    @Nullable
    public static String getProcessedType(@Nullable JSType type, PsiElement surroundClass, PsiElement context) {
        if (type == null || !BaseCreateMembersFix.dialectSupportsTypes(surroundClass)) {
            return null;
        }
        String stringType = (type = BaseCreateMembersFix.fixGenericsByOwner(JSTypeUtils.getValuableType(type), surroundClass, context)).getTypeText(JSType.TypeTextFormat.CODE);
        if (TypeScriptUtil.hasAmbientExternalModuleInQName(stringType) && TypeScriptUtil.hasAmbientExternalModuleInQName(stringType = type.getTypeText())) {
            return null;
        }
        return stringType;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static JSType fixGenericsByOwner(@Nullable JSType type, @Nullable PsiElement surroundClassOrLiteral, @Nullable PsiElement context) {
        JSType expectedType;
        if (type == null) {
            return null;
        }
        if (surroundClassOrLiteral instanceof JSClass && JSTypeUtils.hasGenericParameter(type)) {
            type = TypeScriptUtil.applyGenericsToType(type, (JSClass)surroundClassOrLiteral, context instanceof JSClass ? (JSClass)context : JSResolveUtil.getClassOfContext(context));
        }
        if (surroundClassOrLiteral instanceof JSObjectLiteralExpression && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)surroundClassOrLiteral)) instanceof JSGenericTypeImpl) {
            JSResolvedTypeInfo info;
            TypeScriptTypeParameterListOwner owner;
            List<JSType> genericArgs = JSTypeUtils.getGenericTypeArguments(expectedType);
            JSType innerType = ((JSGenericTypeImpl)expectedType).getType();
            if (genericArgs != null && innerType instanceof JSResolvableType && (owner = (info = ((JSResolvableType)innerType).resolveType()).getDeclarationOfType(TypeScriptTypeParameterListOwner.class)) != null) {
                type = JSTypeUtils.applyGenericArguments(type, (JSTypeSubstitutor)new JSTypeSubstitutor.StringTypeSubstitutor(TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, genericArgs)));
            }
        }
        return type;
    }

    private static boolean dialectSupportsTypes(@NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (context == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(7);
        }
        return (holder = DialectDetector.dialectOfElement(context)) != null && holder.hasFeature(JSLanguageFeature.TYPES);
    }

    protected String importType(String s, T fun, @Nullable MultiMap<String, String> types) {
        if (s == null) {
            return null;
        }
        if (fun instanceof JSFunction || fun instanceof JSVariable) {
            Collection fullNames;
            String resolvedTypeName = JSImportHandlingUtil.resolveTypeName(s, fun);
            if (StringUtil.isEmpty((String)resolvedTypeName)) {
                return s;
            }
            boolean allowShorten = types == null ? true : (fullNames = types.get((Object)JSResolveUtil.getShortTypeName(s, false))).isEmpty() || fullNames.size() == 1 && ((String)fullNames.iterator().next()).equals(resolvedTypeName);
            Pair<String, PsiElement> importResult = ImportUtils.importAndShortenReference(resolvedTypeName, this.anchor != null ? this.anchor : this.myJsClass, true, allowShorten);
            String result2 = (String)importResult.first;
            if (this.anchor != null) {
                this.anchor = (PsiElement)importResult.second;
            }
            return JSResolveUtil.getQualifiedTypeName(result2);
        }
        return s;
    }

    protected String buildParameterList(JSParameterList parameterList, T fun, MultiMap<String, String> types) {
        if (parameterList != null) {
            boolean isTypeScriptFunction;
            StringBuilder signature = new StringBuilder();
            boolean isExpectedCodeTypeScript = this.myJsClass != null && DialectDetector.isTypeScript(this.myJsClass);
            boolean bl = isTypeScriptFunction = fun instanceof TypeScriptFunction && isExpectedCodeTypeScript;
            if (isTypeScriptFunction) {
                signature.append(TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics((TypeScriptFunction)fun, this.myJsClass));
            }
            signature.append('(');
            boolean firstParameter = true;
            for (JSParameterListElement param : parameterList.getParameters()) {
                JSExpression initializer;
                if (!firstParameter) {
                    signature.append(", ");
                }
                firstParameter = false;
                if (param.isRest()) {
                    signature.append("... ").append(param.getName());
                    continue;
                }
                JSType type = param.getType();
                String s = this.getTypeString(type, fun, types);
                signature.append(param.getName());
                if (isTypeScriptFunction && param.isOptional() && !param.hasInitializer()) {
                    signature.append("?");
                }
                if (!StringUtil.isEmpty((String)s)) {
                    signature.append(":").append(s);
                }
                if ((initializer = param.getInitializer()) == null) continue;
                signature.append(" = ").append(initializer.getText());
            }
            signature.append(")");
            return signature.toString();
        }
        return "()";
    }

    protected String buildName(T fun) {
        return fun instanceof JSNamedElementBase ? JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)fun, false) : null;
    }

    @NonNls
    protected String buildFunctionKind(T fun) {
        if (fun instanceof JSFunction) {
            JSFunction function = (JSFunction)fun;
            if (function.isGetProperty()) {
                return "get ";
            }
            if (function.isSetProperty()) {
                return "set ";
            }
        }
        return "";
    }

    @NonNls
    protected String buildFunctionBodyText(@NonNls String retType, JSParameterList parameterList, T func) {
        return " {}";
    }

    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, T function) {
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.NATIVE, false);
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, false);
    }

    public void addElementToProcess(T function) {
        this.elementsToProcess.add(function);
    }

    public Set<T> getElementsToProcess() {
        JSElement[] objects = this.elementsToProcess.toArray(JSElement.EMPTY_ARRAY);
        Comparator<JSElement> tComparator = Comparator.comparingInt(PsiElement::getTextOffset);
        int size = this.elementsToProcess.size();
        LinkedHashSet result2 = new LinkedHashSet(size);
        ArrayList<JSElement> objectsFromSameFile = new ArrayList<JSElement>();
        PsiFile containingFile = null;
        for (int i = 0; i < size; ++i) {
            JSElement object = objects[i];
            PsiFile currentContainingFile = object.getContainingFile();
            if (currentContainingFile != containingFile) {
                if (containingFile != null) {
                    Collections.sort(objectsFromSameFile, tComparator);
                    result2.addAll(objectsFromSameFile);
                    objectsFromSameFile.clear();
                }
                containingFile = currentContainingFile;
            }
            objectsFromSameFile.add(object);
        }
        Collections.sort(objectsFromSameFile, tComparator);
        result2.addAll(objectsFromSameFile);
        this.elementsToProcess.clear();
        this.elementsToProcess.addAll(result2);
        return this.elementsToProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/BaseCreateMembersFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeInvoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addOneMethodToClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addMethodToClassWithoutAnchor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "calcNamespaceId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "dialectSupportsTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

