/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.lang.typescript.refactoring.extractMethod.TypeScriptExtractFunctionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFunctionIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsMethod;
    private final boolean myIsModuleScope;
    private final String myFunctionName;
    private boolean myIsProperty;
    private static final String ourJSImplementedMethodBodyTemplate = "JavaScript Implemented Method Body.js";
    private static final String ATTRIBUTE_IS_ASSIGNMENT_TARGET = "IS_ASSIGNMENT_TARGET";
    private static final String ATTRIBUTE_IS_NEW_CALL = "IS_NEW_CALL";
    private static final String ATTRIBUTE_HAS_EXPECTED_TYPE = "HAS_EXPECTED_TYPE";

    public CreateJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope) {
        super(name, isMethod && !isModuleScope ? "javascript.create.method.intention.name" : "javascript.create.function.intention.name");
        this.myFunctionName = name;
        this.myIsMethod = isMethod;
        this.myIsModuleScope = isModuleScope;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file2, Editor editor) {
        this.applyFixWithScopeSelection(project, psiElement, file2, editor, ApplicationManager.getApplication().isUnitTestMode() ? (defaultSuggestedScope, scopeList, cb) -> cb.pass((Object)CreateJSFunctionIntentionAction.chooseIntroductionScopeForTest(psiElement, scopeList)) : new JSExtractFunctionHandler.ScopeSelectionPopup(editor));
    }

    public void applyFixWithScopeSelection(Project project, final PsiElement psiElement, PsiFile file2, Editor editor, JSScopeSelectionUI scopeSelectionUi) {
        if (psiElement == null) {
            return;
        }
        JSExtractFunctionHandler extractFunctionHandler = DialectDetector.isTypeScript(psiElement) ? new TypeScriptExtractFunctionHandler() : new JSExtractFunctionHandler();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)this.calculateAnchors((PsiElement)psiElement).first;
        if (CreateJSFunctionIntentionAction.getClassFromReferenceExpression(referenceExpression) != null) {
            this.doApplyFix(project, psiElement, file2, editor);
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)referenceExpression);
        List scopes = extractFunctionHandler.findBases(psiElement);
        if (dialect != null && JSClassUtils.isES6ClassImplementation(dialect) && referenceExpression.getQualifier() == null) {
            scopes = ContainerUtil.filter(scopes, scope -> scope.isClassContext() == this.myIsMethod);
        }
        final List finalScopes = scopes;
        final boolean isActionScript = dialect != null && dialect.isECMA4;
        JSSignatureContext context = new JSSignatureContext(){

            @Override
            public boolean isActionScript() {
                return isActionScript;
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            @NotNull
            public JSContext getJSContext() {
                JSContext jSContext = JSContext.UNKNOWN;
                if (jSContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jSContext;
            }

            @Override
            public PsiElement getAnchor() {
                return psiElement;
            }

            @Override
            @NotNull
            public List<JSExtractFunctionHandler.IntroductionScope> getIntroductionScopes() {
                List list = finalScopes;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getJSContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIntroductionScopes";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        Consumer callback = scope -> {
            if (scope.isClassContext()) {
                this.doApplyFix(project, psiElement, file2, editor);
            } else {
                this.myIsProperty = scope.getParent() instanceof JSObjectLiteralExpression;
                boolean placeAtScopeStart = JSDeclarationsAtScopeStartInspection.isEnabledForElement(psiElement);
                PsiElement anchor = JSUtils.findFunctionAnchor(scope.getParent(), psiElement, placeAtScopeStart);
                anchor = JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
                this.doApplyFix(project, psiElement, file2, editor, anchor, scope.getParent());
            }
        };
        extractFunctionHandler.chooseIntroductionScope(context, (Consumer<JSExtractFunctionHandler.IntroductionScope>)callback, scopeSelectionUi, this.myFunctionName);
    }

    private static JSExtractFunctionHandler.IntroductionScope chooseIntroductionScopeForTest(@NotNull PsiElement usageElement, @NotNull List<JSScopeSelectionUI.ScopePresentation> presentations) {
        List scopes;
        if (usageElement == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(0);
        }
        if (presentations == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(1);
        }
        if ((scopes = ContainerUtil.map(presentations, presentation -> presentation.getScope())).isEmpty()) {
            throw new RuntimeException("No available scopes");
        }
        if (scopes.size() == 1) {
            return (JSExtractFunctionHandler.IntroductionScope)scopes.get(0);
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, JSStatement.class, (boolean)false);
        if (statement == null) {
            throw new RuntimeException("Could not find statement from usage");
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (docComment instanceof JSDocComment) {
            String scopePresentation = docComment.getText().substring(3, docComment.getTextLength() - 2).trim();
            for (JSExtractFunctionHandler.IntroductionScope scope : scopes) {
                if (!scopePresentation.equals(scope.toString())) continue;
                return scope;
            }
            throw new RuntimeException("Scope with name " + scopePresentation + " not found");
        }
        return (JSExtractFunctionHandler.IntroductionScope)scopes.get(scopes.size() - 1);
    }

    @Nullable
    private static PsiElement getClassFromReferenceExpression(JSReferenceExpression referenceExpression) {
        if (referenceExpression == null || !JSClassUtils.canHaveClasses((PsiElement)referenceExpression)) {
            return null;
        }
        if (referenceExpression.getQualifier() != null) {
            return CreateJSFunctionIntentionAction.getType(referenceExpression.getQualifier(), referenceExpression.getContainingFile());
        }
        return null;
    }

    @Override
    protected void writeFunctionAndName(Template template, String createdMethodName, @NotNull PsiElement anchorParent, @Nullable PsiElement clazz, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(2);
        }
        if (this.myIsProperty && !this.myIsModuleScope) {
            createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            template.addTextSegment(createdMethodName);
            template.addTextSegment(": function ");
            return;
        }
        if (clazz != null) {
            if (createdMethodName.indexOf(46) != -1) {
                createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            }
            template.addTextSegment(JSClassUtils.createClassFunctionName(createdMethodName, anchorParent));
            return;
        }
        if (!this.myIsMethod || this.isExportWithoutFrom() || DialectDetector.isActionScript(anchorParent) || DialectDetector.isTypeScript(anchorParent) && referenceExpression != null && referenceExpression.getQualifier() == null) {
            template.addTextSegment("function ");
            template.addTextSegment(createdMethodName);
            return;
        }
        int indexOfDot = createdMethodName.lastIndexOf(46);
        if (referenceExpression == null || indexOfDot > 0 && (referenceExpression.getContainingFile() != anchorParent.getContainingFile() || this.myIsModuleScope)) {
            template.addTextSegment(this.isExportDefault() ? "export default function " : "export function ");
            template.addTextSegment(createdMethodName.substring(indexOfDot + 1));
            return;
        }
        if (indexOfDot == -1) {
            template.addTextSegment(JSChangeUtil.getVariablePrefix(anchorParent) + " ");
        }
        template.addTextSegment(createdMethodName);
        template.addTextSegment(" = function ");
    }

    @Override
    protected void addSemicolonSegment(Template template, PsiElement context) {
        if (this.myIsProperty) {
            template.addTextSegment(",");
        } else {
            super.addSemicolonSegment(template, context);
        }
    }

    @Override
    protected void addParameters(Template template, JSReferenceExpression methodExpression, @NotNull PsiElement anchorParent) {
        PsiElement element;
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(3);
        }
        if ((element = methodExpression.getParent()) instanceof JSCallExpression) {
            CreateJSFunctionIntentionAction.addParameters(template, ((JSCallExpression)element).getArguments(), (PsiElement)methodExpression, anchorParent);
        } else if (element instanceof ES6TaggedTemplateExpression) {
            JSStringTemplateExpression templateExpression = ((ES6TaggedTemplateExpression)element).getTemplateExpression();
            JSExpression[] arguments = templateExpression != null ? templateExpression.getArguments() : JSExpression.EMPTY_ARRAY;
            CreateJSFunctionIntentionAction.addParameter(template, "strings", DialectDetector.isTypeScript((PsiElement)methodExpression) ? "TemplateStringsArray" : null, (PsiElement)methodExpression);
            if (arguments.length > 0) {
                template.addTextSegment(", ");
                CreateJSFunctionIntentionAction.addParameters(template, arguments, (PsiElement)methodExpression, anchorParent);
            }
        }
    }

    public static void addParameters(@NotNull Template template, @NotNull JSExpression[] expressions, @NotNull PsiElement callExpressionContext, PsiElement anchorParent) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(4);
        }
        if (expressions == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(5);
        }
        if (callExpressionContext == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(6);
        }
        int paramCount = expressions.length;
        THashSet usedParameterNames = new THashSet();
        for (int i = 0; i < paramCount; ++i) {
            JSExpression passedParameterValue;
            String var;
            if (i != 0) {
                template.addTextSegment(", ");
            }
            if ((var = (passedParameterValue = expressions[i]) instanceof JSReferenceExpression ? ((JSReferenceExpression)passedParameterValue).getReferenceName() : JSNameSuggestionsUtil.generateVariableNameFromExpression(passedParameterValue, callExpressionContext)) == null || var.length() == 0) {
                var = "param" + (i != 0 ? Integer.toString(i + 1) : "");
            } else {
                String baseName = var;
                int j = 2;
                while (usedParameterNames.contains(var)) {
                    var = baseName + j;
                    ++j;
                }
                usedParameterNames.add(var);
            }
            String typeName = null;
            DialectOptionHolder holder = DialectDetector.dialectOfElement(anchorParent);
            if (holder != null && (holder.isTypeScript || holder.isECMA4)) {
                JSType type = JSResolveUtil.getExpressionJSType(passedParameterValue);
                String string = typeName = type == null ? null : CreateJSFunctionIntentionAction.getTypeText(type, anchorParent);
                if (holder.isTypeScript && (typeName == null || "null".equals(typeName))) {
                    typeName = null;
                }
            }
            CreateJSFunctionIntentionAction.addParameter(template, var, typeName, callExpressionContext);
        }
    }

    private static void addParameter(@NotNull Template template, @NotNull String parameterName, @Nullable String typeName, @NotNull PsiElement context) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(7);
        }
        if (parameterName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(8);
        }
        if (context == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(9);
        }
        BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(parameterName);
        template.addVariable(parameterName, (Expression)expression, (Expression)expression, true);
        if (typeName != null) {
            template.addTextSegment(":");
            CreateJSFunctionIntentionAction.addTypeVariable(template, parameterName, context, typeName);
        }
    }

    @Override
    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(10);
        }
        this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, anchorParent, true);
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @Nullable PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression superRefExpression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext);
        if (superRefExpression == null) {
            return null;
        }
        if (CreateJSFunctionIntentionAction.shouldInsertQualifier(anchor, superRefExpression)) {
            String name;
            JSClass contextClass = JSUtils.getMemberContainingClass(anchor);
            String qualifier = "this";
            if (contextClass != null && isStaticContext && (name = contextClass.getName()) != null) {
                qualifier = name;
            }
            return (JSReferenceExpression)JSInsertThisFix.insertQualifier((JSExpression)superRefExpression, editor, qualifier);
        }
        return superRefExpression;
    }

    private static boolean shouldInsertQualifier(@Nullable PsiElement anchor, JSReferenceExpression superRefExpression) {
        return !DialectDetector.isActionScript((PsiElement)superRefExpression) && superRefExpression.getQualifier() == null && anchor != null && null != JSUtils.getMemberContainingClass(anchor);
    }

    @Override
    protected void addBody(Template template, JSReferenceExpression refExpr, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(11);
        }
        template.addTextSegment("\n");
        template.addSelectionStartVariable();
        this.appendFunctionBody(template, refExpr, anchorParent);
        template.addSelectionEndVariable();
        template.addEndVariable();
        template.addTextSegment("\n");
    }

    protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiElement anchorParent) {
        PsiElement parent = refExpr.getParent();
        JSType expectedType = parent instanceof JSCallExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent) : null;
        String methodName = refExpr.getReferenceName();
        assert (methodName != null);
        if (DialectDetector.isTypeScript(anchorParent)) {
            StringBuilder builder = new StringBuilder();
            TypeScriptImplementMemberUtil.appendDefaultMethodBody((PsiElement)refExpr, expectedType, builder, methodName);
            template.addTextSegment(builder.toString());
        } else {
            CreateJSFunctionIntentionAction.buildImplementedFunctionBody(template, refExpr.getParent() instanceof JSNewExpression, anchorParent.getProject(), CreateJSFunctionIntentionAction.isAssignmentTarget(parent, expectedType), expectedType, methodName);
        }
    }

    private static void buildImplementedFunctionBody(@NotNull Template template, boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(13);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(14);
        }
        template.addTextSegment(CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(isNewCall, project, isAssignmentTarget, expectedType, methodName));
    }

    @NotNull
    public static String getImplementedFunctionBodyText(boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName) {
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(15);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(16);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(ourJSImplementedMethodBodyTemplate);
        Properties properties = fileTemplateManager.getDefaultProperties();
        properties.setProperty(ATTRIBUTE_HAS_EXPECTED_TYPE, String.valueOf(expectedType != null && !(expectedType instanceof JSVoidType)));
        properties.setProperty(ATTRIBUTE_IS_NEW_CALL, String.valueOf(isNewCall));
        properties.setProperty(ATTRIBUTE_IS_ASSIGNMENT_TARGET, String.valueOf(isAssignmentTarget));
        properties.setProperty("DEFAULT_RETURN_VALUE", JSTypeUtils.defaultValueOfType(expectedType));
        properties.setProperty("METHOD_NAME", methodName);
        String string = TypeScriptImplementMemberUtil.getBodyTextFromTemplate(fileTemplate, properties);
        if (string == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean isAssignmentTarget(PsiElement parent, JSType expectedType) {
        PsiElement parentParent = parent == null ? null : parent.getParent();
        return expectedType != null || parentParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parentParent).getROperand() == parent || parentParent instanceof JSVariable && ((JSVariable)parentParent).getInitializer() == parent || parentParent instanceof JSReturnStatement || parentParent instanceof JSArgumentList;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(18);
        }
        super.buildTemplate(template, referenceExpression, staticContext, anchorParent);
        if (this.myIsMethod && !JSClassUtils.canHaveClasses(anchorParent)) {
            this.addSemicolonSegment(template, anchorParent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedFunctionBodyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScopeForTest";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeFunctionAndName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addReturnType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBody";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildImplementedFunctionBody";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedFunctionBodyText";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

