/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptorWrapper;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)JSChangeSignatureFix.class.getName());
    protected final SmartPsiElementPointer<JSFunction> myFunction;
    @Nullable
    private final SmartPsiElementPointer<JSArgumentList> myExpectedArguments;
    @Nullable
    protected final SmartPsiElementPointer<JSParameterList> myExpectedParameterList;
    private final boolean myShowDialogOnIncompatibleOverride;
    @Nullable
    private String myOverriddenReturnType;
    private Map<String, String> myOverriddenParameterTypes;

    public JSChangeSignatureFix(JSFunction function, JSParameterList expectedParameterList, boolean showDialogOnIncompatibleOverride) {
        this(function, expectedParameterList, null, showDialogOnIncompatibleOverride);
    }

    public JSChangeSignatureFix(JSFunction function, JSParameterList expectedParameterList) {
        this(function, expectedParameterList, true);
    }

    public JSChangeSignatureFix(JSFunction function, JSArgumentList expectedArguments) {
        this(function, null, expectedArguments, true);
    }

    public JSChangeSignatureFix(JSFunction function) {
        this(function, null, null, true);
    }

    private JSChangeSignatureFix(@NotNull JSFunction function, @Nullable JSParameterList expectedParameterList, @Nullable JSArgumentList expectedArgumentList, boolean showDialogOnIncompatibleOverride) {
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(0);
        }
        this.myOverriddenParameterTypes = Collections.emptyMap();
        this.myFunction = SmartPointerManager.createPointer((PsiElement)function);
        this.myExpectedParameterList = expectedParameterList == null ? null : SmartPointerManager.createPointer((PsiElement)expectedParameterList);
        this.myExpectedArguments = expectedArgumentList == null ? null : SmartPointerManager.createPointer((PsiElement)expectedArgumentList);
        this.myShowDialogOnIncompatibleOverride = showDialogOnIncompatibleOverride;
    }

    @NotNull
    public String getText() {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null) {
            String string = JSBundle.message((String)"change.method.signature.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                JSChangeSignatureFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = JSBundle.message((String)"change.method.signature.fix.text", (Object[])new Object[]{JSFormatUtil.formatMethod(function, 4353, 0, 0, null)});
        if (string == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"change.method.signature.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        JSFunction function;
        if (project == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(4);
        }
        if ((function = (JSFunction)this.myFunction.getElement()) == null || !function.isValid() || ModuleUtilCore.findModuleForPsiElement((PsiElement)function) == null) {
            return false;
        }
        if (this.myExpectedParameterList != null) {
            JSParameterList parameterListElement = (JSParameterList)this.myExpectedParameterList.getElement();
            return parameterListElement != null && parameterListElement.isValid();
        }
        if (this.myExpectedArguments != null) {
            JSExpression[] arguments;
            JSArgumentList argumentList = (JSArgumentList)this.myExpectedArguments.getElement();
            for (JSExpression argument : arguments = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY) {
                if (argument.isValid()) continue;
                return false;
            }
            return this.handleCall(function, arguments, true) != null;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(5);
        }
        PsiFile context = editor != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : file2;
        this.invoke((PsiElement)context);
    }

    public void invoke(PsiElement context) throws IncorrectOperationException {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        if (function == null) {
            return;
        }
        Pair<List<JSParameterInfo>, Boolean> parameterInfos = this.buildParameterInfos(function);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runSilently((List)parameterInfos.first, function);
        } else if (!((Boolean)parameterInfos.second).booleanValue() && !this.needToShowDialog(function)) {
            this.runSilently((List)parameterInfos.first, function);
        } else {
            this.createDialog(context, (List)parameterInfos.first).show();
        }
    }

    @NotNull
    protected Pair<List<JSParameterInfo>, Boolean> buildParameterInfos(@NotNull JSFunction function) {
        List<JSParameterInfo> paramInfos;
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(6);
        }
        boolean mustShowDialog = false;
        JSArgumentList argumentList = this.getExpectedArguments();
        if (argumentList != null) {
            Pair<Boolean, List<JSParameterInfo>> result2 = this.handleCall(function, argumentList.getArguments(), false);
            LOG.assertTrue(result2 != null);
            mustShowDialog = (Boolean)result2.first;
            paramInfos = (List<JSParameterInfo>)result2.second;
        } else {
            paramInfos = this.myExpectedParameterList != null ? JSChangeSignatureFix.buildParameterInfosForExpected(function, ((JSParameterList)this.myExpectedParameterList.getElement()).getParameters()) : JSMethodDescriptor.getParameters(function, this.myOverriddenParameterTypes);
        }
        Pair pair = Pair.create(paramInfos, (Object)mustShowDialog);
        if (pair == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(7);
        }
        return pair;
    }

    protected JSChangeSignatureDialog createDialog(PsiElement context, final List<JSParameterInfo> paramInfos) {
        JSFunction function = (JSFunction)this.myFunction.getElement();
        JSMethodDescriptor parent = JSMethodDescriptorFactory.create(function, false);
        JSMethodDescriptorWrapper descriptor2 = new JSMethodDescriptorWrapper(parent){

            @Override
            public List<JSParameterInfo> getParameters() {
                return paramInfos;
            }

            @Override
            public String getReturnType() {
                String returnType = JSChangeSignatureFix.this.myOverriddenReturnType;
                if (returnType == null) {
                    returnType = super.getReturnType();
                }
                return returnType;
            }
        };
        return new JSChangeSignatureDialog(descriptor2, context){

            @Override
            protected JSChangeSignatureProcessor createRefactoringProcessor() {
                JSChangeSignatureProcessor p = super.createRefactoringProcessor();
                JSChangeSignatureFix.this.setDeclarationFilter(p);
                JSChangeSignatureFix.this.setCallFilter(p);
                return p;
            }

            public JComponent getPreferredFocusedComponent() {
                if (this.myReturnTypeField != null) {
                    return this.myReturnTypeField.getComponent();
                }
                return super.getPreferredFocusedComponent();
            }
        };
    }

    private boolean needToShowDialog(@NotNull JSFunction function) {
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(8);
        }
        if (!this.myShowDialogOnIncompatibleOverride) {
            return false;
        }
        if (JSInheritanceUtil.participatesInHierarchy(function)) {
            return true;
        }
        JSCallExpression callExpression = this.getCallExpression();
        Ref hasUsages = new Ref((Object)Boolean.FALSE);
        ReferencesSearch.search((PsiElement)function, (SearchScope)function.getUseScope()).forEach(ref -> {
            if (callExpression == null || ref.getElement() != callExpression.getMethodExpression()) {
                hasUsages.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        });
        return (Boolean)hasUsages.get();
    }

    protected void runSilently(List<JSParameterInfo> paramInfos, @NotNull JSFunction function) {
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(9);
        }
        JSAttributeList attributeList = function instanceof JSFunctionExpression && function.getParent() instanceof JSVariable ? ((JSVariable)function.getParent()).getAttributeList() : function.getAttributeList();
        this.createProcessor(paramInfos, attributeList, function).run();
    }

    protected JSChangeSignatureProcessor createProcessor(List<JSParameterInfo> paramInfos, JSAttributeList attributeList, @NotNull JSFunction function) {
        String returnType;
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(10);
        }
        if ((returnType = this.myOverriddenReturnType) == null) {
            returnType = JSMethodDescriptorFactory.create(function, false).getReturnType();
        }
        JSChangeSignatureProcessor p = new JSChangeSignatureProcessor(function, attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL, function.getName(), returnType, paramInfos.toArray(JSParameterInfo.EMPTY_ARRAY), Collections.emptySet(), Collections.emptySet());
        this.setDeclarationFilter(p);
        this.setCallFilter(p);
        return p;
    }

    public void setReturnType(@Nullable String overriddenReturnType) {
        this.myOverriddenReturnType = overriddenReturnType;
    }

    public void setParameterTypes(@NotNull Map<String, String> overriddenParameterTypes) {
        if (overriddenParameterTypes == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(11);
        }
        this.myOverriddenParameterTypes = overriddenParameterTypes;
    }

    private void setDeclarationFilter(JSChangeSignatureProcessor processor) {
        if (this.myExpectedParameterList != null) {
            JSFunction subjectFunction = (JSFunction)((JSParameterList)this.myExpectedParameterList.getElement()).getParent();
            processor.setDeclarationsFilter((Condition<JSFunction>)((Condition)jsFunction -> subjectFunction != jsFunction));
        }
    }

    private void setCallFilter(JSChangeSignatureProcessor processor) {
        JSCallExpression callExpression = this.getCallExpression();
        if (callExpression != null) {
            processor.setCallFilter((Condition<JSCallExpression>)((Condition)expression -> expression != callExpression));
        }
    }

    @Nullable
    private JSArgumentList getExpectedArguments() {
        return this.myExpectedArguments != null ? (JSArgumentList)this.myExpectedArguments.getElement() : null;
    }

    @Nullable
    private JSCallExpression getCallExpression() {
        JSArgumentList arguments = this.getExpectedArguments();
        return arguments != null ? (JSCallExpression)ObjectUtils.tryCast((Object)arguments.getParent(), JSCallExpression.class) : null;
    }

    @Nullable
    protected Pair<Boolean, List<JSParameterInfo>> handleCall(@NotNull JSFunction function, @NotNull JSExpression[] arguments, boolean dryRun) {
        boolean showDialog;
        ArrayList<JSParameterInfo> result2;
        block18: {
            Trinity<Integer, Integer, Boolean> minMaxParameters;
            ProcessingContext processingContext;
            boolean hasTypesLang;
            JSParameter[] parameters;
            block20: {
                block19: {
                    if (function == null) {
                        JSChangeSignatureFix.$$$reportNull$$$0(12);
                    }
                    if (arguments == null) {
                        JSChangeSignatureFix.$$$reportNull$$$0(13);
                    }
                    parameters = function.getParameterVariables();
                    result2 = new ArrayList<JSParameterInfo>(arguments.length);
                    showDialog = false;
                    hasTypesLang = DialectDetector.isActionScript((PsiElement)function) || DialectDetector.isTypeScript((PsiElement)function);
                    processingContext = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)function);
                    minMaxParameters = ValidateTypesUtil.getMinMaxParameters((JSParameterItem[])parameters);
                    if (arguments.length >= (Integer)minMaxParameters.first) break block19;
                    int ai = 0;
                    int pi = 0;
                    HashSet mismatchIndexes = ContainerUtil.newHashSet();
                    while (ai < arguments.length && pi < (Integer)minMaxParameters.first) {
                        JSType argumentJSType;
                        JSExpression argument = arguments[ai];
                        JSParameter parameter = parameters[pi];
                        JSType jsType = parameter.getType();
                        JSType jSType = argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                        if (JSChangeSignatureFix.isAssignableType(jsType, argumentJSType, argument, processingContext)) {
                            result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                            ++pi;
                            ++ai;
                            continue;
                        }
                        mismatchIndexes.add(pi);
                        ++pi;
                    }
                    if (result2.size() != arguments.length) {
                        return null;
                    }
                    while (pi < parameters.length) {
                        if (parameters[pi].isOptional()) {
                            showDialog = true;
                            result2.add(JSParameterInfo.build((JSParameterListElement)parameters[pi], pi));
                        }
                        ++pi;
                    }
                    break block18;
                }
                if (arguments.length <= (Integer)minMaxParameters.second) break block20;
                ArrayList<String> paramsNames = new ArrayList<String>();
                for (JSParameter parameter : parameters) {
                    paramsNames.add(parameter.getName());
                }
                int pi = 0;
                int lastRequiredParamIndex = -1;
                for (int ai = 0; ai < arguments.length; ++ai) {
                    JSType argumentJSType;
                    JSExpression argument = arguments[ai];
                    JSParameter parameter = pi < parameters.length ? parameters[pi] : null;
                    JSType jSType = argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                    if (parameter != null && JSChangeSignatureFix.isAssignableType(parameter.getType(), argumentJSType, argument, processingContext)) {
                        result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                        ++pi;
                        continue;
                    }
                    String name = dryRun ? null : JSChangeSignatureFix.generateParameterName(argument, paramsNames, function);
                    String defaultValue = argument.getText();
                    if (!dryRun && StringUtil.isNotEmpty((String)defaultValue) && DialectDetector.isActionScript((PsiElement)function)) {
                        PsiElement psiElement = JSChangeUtil.createExpressionWithContext(defaultValue, (PsiElement)argument).getPsi();
                        psiElement.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)argument);
                        PsiElement fixed = ActionScriptRefactoringUtil.fixOutgoingReferences(psiElement, new ArrayList<String>(), new ArrayList<String>(), Collections.emptyList(), null, false, false);
                        defaultValue = fixed.getText();
                    }
                    String argumentTypeText = argumentJSType != null ? JSTypeUtils.copyWithLanguageOfContext(argumentJSType, (PsiElement)function).getTypeText(JSType.TypeTextFormat.CODE) : "";
                    result2.add(new JSParameterInfo(name, argumentTypeText, "", defaultValue, -1));
                    lastRequiredParamIndex = result2.size() - 1;
                }
                if (result2.size() != arguments.length) {
                    return null;
                }
                if (!DialectDetector.isActionScript((PsiElement)function)) break block18;
                for (int i = 0; i < lastRequiredParamIndex; ++i) {
                    ((JSParameterInfo)result2.get(i)).setInitializer("");
                }
                break block18;
            }
            int pi = 0;
            for (int ai = 0; pi < parameters.length || ai < arguments.length; ++pi, ++ai) {
                if (pi < parameters.length && ai < arguments.length) {
                    JSType argumentJSType;
                    JSParameter parameter = parameters[pi];
                    JSExpression argument = arguments[ai];
                    JSType parameterJSType = parameter.getType();
                    JSType jSType = argumentJSType = hasTypesLang ? JSResolveUtil.getExpressionJSType(argument) : null;
                    if (parameter.isRest()) {
                        result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                        break;
                    }
                    if (JSChangeSignatureFix.isAssignableType(parameterJSType, argumentJSType, argument, processingContext)) {
                        result2.add(JSParameterInfo.build((JSParameterListElement)parameter, pi));
                        continue;
                    }
                    String argumentType = argumentJSType.getTypeText(JSType.TypeTextFormat.CODE);
                    JSParameterInfo parameterInfo = JSParameterInfo.build((JSParameterListElement)parameter, pi);
                    parameterInfo.setTypeText(argumentType);
                    parameterInfo.setInitializer("");
                    result2.add(parameterInfo);
                    continue;
                }
                if (pi >= parameters.length) {
                    LOG.assertTrue(((Boolean)minMaxParameters.third).booleanValue());
                    break;
                }
                LOG.assertTrue(ai >= arguments.length);
                result2.add(JSParameterInfo.build((JSParameterListElement)parameters[pi], pi));
            }
        }
        return Pair.create((Object)showDialog, result2);
    }

    private static boolean isAssignableType(@Nullable JSType parameterType, @Nullable JSType argumentType, @NotNull JSExpression argument, @NotNull ProcessingContext processingContext) {
        if (argument == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(14);
        }
        if (processingContext == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(15);
        }
        if (argumentType == null || parameterType == null) {
            return true;
        }
        boolean assignable = parameterType.isDirectlyAssignableType(argumentType, processingContext);
        boolean isActionScript = DialectDetector.isActionScript((PsiElement)argument);
        if (!isActionScript) {
            return assignable;
        }
        if (!assignable) {
            return false;
        }
        String parameterTypeText = parameterType.getTypeText(JSType.TypeTextFormat.CODE);
        String argumentTypeText = argumentType.getTypeText(JSType.TypeTextFormat.CODE);
        if ("Boolean".equals(parameterTypeText)) {
            return "Boolean".equals(argumentTypeText);
        }
        return !ValidateTypesUtil.checkIfNullIsAssignedToNumeric(argument, parameterTypeText, argumentTypeText);
    }

    @NotNull
    private static String generateParameterName(@NotNull JSExpression argument, Collection<String> existingNames, @NotNull JSFunction function) {
        if (argument == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(16);
        }
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(17);
        }
        String name = null;
        if (argument instanceof JSReferenceExpression) {
            name = JSNameSuggestionsUtil.trimPrefix((JSReferenceExpression)argument, ((JSReferenceExpression)argument).getReferenceName());
        }
        if (argument instanceof JSNamedElement) {
            name = argument.getName();
        }
        if (name != null && JSChangeSignatureProcessor.getCollidingLocal(function, name, (Condition<PsiElement>)Conditions.alwaysTrue()) == null && !existingNames.contains(name)) {
            String string = name;
            if (string == null) {
                JSChangeSignatureFix.$$$reportNull$$$0(18);
            }
            return string;
        }
        List names = JSNameSuggestionsUtil.generateVariableNamesFromExpression(argument, (PsiElement)function, "", existingNames, JSNamedEntityKind.Parameter);
        if ((names = ContainerUtil.filter(names, aName -> {
            if (function == null) {
                JSChangeSignatureFix.$$$reportNull$$$0(25);
            }
            return JSChangeSignatureProcessor.getCollidingLocal(function, aName, (Condition<PsiElement>)Conditions.alwaysTrue()) == null;
        })).isEmpty()) {
            int postfix = 1;
            name = "p";
            while (existingNames.contains(name)) {
                name = "p" + postfix++;
            }
        } else {
            name = (String)names.iterator().next();
        }
        existingNames.add(name);
        String string = name;
        if (string == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected static List<JSParameterInfo> buildParameterInfosForExpected(@NotNull JSFunction function, @NotNull JSParameterListElement[] expectedParams) {
        if (function == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(20);
        }
        if (expectedParams == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(21);
        }
        JSParameterListElement[] actualParams = function.getParameters();
        ArrayList<JSParameterInfo> result2 = new ArrayList<JSParameterInfo>(expectedParams.length);
        HashMap<String, Integer> actualName2Index = new HashMap<String, Integer>(actualParams.length);
        for (int i = 0; i < actualParams.length; ++i) {
            actualName2Index.put(actualParams[i].getName(), i);
        }
        JSParameterListElement[] jSParameterListElementArray = expectedParams;
        int n = jSParameterListElementArray.length;
        for (int i = 0; i < n; ++i) {
            JSParameterListElement expectedParam;
            Integer prevIndex = (Integer)actualName2Index.get((expectedParam = jSParameterListElementArray[i]).getName());
            JSParameterInfo parameterInfo = JSParameterInfo.build(expectedParam, prevIndex != null ? prevIndex : -1);
            parameterInfo.setCallValue(JSTypeUtils.defaultValueOfType(parameterInfo.getTypeText()));
            result2.add(parameterInfo);
        }
        ArrayList<JSParameterInfo> arrayList = result2;
        if (arrayList == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(23);
        }
        if (descriptor2 == null) {
            JSChangeSignatureFix.$$$reportNull$$$0(24);
        }
        this.invoke(descriptor2.getPsiElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureFix";
                break;
            }
            case 4: 
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenParameterTypes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParams";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSChangeSignatureFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfos";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generateParameterName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterInfosForExpected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterInfos";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "needToShowDialog";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runSilently";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setParameterTypes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleCall";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildParameterInfosForExpected";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateParameterName$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

