/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGoToDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceElement == null) {
            return null;
        }
        Project project = editor.getProject();
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (project == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(editor.getProject())) {
                return null;
            }
            VirtualFile virtualFile = sourceElement.getContainingFile().getVirtualFile();
            TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(project, virtualFile);
            if (service == null || !service.checkCanUseService()) {
                return null;
            }
            ResolveResult[] results = ((JSReferenceExpression)parent).multiResolve(false);
            if (results.length == 0) {
                return TypeScriptGoToDeclarationHandler.getResultsFromTypeScriptService(project, editor, sourceElement);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement[] getResultsFromTypeScriptService(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement sourceElement) {
        Future<TypeScriptResponseCommon.FileSpan[]> future;
        if (project == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(2);
        }
        if ((future = TypeScriptLanguageServiceEvents.getService(project).getDeclaration(sourceElement, editor.getDocument())) == null) {
            return null;
        }
        TypeScriptResponseCommon.FileSpan[] spans = JSLanguageServiceUtil.awaitFuture(future, 700L, 10L, null);
        if (spans == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (PsiElement[])Arrays.stream(spans).map(el -> {
            if (project == null) {
                TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(6);
            }
            String path = el.file.getPath();
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null) {
                return null;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) {
                return null;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return null;
            }
            return TypeScriptGoToDeclarationHandler.getElement(psiFile, document, el);
        }).filter(el -> el != null).map(el -> JSTargetElementEvaluator.adjustTargetElement(el)).toArray(PsiElement[]::new);
    }

    @Nullable
    private static PsiElement getElement(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull TypeScriptResponseCommon.FileSpan span) {
        TypeScriptResponseCommon.Location end;
        TypeScriptResponseCommon.Location start;
        JSLanguageServiceUtil.PsiElementInfo info;
        if (psiFile == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(3);
        }
        if (document == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(4);
        }
        if (span == null) {
            TypeScriptGoToDeclarationHandler.$$$reportNull$$$0(5);
        }
        if ((info = TypeScriptLanguageServiceUtil.getPsiElementInfo(psiFile, document, start = span.start, end = span.end)) == null) {
            return null;
        }
        PsiElement element = info.getElement();
        if (element != null) {
            return element;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        return TypeScriptPsiUtil.getPsiElementByRange(psiFile, range);
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResultsFromTypeScriptService";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getResultsFromTypeScriptService$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

