/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptServiceRelatedAction;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceFix
implements IntentionAction,
Iconable,
LowPriorityAction,
TypeScriptServiceRelatedAction {
    static final State LOADING = new State(null){

        @Override
        String getName() {
            return "Loading service fixes...";
        }
    };
    @NotNull
    private final Runnable myRefreshCallback;
    private final int myIndex;
    @Nullable
    private volatile State myState;

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    public TypeScriptLanguageServiceFix(@NotNull Runnable refresh, int index) {
        if (refresh == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(0);
        }
        this.myRefreshCallback = refresh;
        this.myIndex = index;
    }

    @Nls
    @NotNull
    public String getText() {
        this.myRefreshCallback.run();
        State state = this.myState;
        String string = state == null ? "" : StringUtil.notNullize((String)state.getName());
        if (string == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(3);
        }
        this.myRefreshCallback.run();
        State state = this.myState;
        return state != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        State state;
        if (project == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(4);
        }
        if ((state = this.myState) == null) {
            return;
        }
        TypeScriptCodeActionInfo fix = state.fix;
        if (fix == null) {
            return;
        }
        for (TypeScriptCodeActionInfo.FileCodeEdits change : fix.changes) {
            Object[] changes;
            String name = LocalFilePath.getPath(change.fileName);
            if (StringUtil.isEmpty((String)name) || (changes = change.textChanges) == null || changes.length == 0) continue;
            String filePath = FileUtil.toSystemIndependentName((String)name);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (virtualFile == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot find the file " + filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            boolean okToWrite = FileModificationService.getInstance().prepareVirtualFilesForWrite(project, (Collection)ContainerUtil.createMaybeSingletonList((Object)virtualFile));
            if (!okToWrite) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot write to the file " + filePath), (String)CommonBundle.getErrorTitle(), null);
                break;
            }
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document == null) continue;
            List sortedRanges = ContainerUtil.reverse((List)((List)((StreamEx)StreamEx.of((Object[])changes).map(el -> {
                JSLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getPsiElementInfo(null, document, el.start, el.end);
                TextRange range = info == null ? null : info.getRange();
                return range == null ? null : new Edit(range, el.newText);
            }).filter(el -> el != null)).collect(Collectors.toList())));
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
                if (project == null) {
                    TypeScriptLanguageServiceFix.$$$reportNull$$$0(8);
                }
                int startRange = -1;
                int endRange = -1;
                PsiManager manager = file2.getManager();
                PsiFile currentPsiFile = manager.findFile(virtualFile);
                for (Edit edit : sortedRanges) {
                    String text = StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)edit.text));
                    TypeScriptLanguageServiceFix.replaceText(document, text, edit.range);
                    TextRange newRange = new TextRange(edit.range.getStartOffset(), edit.range.getStartOffset() + text.length());
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    if (startRange == -1 || startRange > newRange.getStartOffset()) {
                        startRange = newRange.getStartOffset();
                    }
                    if (endRange != -1 && endRange >= newRange.getEndOffset()) continue;
                    endRange = newRange.getEndOffset();
                }
                if (startRange == -1 || startRange >= document.getTextLength()) {
                    return;
                }
                if (endRange == -1 || endRange >= document.getTextLength() || endRange < startRange) {
                    return;
                }
                if (currentPsiFile != null) {
                    CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)currentPsiFile, startRange, endRange);
                }
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    private static void replaceText(@NotNull Document document, @NotNull String text, @NotNull TextRange range) {
        if (document == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(5);
        }
        if (text == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(6);
        }
        if (range == null) {
            TypeScriptLanguageServiceFix.$$$reportNull$$$0(7);
        }
        if (range.getLength() == 0) {
            document.insertString(range.getStartOffset(), (CharSequence)text);
        } else {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
        }
    }

    public void update(@Nullable State state) {
        this.myState = state;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresh";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class Edit {
        @NotNull
        final TextRange range;
        @NotNull
        final String text;

        public Edit(@NotNull TextRange range, String text) {
            if (range == null) {
                Edit.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Edit.$$$reportNull$$$0(1);
            }
            this.range = range;
            this.text = text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix$Edit";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        @Nullable
        private final TypeScriptCodeActionInfo fix;

        public State(@Nullable TypeScriptCodeActionInfo fix) {
            this.fix = fix;
        }

        @Nullable
        String getName() {
            return this.fix == null ? null : this.fix.description;
        }
    }
}

