/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceFileCommandCache;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixes;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptGetCodeFixesResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptLanguageServiceFixSet {
    private static final int MAX_QUICK_FIXES = 5;
    private final JSLanguageServiceFileCommandCache myFixProvider;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final TypeScriptLanguageServiceAnnotationResult myResult;
    @NotNull
    private final List<TypeScriptLanguageServiceFix> myFixes;

    @NotNull
    public List<TypeScriptLanguageServiceFix> getFixes() {
        List<TypeScriptLanguageServiceFix> list = this.myFixes;
        if (list == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(0);
        }
        return list;
    }

    public TypeScriptLanguageServiceFixSet(@NotNull Project project, @NotNull JSLanguageServiceFileCommandCache service, @NotNull VirtualFile virtualFile, @NotNull TypeScriptLanguageServiceAnnotationResult result2) {
        if (project == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(1);
        }
        if (service == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(4);
        }
        this.myFixProvider = service;
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myResult = result2;
        ArrayList fixes = ContainerUtil.newArrayListWithCapacity((int)5);
        int i = 0;
        while (i < 5) {
            int index = i++;
            fixes.add(new TypeScriptLanguageServiceFix(() -> this.refresh(index), index));
        }
        this.myFixes = fixes;
    }

    public void refresh(int index) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile);
        if (psiFile == null) {
            this.myFixes.forEach(el -> el.update(null));
            return;
        }
        TypeScriptGetCodeFixes command = this.createCommand();
        TypeScriptGetCodeFixesResponse response = (TypeScriptGetCodeFixesResponse)this.myFixProvider.getCachedValue(psiFile, command);
        if (response != null) {
            this.updateState(response);
            return;
        }
        this.calcAndUpdateState(psiFile, command, index);
    }

    private void calcAndUpdateState(@NotNull PsiFile psiFile, @NotNull TypeScriptGetCodeFixes command, int index) {
        if (psiFile == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(5);
        }
        if (command == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(6);
        }
        if (index == 0) {
            this.myFixes.forEach(el -> el.update(null));
        }
        Gson gson = JSLanguageServiceUtil.getGson(this.myFixProvider.getService());
        TypeScriptGetCodeFixesResponse result2 = null;
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (index == 0 && (result2 = this.myFixProvider.calculateWithCache(psiFile, command, TypeScriptLanguageServiceFixSet.createGetCodeFixesProcessor(gson), 10L)) == null) {
                this.setLoadingState();
                return;
            }
        } else {
            if (index == 0) {
                this.setLoadingState();
            }
            result2 = this.myFixProvider.calculateWithCache(psiFile, command, TypeScriptLanguageServiceFixSet.createGetCodeFixesProcessor(gson), JSLanguageServiceUtil.TIMEOUT_MILLS);
        }
        if (result2 != null) {
            this.updateState(result2);
        }
    }

    private void setLoadingState() {
        for (int i = 0; i < this.myFixes.size(); ++i) {
            TypeScriptLanguageServiceFix fix = this.myFixes.get(i);
            fix.update(i == 0 ? TypeScriptLanguageServiceFix.LOADING : null);
        }
    }

    private void updateState(@NotNull TypeScriptGetCodeFixesResponse response) {
        TypeScriptCodeActionInfo[] body;
        if (response == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(7);
        }
        TypeScriptCodeActionInfo[] actions = (body = response.body) == null ? new TypeScriptCodeActionInfo[]{} : body;
        for (int i = 0; i < this.myFixes.size(); ++i) {
            TypeScriptLanguageServiceFix fix = this.myFixes.get(i);
            if (actions.length > i) {
                TypeScriptCodeActionInfo action = actions[i];
                fix.update(new TypeScriptLanguageServiceFix.State(action));
                continue;
            }
            fix.update(null);
        }
    }

    @NotNull
    public TypeScriptGetCodeFixes createCommand() {
        TypeScriptGetCodeFixesRequestArgs args = new TypeScriptGetCodeFixesRequestArgs();
        args.file = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(this.myVirtualFile));
        args.startOffset = this.myResult.getColumn() + 1;
        args.startLine = this.myResult.getLine() + 1;
        args.endOffset = this.myResult.getEndColumn() + 1;
        args.endLine = this.myResult.getEndLine() + 1;
        args.errorCodes = new int[]{this.myResult.getErrorCode()};
        TypeScriptGetCodeFixes typeScriptGetCodeFixes = new TypeScriptGetCodeFixes(args);
        if (typeScriptGetCodeFixes == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(8);
        }
        return typeScriptGetCodeFixes;
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse> createGetCodeFixesProcessor(@NotNull Gson gson) {
        if (gson == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(9);
        }
        JSLanguageServiceCommandProcessor<TypeScriptGetCodeFixesResponse> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            if (gson == null) {
                TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(11);
            }
            if (answer.isEmpty()) {
                return null;
            }
            JsonObject element = answer.getElement();
            return (TypeScriptGetCodeFixesResponse)gson.fromJson((JsonElement)element, TypeScriptGetCodeFixesResponse.class);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptLanguageServiceFixSet.$$$reportNull$$$0(10);
        }
        return jSLanguageServiceCommandProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetCodeFixesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcAndUpdateState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGetCodeFixesProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createGetCodeFixesProcessor$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

