/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.common.collect.Streams;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLanguageServiceCacheImpl
extends JSLanguageServiceDefaultCacheData {
    private final Project myProject;
    private final Map<VirtualFile, LastUpdateInfo> myUpdateFiles = ContainerUtil.newConcurrentMap();
    private final Set<VirtualFile> myOpenedFilesByEvent = ContainerUtil.newConcurrentSet();
    private final Set<VirtualFile> myExternalConfigs = ContainerUtil.newConcurrentSet();

    public TypeScriptLanguageServiceCacheImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public final JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(0);
        }
        if (input instanceof TypeScriptLanguageServiceUpdateCommand) {
            return (JSLanguageServiceObject)ReadAction.compute(() -> {
                if (input == null) {
                    TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(20);
                }
                return this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateCommand)input);
            });
        }
        if (input instanceof TypeScriptCompositeCommand) {
            JSLanguageServiceCommand[] commands = ((TypeScriptCompositeCommand)input).getNestedCommands();
            ArrayList results = ContainerUtil.newArrayListWithCapacity((int)commands.length);
            for (JSLanguageServiceCommand command : commands) {
                JSLanguageServiceObject serviceObject = this.updateCacheAndGetServiceObject(command);
                if (serviceObject == null) continue;
                if (serviceObject instanceof TypeScriptCommandSetRequest) {
                    ((TypeScriptCommandSetRequest)serviceObject).nestedRequests.forEach((nestedServiceObject, nestedCommand) -> {
                        JSLanguageServiceRequest request = new JSLanguageServiceRequest((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedServiceObject, -1L, -1);
                        results.add(request);
                    });
                    continue;
                }
                JSLanguageServiceRequest request = new JSLanguageServiceRequest(command, serviceObject, -1L, -1);
                results.add(request);
            }
            if (results.size() == 0) {
                return null;
            }
            return new TypeScriptCompositeRequest(results);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            VirtualFile file2;
            if (input instanceof TypeScriptOpenEditorCommand) {
                return (JSLanguageServiceObject)ReadAction.compute(() -> {
                    if (input == null) {
                        TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(19);
                    }
                    return this.refreshAndGetOpenEditorCommand((JSLanguageServiceSimpleCommand)input);
                });
            }
            if (input instanceof TypeScriptCloseEditorCommand) {
                return (JSLanguageServiceObject)ReadAction.compute(() -> {
                    if (input == null) {
                        TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(18);
                    }
                    return this.refreshAndGetCloseEditorCommand((JSLanguageServiceSimpleCommand)input);
                });
            }
            if (input instanceof TypeScriptReloadFileCommand && (this.myOpenedFilesByEvent.contains(file2 = ((TypeScriptReloadFileCommand)input).getFile()) || this.myUpdateFiles.containsKey(file2))) {
                return null;
            }
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    @Nullable
    public JSLanguageServiceObject refreshAndGetCloseEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        VirtualFile configFile;
        String name;
        TypeScriptConfig config2;
        if (input == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(1);
        }
        TypeScriptCloseEditorCommand command = (TypeScriptCloseEditorCommand)input;
        VirtualFile virtualFile = command.getFile();
        this.myOpenedFilesByEvent.remove(virtualFile);
        if (this.myUpdateFiles.remove(virtualFile) == null) {
            return null;
        }
        if (TypeScriptConfigUtil.hasConfigsWithNonStandardName(this.myProject) && TypeScriptConfigUtil.isNonStandardName(config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, virtualFile)) && this.myExternalConfigs.contains(config2.getConfigFile()) && (name = JSLanguageServiceUtil.normalizeNameAndPath(configFile = config2.getConfigFile())) != null) {
            this.myExternalConfigs.remove(configFile);
            return new TypeScriptCommandSetRequest(ContainerUtil.newArrayList((Object[])new JSLanguageServiceSimpleCommand[]{new TypeScriptCloseExternalProjectRequest(name), input}));
        }
        return input.toSerializableObject();
    }

    @Nullable
    public JSLanguageServiceObject refreshAndGetOpenEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        VirtualFile configFile;
        String name;
        if (input == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(2);
        }
        TypeScriptOpenEditorCommand command = (TypeScriptOpenEditorCommand)input;
        VirtualFile file2 = command.getFile();
        this.myOpenedFilesByEvent.add(file2);
        if (this.myUpdateFiles.containsKey(file2)) {
            return null;
        }
        String path = JSLanguageServiceUtil.normalizeNameAndPath(file2);
        this.myUpdateFiles.put(file2, new LastUpdateInfo(path, command.getTimestamp(), command.getContentLength(), command.getLineCount(), command.getLastLineStartOffset()));
        if (!TypeScriptConfigUtil.hasConfigsWithNonStandardName(this.myProject)) {
            return input.toSerializableObject();
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, file2);
        if (TypeScriptConfigUtil.isNonStandardName(config2) && !this.myExternalConfigs.contains(config2.getConfigFile()) && (name = JSLanguageServiceUtil.normalizeNameAndPath(configFile = config2.getConfigFile())) != null) {
            this.myExternalConfigs.add(configFile);
            return new TypeScriptCommandSetRequest(ContainerUtil.newArrayList((Object[])new JSLanguageServiceSimpleCommand[]{new TypeScriptOpenExternalProjectRequest(name), input}));
        }
        return input.toSerializableObject();
    }

    @Nullable
    private JSLanguageServiceObject getUpdateFilesServiceObject(@NotNull TypeScriptLanguageServiceUpdateCommand command) {
        if (command == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return null;
        }
        Map<VirtualFile, Long> currentChangedFiles = command.myChangedFilesToTimeStamp;
        Map<VirtualFile, Document> unsavedContents = command.myUnsavedFilesContent;
        Set<VirtualFile> filesToClose = this.getFilesToClose(currentChangedFiles);
        Collection<VirtualFile> filesToOpen = this.getFilesToOpen(currentChangedFiles);
        Collection<VirtualFile> changedFiles = this.getFilesToChange(currentChangedFiles, filesToOpen);
        HashMap toUpdateCache = ContainerUtil.newHashMap();
        List toOpen = filesToOpen.stream().filter(el -> unsavedContents.containsKey(el)).map(el -> {
            Document document = (Document)unsavedContents.get(el);
            Long timestampObject = (Long)currentChangedFiles.get(el);
            String text = document.getText();
            int count = document.getLineCount();
            int contentLength = document.getTextLength();
            long timestamp = timestampObject == null ? -1L : timestampObject;
            int offset = count == 0 ? 0 : document.getLineStartOffset(count - 1);
            String path = JSLanguageServiceUtil.normalizeNameAndPath(el);
            toUpdateCache.put(el, new LastUpdateInfo(path, timestamp, contentLength, count, offset));
            String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, el);
            return new TypeScriptOpenEditorCommand((VirtualFile)el, timestamp, contentLength, count, offset, text, projectFileName);
        }).collect(Collectors.toList());
        List toChange = changedFiles.stream().map(el -> {
            LastUpdateInfo info = this.myUpdateFiles.get(el);
            Document document = (Document)unsavedContents.get(el);
            String text = document.getText();
            int newLineCount = document.getLineCount();
            int newOffset = newLineCount == 0 ? 0 : document.getLineStartOffset(newLineCount - 1);
            Long newTimestamp = (Long)currentChangedFiles.get(el);
            int newContentLength = text.length();
            String path = JSLanguageServiceUtil.normalizeNameAndPath(el);
            toUpdateCache.put(el, new LastUpdateInfo(path, newTimestamp, newContentLength, newLineCount, newOffset));
            TypeScriptChangeRequestArgs req = TypeScriptChangeRequestArgs.build(el, text, info.myContentLength, info.myLineCount, info.myLastLineStartOffset);
            return new TypeScriptChangeCommand(req);
        }).collect(Collectors.toList());
        ArrayList toCloseByRename = ContainerUtil.newArrayList();
        ArrayList toOpenByRename = ContainerUtil.newArrayList();
        HashSet filesToCloseByRename = ContainerUtil.newHashSet();
        this.myUpdateFiles.forEach((file2, storedInfo) -> {
            String newPath = JSLanguageServiceUtil.normalizeNameAndPath(file2);
            String oldPath = ((LastUpdateInfo)storedInfo).myLastPath;
            if (newPath != null && !Objects.equals(newPath, oldPath)) {
                toCloseByRename.add(TypeScriptLanguageServiceCacheImpl.createCloseCommand(file2, oldPath));
                if (!filesToOpen.contains(file2) && !filesToClose.contains(file2)) {
                    LastUpdateInfo updateInfo = (LastUpdateInfo)toUpdateCache.get(file2);
                    LastUpdateInfo info = new LastUpdateInfo(updateInfo == null ? storedInfo : updateInfo, newPath);
                    Document document = (Document)unsavedContents.get(file2);
                    String text = document == null ? null : document.getText();
                    String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, file2);
                    toOpenByRename.add(new TypeScriptOpenEditorCommand((VirtualFile)file2, info.myTimestamp, info.myContentLength, info.myLineCount, info.myLastLineStartOffset, text, projectFileName));
                }
            }
        });
        Collection toClose = filesToClose.stream().filter(el -> !filesToCloseByRename.contains(el)).map(el -> TypeScriptLanguageServiceCacheImpl.createCloseCommand(el, JSLanguageServiceUtil.normalizeNameAndPath(el))).collect(Collectors.toList());
        filesToClose.forEach(el -> this.myUpdateFiles.remove(el));
        this.myUpdateFiles.putAll(toUpdateCache);
        if (toChange.isEmpty() && toClose.isEmpty() && toOpen.isEmpty() && toCloseByRename.isEmpty() && toOpenByRename.isEmpty()) {
            return null;
        }
        Pair<Collection<TypeScriptCommandWithArguments>, Collection<TypeScriptCommandWithArguments>> openAndCloseExternals = this.getAndUpdateExternalConfigsCommand();
        Collection openExternal = (Collection)openAndCloseExternals.getFirst();
        Collection closeExternal = (Collection)openAndCloseExternals.getSecond();
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(openExternal);
        result2.addAll(toCloseByRename);
        result2.addAll(toOpen);
        result2.addAll(toOpenByRename);
        result2.addAll(toChange);
        result2.addAll(toClose);
        result2.addAll(closeExternal);
        return new TypeScriptCommandSetRequest(result2);
    }

    @NotNull
    private Pair<Collection<TypeScriptCommandWithArguments>, Collection<TypeScriptCommandWithArguments>> getAndUpdateExternalConfigsCommand() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myExternalConfigs.isEmpty() && !TypeScriptConfigUtil.hasConfigsWithNonStandardName(this.myProject)) {
            Pair pair = Pair.create((Object)ContainerUtil.emptyList(), (Object)ContainerUtil.emptyList());
            if (pair == null) {
                TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Set actualExternalConfigs = Streams.concat((Stream[])new Stream[]{this.myUpdateFiles.keySet().stream(), this.myOpenedFilesByEvent.stream()}).map(file2 -> TypeScriptConfigUtil.getConfigForFile(this.myProject, file2)).filter(el -> el != null).filter(el -> TypeScriptConfigUtil.isNonStandardName(el)).map(el -> el.getConfigFile()).collect(Collectors.toSet());
        HashSet toClose = ContainerUtil.newHashSet(this.myExternalConfigs);
        toClose.removeAll(actualExternalConfigs);
        HashSet toOpen = ContainerUtil.newHashSet(actualExternalConfigs);
        toOpen.removeAll(this.myExternalConfigs);
        this.myExternalConfigs.clear();
        this.myExternalConfigs.addAll(actualExternalConfigs);
        Pair pair = Pair.create(TypeScriptLanguageServiceCacheImpl.convertToCommands(toOpen, (Function<String, TypeScriptCommandWithArguments>)((Function)TypeScriptOpenExternalProjectRequest::new)), TypeScriptLanguageServiceCacheImpl.convertToCommands(toClose, (Function<String, TypeScriptCommandWithArguments>)((Function)TypeScriptCloseExternalProjectRequest::new)));
        if (pair == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    private static Set<TypeScriptCommandWithArguments> convertToCommands(@NotNull Set<VirtualFile> toOpen, @NotNull Function<String, TypeScriptCommandWithArguments> factory) {
        if (toOpen == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(6);
        }
        if (factory == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(7);
        }
        Set<TypeScriptCommandWithArguments> set = toOpen.stream().map(el -> JSLanguageServiceUtil.normalizeNameAndPath(el)).filter(el -> el != null).map(el -> {
            if (factory == null) {
                TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(17);
            }
            return (TypeScriptCommandWithArguments)factory.fun(el);
        }).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static TypeScriptCloseEditorCommand createCloseCommand(@NotNull VirtualFile el, @Nullable String path) {
        if (el == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(9);
        }
        TypeScriptFileObject object = new TypeScriptFileObject();
        object.file = LocalFilePath.create(path);
        TypeScriptCloseEditorCommand typeScriptCloseEditorCommand = new TypeScriptCloseEditorCommand(object, el);
        if (typeScriptCloseEditorCommand == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(10);
        }
        return typeScriptCloseEditorCommand;
    }

    private Collection<VirtualFile> getFilesToOpen(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(11);
        }
        return currentChangedFiles.keySet().stream().filter(el -> !this.myUpdateFiles.containsKey(el)).collect(Collectors.toList());
    }

    private Collection<VirtualFile> getFilesToChange(@NotNull Map<VirtualFile, Long> currentChangedFiles, @NotNull Collection<VirtualFile> filesToOpen) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(12);
        }
        if (filesToOpen == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(13);
        }
        ArrayList realChangedFiles = ContainerUtil.newArrayList();
        currentChangedFiles.forEach((file2, modified) -> {
            if (filesToOpen == null) {
                TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(16);
            }
            if (filesToOpen.contains(file2)) {
                return;
            }
            LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file2);
            if (lastUpdateInfo == null) {
                JSLanguageServiceQueue.LOGGER.error("Incorrect cache");
                return;
            }
            long timeStamp = lastUpdateInfo.myTimestamp;
            if (modified < 0L || timeStamp == -1L || modified != timeStamp) {
                realChangedFiles.add(file2);
            }
        });
        return realChangedFiles;
    }

    @NotNull
    private Set<VirtualFile> getFilesToClose(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(14);
        }
        HashSet toClose = ContainerUtil.newHashSet();
        for (VirtualFile file2 : this.myUpdateFiles.keySet()) {
            if (currentChangedFiles.containsKey(file2) || this.myOpenedFilesByEvent.contains(file2)) continue;
            toClose.add(file2);
        }
        HashSet hashSet = toClose;
        if (hashSet == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        this.clear();
        this.myExternalConfigs.clear();
        this.myOpenedFilesByEvent.clear();
        this.myUpdateFiles.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toOpen";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentChangedFiles";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOpen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndUpdateExternalConfigsCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommands";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCloseCommand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToClose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateCacheAndGetServiceObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetCloseEditorCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetOpenEditorCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesServiceObject";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommands";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCloseCommand";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToOpen";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToChange";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToClose";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilesToChange$19";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$convertToCommands$17";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateCacheAndGetServiceObject$3";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateCacheAndGetServiceObject$2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateCacheAndGetServiceObject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LastUpdateInfo {
        private final long myTimestamp;
        private final long myContentLength;
        private final int myLineCount;
        private final int myLastLineStartOffset;
        private final String myLastPath;

        public LastUpdateInfo(@NotNull LastUpdateInfo toCopy, @NotNull String newPath) {
            if (toCopy == null) {
                LastUpdateInfo.$$$reportNull$$$0(0);
            }
            if (newPath == null) {
                LastUpdateInfo.$$$reportNull$$$0(1);
            }
            this.myTimestamp = toCopy.myTimestamp;
            this.myContentLength = toCopy.myContentLength;
            this.myLineCount = toCopy.myLineCount;
            this.myLastLineStartOffset = toCopy.myLastLineStartOffset;
            this.myLastPath = newPath;
        }

        public LastUpdateInfo(String path, long timestamp, long contentLength, int lineCount, int lastLineStartOffset) {
            this.myTimestamp = timestamp;
            this.myContentLength = contentLength;
            this.myLineCount = lineCount;
            this.myLastLineStartOffset = lastLineStartOffset;
            this.myLastPath = path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl$LastUpdateInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

