/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedMembersByKindIndex;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportCompletionUtil {
    @NotNull
    public static final JSInsertHandler IMPORT_INSERT_HANDLER = new JSInsertHandler(){

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            ES6ImportCompletionUtil.insertLookupItem(context, item, (Consumer<JSElement>)((Consumer)importedElement -> {
                PsiElement originalElement;
                if (importedElement != null && (originalElement = context.getFile().findElementAt(context.getStartOffset())) != null) {
                    PsiElement toProcessPlace;
                    PsiElement psiElement = toProcessPlace = originalElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER ? originalElement.getParent() : originalElement;
                    if (toProcessPlace instanceof JSReferenceExpression && toProcessPlace.isValid()) {
                        context.commitDocument();
                        PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
                        JSInsertHandler.insertBracesIfNeed(context, (PsiElement)importedElement, toProcessPlace);
                    }
                }
            }));
        }
    };

    public static void addExportedVariants(@NotNull JSReferenceExpression expression, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(0);
        }
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(1);
        }
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(2);
        }
        assert (expression.getQualifier() == null);
        ES6ImportCompletionUtil.addExportedVariants((PsiElement)expression, sinkResults, completionResultSet);
    }

    public static void addExportedVariants(@NotNull ES6ImportExportSpecifier specifier, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (specifier == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(3);
        }
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(4);
        }
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(5);
        }
        ES6ImportCompletionUtil.addExportedVariants((PsiElement)specifier, sinkResults, completionResultSet);
    }

    private static void addExportedVariants(@NotNull PsiElement place, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (place == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(6);
        }
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(7);
        }
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(8);
        }
        if (ES6ImportCompletionUtil.skipPlace(place)) {
            return;
        }
        PsiFile containingFile = place.getContainingFile();
        THashSet<PsiElement> addedElements = ES6ImportCompletionUtil.getProcessedElements(sinkResults);
        Project project = containingFile.getProject();
        JSInsertHandler handler = IMPORT_INSERT_HANDLER;
        JSImportPlaceInfo info = new JSImportPlaceInfo(place);
        MultiMap symbolsToImport = MultiMap.createSet();
        ArrayList needToCheckConfigAccess = ContainerUtil.newArrayList();
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)containingFile, true);
        PrefixMatcher prefixMatcher = completionResultSet.getPrefixMatcher();
        boolean isTypeScript = DialectDetector.isTypeScript(place);
        boolean isImportSpecifier = place instanceof ES6ImportSpecifier;
        Processor processor = CommonProcessors.processAll(element -> {
            boolean canBeImported;
            if (completionResultSet == null) {
                ES6ImportCompletionUtil.$$$reportNull$$$0(18);
            }
            if (addedElements.contains(element)) {
                return;
            }
            if (element instanceof ES6ExportSpecifier && !ES6CreateImportUtil.isAcceptableExportSpecifier((ES6ExportSpecifier)element)) {
                return;
            }
            String name = ES6ImportPsiUtil.getExportedElementName(element);
            if (name == null || !prefixMatcher.prefixMatches(name)) {
                return;
            }
            boolean bl = element instanceof JSExportAssignment || (isImportSpecifier ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info)) ? true : (canBeImported = false);
            if (!canBeImported) {
                return;
            }
            Collection classes = symbolsToImport.get((Object)name);
            if (classes.contains(element.getClass())) {
                return;
            }
            Class<?> elementClass = element.getClass();
            symbolsToImport.putValue((Object)name, elementClass);
            PsiFile file2 = element.getContainingFile();
            if (!isTypeScript || file2 instanceof JSFile && ((JSFile)file2).isCommonJSModule()) {
                LookupElement item = ES6ImportCompletionUtil.createLookupElement(name, (PsiElement)element, handler);
                completionResultSet.addElement(item);
            } else {
                needToCheckConfigAccess.add(element);
            }
        });
        ES6ImportCompletionUtil.processExportedElementsForKey(project, "exp", scope, (Processor<JSElement>)processor);
        if (!isImportSpecifier) {
            ES6ImportCompletionUtil.processExportedElementsForKey(project, "def", scope, (Processor<JSElement>)processor);
        }
        needToCheckConfigAccess.forEach(element -> {
            if (completionResultSet == null) {
                ES6ImportCompletionUtil.$$$reportNull$$$0(17);
            }
            if (TypeScriptConfigService.Provider.isAccessible(project, info.getFile(), element.getContainingFile().getVirtualFile())) {
                String name = ES6ImportPsiUtil.getExportedElementName(element);
                assert (name != null);
                LookupElement item = ES6ImportCompletionUtil.createLookupElement(name, (PsiElement)element, handler);
                completionResultSet.addElement(item);
            }
        });
    }

    private static boolean skipPlace(@Nullable PsiElement place) {
        return TypeScriptPsiUtil.isTsIndexerType(place);
    }

    @NotNull
    public static THashSet<PsiElement> getProcessedElements(@NotNull Iterable sinkResults) {
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(9);
        }
        THashSet addedElements = new THashSet();
        for (Object object : sinkResults) {
            PsiElement sinkResult;
            if (object instanceof LookupElement) {
                sinkResult = ((LookupElement)object).getPsiElement();
            } else {
                if (!(object instanceof PsiElement)) continue;
                sinkResult = (PsiElement)object;
            }
            if (sinkResult instanceof ES6ImportExportSpecifier) {
                ResolveResult[] results;
                for (ResolveResult result2 : results = ((ES6ImportExportSpecifier)sinkResult).multiResolve(false)) {
                    PsiElement element = result2.getElement();
                    if (element == null) continue;
                    addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)element));
                }
                continue;
            }
            if (sinkResult == null) continue;
            addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)sinkResult));
        }
        THashSet tHashSet = addedElements;
        if (tHashSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(10);
        }
        return tHashSet;
    }

    private static void processExportedElementsForKey(Project project, String key, GlobalSearchScope scope, Processor<JSElement> processor) {
        StubIndex.getInstance().processElements(ES6ExportedMembersByKindIndex.KEY, (Object)key, project, scope, JSElement.class, processor);
    }

    private static LookupElement createLookupElement(@NotNull String name, @NotNull PsiElement element, @NotNull InsertHandler<LookupElement> handler) {
        if (name == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(12);
        }
        if (handler == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(13);
        }
        return JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler(handler).withIcon(JSLookupUtilImpl.getIcon(element, false)), JSLookupPriority.NO_RELEVANT_NO_SMARTNESS_PRIORITY);
    }

    public static void insertLookupItem(@NotNull InsertionContext context, @NotNull LookupElement item, @Nullable Consumer<JSElement> afterInsert) {
        if (context == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(14);
        }
        if (item == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(15);
        }
        context.commitDocument();
        CaretModel model = context.getEditor().getCaretModel();
        if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
            return;
        }
        PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
        if (originalElement == null || !ES6ImportCompletionUtil.shouldAddImportFromCompletion(originalElement)) {
            return;
        }
        String name = item.getLookupString();
        PsiElement psiElement = item.getPsiElement();
        ES6ImportAction action = ES6CreateImportUtil.createImportAction(context.getEditor(), originalElement, name, null, ES6ImportAction.DEFAULT_FILTER);
        if (psiElement instanceof JSElement) {
            action.executeFor((JSElement)psiElement, afterInsert);
        } else {
            action.executeForAllVariants(afterInsert);
        }
    }

    private static boolean shouldAddImportFromCompletion(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(16);
        }
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings.hasTSImportCompletionEffective(element.getProject()) : settings.isUseJavaScriptAutoImport();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResults";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExportedVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedElements";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "insertLookupItem";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddImportFromCompletion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExportedVariants$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExportedVariants$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

