/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.completion.ItemWithAction;
import com.intellij.lang.typescript.completion.TypeScriptSameSignatureCallParametersContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSmartCompletionContributor
extends JSSmartCompletionContributor {
    @Override
    @Nullable
    public List<LookupElement> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        List<LookupElement> variants;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (location.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(location) && !(variants = this.addVariantsForUnqualifiedReference(location)).isEmpty()) {
            return variants;
        }
        return TypeScriptSmartCompletionContributor.mergeVariants(TypeScriptSmartCompletionContributor.getVariantForDynamicallyNamedProperties(location), TypeScriptSmartCompletionContributor.mergeVariants(super.getSmartCompletionVariants(location), TypeScriptSameSignatureCallParametersContributor.getSameSignatureCallItems(location)));
    }

    @Nullable
    private static List<LookupElement> getVariantForDynamicallyNamedProperties(@NotNull JSReferenceExpression location) {
        JSExpression qualifier;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((qualifier = location.getQualifier()) == null) {
            return null;
        }
        JSType type = JSResolveUtil.getExpressionJSType(qualifier);
        if (type == null) {
            return null;
        }
        ArrayList results = ContainerUtil.newArrayList();
        TypeScriptLiteralKeyUtil.evalForAllProperties(type, (o, element, nestingDepth) -> {
            if (location == null) {
                TypeScriptSmartCompletionContributor.$$$reportNull$$$0(11);
            }
            TypeScriptSmartCompletionContributor.addVariantIfComputedProp(o, results, nestingDepth, (PsiElement)location);
            return false;
        }, true);
        return results.size() == 0 ? null : results;
    }

    @Nullable
    private static JSFieldVariable getConstByInitializerType(@NotNull JSLiteralType type) {
        PsiElement sourceElement;
        if (type == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((sourceElement = type.getSource().getSourceElement()) instanceof JSFieldVariable && ((JSFieldVariable)sourceElement).isConst()) {
            return (JSFieldVariable)sourceElement;
        }
        if (!(sourceElement instanceof JSLiteralExpression)) {
            return null;
        }
        JSFieldVariable variable = (JSFieldVariable)ObjectUtils.tryCast((Object)sourceElement.getParent(), JSFieldVariable.class);
        if (variable == null || variable.getInitializerOrStub() != sourceElement) {
            return null;
        }
        return variable;
    }

    @Nullable
    public static ItemWithAction getSpecialItemForCompletion(@NotNull JSComputedPropertyNameOwner member, PsiElement location) {
        ES6ComputedName computedPropertyName;
        if (member == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((computedPropertyName = member.getComputedPropertyName()) == null) {
            return null;
        }
        JSType expressionJSType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName));
        if (expressionJSType instanceof JSStringLiteralTypeImpl) {
            ItemWithAction indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, TypeScriptSmartCompletionContributor.getConstByInitializerType((JSLiteralType)expressionJSType));
            if (indexedItem != null) {
                return indexedItem;
            }
            String literal = ((JSStringLiteralTypeImpl)expressionJSType).getLiteral();
            char quoteChar = JSCodeStyleSettings.getQuoteChar((PsiElement)member);
            return new ItemWithAction(JSSymbolUtil.isValidPropertyName(literal) ? literal : JSSymbolUtil.handleSpecialPropertyNames(literal, quoteChar), null);
        }
        if (expressionJSType instanceof JSNumberLiteralTypeImpl) {
            ItemWithAction indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, TypeScriptSmartCompletionContributor.getConstByInitializerType((JSLiteralType)expressionJSType));
            if (indexedItem != null) {
                return indexedItem;
            }
            expressionJSType = ((JSNumberLiteralTypeImpl)expressionJSType).copyWithCanBeWidened(false);
            return new ItemWithAction(expressionJSType.getTypeText(JSType.TypeTextFormat.CODE), null);
        }
        if (expressionJSType instanceof JSUniqueSymbolTypeImpl) {
            JSFieldVariable element = ((JSUniqueSymbolTypeImpl)expressionJSType).getElement();
            return TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, element);
        }
        return null;
    }

    private static ActionState getActionState(JSQualifiedNamedElement elementToImport, PsiElement location) {
        PsiFile originalFile = (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)location.getContainingFile());
        if (elementToImport.getContainingFile() == originalFile) {
            return ActionState.Available;
        }
        return ES6CreateImportUtil.isAvailableForImport((PsiElement)elementToImport, location) ? ActionState.ShouldImport : ActionState.NotAvailable;
    }

    @Nullable
    private static ItemWithAction getIndexerItemForVariableIfAvailable(@NotNull PsiElement location, @Nullable JSFieldVariable element) {
        ActionState state;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        if (element == null) {
            return null;
        }
        String name = element.getName();
        if (name == null) {
            return null;
        }
        JSFieldVariable elementToImport = element;
        if (element instanceof JSField) {
            JSClass context = JSResolveUtil.getClassOfContext((PsiElement)element);
            if (context == null) {
                return null;
            }
            elementToImport = context;
            name = context.getName() + "." + name;
        }
        if (!(state = TypeScriptSmartCompletionContributor.getActionState((JSQualifiedNamedElement)elementToImport, location)).isAvailable()) {
            return null;
        }
        JSFieldVariable finalElementToImport = elementToImport;
        return new ItemWithAction("[" + name + "]", state.getAction(location, (JSQualifiedNamedElement)finalElementToImport));
    }

    private static void importIfNeeded(PsiFile originalFile, JSQualifiedNamedElement finalElementToImport) {
        ES6CreateImportUtil.insertImport((PsiElement)originalFile, finalElementToImport, finalElementToImport.getName());
        ES6CreateImportUtil.optimizeImports((PsiElement)originalFile);
    }

    private static void addVariantIfComputedProp(@Nullable Object member, @NotNull List<LookupElement> results, int nestingDepth, PsiElement location) {
        if (results == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(5);
        }
        if (!(member instanceof ES6Property) && !(member instanceof JSField)) {
            return;
        }
        ItemWithAction nameForCompletion = TypeScriptSmartCompletionContributor.getSpecialItemForCompletion((JSComputedPropertyNameOwner)member, location);
        if (nameForCompletion != null) {
            results.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)member, nameForCompletion.item, JSLookupPriority.getNestingLevelPriority(nestingDepth), true, false, null, !JSSymbolUtil.isValidPropertyName(nameForCompletion.item), null, nameForCompletion.importAction));
        }
    }

    @Override
    protected void processSingleLiteralVariant(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, JSType type) {
        String enumFieldName;
        ActionState state;
        TypeScriptEnumField field;
        TypeScriptEnum typeScriptEnum;
        JSResolvedTypeInfo resolvedType;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(6);
        }
        if (literalVariants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(7);
        }
        super.processSingleLiteralVariant(location, insideStringLiteral, literalVariants, type);
        if (insideStringLiteral) {
            return;
        }
        if (type instanceof JSResolvableType && type.isTypeScript() && (resolvedType = ((JSResolvableType)type).resolveType()).isEnumLiteral() && (typeScriptEnum = (TypeScriptEnum)JSUtils.getMemberContainingClass((PsiElement)(field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class)))) != null && (state = TypeScriptSmartCompletionContributor.getActionState((JSQualifiedNamedElement)typeScriptEnum, (PsiElement)location)).isAvailable() && (enumFieldName = TypeScriptSmartCompletionContributor.getEnumFieldName(typeScriptEnum, field.getName(), location)) != null) {
            LookupElement prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)field, enumFieldName, JSLookupPriority.SMART_PRIORITY, false, false, null, false, null, state.getAction((PsiElement)location, (JSQualifiedNamedElement)typeScriptEnum));
            literalVariants.add(prioritizedLookupItem);
        }
        if (location instanceof JSReferenceExpression && JSTypeUtils.isEnumType(type)) {
            Collection<? extends PsiElement> resolvedElements = TypeScriptTypeParser.resolveElementsByType(type);
            for (PsiElement psiElement : resolvedElements) {
                JSField[] fields;
                if (!(psiElement instanceof TypeScriptEnum)) continue;
                for (JSField field2 : fields = ((TypeScriptEnum)psiElement).getFields()) {
                    ActionState state2;
                    String fieldName = field2.getName();
                    String enumFieldName2 = TypeScriptSmartCompletionContributor.getEnumFieldName((TypeScriptEnum)psiElement, fieldName, location);
                    if (enumFieldName2 == null || !(state2 = TypeScriptSmartCompletionContributor.getActionState((JSQualifiedNamedElement)psiElement, (PsiElement)location)).isAvailable()) continue;
                    literalVariants.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)field2, enumFieldName2, JSLookupPriority.SMART_PRIORITY, true, false, null, false, null, state2.getAction((PsiElement)location, (JSQualifiedNamedElement)psiElement)));
                }
            }
        }
    }

    @Nullable
    private static String getEnumFieldName(TypeScriptEnum element, String fieldName, JSExpression location) {
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        JSType type = JSNamedTypeFactory.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)element, true), JSTypeContext.INSTANCE);
        String name = TypeScriptUtil.getShortestTypeNameInContext(type, (PsiElement)location);
        return name + "." + fieldName;
    }

    @Override
    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<LookupElement> variants) {
        List<LookupElement> result2;
        JSType typedef;
        if (expectedType == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(8);
        }
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(9);
        }
        if (variants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(10);
        }
        if (expectedType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)expectedType).getTypedef()) != null) {
            expectedType = typedef;
        }
        if ((result2 = this.getLiteralVariantsForExpectedType((JSExpression)location, false, expectedType)) != null) {
            variants.addAll(result2);
        }
        super.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
    }

    @Override
    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalVariants";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSmartCompletionVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariantForDynamicallyNamedProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstByInitializerType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecialItemForCompletion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexerItemForVariableIfAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariantIfComputedProp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processSingleLiteralVariant";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariantsForUnqualifiedExpectedType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getVariantForDynamicallyNamedProperties$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ActionState {
        Available,
        NotAvailable,
        ShouldImport;


        public boolean isAvailable() {
            return this == Available || this == ShouldImport;
        }

        public Runnable getAction(PsiElement location, JSQualifiedNamedElement finalElementToImport) {
            if (this == Available) {
                return null;
            }
            PsiFile originalFile = (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)location.getContainingFile());
            return () -> TypeScriptSmartCompletionContributor.importIfNeeded(originalFile, finalElementToImport);
        }
    }
}

