/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.inspection.SuspiciousTypeOfGuardInspection;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SuspiciousInstanceOfGuardInspection
extends JSInspection {
    public static final String SHORT_NAME = SuspiciousInstanceOfGuardInspection.calcShortNameFromClass(SuspiciousInstanceOfGuardInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SuspiciousInstanceOfGuardInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            SuspiciousInstanceOfGuardInspection.$$$reportNull$$$0(1);
        }
        if (!DialectDetector.isTypeScript((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SuspiciousInstanceOfGuardInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression expression) {
                ProcessingContext context;
                IElementType sign = expression.getOperationSign();
                if (sign != JSTokenTypes.INSTANCEOF_KEYWORD) {
                    return;
                }
                JSExpression lOperand = expression.getLOperand();
                JSExpression rOperand = expression.getROperand();
                if (!(lOperand instanceof JSReferenceExpression) || rOperand == null) {
                    return;
                }
                PsiElement instanceOf = JSRefactoringUtil.skipWhitespaces(lOperand.getNextSibling(), true);
                if (instanceOf == null) {
                    return;
                }
                JSType lType = JSResolveUtil.getExpressionJSType(lOperand);
                if (lType == null || lType instanceof JSAnyType) {
                    return;
                }
                lType = lType.transformTypeHierarchy(t -> SuspiciousTypeOfGuardInspection.getGenericConstraintSelfOrAny(t));
                JSType rType = JSResolveUtil.getExpressionJSType(rOperand);
                if (!(rType instanceof JSTypeImpl)) {
                    return;
                }
                if ((rType = TypeScriptUtil.getConstructedType(rType, rOperand)).isDirectlyAssignableType(lType, context = JSTypeComparingContextService.getSubtypingProcessingContext((PsiElement)expression))) {
                    Ref inheritor = Ref.create((Object)false);
                    if (this.checkInherits(lType, rType, (Ref<Boolean>)inheritor)) {
                        return;
                    }
                    if (lType instanceof JSCompositeTypeImpl) {
                        for (JSType part : ((JSCompositeTypeImpl)lType).getTypes()) {
                            if (!this.checkInherits(part, rType, (Ref<Boolean>)inheritor)) continue;
                            return;
                        }
                    }
                    holder.registerProblem(instanceOf, JSBundle.message((String)(inheritor.get() == Boolean.TRUE ? "typescript.redundant.instanceof.inheritor.guard" : "typescript.redundant.instanceof.guard"), (Object[])new Object[]{((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (lType.isDirectlyAssignableType(rType, context)) {
                    return;
                }
                if (lType instanceof JSCompositeTypeImpl) {
                    for (JSType part : ((JSCompositeTypeImpl)lType).getTypes()) {
                        if (!part.isDirectlyAssignableType(rType, context) && !rType.isDirectlyAssignableType(part, context)) continue;
                        return;
                    }
                }
                holder.registerProblem(instanceOf, JSBundle.message((String)"typescript.suspicious.instanceof.guard", (Object[])new Object[]{((JSReferenceExpression)lOperand).getReferenceName(), rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }

            private boolean checkInherits(@NotNull JSType lType, @NotNull JSType rType, @NotNull Ref<Boolean> inheritor) {
                if (lType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (inheritor == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSResolvableType rResolvable = (JSResolvableType)ObjectUtils.tryCast((Object)TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(rType), JSResolvableType.class);
                JSResolvableType lResolvable = (JSResolvableType)ObjectUtils.tryCast((Object)TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(lType), JSResolvableType.class);
                if (lResolvable == null || rResolvable == null) {
                    return false;
                }
                JSClass lClass = lResolvable.resolveType().getDeclarationOfType(JSClass.class);
                JSClass rClass = rResolvable.resolveType().getDeclarationOfType(JSClass.class);
                if (lClass != null && rClass != null && lClass != rClass && !JSInheritanceUtil.isParentClass(lClass, rClass)) {
                    return true;
                }
                inheritor.set((Object)true);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "lType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "inheritor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/inspection/SuspiciousInstanceOfGuardInspection$1";
                objectArray[2] = "checkInherits";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            SuspiciousInstanceOfGuardInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/SuspiciousInstanceOfGuardInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/SuspiciousInstanceOfGuardInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

