/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportAction
extends ES6ImportAction {
    public TypeScriptImportAction(@Nullable Editor editor, @Nullable PsiElement context, @Nullable String name, @NotNull ES6ImportAction.ImportElementFilter filter) {
        if (filter == null) {
            TypeScriptImportAction.$$$reportNull$$$0(0);
        }
        super(editor, context, name, filter);
    }

    @Override
    @NotNull
    protected List<JSElement> additionalProcessCandidates(@NotNull JSImportPlaceInfo info, @NotNull List<JSElement> candidates) {
        if (info == null) {
            TypeScriptImportAction.$$$reportNull$$$0(1);
        }
        if (candidates == null) {
            TypeScriptImportAction.$$$reportNull$$$0(2);
        }
        assert (this.myContext != null);
        for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(this.myContext.getProject(), this.myContext)) {
            String moduleName = module.getExternalModuleText();
            if (moduleName == null || !StringUtil.unquoteString((String)moduleName).equalsIgnoreCase(this.myName)) continue;
            candidates.add((JSElement)module);
            break;
        }
        List<JSElement> list = candidates.stream().filter(el -> {
            if (info == null) {
                TypeScriptImportAction.$$$reportNull$$$0(10);
            }
            return this.isAccessibleModule(info, (JSElement)el) && !TypeScriptImportAction.isOverloadDeclaration(el);
        }).collect(Collectors.toList());
        if (list == null) {
            TypeScriptImportAction.$$$reportNull$$$0(3);
        }
        return list;
    }

    private boolean isAccessibleModule(@NotNull JSImportPlaceInfo info, @NotNull JSElement el) {
        if (info == null) {
            TypeScriptImportAction.$$$reportNull$$$0(4);
        }
        if (el == null) {
            TypeScriptImportAction.$$$reportNull$$$0(5);
        }
        assert (this.myContext != null);
        PsiFile file2 = el.getContainingFile();
        if (!(file2 instanceof JSFile)) {
            return false;
        }
        return ((JSFile)file2).isCommonJSModule() || TypeScriptConfigService.Provider.isAccessible(this.myContext.getProject(), info.getFile(), file2.getVirtualFile());
    }

    private static boolean isOverloadDeclaration(@NotNull JSElement element) {
        if (element == null) {
            TypeScriptImportAction.$$$reportNull$$$0(6);
        }
        return element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration();
    }

    @Override
    protected void runAction(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            TypeScriptImportAction.$$$reportNull$$$0(7);
        }
        if (elementToImport == null) {
            TypeScriptImportAction.$$$reportNull$$$0(8);
        }
        if (place == null) {
            TypeScriptImportAction.$$$reportNull$$$0(9);
        }
        assert (this.myContext != null);
        PsiFile containingFile = this.myContext.getContainingFile();
        if (containingFile instanceof JSExpressionCodeFragment) {
            ((JSExpressionCodeFragment)containingFile).importElement(elementToImport);
        } else {
            TypeScriptAutoImportUtil.addImportStatement(editor, name, elementToImport, place);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptImportAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptImportAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "additionalProcessCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "additionalProcessCandidates";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOverloadDeclaration";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$additionalProcessCandidates$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

