/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPsiUtil {
    public static final Condition<PsiElement> IS_TS_MODULE = Conditions.instanceOf(TypeScriptModule.class);
    private static final String THIS_NAME = "this";

    private TypeScriptPsiUtil() {
    }

    @Nullable
    public static JSType getTypeFromDeclaration(StubBasedPsiElementBase element) {
        TypeScriptType resultType = TypeScriptPsiUtil.getStubOrPsiTypeElement(element);
        return resultType == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)resultType);
    }

    @Nullable
    public static JSTypeDeclaration unparenthesizeType(@Nullable JSTypeDeclaration type) {
        while (type instanceof TypeScriptParenthesizedType) {
            type = ((TypeScriptParenthesizedType)type).getInnerType();
        }
        return type;
    }

    @Nullable
    public static PsiElement getParentSkipTypeParentheses(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(0);
        }
        return PsiTreeUtil.skipParentsOfType((PsiElement)type, (Class[])new Class[]{TypeScriptParenthesizedType.class});
    }

    @Nullable
    public static JSClass getParentClass(@Nullable PsiElement element) {
        PsiElement secondParent;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSClass) {
            return (JSClass)parent;
        }
        if (parent instanceof TypeScriptObjectType && (secondParent = parent.getParent()) instanceof JSClass) {
            return (JSClass)secondParent;
        }
        return null;
    }

    public static boolean hasImplicitExportForDeclarations(@Nullable PsiElement moduleOrFile) {
        if (moduleOrFile instanceof TypeScriptModule) {
            return ((TypeScriptModule)moduleOrFile).hasImplicitExportForDeclarations();
        }
        if (moduleOrFile instanceof JSFile) {
            if (!((JSFile)moduleOrFile).isCommonJSModule()) {
                return false;
            }
            if (TypeScriptUtil.isDefinitionFile((PsiFile)((JSFile)moduleOrFile))) {
                return !TypeScriptPsiUtil.hasExportStatements(moduleOrFile);
            }
        }
        return false;
    }

    public static boolean hasExportStatements(@NotNull PsiElement moduleOrFile) {
        ES6ImportHandler.ES6ExportCache cache;
        if (moduleOrFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(1);
        }
        return (cache = ES6ImportHandler.getExportedCacheForModule(moduleOrFile)) != null && cache.hasExportStatements();
    }

    public static boolean isAmbientDeclaration(@Nullable PsiElement element) {
        if (element instanceof JSAttributeListOwner) {
            while (element != null && !(element instanceof JSFile)) {
                if (TypeScriptPsiUtil.hasAmbientAttribute((JSAttributeListOwner)element)) {
                    return true;
                }
                element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, TypeScriptModule.class, JSFile.class});
            }
            if (element != null && TypeScriptUtil.isDefinitionFile((PsiFile)((JSFile)element))) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAmbientAttribute(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(2);
        }
        if (element instanceof JSProperty || element instanceof JSRecordType.CallSignature || element instanceof JSRecordType.IndexSignature) {
            return false;
        }
        if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isGlobalScopeAugmentation()) {
            return true;
        }
        JSAttributeList list = element.getAttributeList();
        return list != null && list.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isNamedTypeDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportExportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof TypeScriptEnumField;
    }

    public static boolean isNamedTypeContainerDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || TypeScriptPsiUtil.isNamespaceDefinition(element);
    }

    public static boolean isNamespaceDefinition(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ExportDefaultAssignment || element instanceof JSFile || element instanceof ES6ImportExportSpecifier || element instanceof TypeScriptGlobalModuleExportDeclaration;
    }

    @Nullable
    public static TypeScriptExportAssignment findExportAssignment(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isTypeScript(module)) {
            return null;
        }
        TypeScriptExportAssignment exportAssignment = null;
        if (module instanceof PsiFileImpl) {
            StubElement stub = ((PsiFileImpl)module).getStub();
            if (stub != null) {
                StubElement exportAssignmentStub = stub.findChildStubByType(TypeScriptElementTypes.EXPORT_ASSIGNMENT);
                if (exportAssignmentStub != null) {
                    exportAssignment = (TypeScriptExportAssignment)exportAssignmentStub.getPsi();
                }
            } else {
                exportAssignment = (TypeScriptExportAssignment)((PsiFileImpl)module).findChildByClass(TypeScriptExportAssignment.class);
            }
        } else if (module instanceof TypeScriptModuleImpl) {
            exportAssignment = (TypeScriptExportAssignment)((TypeScriptModuleImpl)module).getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.EXPORT_ASSIGNMENT);
        }
        return exportAssignment;
    }

    public static boolean isClassMember(JSParameter parameter) {
        return TypeScriptPsiUtil.isFieldParameter(parameter);
    }

    @Nullable
    public static String getNameFromIdentifierOwner(@NotNull JSNamedElement identifierOwner) {
        String nameFromComputed;
        if (identifierOwner == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(4);
        }
        if (identifierOwner instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)identifierOwner).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        return TypeScriptPsiUtil.getNameFromIdentifier(identifierOwner.findNameIdentifier());
    }

    @Nullable
    public static String getNameFromIdentifier(@Nullable ASTNode identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            identifier = identifier.getFirstChildNode();
        }
        if (identifier == null) {
            return null;
        }
        if (JSTokenTypes.STRING_LITERALS.contains(identifier.getElementType())) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(identifier.getText());
        }
        return identifier.getText();
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(5);
        }
        return (TypeScriptType)ArrayUtil.getFirstElement((Object[])TypeScriptPsiUtil.getStubOrPsiTypeElements(element));
    }

    @NotNull
    public static TypeScriptType[] getStubOrPsiTypeElements(@NotNull StubBasedPsiElementBase element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(6);
        }
        TypeScriptType[] typeScriptTypeArray = (TypeScriptType[])element.getStubOrPsiChildren(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY);
        if (typeScriptTypeArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(7);
        }
        return typeScriptTypeArray;
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase element, int index) {
        TypeScriptType[] elements;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(8);
        }
        return (elements = TypeScriptPsiUtil.getStubOrPsiTypeElements(element)).length > index ? elements[index] : null;
    }

    @Nullable
    public static TypeScriptType getPsiTypeElement(@NotNull JSElementImpl element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(9);
        }
        return (TypeScriptType)ArrayUtil.getFirstElement((Object[])element.getChildrenAsPsiElements(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY));
    }

    public static boolean isTopLevelContainer(@Nullable PsiElement element) {
        return element instanceof JSFile || element instanceof TypeScriptModule || element instanceof JSEmbeddedContent && !(element.getContainingFile() instanceof JSFile);
    }

    public static boolean isTopLevelContainerMember(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(10);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentOverDefaultAssignable(element);
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    public static boolean isTopLevelContainerMember(@NotNull JSQualifiedObjectStubBase<?> stubElement) {
        StubElement parentStub;
        if (stubElement == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(11);
        }
        if ((parentStub = stubElement.getParentStub()) != null && parentStub.getStubType() == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            parentStub = parentStub.getParentStub();
        }
        if (parentStub != null && JSElementTypes.VAR_STATEMENTS.contains((IElementType)parentStub.getStubType())) {
            parentStub = parentStub.getParentStub();
        }
        IStubElementType type = parentStub != null ? parentStub.getStubType() : null;
        return type == JSStubElementTypes.TYPESCRIPT_MODULE || type == null;
    }

    public static PsiElement getParentOverDefaultAssignable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(12);
        }
        if ((parent = element.getContext()) instanceof ES6ExportDefaultAssignment) {
            parent = parent.getContext();
        }
        return parent;
    }

    public static boolean isAmbientModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(13);
        }
        return module.isGlobalScopeAugmentation() || !module.isInternal();
    }

    public static boolean isModule(PsiElement element, boolean includeInternal) {
        return element instanceof JSFile && ((JSFile)element).isCommonJSModule() || element instanceof TypeScriptModule && (includeInternal || !((TypeScriptModule)element).isInternal());
    }

    public static boolean isAugmentationModule(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule && ((TypeScriptModule)element).isAugmentation();
    }

    public static boolean isFromAugmentationModule(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(14);
        }
        return TypeScriptPsiUtil.isAugmentationModule(ES6PsiUtil.findExternalModule(element));
    }

    public static boolean isAbstractElement(@NotNull JSAttributeListOwner element) {
        JSAttributeList list;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(15);
        }
        if ((list = element.getAttributeList()) == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public static boolean referencesNamedTypeContainer(@NotNull ES6ImportExportSpecifier specifier) {
        ResolveResult[] results;
        if (specifier == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(16);
        }
        if ((results = specifier.resolveOverAliases()).length == 0) {
            return true;
        }
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (!TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFieldParameter(@NotNull JSParameter parameter) {
        JSAttributeList list;
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(17);
        }
        return (list = parameter.getAttributeList()) != null && (list.getExplicitAccessType() != null || list.hasModifier(JSAttributeList.ModifierType.READONLY));
    }

    public static boolean isThisParameter(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(18);
        }
        return THIS_NAME.equals(parameter.getName());
    }

    @Nullable
    public static JSParameter getThisParameter(@NotNull JSFunction function) {
        JSParameterList list;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(19);
        }
        if (!((list = function.getParameterList()) instanceof TypeScriptParameterListImpl)) {
            return null;
        }
        JSParameter[] parameters = ((TypeScriptParameterListImpl)list).getRawParameters();
        if (parameters.length == 0) {
            return null;
        }
        JSParameter parameter = parameters[0];
        return TypeScriptPsiUtil.isThisParameter((JSParameterItem)parameter) ? parameter : null;
    }

    @Nullable
    public static JSType getThisParameterType(@NotNull JSFunction function) {
        JSParameter thisParameter;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(20);
        }
        return (thisParameter = TypeScriptPsiUtil.getThisParameter(function)) == null ? null : thisParameter.getType();
    }

    @NotNull
    public static TypeScriptFunction getLastOverload(@NotNull TypeScriptFunction function) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(21);
        }
        TypeScriptFunction prev = null;
        if (!function.isOverloadDeclaration()) {
            TypeScriptFunction typeScriptFunction = function;
            if (typeScriptFunction == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(22);
            }
            return typeScriptFunction;
        }
        for (TypeScriptFunction currentFunction = function; currentFunction != null; currentFunction = currentFunction.getNextOverloadOrImplementation()) {
            prev = currentFunction;
        }
        TypeScriptFunction typeScriptFunction = prev;
        if (typeScriptFunction == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(23);
        }
        return typeScriptFunction;
    }

    @NotNull
    public static Collection<? extends JSFunctionItem> getAllOverloadSignatures(@NotNull TypeScriptFunction functionItem) {
        TypeScriptFunction implementation;
        if (functionItem == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(24);
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        boolean isOverloadImpl = functionItem.isOverloadImplementation();
        if (!isOverloadImpl) {
            result2.add(functionItem);
        }
        result2.addAll(TypeScriptPsiUtil.getAllOverloadsWithImplementation(functionItem));
        TypeScriptFunction typeScriptFunction = implementation = isOverloadImpl ? functionItem : TypeScriptPsiUtil.getOverloadImplementation(functionItem);
        if (implementation != null) {
            result2.remove(implementation);
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(25);
        }
        return linkedHashSet;
    }

    @Nullable
    public static TypeScriptFunction getOverloadImplementation(@NotNull TypeScriptFunction function) {
        TypeScriptFunction overload;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(26);
        }
        return (overload = TypeScriptPsiUtil.getLastOverload(function)) != function && overload.isOverloadImplementation() ? overload : null;
    }

    public static Collection<TypeScriptFunction> getAllOverloadsWithImplementation(@NotNull TypeScriptFunction function) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(27);
        }
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)function);
        String name = function.getName();
        if (name != null && containingClass instanceof TypeScriptInterfaceClass) {
            JSFunction.FunctionKind kind = "constructor".equals(name) ? JSFunction.FunctionKind.CONSTRUCTOR : JSFunction.FunctionKind.SIMPLE;
            TypeScriptFunction[] functions = ((TypeScriptInterfaceClass)containingClass).findFunctionsByNameAndKind(name, kind);
            boolean isStatic = JSPsiImplUtils.hasModifier((JSAttributeListOwner)function, JSAttributeList.ModifierType.STATIC);
            Set<TypeScriptFunction> result2 = Arrays.stream(functions).filter(f -> JSPsiImplUtils.hasModifier((JSAttributeListOwner)f, JSAttributeList.ModifierType.STATIC) == isStatic).collect(Collectors.toSet());
            result2.remove(function);
            return result2;
        }
        TypeScriptFunction overload = TypeScriptPsiUtil.getLastOverload(function);
        LinkedHashSet result3 = overload == function ? ContainerUtil.newLinkedHashSet() : ContainerUtil.newLinkedHashSet((Object[])new TypeScriptFunction[]{overload});
        result3.addAll(overload.getOverloadDeclarations());
        result3.remove(function);
        return result3;
    }

    public static ResolveResult[] chooseOverload(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(28);
        }
        Arrays.sort(resolveResults, TypeScriptSignatureChooser.FUNCTIONS_FIRST_RESOLVE_RESULT);
        ResolveResult resultWithLiteralArguments = null;
        block0: for (ResolveResult result2 : resolveResults) {
            PsiElement element;
            if (!result2.isValidResult() || !((element = result2.getElement()) instanceof TypeScriptFunction)) continue;
            for (JSParameterListElement listElement : ((TypeScriptFunction)element).getParameters()) {
                if (!(listElement.getTypeElement() instanceof TypeScriptStringLiteralType)) continue;
                resultWithLiteralArguments = result2;
                break block0;
            }
        }
        ResolveResult result3 = resultWithLiteralArguments != null ? resultWithLiteralArguments : (ResolveResult)ArrayUtil.getFirstElement((Object[])resolveResults);
        return new ResolveResult[]{result3};
    }

    public static ResolveResult[] removeDuplicates(@NotNull ResolveResult[] resolveResults, @Nullable PsiElement place) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(29);
        }
        if (resolveResults.length > 20) {
            return resolveResults;
        }
        if (place == null || DialectDetector.isTypeScript(place) || resolveResults.length <= 1) {
            return resolveResults;
        }
        if (!TypeScriptPsiUtil.elementsCanBeMerged(resolveResults)) {
            return resolveResults;
        }
        JSCoreLibraryElementsCollector<ResolveResult> collector = new JSCoreLibraryElementsCollector<ResolveResult>();
        ArrayList newResult = ContainerUtil.newArrayList();
        for (ResolveResult result2 : resolveResults) {
            PsiElement element = result2.getElement();
            if (collector.isLibraryElement(element)) {
                collector.addElement(element, result2);
                continue;
            }
            newResult.add(result2);
        }
        Collection values = collector.getValues();
        for (ResolveResult currentResult : resolveResults) {
            if (!values.contains(currentResult)) continue;
            newResult.add(currentResult);
        }
        return newResult.toArray(ResolveResult.EMPTY_ARRAY);
    }

    public static boolean elementsCanBeMerged(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(30);
        }
        for (ResolveResult result2 : resolveResults) {
            if (!result2.isValidResult()) {
                return false;
            }
            PsiElement element = result2.getElement();
            if (element instanceof TypeScriptFunction || element instanceof TypeScriptVariable || element instanceof TypeScriptField) continue;
            return false;
        }
        return true;
    }

    public static boolean isImplementationAndOverloadFunction(PsiElement _element, PsiElement resolvedElement) {
        if (_element instanceof TypeScriptFunction && resolvedElement instanceof TypeScriptFunction) {
            TypeScriptFunction function = (TypeScriptFunction)_element;
            TypeScriptFunction resolvedFunction = (TypeScriptFunction)resolvedElement;
            if (resolvedFunction.isOverloadDeclaration() && function.isOverloadImplementation() && function.getOverloadDeclarations().contains(resolvedFunction)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getMemberName(@NotNull JSComputedPropertyNameOwner function) {
        String name;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(31);
        }
        if ((name = function.getName()) == null) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets(function);
        }
        String string = name == null ? "" : JSStringUtil.unquoteAndUnescapeString(name);
        if (string == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    public static boolean isLiteralModuleAugmentationName(@Nullable PsiElement element) {
        PsiElement parent;
        return element instanceof JSLiteralExpression && (parent = element.getParent()) instanceof TypeScriptModule && element.isEquivalentTo(((TypeScriptModule)parent).getNameIdentifier());
    }

    @NotNull
    public static TypeScriptTypeParameter[] getTypeParametersForOwner(@Nullable PsiElement sourceElement) {
        if (!(sourceElement instanceof TypeScriptTypeParameterListOwner)) {
            if (TypeScriptTypeParameter.EMPTY_ARRAY == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(33);
            }
            return TypeScriptTypeParameter.EMPTY_ARRAY;
        }
        TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameterList();
        TypeScriptTypeParameter[] typeScriptTypeParameterArray = list == null ? TypeScriptTypeParameter.EMPTY_ARRAY : list.getTypeParameters();
        if (typeScriptTypeParameterArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(34);
        }
        return typeScriptTypeParameterArray;
    }

    @NotNull
    public static JSTypeDeclaration[] getNewExpressionTypeArguments(@NotNull PsiElement expression) {
        if (expression == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(35);
        }
        if (expression instanceof TypeScriptNewExpression) {
            TypeScriptNewExpression newExpression = (TypeScriptNewExpression)expression;
            TypeScriptTypeArgumentList arguments = newExpression.getTypeArguments();
            JSTypeDeclaration[] jSTypeDeclarationArray = arguments == null ? JSTypeDeclaration.EMPTY_ARRAY : arguments.getTypeArguments();
            if (jSTypeDeclarationArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(36);
            }
            return jSTypeDeclarationArray;
        }
        if (JSTypeDeclaration.EMPTY_ARRAY == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(37);
        }
        return JSTypeDeclaration.EMPTY_ARRAY;
    }

    @NotNull
    public static JSTypeDeclaration[] getNestedTypeArguments(@Nullable PsiElement parentExpression) {
        if (parentExpression instanceof TypeScriptNewExpression) {
            JSTypeDeclaration[] jSTypeDeclarationArray = TypeScriptPsiUtil.getNewExpressionTypeArguments(parentExpression);
            if (jSTypeDeclarationArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(38);
            }
            return jSTypeDeclarationArray;
        }
        TypeScriptTypeArgumentList list = (TypeScriptTypeArgumentList)PsiTreeUtil.getStubChildOfType((PsiElement)parentExpression, TypeScriptTypeArgumentList.class);
        if (list != null) {
            JSTypeDeclaration[] jSTypeDeclarationArray = list.getTypeArguments();
            if (jSTypeDeclarationArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(39);
            }
            return jSTypeDeclarationArray;
        }
        if (JSTypeDeclaration.EMPTY_ARRAY == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(40);
        }
        return JSTypeDeclaration.EMPTY_ARRAY;
    }

    public static boolean isTsIndexerType(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof TypeScriptType)) {
            return false;
        }
        PsiElement pp = parent.getParent();
        return pp instanceof TypeScriptIndexSignature && ((TypeScriptIndexSignature)pp).getParameterType() == parent;
    }

    public static boolean isObjectBuiltInTypeProperty(JSRecordType.TypeMember member) {
        JSRecordType.MemberSource source = member.getMemberSource();
        if (source.isEmpty()) {
            if (member instanceof JSCompositeFunctionPropertySignatureImpl) {
                for (JSRecordType.TypeMember typeMember : ((JSCompositeFunctionPropertySignatureImpl)member).getMembers()) {
                    if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(typeMember)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        JSClass parent = JSUtils.getMemberContainingClass(source.getSingleElement());
        return parent instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)parent).getQualifiedName());
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static TypeScriptType getParentTypeViaUnionsAndIntersections(@Nullable TypeScriptType type, boolean includeIntersections) {
        if (type == null) {
            return null;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentSkipTypeParentheses((JSTypeDeclaration)type);
        if (parent instanceof TypeScriptUnionOrIntersectionType && (includeIntersections || ((TypeScriptUnionOrIntersectionType)parent).isUnionType())) {
            return TypeScriptPsiUtil.getParentTypeViaUnionsAndIntersections((TypeScriptType)parent, includeIntersections);
        }
        return type;
    }

    public static boolean returnTypeAnnotationForbidden(@NotNull JSElement node) {
        if (node == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(41);
        }
        JSFunction function = node instanceof JSFunction ? (JSFunction)node : null;
        return function != null && (function.getKind() == JSFunction.FunctionKind.SETTER || function.isConstructor());
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        int rangeStartOffset;
        PsiElement startElement;
        if (psiFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(42);
        }
        if ((startElement = psiFile.findElementAt(rangeStartOffset = range.getStartOffset())) == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    @NotNull
    public static ResolveResult[] removeCompileTimeTypes(@NotNull ResolveResult[] results) {
        if (results == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(43);
        }
        if (results.length == 0) {
            if (results == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(44);
            }
            return results;
        }
        Collection compileTypeElements = null;
        for (ResolveResult result2 : results) {
            if (!result2.isValidResult() || !(result2 instanceof JSResolveResult)) continue;
            PsiElement element = result2.getElement();
            if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
            }
            if (!(element instanceof TypeScriptCompileTimeType)) continue;
            if (compileTypeElements == null) {
                compileTypeElements = ContainerUtil.newLinkedHashSet();
            }
            compileTypeElements.add(result2);
        }
        if (compileTypeElements == null || compileTypeElements.isEmpty()) {
            if (results == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(45);
            }
            return results;
        }
        if (compileTypeElements.size() != results.length) {
            Collection finalCompileTypeElements = compileTypeElements;
            ResolveResult[] resolveResultArray = (ResolveResult[])Arrays.stream(results).filter(el -> !finalCompileTypeElements.contains(el)).toArray(ResolveResult[]::new);
            if (resolveResultArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(46);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])compileTypeElements.stream().map(el -> new JSResolveResult(el.getElement(), (JSElement)((JSResolveResult)el).getES6Import(), "javascript.element.is.not.accessible.message")).toArray(ResolveResult[]::new);
        if (resolveResultArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(47);
        }
        return resolveResultArray;
    }

    public static boolean isPlaceRuntimeOnly(@Nullable PsiElement place, boolean checkTypeContext) {
        return place instanceof JSReferenceExpression && (!checkTypeContext || !JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place)) && !(place instanceof TypeScriptEntityName) && !(place.getParent() instanceof JSExportAssignment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierOwner";
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiTypeElements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastOverload";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverloadSignatures";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersForOwner";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionTypeArguments";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypeArguments";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCompileTimeTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkipTypeParentheses";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasExportStatements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbientAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExportAssignment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIdentifierOwner";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElements";
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelContainerMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParentOverDefaultAssignable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAmbientModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFromAugmentationModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "referencesNamedTypeContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFieldParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isThisParameter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameterType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLastOverload";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadSignatures";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadImplementation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadsWithImplementation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverload";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "elementsCanBeMerged";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMemberName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionTypeArguments";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "returnTypeAnnotationForbidden";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementByRange";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeCompileTimeTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

