/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAugmentationUtil {
    @NotNull
    public static Collection<PsiElement> getAugmentations(@NotNull PsiElement context, @NotNull Collection<PsiElement> modules) {
        if (context == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(1);
        }
        if (!DialectDetector.isTypeScript(context) || modules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = context.getProject();
        Collection<TypeScriptModule> augmentationModules = TypeScriptUtil.getAllAugmentationModules(project, context);
        if (augmentationModules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFile scope = TypeScriptAugmentationUtil.getVirtualFile(context);
        if (scope == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        VirtualFile closestNodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot(scope);
        for (TypeScriptModule augmentation : augmentationModules) {
            VirtualFile moduleFile = TypeScriptAugmentationUtil.getVirtualFile((PsiElement)augmentation);
            if (!TypeScriptAugmentationUtil.isAccessibleAugmentation(project, scope, closestNodeModules, moduleFile)) continue;
            Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation(augmentation);
            for (PsiElement resolvedModule : elements) {
                if (!modules.contains(resolvedModule)) continue;
                result2.add(augmentation);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static boolean isAccessibleAugmentation(@NotNull Project project, @NotNull VirtualFile scope, @Nullable VirtualFile closestNodeModules, @Nullable VirtualFile candidate) {
        if (project == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(7);
        }
        if (candidate == null) {
            return false;
        }
        if (TypeScriptConfigService.Provider.isAccessible(project, scope, candidate)) {
            return true;
        }
        if (closestNodeModules == null) {
            return false;
        }
        return TypeScriptUtil.isDefinitionFile(candidate) && VfsUtilCore.isAncestor((VirtualFile)closestNodeModules, (VirtualFile)candidate, (boolean)true);
    }

    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(8);
        }
        PsiFile file2 = element.getContainingFile();
        PsiFile originalFile = file2.getOriginalFile();
        return originalFile.getVirtualFile();
    }

    @NotNull
    private static Collection<PsiElement> resolveAugmentation(@NotNull TypeScriptModule module) {
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(9);
        }
        Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)module);
        if (collection == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    public static boolean isExternalModuleAugmentation(@NotNull PsiElement candidate) {
        if (candidate == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(11);
        }
        if (!(candidate instanceof TypeScriptModule)) {
            return false;
        }
        TypeScriptModule module = (TypeScriptModule)candidate;
        if (!TypeScriptPsiUtil.isAmbientModule(module)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)module);
        if (container instanceof JSFile) {
            return ((JSFile)container).isCommonJSModule();
        }
        if (container instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)container)) {
            JSElement secondLevelParent = ES6PsiUtil.getExportScope((PsiElement)container);
            return secondLevelParent != null && !ES6PsiUtil.isExternalModule((PsiElement)secondLevelParent);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugmentations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAugmentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentations";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleAugmentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveAugmentation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExternalModuleAugmentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

