/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptContextualTypeEvaluator;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluator {
    private static final TypeScriptGenericTypesEvaluator INSTANCE = new TypeScriptGenericTypesEvaluator();

    private TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    protected Function.Mono<JSType> getQualifierGenericsEvaluator(@NotNull JSType startType, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        JSType qualifierType;
        if (startType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        Function.Mono<JSType> jsGenericEvaluator = super.getQualifierGenericsEvaluator(startType, qualifier, methodExpression, resolvedFunction);
        boolean hasGenerics = JSTypeUtils.hasGenericParameter(startType);
        boolean hasThisGenericType = JSTypeUtils.hasThisGenericType(startType);
        if (!hasGenerics && !hasThisGenericType) {
            if (!(startType instanceof JSResolvableType)) {
                Function.Mono<JSType> mono = jsGenericEvaluator;
                if (mono == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
                }
                return mono;
            }
            JSResolvableType jsType = (JSResolvableType)startType;
            JSResolvedTypeInfo resolvedType = jsType.resolveType();
            if (!resolvedType.isLocal()) {
                Function.Mono<JSType> mono = jsGenericEvaluator;
                if (mono == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
                }
                return mono;
            }
        }
        if ((qualifierType = JSResolveUtil.getExpressionJSType((PsiElement)qualifier, JSEvaluateContext.JSEvaluationPlace.QUALIFIER)) == null) {
            Function.Mono<JSType> mono = jsGenericEvaluator;
            if (mono == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
            }
            return mono;
        }
        PsiElement sourceElement = startType.getSource().getSourceElement();
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(qualifierType);
        JSTypeSubstitutor substitutor = JSTypeSubstitutor.combine((JSTypeSubstitutor)this.getTypeSubstitutorFromQualifierType(expanded, sourceElement, (PsiElement)methodExpression), (JSTypeSubstitutor)TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExplicitThisParameterType((Getter<? extends JSType>)((Getter)() -> expanded), resolvedFunction));
        Function.Mono mono = toApply -> {
            toApply = (JSType)jsGenericEvaluator.fun(toApply);
            toApply = TypeScriptGenericTypesEvaluator.evaluateThisType(toApply, qualifierType);
            toApply = JSTypeUtils.applyGenericArguments(toApply, substitutor);
            return toApply;
        };
        if (mono == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        return mono;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        if (!(recordType instanceof JSSimpleRecordTypeImpl)) {
            return false;
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    @NotNull
    private static JSType evaluateThisType(@NotNull JSType type, final @NotNull JSType qualifierType) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        JSType jSType = type.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSRecursiveExpandTransformer(){

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type instanceof TypeScriptGenericThisTypeImpl && (!(qualifierType instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)qualifierType))) {
                    JSType jSType = qualifierType;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                JSType jSType = type;
                if (jSType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    public boolean hasGenericsCompatibilityErrors(@NotNull List<JSType> parameterTypes, @NotNull List<JSType> arguments, @NotNull TypeScriptFunction context) {
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        List<Supplier<JSType>> argumentProviders = arguments.stream().map(el -> () -> el).collect(Collectors.toList());
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, -1, (PsiElement)context);
        final Ref hasErrors = Ref.create((Object)false);
        JSGenericTypesEvaluator.GenericErrorReporter reporter = new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(@NotNull String parameter) {
                if (parameter == null) {
                    2.$$$reportNull$$$0(0);
                }
                hasErrors.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$2", "error"));
            }
        };
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.intersectGenerics(genericArguments, (PsiElement)context, reporter);
        if (((Boolean)hasErrors.get()).booleanValue()) {
            return true;
        }
        TypeScriptTypeParameter[] owner = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)context);
        List<JSType> functionGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(owner);
        if (functionGenerics.isEmpty()) {
            return false;
        }
        for (JSType generic : functionGenerics) {
            JSTypeUtils.applyGenericArguments(generic, substitutor, true, reporter);
            if (!((Boolean)hasErrors.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorFromQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement place) {
        JSClass parentClass;
        JSType constraintType;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        PsiElement context = (PsiElement)ObjectUtils.coalesce((Object)sourceElement, (Object)place);
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionTypeImpl) {
            for (JSType typeToProcess : ((JSIntersectionTypeImpl)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = this.getTypeSubstitutorFromQualifierType(typeToProcess, sourceElement, place);
                substitutor.putAll(candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            JSTypeSubstitutor outerArguments = genericType.getOuterArguments();
            if (!outerArguments.isEmpty()) {
                substitutor.putAll(outerArguments);
            }
            if (genericType.getType() instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = new JSGenericTypeImpl(genericType.getSource(), genericType.getType().substitute(), genericType.getArguments(), genericType.getOuterArguments());
            }
        } else if (qualifierType instanceof JSRecordType) {
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression && DialectDetector.isTypeScript(qualifierSource)) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null) {
                if (objectType.isEquivalentTo(qualifierType, null, false)) {
                    JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                    if (jSTypeSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
                    }
                    return jSTypeSubstitutor;
                }
                substitutor.putAll(TypeScriptGenericTypesEvaluator.findAndIntersectGenericsTypeValues(qualifierType, objectType, context));
            }
        } else if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
            qualifierType = qualifierType.substitute();
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement != null && (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSTypeImpl) && (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class)) != null) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, place);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForQualifierType(qualifierType, qualifierClass) : arguments;
                Ref ref = Ref.create((Object)substitutor);
                TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, (Ref<JSTypeSubstitutor>)ref);
                if (ref.isNull()) continue;
                substitutor = (JSTypeSubstitutor)ref.get();
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getArgumentsListForQualifierType(@NotNull JSType qualifierType, @NotNull JSClass qualifierClass) {
        TypeScriptTypeParameter[] parameters;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        if (qualifierClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(qualifierType) && (parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)qualifierClass)).length > 0) {
            List<JSType> list = Arrays.stream(parameters).map(JSGenericTypesEvaluator::getTypeParameterDefaultType).collect(Collectors.toList());
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        Ref substitutor = Ref.create();
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, (Ref<JSTypeSubstitutor>)substitutor);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, (JSTypeSubstitutor)substitutor.get());
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    public static void processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, typeArgumentsList, expectedGenericOwnerClass, substitutor, ContainerUtil.newHashSet());
    }

    public static boolean processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor, @NotNull Set<JSClass> visitedClasses) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        if (visitedClasses == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        if (!(expectedGenericOwnerClass instanceof TypeScriptTypeParameterListOwner) || contextClass == null) {
            return true;
        }
        if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            JSTypeSubstitutor oldSubstitutor = (JSTypeSubstitutor)substitutor.get();
            if (oldSubstitutor != null && !oldSubstitutor.isEmpty()) {
                genericArguments = new JSTypeSubstitutor(genericArguments);
                genericArguments.putAll(oldSubstitutor);
            }
            substitutor.set((Object)genericArguments);
            return false;
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = contextClass.getExtendsList();
        JSReferenceList implementsList = contextClass.getImplementsList();
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        if (!superReferences.isEmpty()) {
            JSTypeSubstitutor typeArguments = contextClass instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList) : JSTypeSubstitutor.EMPTY;
            for (Pair reference : superReferences) {
                if (((Collection)reference.second).isEmpty()) continue;
                List<JSType> superclassTypeArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(((JSReferenceListMember)reference.first).getTypeArguments(), typeArguments);
                for (JSClass jsSuperClass : (Collection)reference.second) {
                    if (!JSInheritanceUtil.isParentClass(jsSuperClass, expectedGenericOwnerClass, false)) continue;
                    if (!visitedClasses.add(jsSuperClass)) {
                        return false;
                    }
                    if (TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jsSuperClass, superclassTypeArguments, expectedGenericOwnerClass, substitutor, visitedClasses)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable JSTypeSubstitutor typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list = mappedArguments;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        return list;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        if (typeParameterListOwner == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<JSType> typeArgumentsList) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = new JSTypeSubstitutor();
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(parameters, genericArguments, type)) continue;
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null) continue;
            TypeScriptTypeParser.TypeParameterGenericId id = TypeScriptTypeParser.getTypeParameterId(parameter);
            genericArguments.put((JSTypeSubstitutor.JSTypeGenericId)id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        return jSTypeSubstitutor;
    }

    @Override
    @Nullable
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext genericEvaluationContext) {
        if (genericEvaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
        }
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (methodExpression != null) {
            JSReferenceList list;
            TypeScriptClass tsClass;
            PsiElement callExpression = methodExpression.getParent();
            JSTypeSubstitutor map = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolvedFunction, callExpression, null);
            if (TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) && (tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class)) != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
                if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                    JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                    List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                    TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                    JSTypeSubstitutor argumentsFromSuper = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
                    if (map != null) {
                        map.putAll(argumentsFromSuper);
                    }
                } else {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
                    type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<JSType>)ContainerUtil.emptyList(), parentClass, type);
                }
            }
            type = JSTypeUtils.applyGenericArguments(type, map, false, genericEvaluationContext.reporter);
        }
        return super.evaluateGenerics(type, methodExpression, resolvedFunction, genericEvaluationContext);
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        JSTypeSubstitutor candidate;
        boolean isES6TaggedTemplateContext;
        PsiElement parent;
        if (member instanceof TypeScriptProxyImplicitElement) {
            member = ((TypeScriptProxyImplicitElement)member).getExplicitElement();
        }
        if (place == null || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        boolean isFunctionCallContext = (parent = place.getParent()) instanceof JSCallExpression && member instanceof TypeScriptTypeParameterListOwner;
        boolean bl = isES6TaggedTemplateContext = parent instanceof ES6TaggedTemplateExpression && member instanceof TypeScriptTypeParameterListOwner;
        if (isFunctionCallContext) {
            candidate = this.inferGenericTypesForCall(member, (JSCallExpression)parent, null);
            substitutor.putAll(candidate, el -> !(el instanceof JSAnyType));
        }
        if (isES6TaggedTemplateContext) {
            candidate = this.inferGenericTypesForTaggedTemplateCall(member, (ES6TaggedTemplateExpression)parent, null, -1);
            substitutor.putAll(candidate, el -> !(el instanceof JSAnyType));
        }
        if (qualifierType != null) {
            substitutor.putAll(this.getTypeSubstitutorFromQualifierType(qualifierType, member, place));
            if (isFunctionCallContext) {
                substitutor.putAll(TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExplicitThisParameterType((Getter<? extends JSType>)((Getter)() -> qualifierType), member));
            }
        }
        if (isFunctionCallContext || isES6TaggedTemplateContext) {
            substitutor.putAll(TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(member, parent, substitutor));
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        JSExpression qualifier = referenceExpression.getQualifier();
        JSType qualifierType = null;
        if (qualifier != null) {
            qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        }
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, qualifierType, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, qualifierType, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(PsiElement resolveResult, PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    @Nullable
    public static JSType getParameterExpressionType(@NotNull JSExpression expression, boolean contextual) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        if (contextual) {
            return TypeScriptGenericTypesEvaluator.getParameterExpressionType(TypeScriptContextualTypeEvaluator.getContextualType(expression));
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        return TypeScriptGenericTypesEvaluator.getParameterExpressionType((JSTypeEvaluationResult)exprTypeRef.get());
    }

    @Nullable
    public static JSType getParameterExpressionType(@Nullable JSTypeEvaluationResult result2) {
        if (result2 == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
        if (results.size() <= 1) {
            return JSTypeUtils.getValuableType(result2.getType());
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = JSTypeUtils.getValuableType(element.getType());
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isStrict() && typeSource.isStrict());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source == null ? JSTypeSource.EMPTY_TS : source, types);
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull JSTypeSubstitutor genericArguments) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        if (typeParameters.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeScriptTypeParser.TypeParameterGenericId id;
            String name;
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument) : null;
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(typeParameters, genericArguments, type)) continue;
            if (typeArguments.length > 0 && type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null || genericArguments.containsId((JSTypeSubstitutor.JSTypeGenericId)(id = TypeScriptTypeParser.getTypeParameterId(parameter))) && type == null) continue;
            genericArguments.put((JSTypeSubstitutor.JSTypeGenericId)id, type);
        }
    }

    private static boolean addFromNamedSubstitutor(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeSubstitutor genericArguments, JSType type) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        if (!(type instanceof JSNamedTypeSubstitutorType)) {
            return false;
        }
        String genericName = ((JSNamedTypeSubstitutorType)type).getGenericName();
        Optional<TypeScriptTypeParameter> first = Arrays.stream(typeParameters).filter(p -> genericName.equals(p.getName())).findFirst();
        first.ifPresent(parameter -> {
            if (genericArguments == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(99);
            }
            genericArguments.put((JSTypeSubstitutor.JSTypeGenericId)TypeScriptTypeParser.getTypeParameterId(parameter), ((JSNamedTypeSubstitutorType)type).getRealType());
        });
        return true;
    }

    @Contract(value="_,_,!null -> !null")
    public static JSTypeSubstitutor addExplicitGenericArgumentsFromCall(PsiElement resolveResult, PsiElement callExpression, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            return genericArguments == null ? null : new JSTypeSubstitutor(genericArguments);
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor(genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNewExpressionTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, substitutor);
        }
        return substitutor;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(@NotNull JSExpression[] arguments, boolean contextual) {
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
        }
        if (arguments.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
            }
            return list;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ArrayUtil.getFirstElement((Object[])arguments));
        boolean isTypeScript = holder != null && holder.isTypeScript;
        List argumentTypes = ContainerUtil.newSmartList();
        for (JSExpression expression : arguments) {
            JSType type = TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, contextual);
            argumentTypes.add(isTypeScript && !contextual ? TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny((PsiElement)expression, type) : (type != null ? type : JSAnyType.get((PsiElement)expression, false)));
        }
        List list = argumentTypes;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    public static JSType getExplicitTypeOrAnyIfTypeScript(@Nullable PsiElement expression, @Nullable JSType type) {
        if (type == null) {
            JSAnyType jSAnyType = JSAnyType.get(expression, false);
            if (jSAnyType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
            }
            return jSAnyType;
        }
        if (expression == null || !expression.isValid()) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
            }
            return jSType;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(expression);
        if (holder != null && holder.isTypeScript) {
            JSType jSType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(expression, type);
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        return jSType;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull PsiElement expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        JSType jSType = type == null ? JSAnyType.get(expression, false) : JSTypeUtils.replaceImplicitTypesWithAny(type);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
            }
            return list;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type, element, place);
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result2.add((JSClass)psiElement);
        }
        List list = result2;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace) {
            if (JSCorePredefinedLibrariesProvider.isLibraryElement(element)) {
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
                }
                return collection;
            }
            if (!DialectDetector.isTypeScript(element)) {
                Collection<PsiElement> elements = new ES6QualifiedNameResolver(element).resolveQualifiedName(type);
                if (elements.size() > 0) {
                    Collection<PsiElement> collection = elements;
                    if (collection == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
                    }
                    return collection;
                }
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
                }
                return collection;
            }
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, element);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
        }
        return collection;
    }

    @NotNull
    public static List<TypeScriptGenericDeclarationTypeImpl> buildGenericParameterDeclarations(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        if (parameters.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
            }
            return list;
        }
        ArrayList generics = ContainerUtil.newArrayList();
        for (TypeScriptTypeParameter parameter : parameters) {
            TypeScriptGenericDeclarationTypeImpl declaration = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
            generics.add(declaration);
        }
        ArrayList arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(76);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(77);
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(parameters).stream().map(el -> el.toGenericParameter()).collect(Collectors.toList());
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(78);
        }
        return list;
    }

    @NotNull
    public static TypeScriptGenericDeclarationTypeImpl buildGenericParameterDeclaration(@NotNull TypeScriptTypeParameter parameter) {
        if (parameter == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(79);
        }
        TypeScriptType constraint = parameter.getTypeConstraint();
        TypeScriptType parameterDefault = parameter.getDefault();
        NotNullLazyValue constraintType = constraint == null ? null : NotNullLazyValue.createValue(() -> TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint));
        NotNullLazyValue defaultType = parameterDefault == null ? null : NotNullLazyValue.createValue(() -> TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameterDefault));
        TypeScriptTypeParser.TypeParameterGenericId genericId = TypeScriptTypeParser.getTypeParameterId(parameter);
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true);
        TypeScriptGenericDeclarationTypeImpl typeScriptGenericDeclarationTypeImpl = new TypeScriptGenericDeclarationTypeImpl(genericId, (NotNullLazyValue<? extends JSType>)constraintType, (NotNullLazyValue<? extends JSType>)defaultType, source);
        if (typeScriptGenericDeclarationTypeImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(80);
        }
        return typeScriptGenericDeclarationTypeImpl;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(81);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(82);
        }
        JSType jSType = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionType, callExpression.getMethodExpression(), callExpression instanceof JSNewExpression, TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callExpression));
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(83);
        }
        return jSType;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @Nullable JSExpression methodExpression, boolean isNewExpression, @NotNull JSTypeDeclaration[] typeArguments) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(84);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(85);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSTypeSubstitutor defaultParamsSubstitutor = new JSTypeSubstitutor();
        JSFunctionTypeImpl resultType = isNewExpression && sourceElement instanceof TypeScriptClass ? TypeScriptGenericTypesEvaluator.wrapNewExpressionReturnTypeWithGenerics(functionType, defaultParamsSubstitutor, typeArguments) : functionType;
        JSType evaluatedType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, methodExpression, sourceElement);
        JSType jSType = JSTypeUtils.applyGenericArguments(evaluatedType, defaultParamsSubstitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(86);
        }
        return jSType;
    }

    @NotNull
    private static JSType wrapNewExpressionReturnTypeWithGenerics(@NotNull JSFunctionTypeImpl functionType, @NotNull JSTypeSubstitutor defaultParamsSubstitutor, @NotNull JSTypeDeclaration[] typeArguments) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(87);
        }
        if (defaultParamsSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(88);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(89);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSType returnType = functionType.getReturnType();
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
        if (typeParameters.length > 0 && returnType instanceof JSNamedType) {
            List<JSType> defaultGenerics;
            if (typeArguments.length == 0) {
                Arrays.stream(typeParameters).forEach(el -> {
                    if (defaultParamsSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(98);
                    }
                    defaultParamsSubstitutor.put((JSTypeSubstitutor.JSTypeGenericId)TypeScriptTypeParser.getTypeParameterId(el), TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(el));
                });
                defaultGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
            } else {
                defaultGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(typeArguments, defaultParamsSubstitutor);
            }
            JSGenericTypeImpl newReturnType = new JSGenericTypeImpl(functionType.getSource(), returnType, defaultGenerics);
            JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(functionType.getSource(), functionType.getParameters(), newReturnType);
            if (jSFunctionTypeImpl == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(90);
            }
            return jSFunctionTypeImpl;
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = functionType;
        if (jSFunctionTypeImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(91);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExtendClass(@NotNull JSClass contextClass, @NotNull JSClass genericOwner) {
        if (contextClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(92);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(93);
        }
        if (!(genericOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(94);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)genericOwner).getTypeParameterList();
        if (typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(95);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        if (parameters.length <= 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(96);
            }
            return jSTypeSubstitutor;
        }
        Ref substitutor = Ref.create((Object)new JSTypeSubstitutor());
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, (List<JSType>)ContainerUtil.emptyList(), genericOwner, (Ref<JSTypeSubstitutor>)substitutor);
        JSTypeSubstitutor result2 = (JSTypeSubstitutor)substitutor.get();
        JSTypeSubstitutor jSTypeSubstitutor = result2 == null ? JSTypeSubstitutor.EMPTY : result2;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(97);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 83: 
            case 86: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 83: 
            case 86: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 83: 
            case 86: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 8: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 12: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 23: 
            case 26: 
            case 28: 
            case 33: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedClasses";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 39: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericEvaluationContext";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 50: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 52: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 53: 
            case 55: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 81: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 88: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultParamsSubstitutor";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierGenericsEvaluator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateThisType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForQualifierType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAnyIfTypeScript";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclarations";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclaration";
                break;
            }
            case 83: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapNewExpressionReturnTypeWithGenerics";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierGenericsEvaluator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 83: 
            case 86: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evaluateThisType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasGenericsCompatibilityErrors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForQualifierType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 33: 
            case 36: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenerics";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getParameterExpressionType";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addFromNamedSubstitutor";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclarations";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclaration";
                break;
            }
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "wrapNewExpressionReturnTypeWithGenerics";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExtendClass";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$wrapNewExpressionReturnTypeWithGenerics$13";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addFromNamedSubstitutor$9";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 83: 
            case 86: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

