/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TypeScriptGeneratedFilesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TypeScriptExcludeManager
implements PersistentStateComponent<State> {
    private static final int VERSION = 1;
    private final Project myProject;
    private volatile State myState = new State();

    public TypeScriptExcludeManager(Project project) {
        this.myProject = project;
    }

    @Nullable
    public static TypeScriptExcludeManager getInstance(@NotNull Project project) {
        if (project == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(0);
        }
        return (TypeScriptExcludeManager)ServiceManager.getService((Project)project, TypeScriptExcludeManager.class);
    }

    public boolean isExcludeDeclarationFiles() {
        return this.myState.excludeDeclarationFiles;
    }

    public void setExcludeDeclarationFiles(boolean excludeDefinitionFiles) {
        this.myState.excludeDeclarationFiles = excludeDefinitionFiles;
    }

    public boolean isExcludeGeneratedFiles() {
        return this.myState.excludeGeneratedFiles;
    }

    @NotNull
    public Collection<VirtualFile> getExcludedPlainFiles() {
        Collection<String> files = this.getExcludedPaths();
        if (files.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExcludeManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        Set<VirtualFile> filteredFiles = TypeScriptExcludeManager.getVirtualFilesFor(files);
        if (filteredFiles.size() != files.size()) {
            this.updateExcludedFiles(filteredFiles);
        }
        Set<VirtualFile> set = filteredFiles;
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<VirtualFile> getAdditionalRoots() {
        Collection<String> additionalRoots = this.myState.additionalRoots;
        if (additionalRoots.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptExcludeManager.$$$reportNull$$$0(3);
            }
            return list;
        }
        Set<VirtualFile> filteredFiles = TypeScriptExcludeManager.getVirtualFilesFor(additionalRoots);
        if (filteredFiles.size() != additionalRoots.size()) {
            this.updateAdditionalRoots(filteredFiles);
        }
        Set<VirtualFile> set = filteredFiles;
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<String> getExcludedPaths() {
        Collection<String> collection = this.myState.exactExcludedFiles;
        if (collection == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public synchronized void updateAdditionalRoots(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(6);
        }
        this.myState.additionalRoots = TypeScriptExcludeManager.mapToStrings(files);
    }

    private synchronized void updateExcludedFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(7);
        }
        this.myState.exactExcludedFiles = TypeScriptExcludeManager.mapToStrings(files);
    }

    public int getVersion() {
        return this.myState.version;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public boolean isProjectProcessed() {
        return this.myState.version == 1;
    }

    public void updateVersion() {
        this.myState.version = 1;
    }

    public void addFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(8);
        }
        ArrayList result2 = ContainerUtil.newArrayList(this.getExcludedPaths());
        result2.addAll(TypeScriptExcludeManager.mapToStrings(files));
        this.myState.exactExcludedFiles = result2;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesFor(@NotNull Collection<String> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(9);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Set set = files.stream().map(el -> localFileSystem.findFileByPath(el)).filter(el -> el != null).collect(Collectors.toCollection(ContainerUtil::newHashSet));
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static List<String> mapToStrings(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.mapNotNull(files, el -> el.getCanonicalPath());
        if (list == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void setFiles(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptExcludeManager.mapToStrings(files);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(13);
        }
        this.myState = state;
    }

    @NotNull
    public Set<String> getIncludedJSSourcePackages() {
        Set<String> set = this.myState.includedJSSourcePackages;
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(14);
        }
        return set;
    }

    public void setIncludedJSSourcePackages(@NotNull Set<String> includedJSSourcePackages) {
        if (includedJSSourcePackages == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(15);
        }
        this.myState.includedJSSourcePackages = includedJSSourcePackages;
    }

    public void updateProject() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptExcludeManager";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedJSSourcePackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptExcludeManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPlainFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToStrings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedJSSourcePackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateAdditionalRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateExcludedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapToStrings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedJSSourcePackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public int version = 0;
        public boolean excludeDeclarationFiles = true;
        public boolean excludeGeneratedFiles = true;
        @NotNull
        public Collection<String> exactExcludedFiles = new SmartList();
        public Collection<String> additionalRoots = new SmartList();
        public Set<String> includedJSSourcePackages = ContainerUtil.newHashSet();
    }
}

