/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.structureView;

import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

class TypeScriptStructureItemPresentation
extends JSStructureItemPresentation {
    public TypeScriptStructureItemPresentation(@NotNull JSStructureViewElementBase jsStructureViewElement) {
        if (jsStructureViewElement == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(0);
        }
        super(jsStructureViewElement);
    }

    @Override
    protected String buildPresentationForElement(PsiElement psiElement) {
        StringBuilder presentation = null;
        if (psiElement instanceof TypeScriptCallSignature) {
            presentation = new StringBuilder();
            presentation.append(((TypeScriptCallSignature)psiElement).isConstructor() ? "new" : "");
            presentation.append(JSSymbolPresentationUtils.buildFunctionSignaturePresentation((JSFunctionItem)((JSFunction)psiElement)));
        } else if (psiElement instanceof TypeScriptPropertySignature) {
            presentation = new StringBuilder();
            presentation.append(JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((TypeScriptPropertySignature)psiElement), true));
            JSTypeDeclaration type = ((TypeScriptPropertySignature)psiElement).getTypeDeclaration();
            if (type != null && !(type instanceof TypeScriptObjectType)) {
                presentation.append(this.getTypeSeparator());
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation(type));
            }
        } else if (psiElement instanceof TypeScriptIndexSignature) {
            JSTypeDeclaration parameterType;
            presentation = new StringBuilder("[");
            TypeScriptIndexSignature indexSignature = (TypeScriptIndexSignature)psiElement;
            PsiElement nameElement = indexSignature.getParameterNameElement();
            if (nameElement != null) {
                presentation.append(nameElement.getText());
            }
            if ((parameterType = indexSignature.getParameterType()) != null) {
                presentation.append(this.getTypeSeparator());
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation(parameterType));
            }
            presentation.append("]");
            JSTypeDeclaration type = indexSignature.getType();
            if (type != null) {
                presentation.append(this.getTypeSeparator());
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation(type));
            }
        } else if (psiElement instanceof TypeScriptClass) {
            String name = ((TypeScriptClass)psiElement).getName();
            if (name == null) {
                name = JSFormatUtil.getAnonymousName(psiElement);
            }
            presentation = new StringBuilder(name);
            TypeScriptClass typeScriptClass = (TypeScriptClass)psiElement;
            TypeScriptTypeParameterList list = typeScriptClass.getTypeParameterList();
            if (list != null) {
                presentation.append("<");
                presentation.append(StringUtil.join((Object[])list.getTypeParameters(), parameter -> StringUtil.notNullize((String)parameter.getName()), (String)", "));
                presentation.append(">");
            }
        }
        return presentation != null ? presentation.toString() : super.buildPresentationForElement(psiElement);
    }

    @NotNull
    private static String getTypePresentation(JSTypeDeclaration type) {
        String string = TypeScriptTypeParser.buildTypeFromTypeScript(type).getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            TypeScriptStructureItemPresentation.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsStructureViewElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/structureView/TypeScriptStructureItemPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/structureView/TypeScriptStructureItemPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

