/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class TypeScriptConfigJsonReferenceContributor
extends PsiReferenceContributor {
    public static final String[] JSON_EXTENSIONS = new String[]{".json"};
    private static final PsiFilePattern.Capture<JsonFile> TS_CONFIG_FILE_PATTERN = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withFileType((ElementPattern)StandardPatterns.instanceOf(TypeScriptConfigFileType.class));
    private static final PsiFilePattern.Capture<JsonFile> JS_CONFIG_FILE_PATTERN = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withName("jsconfig.json");
    public static final PsiElementPattern.Capture<JsonStringLiteral> STRING_LITERAL_IN_CONFIG = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{TS_CONFIG_FILE_PATTERN, JS_CONFIG_FILE_PATTERN}));
    private static final ElementPattern<? extends PsiElement> PATTERN_FILES_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("files"));
    private static final ElementPattern<? extends PsiElement> PATTERN_EXCLUDE_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("exclude"));
    private static final ElementPattern<? extends PsiElement> PATTERN_INCLUDE_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("include"));
    private static final ElementPattern<? extends PsiElement> PATTERN_ROOT_DIRS_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("rootDirs"));
    private static final ElementPattern<? extends PsiElement> PATTERN_LIB_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("lib"));
    private static final ElementPattern<? extends PsiElement> PATTERN_TYPES_ROOT_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("typeRoots"));
    private static final ElementPattern<? extends PsiElement> PATTERN_OUT = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("out"));
    private static final ElementPattern<? extends PsiElement> PATTERN_OUT_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("outFile"));
    private static final ElementPattern<? extends PsiElement> PATTERN_BASE_URL_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("baseUrl"));
    private static final ElementPattern<? extends PsiElement> PATTERN_OUT_DIR = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("outDir"));
    private static final ElementPattern<? extends PsiElement> PATTERN_DECLARATION_DIR = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("declarationDir"));
    private static final ElementPattern<? extends PsiElement> PATTERN_EXTENDS = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("extends"));
    private static final ElementPattern<? extends PsiElement> PATTERN_PATH_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("path"));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TypeScriptConfigJsonReferenceContributor.$$$reportNull$$$0(0);
        }
        PsiReferenceProvider referenceProvider = JSFileReferencesUtil.getSimpleReferencesPathProvider(TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PATTERN_FILES_ARRAY, PATTERN_OUT_FILE, PATTERN_OUT_DIR, PATTERN_OUT, PATTERN_EXCLUDE_ARRAY, PATTERN_INCLUDE_ARRAY, PATTERN_BASE_URL_FILE, PATTERN_TYPES_ROOT_ARRAY, PATTERN_DECLARATION_DIR, PATTERN_ROOT_DIRS_ARRAY}), referenceProvider, 100.0);
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PATTERN_EXTENDS, PATTERN_PATH_FILE}), JSFileReferencesUtil.getSimpleReferencesPathProvider(JSON_EXTENSIONS), 100.0);
        registrar.registerReferenceProvider(PATTERN_LIB_ARRAY, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JsonStringLiteral)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                JsonStringLiteral literal = (JsonStringLiteral)element;
                String value = literal.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(element.getProject());
                VirtualFile library = service.findLibraryByShortName(TypeScriptConfigUtil.toLibraryName(value));
                if (library == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                TextRange newRange = new TextRange(1, value.length() + 1);
                TextRange range = element.getTextRange();
                if (newRange.getLength() > range.getLength()) {
                    Logger.getInstance(TypeScriptConfigJsonReferenceContributor.class).error("Wrong tsconfig rage, " + element.getText());
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new JSExactFileReference(element, newRange, Collections.singleton(library.getPath()), ArrayUtil.EMPTY_STRING_ARRAY)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(6);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor", "registerReferenceProviders"));
    }
}

