/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigLibraryUpdater {
    public static final String TSCONFIG_PATHS_LIBRARY = "tsconfig$paths";
    private static final String DEPRECATED_TSCONFIG_LIBRARY = "tsconfig$roots";
    private static final int UPDATE_TIME = (int)TimeUnit.SECONDS.toMillis(6L);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myQueue;

    public TypeScriptConfigLibraryUpdater(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("Update typescript config additional roots/paths", UPDATE_TIME, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myQueue.setRestartTimerOnAdd(true);
    }

    public void queueToUpdate() {
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null || !settings.isAutoIncludeConfigPaths()) {
            return;
        }
        this.myQueue.queue(new Update(this){

            public void run() {
                TypeScriptConfigLibraryUpdater.this.update();
            }
        });
    }

    private void update() {
        ReadAction.run(() -> {
            Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
            if (files.isEmpty()) {
                return;
            }
            for (TypeScriptConfig file2 : files) {
                if (!file2.hasErrors()) continue;
                return;
            }
            this.processConfigsDirectory(files);
        });
    }

    void processConfigsDirectory(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> libraryFiles = this.getFilesToUpdate(configs);
        this.updateFiles(libraryFiles);
    }

    private void updateFiles(@NotNull Collection<VirtualFile> possibleLibraryFiles) {
        if (possibleLibraryFiles == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(2);
        }
        Application application = ApplicationManager.getApplication();
        application.assertReadAccessAllowed();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        List fileOutOfProjectScope = ContainerUtil.filter(possibleLibraryFiles, file2 -> !scope.accept(file2) && fileIndex.getContentRootForFile(file2, false) == null);
        if (!TypeScriptConfigLibraryUpdater.checkNeedUpdate(this.myProject, fileOutOfProjectScope)) {
            return;
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
        assert (service != null);
        ModificationTracker tracker = service.getTracker();
        long count = tracker.getModificationCount();
        Runnable update = () -> WriteAction.run(() -> TypeScriptConfigLibraryUpdater.updateLibrary(this.myProject, fileOutOfProjectScope));
        if (application.isDispatchThread()) {
            update.run();
            return;
        }
        application.invokeLater(update, o -> count != tracker.getModificationCount());
    }

    @NotNull
    private Collection<VirtualFile> getFilesToUpdate(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(3);
        }
        if (configs.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(4);
            }
            return list;
        }
        HashSet toUpdate = ContainerUtil.newHashSet();
        for (TypeScriptConfig config2 : configs) {
            Collection<PsiFileSystemItem> dirs = config2.getRootDirs();
            for (PsiFileSystemItem dir : dirs) {
                String path;
                VirtualFile file2 = dir.getVirtualFile();
                if (file2 == null || (path = file2.getCanonicalPath()) == null || path.length() <= 2) continue;
                toUpdate.add(file2);
            }
            toUpdate.addAll(this.getBaseUrlRelatedFiles(config2));
        }
        HashSet hashSet = toUpdate;
        if (hashSet == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    protected Collection<VirtualFile> getBaseUrlRelatedFiles(@NotNull TypeScriptConfig config2) {
        VirtualFile baseUrl;
        if (config2 == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(6);
        }
        if ((baseUrl = config2.getBaseUrl()) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection<JSModulePathSubstitution> paths = config2.getPaths();
        if (paths.isEmpty()) {
            List<VirtualFile> list = TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
            if (list == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JSModulePathSubstitution substitution : paths) {
            for (String path : substitution.getMappings()) {
                String canonicalPath;
                if (!TypeScriptConfigLibraryUpdater.pathCanBeProcessed(path)) {
                    List<VirtualFile> list = TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
                    if (list == null) {
                        TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(9);
                    }
                    return list;
                }
                boolean endsWithStar = path.contains("*");
                String normalizedPath = endsWithStar ? path.substring(0, path.indexOf("*")) : path;
                VirtualFile pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, normalizedPath);
                if (!endsWithStar && pathUrl == null) {
                    for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
                        pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, normalizedPath + extension);
                        if (pathUrl != null) break;
                    }
                }
                if (pathUrl == null || (canonicalPath = pathUrl.getCanonicalPath()) == null || canonicalPath.length() <= 2) continue;
                result2.add(pathUrl);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getBaseUrlFile(@NotNull VirtualFile baseUrl) {
        String path;
        if (baseUrl == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(11);
        }
        List list = (path = baseUrl.getCanonicalPath()) == null || path.length() <= 2 ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)baseUrl);
        if (list == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static boolean checkNeedUpdate(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(13);
        }
        if (files == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Library library = TypeScriptConfigLibraryUpdater.getDeprecatedLibrary(project);
        if (library != null) {
            return true;
        }
        TypeScriptExcludeManager manager = TypeScriptExcludeManager.getInstance(project);
        if (manager == null) {
            return false;
        }
        HashSet roots = ContainerUtil.newHashSet(manager.getAdditionalRoots());
        return !ContainerUtil.newHashSet(files).equals(roots);
    }

    @Nullable
    private static Library getDeprecatedLibrary(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(15);
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        return libTable.getLibraryByName(DEPRECATED_TSCONFIG_LIBRARY);
    }

    private static void updateLibrary(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        TypeScriptExcludeManager manager;
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(16);
        }
        if (files == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(17);
        }
        if ((manager = TypeScriptExcludeManager.getInstance(project)) == null) {
            return;
        }
        Library library = TypeScriptConfigLibraryUpdater.getDeprecatedLibrary(project);
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        if (library != null) {
            ScriptingLibraryModel model = libraryManager.getScriptingLibraryTable().getModel(library);
            libraryManager.removeLibrary(model);
        }
        boolean needAssociate = libraryManager.getLibraryByName(TSCONFIG_PATHS_LIBRARY) == null;
        manager.updateAdditionalRoots(files);
        libraryManager.commitChanges();
    }

    private static boolean pathCanBeProcessed(String pattern) {
        return JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || pattern.contains("/*") || !pattern.contains("*");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleLibraryFiles";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrlRelatedFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processConfigsDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToUpdate";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlRelatedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkNeedUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedLibrary";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

