/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigUtil {
    public static final String TWO_ASTERISK = "**";
    private static final Key<ParameterizedCachedValue<TypeScriptConfig, PsiFile>> CACHE_KEY = Key.create((String)"TypeScript.PsiFile.To.Config");
    private static final ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile> CACHED_CONFIG_PROVIDER = new ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<TypeScriptConfig> compute(PsiFile param) {
            VirtualFile file2 = param.getOriginalFile().getVirtualFile();
            Project project = param.getProject();
            TypeScriptConfig config2 = file2 == null ? null : TypeScriptConfigUtil.getConfigForFile(project, file2);
            return CachedValueProvider.Result.create((Object)config2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    public static String getNonStandardProjectFileName(@NotNull Project project, @NotNull VirtualFile el) {
        TypeScriptConfig config2;
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(0);
        }
        if (el == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(1);
        }
        return TypeScriptConfigUtil.isNonStandardName(config2 = TypeScriptConfigUtil.getConfigForFile(project, el)) ? FileUtil.toSystemDependentName((String)config2.getConfigFile().getPath()) : null;
    }

    public static String toLibraryName(@NotNull String rawName) {
        if (rawName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(2);
        }
        if ((rawName = StringUtil.toLowerCase((String)rawName)).equals("es6")) {
            return "es2015";
        }
        if (rawName.equals("es7")) {
            return "es2016";
        }
        return rawName;
    }

    public static boolean hasConfigsWithNonStandardName(@NotNull Project project) {
        TypeScriptConfigService service;
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(3);
        }
        if ((service = TypeScriptConfigService.Provider.get(project)) == null) {
            return false;
        }
        return service.getConfigFiles().stream().anyMatch(el -> !el.getConfigFile().getName().equalsIgnoreCase("tsconfig.json"));
    }

    public static boolean isNonStandardName(@Nullable TypeScriptConfig config2) {
        if (config2 == null) {
            return false;
        }
        return TypeScriptConfigUtil.isNonStandardName(config2.getConfigFile());
    }

    public static boolean isNonStandardName(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(4);
        }
        return !configFile.getName().equalsIgnoreCase("tsconfig.json");
    }

    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config2) {
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(config2.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file2, "files");
    }

    @Nullable
    private static JsonProperty getIncludeProperty(Project project, TypeScriptConfig config2) {
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(config2.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file2, "include");
    }

    @Nullable
    private static JsonProperty getProperty(@Nullable PsiFile file2, @NotNull String propertyName) {
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file2, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty(propertyName);
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file2, TypeScriptConfig config2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config2.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config2);
        if (property == null && (property = TypeScriptConfigUtil.getIncludeProperty(project, config2)) == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        List list = value.getValueList();
        if (list.isEmpty()) {
            return false;
        }
        String text = value.getText();
        StringBuilder builder = new StringBuilder(text);
        String path = VfsUtilCore.findRelativePath((VirtualFile)config2.getConfigFile(), (VirtualFile)file2, (char)(text.indexOf("/") > 0 ? (char)'/' : (char)File.separatorChar));
        int i = text.lastIndexOf("]");
        builder.insert(i, ",\"" + path + "\"");
        value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder.toString()));
        return true;
    }

    @NotNull
    private static JsonValue createJSONAndGetPropertyValue(@NotNull Project project, @NotNull String propertyValue) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(6);
        }
        if (propertyValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(7);
        }
        String tempName = "tempName";
        JsonProperty property = TypeScriptConfigUtil.createJsonProperty(project, tempName, propertyValue, false);
        JsonValue jsonValue = (JsonValue)ObjectUtils.assertNotNull((Object)property.getValue());
        if (jsonValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(8);
        }
        return jsonValue;
    }

    @NotNull
    public static JsonProperty createJsonProperty(@NotNull Project project, @NotNull String propertyName, @NotNull String propertyValue, boolean withComma) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(9);
        }
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(10);
        }
        if (propertyValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(11);
        }
        String json = String.format("{ \"" + propertyName + "\":%s" + (withComma ? "," : "") + " }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty jsonProperty = (JsonProperty)ObjectUtils.assertNotNull((Object)TypeScriptConfigUtil.getProperty(psiFile, propertyName));
        if (jsonProperty == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(12);
        }
        return jsonProperty;
    }

    public static boolean strictNullChecks(@Nullable PsiElement context) {
        if (context == null || !context.isValid() || !DialectDetector.isTypeScript(context)) {
            return false;
        }
        TypeScriptConfig file2 = TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile());
        return file2 != null && file2.strictNullChecks();
    }

    public static String getOutDirectory(VirtualFile baseFile, String relativeOrAbsolutePath) {
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return relativeOrAbsolutePath;
        }
        VirtualFile file2 = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file2 == null ? null : file2.getCanonicalPath();
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(13);
        }
        if (DumbService.isDumb((Project)file2.getProject())) {
            return null;
        }
        return (TypeScriptConfig)CachedValuesManager.getManager((Project)file2.getProject()).getParameterizedCachedValue((UserDataHolder)file2, CACHE_KEY, CACHED_CONFIG_PROVIDER, false, (Object)file2);
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<TypeScriptConfig> filteredConfigs = TypeScriptConfigService.Provider.getConfigInclude(project, file2);
        if (filteredConfigs.isEmpty()) {
            return null;
        }
        assert (project != null);
        TypeScriptConfig entry = TypeScriptConfigUtil.getNearestParentConfig(file2, filteredConfigs);
        if (entry != null) {
            return entry;
        }
        return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
    }

    @Nullable
    public static VirtualFile getNearestParentConfig(@Nullable VirtualFile file2) {
        VirtualFile toSearch;
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = toSearch = file2.isDirectory() ? file2 : file2.getParent();
        while (toSearch != null && toSearch.isValid()) {
            VirtualFile child = toSearch.findChild("tsconfig.json");
            if (child != null) {
                return child;
            }
            toSearch = toSearch.getParent();
        }
        return null;
    }

    @Nullable
    public static TypeScriptConfig getNearestParentConfig(@Nullable VirtualFile file2, @NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            return null;
        }
        if (configs.size() <= 1) {
            return (TypeScriptConfig)ContainerUtil.getFirstItem(configs);
        }
        for (VirtualFile toSearch = file2.getParent(); toSearch != null; toSearch = toSearch.getParent()) {
            for (TypeScriptConfig config2 : configs) {
                if (!config2.getConfigDirectory().equals(toSearch)) continue;
                return config2;
            }
        }
        return null;
    }

    public static String getRegularExpressionForGlobPattern(@NotNull Collection<String> specs, @NotNull VirtualFile baseDirectory, @NotNull WildCardType usage) {
        if (specs == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(16);
        }
        if (baseDirectory == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(17);
        }
        if (usage == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(18);
        }
        if (ContainerUtil.isEmpty(specs)) {
            return null;
        }
        StringBuilder pattern = new StringBuilder();
        boolean hasWrittenSubPattern = false;
        block0: for (String spec : specs) {
            if (StringUtil.isEmpty((String)spec)) continue;
            StringBuilder subPattern = new StringBuilder();
            boolean hasRecursiveDirectoryWildcard = false;
            boolean hasWrittenComponent = false;
            ArrayList components = TypeScriptConfigUtil.getNormalizedPathComponents(FileUtil.toSystemIndependentName((String)spec), baseDirectory);
            String lastUsage = components.get(components.size() - 1);
            if (usage != WildCardType.EXCLUDE && !StringUtil.isEmpty((String)lastUsage)) {
                if (TWO_ASTERISK.equals(lastUsage)) continue;
                if (!lastUsage.contains(".") && !lastUsage.contains("*")) {
                    components = ContainerUtil.newArrayList(components);
                    components.add(TWO_ASTERISK);
                    components.add("*");
                }
            }
            int optionalCount = 0;
            for (String component : components) {
                if (TWO_ASTERISK.equals(component)) {
                    if (hasRecursiveDirectoryWildcard) continue block0;
                    subPattern.append("(\\/.+?)?");
                    hasRecursiveDirectoryWildcard = true;
                    hasWrittenComponent = true;
                    continue;
                }
                if (usage == WildCardType.DIRECTORIES) {
                    subPattern.append('(');
                    ++optionalCount;
                }
                if (hasWrittenComponent) {
                    subPattern.append("\\/");
                }
                subPattern.append(TypeScriptConfigUtil.escapeSymbols(component));
                hasWrittenComponent = true;
            }
            while (optionalCount > 0) {
                subPattern.append(")?");
                --optionalCount;
            }
            if (hasWrittenSubPattern) {
                pattern.append("|");
            }
            pattern.append("(").append((CharSequence)subPattern).append(")");
            hasWrittenSubPattern = true;
        }
        if (StringUtil.isEmpty((CharSequence)pattern)) {
            return null;
        }
        return "^(" + pattern + (usage == WildCardType.EXCLUDE ? ")($|\\/)" : ")$");
    }

    private static String escapeSymbols(String component) {
        String escapedString = StringUtil.escapeToRegexp((String)component);
        escapedString = escapedString.replace("\\*", "[^\\/]*");
        escapedString = escapedString.replace("\\?", "[^\\/]");
        return escapedString;
    }

    private static List<String> getNormalizedPathComponents(String spec, VirtualFile baseDirectory) {
        String stringPath = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(baseDirectory, spec);
        int rootLength = TypeScriptConfigUtil.getRootLength(stringPath);
        String root = stringPath.substring(0, rootLength);
        ArrayList result2 = ContainerUtil.newArrayList((Object[])new String[]{StringUtil.trimEnd((String)root, (char)'/')});
        result2.addAll(StringUtil.split((String)stringPath.substring(rootLength), (String)"/"));
        return result2;
    }

    public static boolean isRootDiskPath(@NotNull String stringPath) {
        if (stringPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(19);
        }
        return FileUtil.isAbsolute((String)stringPath);
    }

    private static int getRootLength(@NotNull String absoluteNormalizedPath) {
        if (absoluteNormalizedPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(20);
        }
        if (StringUtil.isEmpty((String)absoluteNormalizedPath)) {
            return 0;
        }
        if (absoluteNormalizedPath.charAt(0) == '/') {
            int p2;
            int p1;
            if (absoluteNormalizedPath.length() > 1 && absoluteNormalizedPath.charAt(1) != '/') {
                return 1;
            }
            int n = p1 = absoluteNormalizedPath.length() > 2 ? absoluteNormalizedPath.indexOf("/", 2) : -1;
            if (p1 < 0) {
                return 2;
            }
            int n2 = p2 = absoluteNormalizedPath.length() > p1 + 1 ? absoluteNormalizedPath.indexOf("/", p1 + 1) : -1;
            if (p2 < 0) {
                return p1 + 1;
            }
            return p2 + 1;
        }
        if (absoluteNormalizedPath.length() > 1 && absoluteNormalizedPath.charAt(1) == ':') {
            if (absoluteNormalizedPath.charAt(2) == '/') {
                return 3;
            }
            return 2;
        }
        if (absoluteNormalizedPath.lastIndexOf("file:///", 0) == 0) {
            return "file:///".length();
        }
        int idx = absoluteNormalizedPath.indexOf("://");
        if (idx != -1) {
            return idx + "://".length();
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteNormalizedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSONAndGetPropertyValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNonStandardProjectFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toLibraryName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigsWithNonStandardName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonStandardName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJSONAndGetPropertyValue";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createJsonProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForPsiFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNearestParentConfig";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRegularExpressionForGlobPattern";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRootDiskPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRootLength";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum WildCardType {
        EXCLUDE,
        DIRECTORIES,
        FILES;

    }
}

