/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public TypeScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
        super(typeChecker);
    }

    @Override
    protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)methodExpression)) {
            highlightType = ProblemHighlightType.WEAK_WARNING;
        }
        this.myTypeChecker.registerProblem(place, message, highlightType, fixes);
    }

    @Override
    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type, PsiElement context) {
        if (type == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        if (type instanceof JSCompositeTypeImpl) {
            for (JSType part : ((JSCompositeTypeImpl)type).getTypes()) {
                if (this.isCallableType(inNewExpression, part, context)) continue;
                return false;
            }
        }
        return super.isCallableType(inNewExpression, type, context);
    }

    @Override
    protected void checkCallArgumentType(JSParameterItem p, JSExpression exp, JSCallExpression node, PsiElement resolveResult) {
        JSFunctionSignatureChecker.DefaultReporter reporter = this.createReporter(exp);
        JSType type = this.addGenericArgumentsAndFillConstraintProblems(p.getTypeWithOptional(), exp, node, resolveResult, reporter);
        if (this.myTypeChecker.checkExpressionIsAssignableToType(exp, type, null, "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null), JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)exp), false)) {
            reporter.reportGenericErrorIfExist();
        }
    }

    @Override
    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (JSTypeUtils.hasGenericParameter(type)) {
            type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(type, callExpression.getMethodExpression(), resolveResult, reporter);
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolveResult, (PsiElement)callExpression, null);
            if (genericArguments != null && !genericArguments.isEmpty()) {
                return JSTypeUtils.applyGenericArguments(type, genericArguments, true, reporter);
            }
        }
        return type;
    }

    @Override
    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }

    private boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type, @NotNull Set<PsiElement> visited) {
        if (visited == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        if (callExpression instanceof JSNewExpression) {
            if (resolveResult instanceof TypeScriptImportStatement) {
                for (PsiElement element : ((TypeScriptImportStatement)resolveResult).findReferencedElements()) {
                    if (!visited.add(element) || !this.processMethodExpressionResolveResult(callExpression, methodExpression, element, type, visited)) continue;
                    return false;
                }
            } else if (resolveResult instanceof TypeScriptClass) {
                if (this.checkClassInstantiate(callExpression, resolveResult)) {
                    return false;
                }
            } else {
                JSResolvedTypeInfo resolvedType;
                JSType valuableType = JSTypeUtils.getValuableType(type);
                if (valuableType instanceof JSResolvableType && (resolvedType = ((JSResolvableType)valuableType).resolveType()) != null && resolvedType.isAbstract()) {
                    this.myTypeChecker.registerProblem((PsiElement)callExpression, JSBundle.message((String)"typescript.validation.message.abstract.class.be.created", (Object[])new Object[]{valuableType.getTypeText()}), null, new LocalQuickFix[0]);
                }
            }
        }
        return super.processMethodExpressionResolveResult(callExpression, methodExpression, resolveResult, type);
    }

    @Override
    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return this.processMethodExpressionResolveResult(callExpression, methodExpression, resolveResult, type, ContainerUtil.newHashSet());
    }

    private boolean checkClassInstantiate(JSCallExpression callExpression, PsiElement resolveResult) {
        if (resolveResult instanceof JSClass) {
            JSClass classElement = (JSClass)resolveResult;
            if (TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)classElement)) {
                this.myTypeChecker.registerProblem((PsiElement)callExpression, JSBundle.message((String)"typescript.validation.message.abstract.class.be.created", (Object[])new Object[]{classElement.getName()}), null, new LocalQuickFix[0]);
                return true;
            }
            if (classElement.isInterface()) {
                this.myTypeChecker.registerProblem((PsiElement)callExpression, JSBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), null, new LocalQuickFix[0]);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/validation/TypeScriptFunctionSignatureChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethodExpressionResolveResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

