/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class TypeScriptTypeChecker
extends JSTypeChecker {
    public <T> TypeScriptTypeChecker(final JSProblemReporter<T> reporter) {
        super(new JSProblemReporter<T>(){

            @Override
            @Nullable
            public T registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                return reporter.registerProblem(place, message, null, fixes);
            }
        });
    }

    @Override
    public void checkTypesInReturnStatement(@NotNull JSElement node) {
        JSExpression expression;
        if (node == null) {
            TypeScriptTypeChecker.$$$reportNull$$$0(0);
        }
        JSExpression jSExpression = expression = node instanceof JSReturnStatement ? ((JSReturnStatement)node).getExpression() : (JSExpression)node;
        if (expression == null) {
            return;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
        if (fun == null || fun.isGenerator()) {
            return;
        }
        PsiElement returnTypeElement = fun.getReturnTypeElement();
        if (returnTypeElement == null) {
            return;
        }
        JSType returnType = fun.getReturnType();
        if (ES6PsiUtil.isAsyncContext(fun) && returnType != null) {
            returnType = this.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        if (returnType instanceof TypeScriptTypePredicateTypeImpl) {
            returnType = ((TypeScriptTypePredicateTypeImpl)returnType).asBoolean();
        }
        this.checkExpressionIsAssignableToType(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    @Override
    public void checkExpressionIsAssignableToVariable(JSVariable p, JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        JSType type = null;
        if (p.getTypeElement() != null || p.getInitializer() != expr) {
            type = p.getType();
        }
        this.checkExpressionIsAssignableToType(expr, type, problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null), true);
    }

    @Override
    protected boolean skipByExpressionType(@NotNull JSExpression expr, @Nullable JSType expressionJSType) {
        TypeScriptType element;
        PsiElement exprParent;
        if (expr == null) {
            TypeScriptTypeChecker.$$$reportNull$$$0(1);
        }
        if (expressionJSType instanceof JSSymbolType && (exprParent = expr.getParent()) instanceof TypeScriptVariable && ((TypeScriptVariable)exprParent).getInitializer() == expr && (element = ((TypeScriptVariable)exprParent).getTypeElement()) instanceof TypeScriptSingleType && StringUtil.equalsIgnoreWhitespaces((CharSequence)element.getText(), (CharSequence)"unique symbol")) {
            return true;
        }
        return super.skipByExpressionType(expr, expressionJSType);
    }

    @Override
    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType type = super.getExpressionType(expr);
        return type == null ? null : JSTypeUtils.replaceImplicitTypesWithAny(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/validation/TypeScriptTypeChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypesInReturnStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "skipByExpressionType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

