/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.plugins.intelliLang.inject.JSInjection;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    public static final String SUPPORT_ID = "js";

    @NotNull
    public String getId() {
        if (SUPPORT_ID == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return SUPPORT_ID;
    }

    @NotNull
    public Class[] getPatternClasses() {
        Class[] classArray = new Class[]{JSPatterns.class};
        if (classArray == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        Language language = host.getLanguage();
        return language == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect;
    }

    public String getHelpId() {
        return "reference.settings.language.injection.generic.javascript";
    }

    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!psiElement.isValidHost()) {
            return false;
        }
        if (this.findCommentOwner(psiElement) == null) {
            return false;
        }
        psiElement.putUserData(InjectLanguageAction.FIX_KEY, host -> {
            Runnable addCommentAction = this.getAddCommentAction((PsiLanguageInjectionHost)host, language.getID());
            if (addCommentAction == null) {
                return false;
            }
            addCommentAction.run();
            return true;
        });
        return false;
    }

    @Nullable
    Runnable getAddCommentAction(@NotNull PsiLanguageInjectionHost host, @NotNull String languageID) {
        if (host == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        if (languageID == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(3);
        }
        if (!host.isValidHost()) {
            return null;
        }
        List<JSLiteralExpression> parts = JSInjectionController.getConcatenationParts(JSInjectionController.getTopElement(host));
        LanguageInjectionSupport tempInjectionSupport = TemporaryPlacesRegistry.getInstance((Project)host.getProject()).getLanguageInjectionSupport();
        PsiElement commentOwner = this.findCommentOwner(host);
        if (commentOwner == null) {
            return null;
        }
        return () -> {
            if (host == null) {
                JSLanguageInjectionSupport.$$$reportNull$$$0(10);
            }
            if (languageID == null) {
                JSLanguageInjectionSupport.$$$reportNull$$$0(11);
            }
            WriteCommandAction.writeCommandAction((Project)host.getProject(), (PsiFile[])new PsiFile[]{host.getContainingFile()}).run(() -> {
                PsiElement sibling;
                boolean startsOnNewLine;
                if (host == null) {
                    JSLanguageInjectionSupport.$$$reportNull$$$0(12);
                }
                if (languageID == null) {
                    JSLanguageInjectionSupport.$$$reportNull$$$0(13);
                }
                boolean bl = startsOnNewLine = (sibling = commentOwner.getPrevSibling()) instanceof PsiWhiteSpace && sibling.textContains('\n');
                if (!startsOnNewLine) {
                    JSChangeUtil.addWs(commentOwner.getParent().getNode(), commentOwner.getNode(), "\n");
                }
                String commentPrefix = JSCodeStyleSettings.getLineCommentPrefix(commentOwner);
                PsiComment commentPsi = JSLanguageInjectionSupport.createPsiFromText(host, "//" + commentPrefix + "language=" + languageID);
                commentOwner.getParent().addBefore((PsiElement)commentPsi, commentOwner);
                for (JSLiteralExpression part : parts) {
                    tempInjectionSupport.removeInjection((PsiElement)part);
                }
            });
        };
    }

    public boolean useDefaultCommentInjector() {
        return false;
    }

    @Nullable
    public JSInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<PsiElement> commentRef) {
        if (host == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(4);
        }
        commentRef = (Ref)ObjectUtils.coalesce(commentRef, (Object)new Ref());
        if (PsiTreeUtil.getParentOfType((PsiElement)host, PsiLanguageInjectionHost.class) != null) {
            return null;
        }
        InjectorUtils.CommentInjectionData injectionData = InjectorUtils.findCommentInjectionData((PsiElement)host, (boolean)false, (Ref)commentRef);
        if (injectionData == null) {
            return null;
        }
        JSInjection injection = new JSInjection("comment");
        injection.setPrefix(injectionData.getPrefix());
        injection.setSuffix(injectionData.getSuffix());
        injection.setInjectedLanguageId(injectionData.getInjectedLanguageId());
        injection.setDisplayName(injectionData.getDisplayName());
        injection.setCanReformat(Boolean.parseBoolean(injectionData.getValues().getOrDefault("format", "true")));
        return injection;
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Configuration configuration = Configuration.getProjectInstance((Project)psiElement.getProject());
        Ref commentRef = new Ref();
        BaseInjection injection = this.findCommentInjection((PsiElement)psiElement, commentRef);
        if (injection == null) {
            return false;
        }
        configuration.replaceInjectionsWithUndo(psiElement.getProject(), ContainerUtil.emptyList(), ContainerUtil.list((Object[])new BaseInjection[]{injection}), ContainerUtil.createMaybeSingletonList((Object)commentRef.get()));
        return true;
    }

    @Nullable
    private PsiElement findCommentOwner(@NotNull PsiLanguageInjectionHost injectionHost) {
        if (injectionHost == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(5);
        }
        PsiElement topElement = JSInjectionController.getTopElement(injectionHost);
        return PsiTreeUtil.getParentOfType((PsiElement)topElement, (Class[])new Class[]{JSSourceElement.class, JSProperty.class});
    }

    @NotNull
    private static PsiComment createPsiFromText(@NotNull PsiLanguageInjectionHost context, @NotNull String text) {
        if (context == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(6);
        }
        if (text == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(7);
        }
        PsiComment psiComment = (PsiComment)((ASTNode)ObjectUtils.assertNotNull((Object)JSChangeUtil.createJSTreeFromText(context.getProject(), text, DialectDetector.languageDialectOfElement((PsiElement)context)))).getPsi(PsiComment.class);
        if (psiComment == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(8);
        }
        return psiComment;
    }

    @NotNull
    public static JSLanguageInjectionSupport getInstance() {
        JSLanguageInjectionSupport jSLanguageInjectionSupport = (JSLanguageInjectionSupport)((Object)ObjectUtils.assertNotNull((Object)InjectorUtils.findInjectionSupport((String)SUPPORT_ID)));
        if (jSLanguageInjectionSupport == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(9);
        }
        return jSLanguageInjectionSupport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageID";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiFromText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAddCommentAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommentOwner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFromText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAddCommentAction$2";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

