/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public class PostgresIntermediateFacade
extends JdbcIntermediateFacade {
    protected static final Pattern ENHANCED_VERSION_PATTERN = Pattern.compile("(\\d{1,2}(\\.\\d{1,3}|alpha|beta){1,5})");
    public static final String CONNECTION_INFO_QUERY = "select current_database(), current_schema(), current_user";

    public PostgresIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public PostgresIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Postgres.RDBMS;
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        return this.getConnectionInfoSmartly(CONNECTION_INFO_QUERY, ENHANCED_VERSION_PATTERN, 1, SIMPLE_VERSION_PATTERN, 1);
    }
}

