/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final Map<String, Integer> SPECIAL_VALUES = new HashMap<String, Integer>();
    @NotNull
    private final int[] elements;
    public static final Version ZERO;

    public static Version of(@NotNull String string) {
        String[] substrings;
        ArrayList<Integer> b = new ArrayList<Integer>(5);
        for (String ss : substrings = string.split("[.,\\-_ ]|(?<=\\d)(?!\\d)|(?<!\\d)(?=\\d)")) {
            String ss2 = ss.trim().toLowerCase(Locale.ENGLISH);
            if (ss2.isEmpty()) continue;
            Integer special = SPECIAL_VALUES.get(ss2);
            if (special != null) {
                b.add(special);
                continue;
            }
            try {
                Integer v = new Integer(ss2);
                b.add(v);
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        if (b.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse version \"" + string + "\"");
        }
        if (b.size() == 1 && (Integer)b.get(0) == 0) {
            return ZERO;
        }
        return Version.of(b.toArray(new Integer[b.size()]));
    }

    public static Version of(int ... elements) {
        int n;
        for (n = elements.length; n > 0 && elements[n - 1] == 0; --n) {
        }
        if (n == 0) {
            return ZERO;
        }
        int[] ownElements = new int[n];
        System.arraycopy(elements, 0, ownElements, 0, n);
        return new Version(ownElements);
    }

    public static Version of(@NotNull Integer[] elements) {
        int n;
        for (n = elements.length; n > 0 && elements[n - 1] == 0; --n) {
        }
        if (n == 0) {
            return ZERO;
        }
        int[] ownElements = new int[n];
        for (int i = 0; i < n; ++i) {
            ownElements[i] = elements[i];
        }
        return new Version(ownElements);
    }

    private Version(@NotNull int[] elements) {
        this.elements = elements;
    }

    public int get(int index) {
        return index < this.elements.length ? this.elements[index] : 0;
    }

    public int size() {
        return this.elements.length;
    }

    @NotNull
    public Version truncate(int n) {
        int m;
        if (this.elements.length <= n) {
            return this;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative desired size: " + n);
        }
        for (m = n; m > 0 && this.elements[m - 1] == 0; --m) {
        }
        if (m == 0) {
            return ZERO;
        }
        int[] newElements = new int[m];
        System.arraycopy(this.elements, 0, newElements, 0, m);
        return new Version(newElements);
    }

    @NotNull
    public Version truncateNegatives() {
        int n = this.elements.length;
        for (int k = 0; k < n; ++k) {
            if (this.elements[k] >= 0) continue;
            return this.truncate(k);
        }
        return this;
    }

    @Override
    public int compareTo(@NotNull Version that) {
        if (this == that) {
            return 0;
        }
        int m = Math.max(this.size(), that.size());
        for (int i = 0; i < m; ++i) {
            int z = Version.compare(this.get(i), that.get(i));
            if (z == 0) continue;
            return z;
        }
        return 0;
    }

    @Override
    public int compareTo(int ... that) {
        int m = Math.max(this.size(), that.length);
        for (int i = 0; i < m; ++i) {
            int z = Version.compare(this.get(i), i < that.length ? that[i] : 0);
            if (z == 0) continue;
            return z;
        }
        return 0;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x > y ? 1 : 0);
    }

    public boolean isOrGreater(int ... than) {
        return this.compareTo(than) >= 0;
    }

    public boolean isOrGreater(@NotNull Version than) {
        return this.compareTo(than) >= 0;
    }

    public boolean less(int ... than) {
        return this.compareTo(than) < 0;
    }

    public boolean less(@NotNull Version than) {
        return this.compareTo(than) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return Arrays.equals(this.elements, that.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    @NotNull
    public String toString() {
        return this.toString(2, 100);
    }

    @NotNull
    public String toString(int minimumElements, int maximumElements) {
        int n = Math.min(Math.max(this.elements.length, minimumElements), maximumElements);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this.get(i));
        }
        return b.toString();
    }

    @NotNull
    public int[] toArray() {
        int n = this.elements.length;
        int[] result = new int[n];
        System.arraycopy(this.elements, 0, result, 0, n);
        return result;
    }

    static {
        SPECIAL_VALUES.put("alpha", -20);
        SPECIAL_VALUES.put("beta", -10);
        ZERO = new Version(new int[0]);
    }
}

