/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.liveEdit.rangeValue.HtmlValueSynchronizerFactory;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlLookupSynchronizerFactory
extends RangeValueSynchronizerFactory.Html<RangeValueSynchronizer> {
    HtmlLookupSynchronizerFactory() {
    }

    @Override
    protected RangeValueSynchronizer create(@NotNull PsiFile file, @NotNull XmlAttribute attribute, @Nullable CssDeclaration cssDeclaration) {
        if (file == null) {
            HtmlLookupSynchronizerFactory.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            HtmlLookupSynchronizerFactory.$$$reportNull$$$0(1);
        }
        if (cssDeclaration == null) {
            PsiElement firstChild = attribute.getFirstChild();
            if (firstChild == attribute.getLastChild() && firstChild.getNode().getElementType() == XmlTokenType.XML_NAME) {
                return null;
            }
            return new AttributeValueLookupSynchronizer(file, attribute);
        }
        return new HtmlValueSynchronizerFactory.InlineStylePropertyValueColorSynchronizer(file, attribute, cssDeclaration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "attribute";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AttributeValueLookupSynchronizer
    extends HtmlValueSynchronizerFactory.PropertyValueLookupSynchronizer {
        private AttributeValueLookupSynchronizer(PsiFile file, XmlAttribute attribute) {
            super(file, attribute.getName(), attribute);
        }

        @Override
        @Nullable
        protected CharSequence itemToString(@NotNull LookupElement item, @NotNull String itemLookupString, @NotNull Lookup lookup, boolean closed) {
            int valueEnd;
            int valueStart;
            XmlAttributeValue valueElement;
            if (item == null) {
                AttributeValueLookupSynchronizer.$$$reportNull$$$0(0);
            }
            if (itemLookupString == null) {
                AttributeValueLookupSynchronizer.$$$reportNull$$$0(1);
            }
            if (lookup == null) {
                AttributeValueLookupSynchronizer.$$$reportNull$$$0(2);
            }
            if ((valueElement = this.attribute.getValueElement()) == null) {
                return itemLookupString;
            }
            ASTNode attributeValue = null;
            ASTNode attributeValueStart = null;
            for (ASTNode element = valueElement.getNode().getFirstChildNode(); element != null; element = element.getTreeNext()) {
                if (element.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    attributeValue = element;
                    break;
                }
                if (element.getElementType() != XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) continue;
                attributeValueStart = element;
            }
            if (attributeValue == null) {
                if (attributeValueStart == null) {
                    ASTNode valueElementNode = valueElement.getNode();
                    valueStart = valueElementNode.getStartOffset() + valueElementNode.getTextLength();
                } else {
                    valueStart = attributeValueStart.getStartOffset() + 1;
                }
                valueEnd = valueStart;
            } else {
                valueStart = attributeValue.getStartOffset();
                valueEnd = valueStart + attributeValue.getTextLength();
            }
            return AttributeValueLookupSynchronizer.getEffectiveText(item, itemLookupString, valueStart, valueEnd, lookup, closed);
        }

        @Override
        protected void doSync(@NotNull CharSequence value) {
            if (value == null) {
                AttributeValueLookupSynchronizer.$$$reportNull$$$0(3);
            }
            this.setProperty(value, false);
        }

        @Override
        protected void doRevert() {
            if (this.attribute.isValid() && !PsiUtilCore.hasErrorElementChild((PsiElement)this.attribute)) {
                this.setProperty(this.attribute.getDisplayValue(), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemLookupString";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory$AttributeValueLookupSynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemToString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doSync";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

