/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.PageReloader;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class InSingleFileBasedSynchronizer
extends FileBasedSynchronizer {
    @Override
    protected final void sync(@NotNull List<PsiFile> files) {
        if (files == null) {
            InSingleFileBasedSynchronizer.$$$reportNull$$$0(0);
        }
        MultiMap projectToFiles = MultiMap.createSmart();
        for (PsiFile psiFile : files) {
            projectToFiles.putValue((Object)psiFile.getProject(), (Object)psiFile.getVirtualFile());
        }
        for (Project project : projectToFiles.keySet()) {
            this.scheduleUpdate(projectToFiles.get((Object)project), project);
        }
    }

    protected abstract void scheduleUpdate(@NotNull Collection<VirtualFile> var1, @NotNull Project var2);

    @NotNull
    protected static VirtualFile getVirtualFile(@NotNull PsiFile file) {
        if (file == null) {
            InSingleFileBasedSynchronizer.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = file.getOriginalFile().getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            InSingleFileBasedSynchronizer.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    public final void reload(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            InSingleFileBasedSynchronizer.$$$reportNull$$$0(3);
        }
        if (project == null) {
            InSingleFileBasedSynchronizer.$$$reportNull$$$0(4);
        }
        PageReloader.save(file, project, () -> {
            if (project == null) {
                InSingleFileBasedSynchronizer.$$$reportNull$$$0(5);
            }
            if (file == null) {
                InSingleFileBasedSynchronizer.$$$reportNull$$$0(6);
            }
            this.doReload(project, file);
        }, true);
    }

    protected abstract void doReload(@NotNull Project var1, @NotNull VirtualFile var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reload$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

