/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.liveEdit.LiveEditManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LiveEditBulkFileListener
implements BulkFileListener {
    private final LiveEditManager liveEditManager;

    public LiveEditBulkFileListener(@NotNull LiveEditManager liveEditManager) {
        if (liveEditManager == null) {
            LiveEditBulkFileListener.$$$reportNull$$$0(0);
        }
        this.liveEditManager = liveEditManager;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LiveEditBulkFileListener.$$$reportNull$$$0(1);
        }
        if (!this.liveEditManager.isOperable()) {
            return;
        }
        List psiFiles = null;
        for (VFileEvent vFileEvent : events) {
            PsiFile psiFile;
            Project project;
            VirtualFile file;
            FileType fileType;
            if (!(vFileEvent instanceof VFileContentChangeEvent) || (fileType = (file = ((VFileContentChangeEvent)vFileEvent).getFile()).getFileType()) != CssFileType.INSTANCE && !JsFileUtil.isScript((FileType)fileType) || (project = ProjectUtil.guessProjectForContentFile((VirtualFile)file, (FileType)fileType)) == null || !this.liveEditManager.isOperable(project) || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null || psiFile instanceof PsiPlainText) continue;
            if (psiFiles == null) {
                psiFiles = new SmartList();
            }
            psiFiles.add(psiFile);
        }
        if (ContainerUtil.isEmpty(psiFiles)) {
            return;
        }
        MultiMap projectToPsiFiles = MultiMap.createSmart();
        for (PsiFile psiFile : psiFiles) {
            projectToPsiFiles.putValue((Object)psiFile.getProject(), (Object)psiFile);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Project project : projectToPsiFiles.keySet()) {
                if (project.isDisposed()) continue;
                Collection psiFilesPerProject = projectToPsiFiles.get((Object)project);
                PsiDocumentManager.getInstance((Project)project).performWhenAllCommitted(() -> this.liveEditManager.schedule(psiFilesPerProject, project));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveEditManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/LiveEditBulkFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

