/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.JBIntSpinner;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditOptions;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class LiveEditConfigurableUi
implements ConfigurableUi<LiveEditOptions> {
    private final JPanel panel;
    private final JCheckBox updateNodeCheckbox;
    private final JSpinner updateNodeAutoDelaySpinner;
    private final JCheckBox updateChromeCheckbox;
    private final JCheckBox updateChromeOnChangesCheckbox;
    private final JSpinner updateChromeAutoDelaySpinner;
    private final JLabel updateChromeAutoDelayMsLabel;
    private final JCheckBox elementHighlightingCheckBox;
    private final JCheckBox restartIfHotSwapFailedCheckBox;

    public LiveEditConfigurableUi() {
        int vGap = JBUI.scale((int)2);
        this.panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, vGap, true, false));
        JPanel updateNodePanel = new JPanel(new FlowLayout(0, 0, 0));
        this.updateNodeCheckbox = new JCheckBox(LiveEditBundle.message("settings.update.node", new Object[0]) + " ");
        updateNodePanel.add(this.updateNodeCheckbox);
        this.updateNodeAutoDelaySpinner = LiveEditConfigurableUi.createDelaySpinner();
        updateNodePanel.add(this.updateNodeAutoDelaySpinner);
        updateNodePanel.add(new JLabel(" ms"));
        this.panel.add(updateNodePanel);
        JPanel updateChromePanel = new JPanel(new FlowLayout(0, 0, 0));
        updateChromePanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.updateChromeCheckbox = new JCheckBox(LiveEditBundle.message("settings.update.chrome", new Object[0]) + " ");
        updateChromePanel.add(this.updateChromeCheckbox);
        String html = LiveEditBundle.message("settings.requires.extension", "https://chrome.google.com/webstore/detail/jetbrains-ide-support/hmhgeddbohgjknpmjagkdomcpobmllji");
        updateChromePanel.add(SwingHelper.createHtmlLabel((String)html, null, null));
        this.panel.add(updateChromePanel);
        JPanel updateChromeSettingsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, vGap, true, false));
        int updateChromePanelOffset = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.updateChromeCheckbox);
        if (updateChromePanelOffset == 0) {
            updateChromePanelOffset = 20;
        }
        updateChromeSettingsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)updateChromePanelOffset));
        JPanel updateChromeOnChangesPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.updateChromeOnChangesCheckbox = new JCheckBox(LiveEditBundle.message("settings.update.on.changes", new Object[0]) + " ");
        updateChromeOnChangesPanel.add(this.updateChromeOnChangesCheckbox);
        this.updateChromeAutoDelaySpinner = LiveEditConfigurableUi.createDelaySpinner();
        updateChromeOnChangesPanel.add(this.updateChromeAutoDelaySpinner);
        this.updateChromeAutoDelayMsLabel = new JLabel(" ms");
        updateChromeOnChangesPanel.add(this.updateChromeAutoDelayMsLabel);
        updateChromeSettingsPanel.add(updateChromeOnChangesPanel);
        this.elementHighlightingCheckBox = new JCheckBox(LiveEditBundle.message("settings.highlight.on.caret", new Object[0]));
        updateChromeSettingsPanel.add(this.elementHighlightingCheckBox);
        JLabel elementHighlightingTip = new JLabel(LiveEditBundle.message("settings.highlight.on.caret.tip", new Object[0]));
        elementHighlightingTip.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        elementHighlightingTip.setForeground(UIUtil.getLabelDisabledForeground());
        int elementHighlightingOffset = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.elementHighlightingCheckBox);
        if (elementHighlightingOffset == 0) {
            elementHighlightingOffset = 20;
        }
        elementHighlightingTip.setBorder((Border)JBUI.Borders.emptyLeft((int)elementHighlightingOffset));
        updateChromeSettingsPanel.add(elementHighlightingTip);
        this.panel.add(updateChromeSettingsPanel);
        this.restartIfHotSwapFailedCheckBox = new JCheckBox(LiveEditBundle.message("settings.restart.if.hotswap.fails", new Object[0]));
        this.restartIfHotSwapFailedCheckBox.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.panel.add(this.restartIfHotSwapFailedCheckBox);
        ActionListener enabledUpdater = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LiveEditConfigurableUi.this.updateEnabled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/liveEdit/LiveEditConfigurableUi$1", "actionPerformed"));
            }
        };
        this.updateNodeCheckbox.addActionListener(enabledUpdater);
        this.updateChromeCheckbox.addActionListener(enabledUpdater);
        this.updateChromeOnChangesCheckbox.addActionListener(enabledUpdater);
        this.updateEnabled();
    }

    private static JBIntSpinner createDelaySpinner() {
        JBIntSpinner spinner = new JBIntSpinner(300, 0, 60000);
        ((SpinnerNumberModel)spinner.getModel()).setStepSize(50);
        return spinner;
    }

    private void updateEnabled() {
        this.updateNodeAutoDelaySpinner.setEnabled(this.updateNodeCheckbox.isSelected());
        this.updateChromeOnChangesCheckbox.setEnabled(this.updateChromeCheckbox.isSelected());
        this.elementHighlightingCheckBox.setEnabled(this.updateChromeCheckbox.isSelected());
        this.updateChromeAutoDelaySpinner.setEnabled(this.updateChromeCheckbox.isSelected() && this.updateChromeOnChangesCheckbox.isSelected());
        this.updateChromeAutoDelayMsLabel.setEnabled(this.updateChromeCheckbox.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private boolean isNodeAutoUpdate() {
        return this.updateNodeCheckbox.isSelected();
    }

    private int getNodeAutoDelay() {
        Object value = this.updateNodeAutoDelaySpinner.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)300);
    }

    private boolean isChromeUpdate() {
        return this.updateChromeCheckbox.isSelected();
    }

    private boolean isChromeUpdateOnChanges() {
        return this.updateChromeOnChangesCheckbox.isSelected();
    }

    private int getChromeAutoDelay() {
        Object value = this.updateChromeAutoDelaySpinner.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)300);
    }

    private boolean isElementHighlighting() {
        return this.elementHighlightingCheckBox.isSelected();
    }

    private boolean isRestartIfHotSwapFailed() {
        return this.restartIfHotSwapFailedCheckBox.isSelected();
    }

    public void reset(@NotNull LiveEditOptions options) {
        if (options == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(1);
        }
        this.updateNodeCheckbox.setSelected(options.isNodeUpdateOnChanges());
        this.updateNodeAutoDelaySpinner.setValue(options.getNodeAutoDelay());
        this.updateChromeCheckbox.setSelected(options.isChromeUpdateApp());
        this.updateChromeOnChangesCheckbox.setSelected(options.isChromeUpdateOnChanges());
        this.updateChromeAutoDelaySpinner.setValue(options.getChromeAutoDelay());
        this.elementHighlightingCheckBox.setSelected(options.isElementHighlighting());
        this.restartIfHotSwapFailedCheckBox.setSelected(options.isRestartIfHotSwapFailed());
        this.updateEnabled();
    }

    public void apply(@NotNull LiveEditOptions options) {
        if (options == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(2);
        }
        options.setNodeUpdateOnChanges(this.isNodeAutoUpdate());
        options.setNodeAutoDelay(this.getNodeAutoDelay());
        options.setChromeUpdateApp(this.isChromeUpdate());
        options.setChromeUpdateOnChanges(this.isChromeUpdateOnChanges());
        options.setChromeAutoDelay(this.getChromeAutoDelay());
        if (this.isElementHighlighting() != options.isElementHighlighting()) {
            options.setElementHighlighting(this.isElementHighlighting(), true);
        }
        options.setRestartIfHotSwapFailed(this.isRestartIfHotSwapFailed());
    }

    public boolean isModified(@NotNull LiveEditOptions options) {
        if (options == null) {
            LiveEditConfigurableUi.$$$reportNull$$$0(3);
        }
        return this.isNodeAutoUpdate() != options.isNodeUpdateOnChanges() || this.getNodeAutoDelay() != options.getNodeAutoDelay() || this.isChromeUpdate() != options.isChromeUpdateApp() || this.isChromeUpdateOnChanges() != options.isChromeUpdateOnChanges() || this.getChromeAutoDelay() != options.getChromeAutoDelay() || this.isElementHighlighting() != options.isElementHighlighting() || this.isRestartIfHotSwapFailed() != options.isRestartIfHotSwapFailed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/LiveEditConfigurableUi";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/LiveEditConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

