/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.Deployer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PageReloader {
    @NotNull
    public static Runnable createReloadBelongsToProject(@NotNull PsiElement element, boolean triggeredByExplicitAction) {
        if (element == null) {
            PageReloader.$$$reportNull$$$0(0);
        }
        Runnable runnable = PageReloader.createReloadBelongsToProject(element, null, triggeredByExplicitAction);
        if (runnable == null) {
            PageReloader.$$$reportNull$$$0(1);
        }
        return runnable;
    }

    @NotNull
    public static Runnable createReloadBelongsToProject(@NotNull PsiElement element, @Nullable String selector, boolean triggeredByExplicitAction) {
        if (element == null) {
            PageReloader.$$$reportNull$$$0(2);
        }
        Project project = element.getProject();
        Runnable runnable = PageReloader.createSaveTask(element.getContainingFile().getViewProvider().getVirtualFile(), project, PageReloader.domTask(project, selector), triggeredByExplicitAction);
        if (runnable == null) {
            PageReloader.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    public static void save(List<PsiFile> files, Condition<List<PsiFile>> actualizer, Runnable callback) {
        PageReloader.saveFiles(files, callback, false, actualizer);
    }

    private static Runnable domTask(@NotNull Project project, @Nullable String selector) {
        if (project == null) {
            PageReloader.$$$reportNull$$$0(4);
        }
        return () -> {
            if (project == null) {
                PageReloader.$$$reportNull$$$0(18);
            }
            ApplicationInspector applicationInspector = ApplicationInspector.getInstance();
            if (selector == null) {
                applicationInspector.reloadPages(project);
            } else {
                applicationInspector.reloadPagesContainingElement(project, selector);
            }
        };
    }

    public static void reloadBelongsTo(@NotNull VirtualFile file, @NotNull Project project, boolean triggeredByExplicitAction) {
        if (file == null) {
            PageReloader.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PageReloader.$$$reportNull$$$0(6);
        }
        PageReloader.save(file, project, PageReloader.domTask(project, null), triggeredByExplicitAction);
    }

    public static void save(@NotNull VirtualFile file, @NotNull Project project, @NotNull Runnable callback, boolean triggeredByExplicitAction) {
        if (file == null) {
            PageReloader.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PageReloader.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            PageReloader.$$$reportNull$$$0(9);
        }
        AppUIUtil.invokeOnEdt((Runnable)PageReloader.createSaveTask(file, project, callback, triggeredByExplicitAction));
    }

    @NotNull
    private static Runnable createSaveTask(@NotNull VirtualFile file, @NotNull Project project, @NotNull Runnable callback, boolean triggeredByExplicitAction) {
        if (file == null) {
            PageReloader.$$$reportNull$$$0(10);
        }
        if (project == null) {
            PageReloader.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            PageReloader.$$$reportNull$$$0(12);
        }
        Runnable runnable = () -> {
            if (project == null) {
                PageReloader.$$$reportNull$$$0(14);
            }
            if (callback == null) {
                PageReloader.$$$reportNull$$$0(15);
            }
            if (file == null) {
                PageReloader.$$$reportNull$$$0(16);
            }
            if (project.isDisposed()) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Deployer deployer = Deployer.getInstance();
            if (deployer == null) {
                callback.run();
            } else {
                deployer.deploy(file, project, triggeredByExplicitAction).onSuccess(it -> {
                    if (callback == null) {
                        PageReloader.$$$reportNull$$$0(17);
                    }
                    callback.run();
                });
            }
        };
        if (runnable == null) {
            PageReloader.$$$reportNull$$$0(13);
        }
        return runnable;
    }

    private static void saveFiles(List<PsiFile> files, Runnable callback, boolean triggeredByExplicitAction, Condition<List<PsiFile>> actualizer) {
        AppUIUtil.invokeOnEdt(() -> {
            if (!actualizer.value((Object)files)) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Deployer deployer = Deployer.getInstance();
            if (deployer == null) {
                callback.run();
                return;
            }
            ActionCallback actionCallback = new ActionCallback(files.size());
            actionCallback.doWhenDone(callback);
            Runnable onUpdateFinished = actionCallback.createSetDoneRunnable();
            for (PsiFile file : files) {
                if (!file.isValid() || file.getProject().isDisposed()) {
                    actionCallback.setDone();
                    continue;
                }
                deployer.deploy(file, triggeredByExplicitAction).onSuccess(it -> onUpdateFinished.run());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/PageReloader";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/PageReloader";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReloadBelongsToProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSaveTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReloadBelongsToProject";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "domTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reloadBelongsTo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSaveTask";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSaveTask$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$domTask$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

