/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.liveEdit.valueAdjuster.AdjustPopup;
import com.jetbrains.liveEdit.valueAdjuster.ValueAdjusterFactory;
import org.jetbrains.annotations.Nullable;

public class AdjustValueAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        boolean b;
        Pair<PsiElement, ValueAdjusterFactory.ValueAdjuster> data = AdjustValueAction.getData(e.getDataContext());
        boolean bl = b = data != null;
        if (data != null) {
            ((ValueAdjusterFactory.ValueAdjuster)data.second).dispose();
        }
        e.getPresentation().setEnabled(b);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(b);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Pair<PsiElement, ValueAdjusterFactory.ValueAdjuster> data = AdjustValueAction.getData(e.getDataContext());
        assert (data != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        AdjustPopup.show(editor, (ValueAdjusterFactory.ValueAdjuster)data.second, ((PsiElement)data.first).getContainingFile().getViewProvider().getVirtualFile());
    }

    @Nullable
    private static Pair<PsiElement, ValueAdjusterFactory.ValueAdjuster> getData(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        ValueAdjusterFactory.ValueAdjuster adjuster = ValueAdjusterFactory.forElement(element);
        if (adjuster == null && offset > 0 && (element = file.findElementAt(offset - 1)) != null) {
            adjuster = ValueAdjusterFactory.forElement(element);
        }
        return adjuster != null ? Pair.create((Object)element, (Object)adjuster) : null;
    }
}

