/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.actions;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.PageReloader;
import com.jetbrains.liveEdit.PsiSynchronizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadInBrowserAction
extends AnAction {
    public ReloadInBrowserAction() {
        super(LiveEditBundle.message("actions.reloadInBrowser", new Object[0]));
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (ReloadInBrowserAction.getPsiFile(e.getDataContext(), project) == null) {
            enabled = false;
        } else if (LiveEditManager.getInstance().isOperableForBrowser(project)) {
            enabled = true;
        } else {
            List debugProcesses = XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class);
            enabled = false;
            if (!debugProcesses.isEmpty()) {
                for (JavaScriptDebugProcess debugProcess : debugProcesses) {
                    WebBrowser browser = debugProcess.getConnection().getBrowser();
                    if (browser == null || !browser.getFamily().equals((Object)BrowserFamily.FIREFOX)) continue;
                    enabled = true;
                    break;
                }
            }
        }
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile file = ReloadInBrowserAction.getPsiFile(e.getDataContext(), project);
        if (file == null || project == null) {
            return;
        }
        PsiSynchronizer synchronizer = PsiSynchronizer.get(file.getFileType());
        if (synchronizer == null) {
            PageReloader.reloadBelongsTo(file, project, true);
        } else {
            synchronizer.reload(file, project);
        }
    }

    @Nullable
    private static VirtualFile getPsiFile(@NotNull DataContext context, @Nullable Project project) {
        VirtualFile file;
        if (context == null) {
            ReloadInBrowserAction.$$$reportNull$$$0(0);
        }
        if ((file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context)) != null) {
            return file;
        }
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        return editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/liveEdit/actions/ReloadInBrowserAction", "getPsiFile"));
    }
}

