/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.actions;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R0\u0010\u0003\u001a$\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\n0\n0\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/liveEdit/actions/UpdateRunningApplicationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "blackListedDebugProcesses", "", "Lcom/intellij/xdebugger/XDebugProcess;", "kotlin.jvm.PlatformType", "", "updateConfigurationProviders", "", "Lcom/jetbrains/liveEdit/update/UpdateConfigurationProvider;", "[Lcom/jetbrains/liveEdit/update/UpdateConfigurationProvider;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doUpdate", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "project", "Lcom/intellij/openapi/project/Project;", "update", "intellij.js.liveEdit"})
public final class UpdateRunningApplicationAction
extends AnAction {
    private final Set<XDebugProcess> blackListedDebugProcesses = ContainerUtil.newConcurrentSet();
    private final UpdateConfigurationProvider[] updateConfigurationProviders;

    private final XDebugProcess getDebugProcess(Project project) {
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        XDebugSession xDebugSession = xDebuggerManager.getCurrentSession();
        return xDebugSession != null ? xDebugSession.getDebugProcess() : null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Presentation presentation = e.getPresentation();
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (runProfile == null) {
            Presentation presentation2 = presentation;
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"presentation");
            presentation2.setText("Update Application" + (PlatformUtils.isWebStorm() ? "" : " (Live Edit)"));
            presentation.setEnabledAndVisible(!XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaScriptDebugProcess.class).isEmpty());
        } else {
            for (UpdateConfigurationProvider provider : this.updateConfigurationProviders) {
                if (!provider.isSupported(runProfile)) continue;
                Presentation presentation3 = presentation;
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"presentation");
                presentation3.setText("Update '" + runProfile.getName() + '\'');
                presentation.setVisible(true);
                Project project3 = project2;
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                presentation.setEnabled(this.getDebugProcess(project3) != null);
                return;
            }
            Presentation presentation4 = presentation;
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"presentation");
            presentation4.setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (runProfile == null) {
            Iterator iterator = XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaScriptDebugProcess.class).iterator();
            while (iterator.hasNext()) {
                JavaScriptDebugProcess debugProcess;
                JavaScriptDebugProcess javaScriptDebugProcess = debugProcess = (JavaScriptDebugProcess)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"debugProcess");
                this.doUpdate(javaScriptDebugProcess);
            }
        } else {
            Project project3 = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            XDebugProcess debugProcess = this.getDebugProcess(project3);
            if (debugProcess instanceof JavaScriptDebugProcess) {
                this.doUpdate((JavaScriptDebugProcess)debugProcess);
            }
        }
    }

    private final void doUpdate(JavaScriptDebugProcess<?> debugProcess) {
        Promise<?> callback;
        if (this.blackListedDebugProcesses.contains(debugProcess)) {
            return;
        }
        Promise<?> promise = callback = ApplicationInspector.getInstance().updateApplication(debugProcess);
        Intrinsics.checkExpressionValueIsNotNull(promise, (String)"callback");
        if (promise.getState() == Promise.State.PENDING) {
            this.blackListedDebugProcesses.add((XDebugProcess)debugProcess);
            Promise<?> $receiver$iv = callback;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.onProcessed((Consumer)new Consumer<Object>(this, debugProcess){
                final /* synthetic */ UpdateRunningApplicationAction this$0;
                final /* synthetic */ JavaScriptDebugProcess $debugProcess$inlined;
                {
                    this.this$0 = updateRunningApplicationAction;
                    this.$debugProcess$inlined = javaScriptDebugProcess;
                }

                public final void accept(@Nullable Object it) {
                    UpdateRunningApplicationAction.access$getBlackListedDebugProcesses$p(this.this$0).remove(this.$debugProcess$inlined);
                }
            }), (String)"(this as Promise<Any?>).onProcessed { handler() }");
        }
    }

    public UpdateRunningApplicationAction() {
        super("Update application", null, AllIcons.Javaee.UpdateRunningApplication);
        ExtensionPointName<UpdateConfigurationProvider> extensionPointName = UpdateConfigurationProvider.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"UpdateConfigurationProvider.EP_NAME");
        this.updateConfigurationProviders = (UpdateConfigurationProvider[])extensionPointName.getExtensions();
    }

    @NotNull
    public static final /* synthetic */ Set access$getBlackListedDebugProcesses$p(UpdateRunningApplicationAction $this) {
        return $this.blackListedDebugProcesses;
    }
}

