/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.reference.SoftReference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementHighlightExecutor {
    volatile boolean ignoreHighlight;
    protected volatile WeakReference<XmlTag> lastHighlightedTagRef;

    @Nullable
    protected XmlTag findTag(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(1);
        }
        return ElementHighlightExecutor.find(editor, project, XmlTag.class);
    }

    @Nullable
    protected static <T extends XmlTagChild> T find(@NotNull Editor editor, @NotNull Project project, @NotNull Class<T> elementClass) {
        PsiFile psiFile;
        if (editor == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(3);
        }
        if (elementClass == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(4);
        }
        return (T)((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == null ? null : (XmlTagChild)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset(), elementClass, (boolean)false));
    }

    public void highlight(@NotNull Editor editor, @NotNull Project project, @Nullable XmlTag tag) {
        if (editor == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            tag = (XmlTag)ReadAction.compute(() -> {
                if (editor == null) {
                    ElementHighlightExecutor.$$$reportNull$$$0(8);
                }
                if (project == null) {
                    ElementHighlightExecutor.$$$reportNull$$$0(9);
                }
                return this.findTag(editor, project);
            });
        }
        if (tag == null || tag == this.getLastHighlightedTag()) {
            return;
        }
        this.ignoreHighlight = false;
        this.doHighlight(editor, project, tag);
    }

    protected abstract void doHighlight(Editor var1, Project var2, XmlTag var3);

    public final void hideHighlight(@NotNull Project project, @Nullable XmlTag ifElement) {
        if (project == null) {
            ElementHighlightExecutor.$$$reportNull$$$0(7);
        }
        if (this.lastHighlightedTagRef != null) {
            if (ifElement != null && ifElement != this.getLastHighlightedTag()) {
                return;
            }
            this.lastHighlightedTagRef = null;
            this.doHideHighlight(project, ifElement);
        }
    }

    protected abstract void doHideHighlight(Project var1, @Nullable XmlTag var2);

    @Nullable
    public final XmlTag getLastHighlightedTag() {
        return (XmlTag)SoftReference.dereference(this.lastHighlightedTagRef);
    }

    public final void clearLastHighlightedTag() {
        this.lastHighlightedTagRef = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTag";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hideHighlight";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$highlight$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

