/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.util.Alarm;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.highlighting.ElementHighlightExecutor;

public abstract class ElementHighlighterOnCaretChangeBase
implements CaretListener,
Runnable {
    protected final ElementHighlightExecutor highlightExecutor;

    protected ElementHighlighterOnCaretChangeBase(ElementHighlightExecutor highlightExecutor) {
        this.highlightExecutor = highlightExecutor;
    }

    public void caretPositionChanged(CaretEvent e) {
        this.scheduleHighlight();
    }

    public void scheduleHighlight() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.run();
            return;
        }
        Alarm alarm = LiveEditManager.getInstance().getAlarm();
        alarm.cancelRequest((Runnable)this);
        alarm.addRequest((Runnable)this, 100);
    }

    public void dispose(Editor editor) {
        this.highlightExecutor.lastHighlightedTagRef = null;
        editor.getCaretModel().removeCaretListener((CaretListener)this);
    }
}

