/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.liveEdit.InSingleFileBasedSynchronizer;
import com.jetbrains.liveEdit.JavaScriptSynchronizer;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.update.ApplicationUpdaterKt;
import com.jetbrains.liveEdit.update.EffectiveFileScriptProcessor;
import com.jetbrains.liveEdit.update.FileScriptProcessor;
import com.jetbrains.liveEdit.update.RestartRequiredNotificationItem;
import com.jetbrains.liveEdit.update.SetSourceExecutor;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateScriptResult;
import com.jetbrains.liveEdit.update.UpdateState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJD\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0018J,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJH\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J \u0010%\u001a\u00020\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001c\u0010(\u001a\u00020\u001b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010*\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010 \u001a\u00020!JK\u0010*\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\f\u001a\u00020\r2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0002\u0010.R*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/liveEdit/update/ApplicationUpdater;", "", "()V", "processToState", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/xdebugger/XDebugProcess;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/liveEdit/update/UpdateState;", "autoTriggeredUpdate", "Lorg/jetbrains/concurrency/Promise;", "result", "Lcom/jetbrains/liveEdit/update/EffectiveFileScriptProcessor;", "vm", "Lorg/jetbrains/debugger/Vm;", "synchronizer", "Lcom/jetbrains/liveEdit/InSingleFileBasedSynchronizer;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "setSourceExecutor", "Lcom/jetbrains/liveEdit/update/SetSourceExecutor;", "checkIsBlackListed", "", "notify", "clearUpdateState", "", "remove", "collectPendingFiles", "", "doUpdate", "nothingToUpdateCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getState", "markAsRestartRequired", "Lcom/jetbrains/liveEdit/update/RestartRequiredNotificationItem;", "notifyIfHasIncorrectFiles", "incorrectFiles", "restartOrNotify", "schedule", "scheduleUpdateScripts", "updateScripts", "sources", "", "", "(Ljava/util/List;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;[Ljava/lang/CharSequence;Ljava/util/concurrent/atomic/AtomicInteger;)Lorg/jetbrains/concurrency/Promise;", "MyFileScriptProcessor", "intellij.js.liveEdit"})
public final class ApplicationUpdater {
    private final ConcurrentMap<XDebugProcess, UpdateState> processToState = ContainerUtil.newConcurrentMap();

    @NotNull
    public final Promise<?> updateScripts(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull AtomicInteger nothingToUpdateCounter) {
        JavaScriptSynchronizer javaScriptSynchronizer;
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)nothingToUpdateCounter, (String)"nothingToUpdateCounter");
        if (this.checkIsBlackListed((XDebugProcess)debugProcess, true)) {
            return Promises.rejectedPromise((String)"blacklisted");
        }
        Vm vm = debugProcess.getMainVm();
        if (vm == null) {
            return Promises.nullPromise();
        }
        Vm vm2 = vm;
        JavaScriptSynchronizer javaScriptSynchronizer2 = javaScriptSynchronizer = (JavaScriptSynchronizer)PsiSynchronizer.EP_NAME.findExtension(JavaScriptSynchronizer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptSynchronizer2, (String)"javaScriptSynchronizer");
        List<VirtualFile> list = EffectiveFileScriptProcessor.getEffectiveFiles((Collection<VirtualFile>)javaScriptSynchronizer2.getIncorrectFiles(), debugProcess, vm2);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"EffectiveFileScriptProce\u2026tFiles, debugProcess, vm)");
        if (this.notifyIfHasIncorrectFiles(list, debugProcess)) {
            return Promises.rejectedPromise((String)"incorrect files");
        }
        List<VirtualFile> files = this.collectPendingFiles(null, (XDebugProcess)debugProcess, javaScriptSynchronizer);
        if (files.isEmpty()) {
            nothingToUpdateCounter.decrementAndGet();
            return Promises.nullPromise();
        }
        return this.doUpdate(files, debugProcess, vm2, javaScriptSynchronizer, null, nothingToUpdateCounter);
    }

    public final boolean notifyIfHasIncorrectFiles(@NotNull List<? extends VirtualFile> incorrectFiles, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(incorrectFiles, (String)"incorrectFiles");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        if (incorrectFiles.isEmpty()) {
            return false;
        }
        for (VirtualFile virtualFile : incorrectFiles) {
            ApplicationUpdaterKt.access$notifyFileHasErrors(virtualFile, (XDebugProcess)debugProcess);
        }
        return true;
    }

    @NotNull
    public final Promise<?> autoTriggeredUpdate(@NotNull EffectiveFileScriptProcessor result, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)synchronizer, (String)"synchronizer");
        if (result.getTransformedFiles().isEmpty()) {
            List<VirtualFile> list = result.getEffectiveFiles();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"result.effectiveFiles");
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"result.debugProcess");
            return this.autoTriggeredUpdate(list, javaScriptDebugProcess, vm, synchronizer, null);
        }
        JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"result.debugProcess");
        this.restartOrNotify((XDebugProcess)javaScriptDebugProcess);
        return Promises.rejectedPromise();
    }

    @NotNull
    public final Promise<? extends Object> autoTriggeredUpdate(@NotNull List<VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer, @Nullable SetSourceExecutor setSourceExecutor) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)synchronizer, (String)"synchronizer");
        this.collectPendingFiles(files, (XDebugProcess)debugProcess, synchronizer);
        return files.isEmpty() ? Promises.resolvedPromise() : this.doUpdate(files, debugProcess, vm, synchronizer, setSourceExecutor, null);
    }

    @NotNull
    public final List<VirtualFile> collectPendingFiles(@Nullable List<VirtualFile> result, @NotNull XDebugProcess debugProcess, @NotNull InSingleFileBasedSynchronizer synchronizer) {
        List list;
        Set<VirtualFile> pendingFiles;
        UpdateState updateState;
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)synchronizer, (String)"synchronizer");
        List newResult = result;
        UpdateState updateState2 = updateState = (UpdateState)this.processToState.get(debugProcess);
        Set<Object> set = pendingFiles = updateState2 != null ? updateState2.getModifiedFiles$intellij_js_liveEdit() : null;
        if (!ContainerUtil.isEmpty((Collection)pendingFiles)) {
            Set<VirtualFile> set2 = pendingFiles;
            if (set2 == null) {
                Intrinsics.throwNpe();
            }
            Iterator<VirtualFile> iterator = set2.iterator();
            while (iterator.hasNext()) {
                VirtualFile pendingFile = iterator.next();
                if (!synchronizer.canHandle(pendingFile.getFileType())) continue;
                iterator.remove();
                if (newResult == null) {
                    newResult = (List)new SmartList();
                }
                newResult.add(pendingFile);
            }
        }
        if ((list = newResult) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> doUpdate(@NotNull List<? extends VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm, @NotNull InSingleFileBasedSynchronizer synchronizer, @Nullable SetSourceExecutor setSourceExecutor, @Nullable AtomicInteger nothingToUpdateCounter) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)synchronizer, (String)"synchronizer");
        boolean bl2 = bl = !files.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CharSequence[] sources = ApplicationUpdaterKt.access$collectSources((XDebugProcess)debugProcess, synchronizer, files);
        if (sources == null) {
            this.getState((XDebugProcess)debugProcess).getModifiedFiles$intellij_js_liveEdit().addAll((Collection<VirtualFile>)files);
            return Promises.rejectedPromise();
        }
        if (setSourceExecutor == null) {
            return this.updateScripts(files, debugProcess, vm, sources, nothingToUpdateCounter);
        }
        SmartList totalResult = new SmartList();
        int length = files.size();
        for (int i = 0; i < length; ++i) {
            totalResult.addAll((Collection)setSourceExecutor.execute(files.get(i), sources[i]));
        }
        return Promises.all((Collection)((Collection)totalResult));
    }

    private final UpdateState getState(XDebugProcess debugProcess) {
        UpdateState updateState = (UpdateState)this.processToState.get(debugProcess);
        if (updateState == null) {
            updateState = new UpdateState();
            UpdateState prevState = this.processToState.putIfAbsent(debugProcess, updateState);
            if (prevState != null) {
                return prevState;
            }
            XDebugProcess xDebugProcess = debugProcess;
            if (xDebugProcess == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.Disposable");
            }
            Disposer.register((Disposable)((Disposable)xDebugProcess), (Disposable)new Disposable(this, debugProcess){
                final /* synthetic */ ApplicationUpdater this$0;
                final /* synthetic */ XDebugProcess $debugProcess;

                public final void dispose() {
                    this.this$0.clearUpdateState(this.$debugProcess, true);
                }
                {
                    this.this$0 = applicationUpdater;
                    this.$debugProcess = xDebugProcess;
                }
            });
        }
        return updateState;
    }

    private final Promise<?> updateScripts(List<? extends VirtualFile> files, JavaScriptDebugProcess<?> debugProcess, Vm vm, CharSequence[] sources, AtomicInteger nothingToUpdateCounter) {
        MyFileScriptProcessor processor = new MyFileScriptProcessor(debugProcess, vm);
        int length = files.size();
        for (int i = 0; i < length; ++i) {
            processor.reset(files.get(i));
            processor.setSource(sources[i]);
            vm.getScriptManager().forEachScript((Function1)new Function1<Script, Boolean>(processor){
                final /* synthetic */ MyFileScriptProcessor $processor;

                public final boolean invoke(@NotNull Script it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$processor.process(it);
                }
                {
                    this.$processor = myFileScriptProcessor;
                    super(1);
                }
            });
        }
        if (processor.getTotalResult().isEmpty()) {
            AtomicInteger atomicInteger = nothingToUpdateCounter;
            if (atomicInteger != null) {
                atomicInteger.decrementAndGet();
            }
            return Promises.nullPromise();
        }
        Promise promise = Promises.collectResults$default((Collection)((Collection)processor.getTotalResult()), (boolean)false, (int)1, null).onSuccess((Consumer)new Consumer<List<? extends UpdateScriptResult>>(this, debugProcess){
            final /* synthetic */ ApplicationUpdater this$0;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;

            public final void accept(List<UpdateScriptResult> it) {
                int unchangedCount = 0;
                for (UpdateScriptResult result : it) {
                    if (result.status == ScriptLiveChangeResult.ChangeStatus.CHANGED) {
                        ApplicationUpdater.access$restartOrNotify(this.this$0, (XDebugProcess)this.$debugProcess);
                        return;
                    }
                    if (result.status != ScriptLiveChangeResult.ChangeStatus.UNCHANGED) continue;
                    ++unchangedCount;
                }
                String string = LiveEditBundle.message("n.scripts.reloaded", it.size() - unchangedCount);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LiveEditBundle.message(\"\u2026it.size - unchangedCount)");
                ApplicationUpdaterKt.access$inform(string, (XDebugProcess)this.$debugProcess);
            }
            {
                this.this$0 = applicationUpdater;
                this.$debugProcess = javaScriptDebugProcess;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"processor.totalResult\n  \u2026, debugProcess)\n        }");
        return promise;
    }

    private final void restartOrNotify(XDebugProcess debugProcess) {
        LiveEditOptions liveEditOptions = LiveEditOptions.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)liveEditOptions, (String)"LiveEditOptions.getInstance()");
        if (liveEditOptions.isRestartIfHotSwapFailed()) {
            ApplicationUpdaterKt.restart(debugProcess);
            UpdateState state = this.getState(debugProcess);
            SingletonNotificationManager lastRestartedOnHotSwapFailedNotification = state.getLastRestartedOnHotSwapFailedNotification$intellij_js_liveEdit();
            if (lastRestartedOnHotSwapFailedNotification == null) {
                NotificationGroup notificationGroup = ApplicationUpdaterKt.getMINOR_NOTIFICATION_GROUP();
                Intrinsics.checkExpressionValueIsNotNull((Object)notificationGroup, (String)"MINOR_NOTIFICATION_GROUP");
                lastRestartedOnHotSwapFailedNotification = new SingletonNotificationManager(notificationGroup, NotificationType.INFORMATION, (NotificationListener)ApplicationUpdaterKt.access$getDISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER$p());
                state.setLastRestartedOnHotSwapFailedNotification$intellij_js_liveEdit(lastRestartedOnHotSwapFailedNotification);
            }
            XDebugSession session = debugProcess.getSession();
            StringBuilder stringBuilder = new StringBuilder();
            XDebugSession xDebugSession = session;
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
            lastRestartedOnHotSwapFailedNotification.notify(stringBuilder.append(xDebugSession.getSessionName()).append(": ").append(LiveEditBundle.message("disable.restart.if.hotswap.failed", new Object[0])).toString(), session.getProject());
        } else {
            RestartRequiredNotificationItem restartNotificationItem = this.markAsRestartRequired(debugProcess);
            if (!restartNotificationItem.hasActiveNotification()) {
                restartNotificationItem.notify(LiveEditBundle.message("restart.required", new Object[0]) + LiveEditBundle.message("enable.restart.if.hotswap.failed", new Object[0]));
            }
        }
    }

    private final RestartRequiredNotificationItem markAsRestartRequired(XDebugProcess debugProcess) {
        UpdateState state = this.getState(debugProcess);
        RestartRequiredNotificationItem restartNotificationItem = state.getNotificationItem$intellij_js_liveEdit();
        if (restartNotificationItem == null) {
            restartNotificationItem = new RestartRequiredNotificationItem(debugProcess);
            state.setNotificationItem$intellij_js_liveEdit(restartNotificationItem);
            state.getModifiedFiles$intellij_js_liveEdit().clear();
        }
        return restartNotificationItem;
    }

    public final boolean checkIsBlackListed(@NotNull XDebugProcess debugProcess, boolean notify) {
        RestartRequiredNotificationItem restartNotificationItem;
        UpdateState state;
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        UpdateState updateState = state = (UpdateState)this.processToState.get(debugProcess);
        RestartRequiredNotificationItem restartRequiredNotificationItem = restartNotificationItem = updateState != null ? updateState.getNotificationItem$intellij_js_liveEdit() : null;
        if (restartNotificationItem != null) {
            if (notify && !restartNotificationItem.hasActiveNotification()) {
                this.restartOrNotify(debugProcess);
            }
            return true;
        }
        return false;
    }

    public final void scheduleUpdateScripts(@NotNull EffectiveFileScriptProcessor result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (result.getTransformedFiles().isEmpty()) {
            List<VirtualFile> list = result.getEffectiveFiles();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"result.effectiveFiles");
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"result.debugProcess");
            this.schedule(list, (XDebugProcess)javaScriptDebugProcess);
        } else {
            JavaScriptDebugProcess javaScriptDebugProcess = result.debugProcess;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"result.debugProcess");
            this.markAsRestartRequired((XDebugProcess)javaScriptDebugProcess);
        }
    }

    public final void schedule(@NotNull List<? extends VirtualFile> files, @NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        this.getState(debugProcess).getModifiedFiles$intellij_js_liveEdit().addAll((Collection<VirtualFile>)files);
    }

    public final void clearUpdateState(@NotNull XDebugProcess debugProcess, boolean remove) {
        block2: {
            SingletonNotificationManager lastRestartedOnHotSwapFailedNotification;
            RestartRequiredNotificationItem notificationItem;
            UpdateState state;
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            UpdateState updateState = state = remove ? (UpdateState)this.processToState.remove(debugProcess) : (UpdateState)this.processToState.get(debugProcess);
            if (state == null) break block2;
            RestartRequiredNotificationItem restartRequiredNotificationItem = notificationItem = state.getNotificationItem$intellij_js_liveEdit();
            if (restartRequiredNotificationItem != null) {
                restartRequiredNotificationItem.clear();
            }
            SingletonNotificationManager singletonNotificationManager = lastRestartedOnHotSwapFailedNotification = state.getLastRestartedOnHotSwapFailedNotification$intellij_js_liveEdit();
            if (singletonNotificationManager != null) {
                singletonNotificationManager.clear();
            }
        }
    }

    public static final /* synthetic */ void access$restartOrNotify(ApplicationUpdater $this, @NotNull XDebugProcess debugProcess) {
        $this.restartOrNotify(debugProcess);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/liveEdit/update/ApplicationUpdater$MyFileScriptProcessor;", "Lcom/jetbrains/liveEdit/update/FileScriptProcessor;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "vm", "Lorg/jetbrains/debugger/Vm;", "(Lcom/jetbrains/liveEdit/update/ApplicationUpdater;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;)V", "source", "", "getSource", "()Ljava/lang/CharSequence;", "setSource", "(Ljava/lang/CharSequence;)V", "state", "Lcom/jetbrains/liveEdit/update/UpdateState;", "getState", "()Lcom/jetbrains/liveEdit/update/UpdateState;", "totalResult", "Lcom/intellij/util/SmartList;", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/liveEdit/update/UpdateScriptResult;", "getTotalResult", "()Lcom/intellij/util/SmartList;", "updateConfiguration", "Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "getUpdateConfiguration", "()Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "process", "", "script", "Lorg/jetbrains/debugger/Script;", "intellij.js.liveEdit"})
    private final class MyFileScriptProcessor
    extends FileScriptProcessor {
        @Nullable
        private final UpdateConfiguration updateConfiguration;
        @NotNull
        private final SmartList<Promise<UpdateScriptResult>> totalResult;
        @NotNull
        private final UpdateState state;
        @Nullable
        private CharSequence source;
        private final Vm vm;

        @Nullable
        public final UpdateConfiguration getUpdateConfiguration() {
            return this.updateConfiguration;
        }

        @NotNull
        public final SmartList<Promise<UpdateScriptResult>> getTotalResult() {
            return this.totalResult;
        }

        @NotNull
        public final UpdateState getState() {
            return this.state;
        }

        @Nullable
        public final CharSequence getSource() {
            return this.source;
        }

        public final void setSource(@Nullable CharSequence charSequence) {
            this.source = charSequence;
        }

        public boolean process(@NotNull Script script) {
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            if (this.isScriptFile(script.getUrl())) {
                CharSequence text = this.source;
                if (this.updateConfiguration != null) {
                    CharSequence charSequence = text;
                    if (charSequence == null) {
                        Intrinsics.throwNpe();
                    }
                    text = this.updateConfiguration.preprocessSource(charSequence);
                }
                CharSequence charSequence = text;
                if (charSequence == null) {
                    Intrinsics.throwNpe();
                }
                VirtualFile virtualFile = this.file;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                JavaScriptDebugProcess javaScriptDebugProcess = this.debugProcess;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"debugProcess");
                this.totalResult.add((Object)ApplicationUpdaterKt.access$setScriptSource(charSequence, script, this.vm, virtualFile, (XDebugProcess)javaScriptDebugProcess, this.state));
                return false;
            }
            return true;
        }

        public MyFileScriptProcessor(@NotNull JavaScriptDebugProcess<?> debugProcess, Vm vm) {
            Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
            super(debugProcess);
            this.vm = vm;
            this.updateConfiguration = ApplicationUpdaterKt.getUpdateConfiguration((XDebugProcess)debugProcess);
            this.totalResult = new SmartList();
            this.state = ApplicationUpdater.this.getState((XDebugProcess)debugProcess);
        }
    }
}

