/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.valueAdjuster;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.valueAdjuster.ValueAdjusterFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdjustPopup {
    public static void show(final Editor editor, final ValueAdjusterFactory.ValueAdjuster valueAdjuster, final VirtualFile virtualFile) {
        final int initialValue = valueAdjuster.getCurrentSliderValue();
        JSlider slider = new JSlider(0, valueAdjuster.getMinimum(), valueAdjuster.getMaximum(), initialValue);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)slider, "Center");
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                valueAdjuster.setValue(editor, ((JSlider)e.getSource()).getValue());
            }
        });
        final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)slider).createPopup();
        slider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    popup.closeOk((InputEvent)e);
                }
            }
        });
        popup.addListener(new JBPopupListener(){

            public void beforeShown(LightweightWindowEvent event) {
                LiveEditManager.getInstance().ignoreFile(virtualFile, true);
            }

            public void onClosed(LightweightWindowEvent event) {
                if (!event.isOk()) {
                    valueAdjuster.setValue(editor, initialValue);
                }
                LiveEditManager.getInstance().ignoreFile(virtualFile, false);
                valueAdjuster.dispose();
            }
        });
        popup.setRequestFocus(true);
        popup.showInBestPositionFor(editor);
    }
}

